/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.plugin;

import javassist.gluonj.Pcd;
import javassist.gluonj.Pointcut;
import javassist.gluonj.Refine;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.expr.Expr;
import javassist.gluonj.pc.PointcutNode;
import javassist.gluonj.pc.PointcutVisitor;
import javassist.gluonj.pc.PrepareVisitor;
import javassist.gluonj.weave.Advice;
import javassist.gluonj.weave.AdviceWeaver;
import javassist.gluonj.weave.AliasList;
import javassist.gluonj.weave.CflowCollector;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.GluonMaker;
import javassist.gluonj.weave.Hook;
import javassist.gluonj.weave.Matcher;
import javassist.gluonj.weave.Residue;

public class Block {
    public static final int RECOVERY = 100;

    @Refine
    static class Pcd2
    extends Pcd {
        Pcd2() {
        }

        public static Pointcut block(Pointcut begin, Pointcut end) {
            Pcut2 pc = (Pcut2)Pcd2.make();
            return pc.block(begin, end);
        }
    }

    @Refine
    static class Pcut2
    extends Pointcut {
        Pcut2() {
            super(null);
        }

        public Pointcut block(Pointcut begin, Pointcut end) {
            AliasList a = new AliasList();
            Pcut2 b = (Pcut2)begin;
            Pcut2 e = (Pcut2)end;
            this.setTree(new BlockPc(b.parse(a), e.parse(a)));
            if (a.next != null) {
                throw new RuntimeException("no alias is available with block pointcuts.");
            }
            return this;
        }
    }

    @Refine
    static class Cflow2
    extends CflowCollector {
        public Cflow2() {
            super(null);
        }

        public void visit(BlockPc pc) throws WeaveException {
            pc.getBegin().accept(this);
            pc.getEnd().accept(this);
        }
    }

    @Refine
    static class Gluon2
    extends GluonMaker {
        Gluon2() {
        }

        protected Advice unknownAdvice(Gluon g, Pointcut pc, Object annotation) throws WeaveException {
            return g.addAdvice(100, pc, ((Recover)annotation).value());
        }
    }

    public static @interface Recover {
        public String value();
    }

    @Refine
    static class AdviceWeaver2
    extends AdviceWeaver {
        AdviceWeaver2() {
        }

        protected static boolean insertHook(Hook hook, Hook.Iterator iterator, Expr expr, StringBuffer before, StringBuffer after) throws CannotCompileException {
            Advice advice = hook.getAdvice();
            PointcutNode pc = advice.getPointcut();
            if (!(pc instanceof BlockPc)) {
                return AdviceWeaver.insertHook(hook, iterator, expr, before, after, null);
            }
            BlockPc block = (BlockPc)pc;
            int kind = advice.getKind();
            String body = advice.getBody(expr, null);
            System.out.println("recovery: " + body);
            block.getEndJP().replace("{{" + body + "} $_ = $proceed($$); }");
            block.clear();
            return true;
        }
    }

    @Refine
    static abstract class Match2
    extends Matcher {
        Match2() {
        }

        public void visit(BlockPc pc) throws WeaveException {
            this.residue = null;
            pc.getBegin().accept(this);
            boolean resultB = this.result;
            Residue residueB = this.residue;
            this.residue = null;
            pc.getEnd().accept(this);
            boolean resultE = this.result;
            Residue residueE = this.residue;
            this.residue = null;
            if (resultB && residueB != null || resultB && residueE != null) {
                throw new WeaveException("bad block pointcut");
            }
            this.result = pc.match(this.getJoinPoint(), resultB, resultE);
        }
    }

    @Refine
    static class Prepare2
    extends PrepareVisitor {
        public Prepare2() {
            super(null);
        }

        public void visit(BlockPc pc) throws WeaveException {
            pc.getBegin().accept(this);
            pc.getEnd().accept(this);
        }
    }

    @Refine
    static interface PcVisitor2
    extends PointcutVisitor {
        public void visit(BlockPc var1) throws WeaveException;
    }

    public static class BlockPc
    extends PointcutNode {
        private PointcutNode begin;
        private PointcutNode end;
        private Expr beginJP;
        private Expr endJP;

        public BlockPc(PointcutNode b, PointcutNode e) {
            this.begin = b;
            this.end = e;
            this.beginJP = null;
            this.endJP = null;
        }

        public String toString() {
            return "block(" + this.begin.toString() + ", " + this.end.toString() + ")";
        }

        public PointcutNode getBegin() {
            return this.begin;
        }

        public PointcutNode getEnd() {
            return this.end;
        }

        public Expr getBeginJP() {
            return this.beginJP;
        }

        public Expr getEndJP() {
            return this.endJP;
        }

        public void clear() {
            this.beginJP = null;
            this.endJP = null;
        }

        public void accept(PointcutVisitor v) throws WeaveException {
            ((PcVisitor2)v).visit(this);
        }

        public boolean match(Expr expr, boolean matchBegin, boolean matchEnd) {
            if (matchEnd && this.beginJP != null) {
                if (this.beginJP.where() == expr.where()) {
                    this.endJP = expr;
                    return true;
                }
                this.beginJP = null;
            }
            if (matchBegin) {
                this.beginJP = expr;
            }
            return false;
        }
    }

    static class Debug
    extends Gluon {
        public static boolean stackTrace = true;

        public Debug() {
            super(null);
        }
    }
}

