/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.plugin;

import java.util.HashMap;
import javassist.gluonj.Aspect;
import javassist.gluonj.Pcd;
import javassist.gluonj.Pointcut;
import javassist.gluonj.Refine;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.CtMethod;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.embedded.expr.ExprEditor;
import javassist.gluonj.embedded.expr.FieldAccess;
import javassist.gluonj.embedded.expr.MethodCall;
import javassist.gluonj.pc.PatternParser;
import javassist.gluonj.util.SimplePcNode;
import javassist.gluonj.weave.Residue;

@Aspect
public class Updater {

    public static class UpdaterPc
    extends SimplePcNode {
        private ClassPool cpool;
        private String rootClassName;
        private CtClass rootClass;
        private String methodName;
        private HashMap updatersMap;

        public UpdaterPc(String cName, String mName) {
            this.rootClassName = cName;
            this.methodName = mName;
            this.updatersMap = new HashMap();
        }

        public String toString() {
            return "updater(" + this.rootClassName + ", " + this.methodName + ")";
        }

        public void prepare(PatternParser p) throws WeaveException {
            this.cpool = p.getClassPool();
            try {
                this.rootClass = this.cpool.get(this.rootClassName);
            }
            catch (NotFoundException e) {
                throw new WeaveException(e);
            }
        }

        public void inspect(CtClass clazz) throws WeaveException {
            if (!clazz.subclassOf(this.rootClass)) {
                return;
            }
            try {
                String className = clazz.getName();
                CtMethod m = clazz.getDeclaredMethod(this.methodName);
                HashMap fields = this.accessedFields(className, m);
                HashMap updaters = this.updateMethods(clazz, fields);
                this.updatersMap.put(className, updaters);
            }
            catch (CannotCompileException e) {
                throw new WeaveException(e);
            }
            catch (NotFoundException e) {
                return;
            }
        }

        public boolean match(MethodCall joinPoint, Residue[] residue) throws WeaveException {
            String className = joinPoint.getClassName();
            Object updaters = this.updatersMap.get(className);
            if (updaters == null) {
                return false;
            }
            try {
                return ((HashMap)updaters).get(joinPoint.getMethod()) != null;
            }
            catch (NotFoundException e) {
                throw new WeaveException(e);
            }
        }

        private HashMap accessedFields(final String className, CtMethod cm) throws CannotCompileException {
            final HashMap fields = new HashMap();
            cm.instrument(new ExprEditor(){

                public void edit(FieldAccess fa) throws CannotCompileException {
                    if (fa.getClassName().equals(className)) {
                        fields.put(fa.getFieldName(), className);
                    }
                }
            });
            return fields;
        }

        private HashMap updateMethods(CtClass clazz, HashMap fields) throws CannotCompileException {
            HashMap<CtMethod, CtClass> updaters = new HashMap<CtMethod, CtClass>();
            CtMethod[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                MethodInspector mi = new MethodInspector(fields);
                methods[i].instrument(mi);
                if (!mi.found) continue;
                updaters.put(methods[i], clazz);
            }
            return updaters;
        }

        private static class MethodInspector
        extends ExprEditor {
            private HashMap fields;
            public boolean found;

            MethodInspector(HashMap map) {
                this.fields = map;
                this.found = false;
            }

            public void edit(FieldAccess fa) throws CannotCompileException {
                String fname;
                Object className;
                if (fa.isWriter() && (className = this.fields.get(fname = fa.getFieldName())) != null && fa.getClassName().equals(className)) {
                    this.found = true;
                }
            }
        }
    }

    @Refine
    static class Pcut2
    extends Pointcut {
        public Pcut2() {
            super(null);
        }

        public Pointcut updater(String className, String methodName) {
            this.setTree(new UpdaterPc(className, methodName));
            return this;
        }
    }

    @Refine
    static class Pcd2
    extends Pcd {
        Pcd2() {
        }

        public static Pointcut updater(String className, String methodName) {
            Pointcut pc = Pcd2.make();
            return ((Pcut2)pc).updater(className, methodName);
        }
    }
}

