/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.util.List;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.CtBehavior;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.expr.Expr;
import javassist.gluonj.embedded.expr.ExprEditor;
import javassist.gluonj.embedded.expr.FieldAccess;
import javassist.gluonj.embedded.expr.MethodCall;
import javassist.gluonj.embedded.expr.NewExpr;
import javassist.gluonj.pc.CflowPc;
import javassist.gluonj.weave.Advice;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.Hook;
import javassist.gluonj.weave.Weaver;
import javassist.gluonj.weave.WrappedWeaveException;

public class AdviceWeaver {
    public static final String CONSTRUCTOR = "<init>";

    public boolean weave(CtClass orig, Gluon glue) throws WeaveException {
        if (!glue.hasAdvice()) {
            return false;
        }
        WeaveEditor editor = new WeaveEditor(glue);
        List cflows = glue.findCflows();
        try {
            CtBehavior[] members = orig.getDeclaredBehaviors();
            for (int i = 0; i < members.length; ++i) {
                members[i].instrument(editor);
                this.prepareCflow(cflows, members[i]);
            }
        }
        catch (WrappedWeaveException e) {
            throw e.weave;
        }
        catch (CannotCompileException e) {
            throw new WeaveException(e);
        }
        return editor.modified;
    }

    private void prepareCflow(List cflows, CtBehavior method) throws WeaveException {
        for (CflowPc pc : cflows) {
            pc.instrument(method);
        }
    }

    public static StringBuffer insertHook(Hook.Iterator iterator, Expr expr, Advice proceed) throws CannotCompileException {
        StringBuffer before = new StringBuffer();
        StringBuffer after = new StringBuffer();
        while (iterator.hasNext()) {
            Hook hook = (Hook)iterator.next();
            if (!AdviceWeaver.insertHook(hook, iterator, expr, before, after, proceed)) continue;
            return null;
        }
        before.insert(0, '{').append("$_ = $proceed($$);").append(after).append('}');
        expr.replace(before.toString());
        return before;
    }

    protected static boolean insertHook(Hook hook, Hook.Iterator iterator, Expr expr, StringBuffer before, StringBuffer after, Advice proceed) throws CannotCompileException {
        String cond;
        Advice adv = hook.advice;
        String body = adv.getBody(expr, proceed);
        body = AdviceWeaver.expandSpecialVars(body, expr);
        if (hook.residue != null && (cond = hook.residue.getIf()) != null) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("if(").append(cond).append("){").append(body).append("}");
            if (adv.kind == 3) {
                sbuf.append("else{ $_ = $proceed($$); }");
            }
            body = sbuf.toString();
        }
        if (adv.kind == 1) {
            before.append('{').append(body).append('}');
        } else if (adv.kind == 2) {
            after.insert(0, '}').insert(0, body).insert(0, '{');
        } else {
            if (adv.kind == 3) {
                StringBuffer around = new StringBuffer(body);
                if (before.length() > 0) {
                    around.insert(0, before);
                }
                if (after.length() > 0) {
                    around.append(after);
                }
                ExprEditor ed = iterator.hasNext() ? AdviceWeaver.makeEditor(iterator, expr) : null;
                AdviceWeaver.printLog(expr, around, adv);
                expr.replace(around.toString(), ed);
                return true;
            }
            throw new RuntimeException("bad advice: " + adv);
        }
        return false;
    }

    private static void printLog(Expr expr, StringBuffer body, Advice advice) {
        if (Gluon.stackTrace && body != null) {
            String m;
            String msg = body.toString();
            if (advice != null && (m = advice.getMessage()) != null) {
                msg = m;
            }
            Weaver.logging("weave at " + expr.getLineNumber() + ':' + expr.getFileName() + " " + msg);
        }
    }

    private static String expandSpecialVars(String body, Expr expr) throws CannotCompileException {
        int len = body.length();
        int state = 0;
        int start = 0;
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char c = body.charAt(i);
            if (state == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    state = 1;
                    start = i;
                    continue;
                }
                sbuf.append(c);
                if (c != '\"') continue;
                state = 2;
                continue;
            }
            if (state == 1) {
                if (Character.isJavaIdentifierPart(c)) continue;
                String rep = null;
                if (body.charAt(start) == '$') {
                    rep = AdviceWeaver.expandSpecialVariable(body.substring(start, i), expr);
                }
                if (rep == null) {
                    for (int k = start; k < i; ++k) {
                        sbuf.append(body.charAt(k));
                    }
                } else {
                    sbuf.append(rep);
                }
                --i;
                state = 0;
                continue;
            }
            sbuf.append(c);
            if (c == '\"') {
                state = 0;
            }
            if (c != '\\' || ++i >= len) continue;
            sbuf.append(body.charAt(i));
        }
        return sbuf.toString();
    }

    private static String expandSpecialVariable(String varName, Expr expr) throws CannotCompileException {
        String NAME = "$name";
        if (varName.equals("$name")) {
            String name;
            if (expr instanceof MethodCall) {
                name = ((MethodCall)expr).getMethodName();
            } else if (expr instanceof FieldAccess) {
                name = ((FieldAccess)expr).getFieldName();
            } else if (expr instanceof NewExpr) {
                name = ((NewExpr)expr).getClassName();
            } else {
                throw new CannotCompileException(varName + " is not available here: " + expr.where().toString());
            }
            name = "\"" + name + "\"";
            return name;
        }
        return null;
    }

    private static ExprEditor makeEditor(Hook.Iterator iterator, Expr expr) {
        Advice adv = iterator.lookAhead().getAdvice();
        ExprEditor ed = adv.makeEditor(iterator, expr);
        if (ed != null) {
            return ed;
        }
        if (expr instanceof MethodCall) {
            return new MethodCallEditor(iterator, (MethodCall)expr);
        }
        if (expr instanceof FieldAccess) {
            return new FieldAccessEditor(iterator, (FieldAccess)expr);
        }
        if (expr instanceof NewExpr) {
            return new NewExprEditor(iterator, (NewExpr)expr);
        }
        throw new RuntimeException("bad join point: " + expr);
    }

    static class FieldAccessEditor
    extends ExprEditor {
        private Hook.Iterator advices;
        private String className;
        private String fieldName;
        private String descriptor;

        public FieldAccessEditor(Hook.Iterator it, FieldAccess access) {
            this.advices = it;
            this.className = access.getClassName();
            this.fieldName = access.getFieldName();
            this.descriptor = access.getSignature();
        }

        public void edit(FieldAccess access) throws CannotCompileException {
            if (access.getClassName().equals(this.className) && access.getFieldName().equals(this.fieldName) && access.getSignature().equals(this.descriptor)) {
                AdviceWeaver.insertHook(this.advices.copy(), access, null);
            }
        }
    }

    static class NewExprEditor
    extends ExprEditor {
        private Hook.Iterator advices;
        private String className;
        private String methodName;
        private String descriptor;

        public NewExprEditor(Hook.Iterator it, NewExpr call) {
            this.advices = it;
            this.className = call.getClassName();
            this.descriptor = call.getSignature();
        }

        public void edit(NewExpr call) throws CannotCompileException {
            if (call.getClassName().equals(this.className) && call.getSignature().equals(this.descriptor)) {
                AdviceWeaver.insertHook(this.advices.copy(), call, null);
            }
        }
    }

    static class MethodCallEditor
    extends ExprEditor {
        private Hook.Iterator advices;
        private String className;
        private String methodName;
        private String descriptor;

        public MethodCallEditor(Hook.Iterator it, MethodCall call) {
            this.advices = it;
            this.className = call.getClassName();
            this.methodName = call.getMethodName();
            this.descriptor = call.getSignature();
        }

        public void edit(MethodCall call) throws CannotCompileException {
            if (call.getClassName().equals(this.className) && call.getMethodName().equals(this.methodName) && call.getSignature().equals(this.descriptor)) {
                AdviceWeaver.insertHook(this.advices.copy(), call, null);
            }
        }
    }

    public static class WeaveEditor
    extends ExprEditor {
        Gluon glue;
        boolean modified;

        public WeaveEditor(Gluon g) {
            this.glue = g;
            this.modified = false;
        }

        public void edit(MethodCall call) throws CannotCompileException {
            try {
                this.applyAdvices(this.glue.match(call), call);
            }
            catch (WeaveException e) {
                throw new WrappedWeaveException(e);
            }
        }

        public void edit(FieldAccess access) throws CannotCompileException {
            try {
                this.applyAdvices(this.glue.match(access), access);
            }
            catch (WeaveException e) {
                throw new WrappedWeaveException(e);
            }
        }

        public void edit(NewExpr access) throws CannotCompileException {
            try {
                this.applyAdvices(this.glue.match(access), access);
            }
            catch (WeaveException e) {
                throw new WrappedWeaveException(e);
            }
        }

        private void applyAdvices(Hook.List hooks, Expr expr) throws CannotCompileException {
            if (hooks.notEmpty()) {
                this.modified = true;
                StringBuffer advice = AdviceWeaver.insertHook(hooks.iterator(), expr, null);
                AdviceWeaver.printLog(expr, advice, null);
            }
        }
    }
}

