/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.io.Serializable;
import java.util.HashMap;

public class AliasList
implements Serializable {
    public AliasList next;
    protected String alias;
    protected String substExpr;

    public AliasList() {
        this.next = null;
        this.alias = null;
        this.substExpr = null;
    }

    public AliasList(String alias, String expr) {
        this.substExpr = expr;
        this.alias = alias;
        this.next = null;
    }

    public static AliasList concat(AliasList list1, AliasList list2) {
        AliasList a = list1;
        if (a == null) {
            return list2;
        }
        while (a.next != null) {
            a = a.next;
        }
        a.next = list2;
        return list1;
    }

    public static String toString(AliasList a) {
        if (a == null) {
            return "[]";
        }
        return a.toString();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('[');
        AliasList a = this;
        while (true) {
            sbuf.append(a.alias);
            sbuf.append('=');
            sbuf.append(a.substExpr);
            a = a.next;
            if (a == null) break;
            sbuf.append(',');
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    public String expand(String src) {
        HashMap hash = new HashMap();
        this.expand(hash);
        return AliasList.expand(src, hash);
    }

    private void expand(HashMap hash) {
        if (this.next != null) {
            this.next.expand(hash);
        }
        String expr = AliasList.expand(this.substExpr, hash);
        hash.put(this.alias, "(" + expr + ")");
    }

    private static String expand(String src, HashMap hash) {
        StringBuffer dest = new StringBuffer();
        StringBuffer token = new StringBuffer();
        boolean start = true;
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (start) {
                if (Character.isJavaIdentifierStart(c)) {
                    start = false;
                    token.append(c);
                    continue;
                }
                dest.append(c);
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                token.append(c);
                continue;
            }
            start = true;
            AliasList.appendToken(dest, token, hash);
            token = new StringBuffer();
            dest.append(c);
        }
        if (token.length() > 0) {
            AliasList.appendToken(dest, token, hash);
        }
        return dest.toString();
    }

    private static void appendToken(StringBuffer dest, StringBuffer token, HashMap hash) {
        String t = token.toString();
        String t2 = (String)hash.get(t);
        if (t2 != null) {
            t = t2;
        }
        dest.append(t);
    }
}

