/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javassist.gluonj.Pointcut;
import javassist.gluonj.Privileged;
import javassist.gluonj.Refine;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.embedded.expr.FieldAccess;
import javassist.gluonj.embedded.expr.MethodCall;
import javassist.gluonj.embedded.expr.NewExpr;
import javassist.gluonj.pc.PointcutNode;
import javassist.gluonj.weave.Advice;
import javassist.gluonj.weave.AliasList;
import javassist.gluonj.weave.CallMatcher;
import javassist.gluonj.weave.CflowCollector;
import javassist.gluonj.weave.FieldMatcher;
import javassist.gluonj.weave.GluonMaker;
import javassist.gluonj.weave.Hook;
import javassist.gluonj.weave.Inspector;
import javassist.gluonj.weave.Matcher;
import javassist.gluonj.weave.NewMatcher;
import javassist.gluonj.weave.Refiner;

public class Gluon {
    private String glueName;
    private ClassPool pool;
    protected List children;
    protected List refiners;
    private HashMap helpers;
    protected List advices;
    private ArrayList inspectors;
    private static final int UNKNOWN = 0;
    private static final int EMPTY = -1;
    private static final int NOT_EMPTY = 1;
    private int hasAdviceCache;
    public static boolean stackTrace = false;
    public static GluonMaker maker = new GluonMaker();

    public Gluon(String name) {
        this(name, new ClassPool(true));
    }

    public Gluon(String name, ClassPool cp) {
        this.pool = cp;
        this.glueName = name;
        this.children = new LinkedList();
        this.refiners = new LinkedList();
        this.helpers = new HashMap();
        this.advices = new LinkedList();
        this.hasAdviceCache = 0;
    }

    public ClassPool getPool() {
        return this.pool;
    }

    public String getName() {
        return this.glueName;
    }

    public String toString() {
        return super.toString() + "[" + this.glueName + "]";
    }

    public Gluon refine(CtClass refine) throws WeaveException {
        this.refiners.add(new Refiner(refine, this.glueName, false, null));
        return this;
    }

    public Gluon refine(CtClass refine, Object[] anno) throws WeaveException {
        if (anno == null) {
            anno = refine.getAvailableAnnotations();
        }
        boolean priv = false;
        String target = null;
        for (int i = 0; i < anno.length; ++i) {
            String arg;
            if (anno[i] instanceof Privileged) {
                priv = true;
                continue;
            }
            if (!(anno[i] instanceof Refine) || (arg = ((Refine)anno[i]).value()) == null || arg.length() <= 0) continue;
            target = arg;
        }
        this.refiners.add(new Refiner(refine, this.glueName, priv, target));
        return this;
    }

    public void addHelper(String className) {
        this.helpers.put(className, className);
    }

    public boolean isHelper(String className) {
        return this.helpers.get(className) != null;
    }

    public Iterator getRefiners() {
        return new Iterator(){
            Iterator glues;
            boolean finish;
            Iterator cur;
            {
                this.glues = Gluon.this.children.iterator();
                this.finish = false;
                this.cur = this.nextIterator();
            }

            private Iterator nextIterator() {
                if (this.glues.hasNext()) {
                    Gluon g = (Gluon)this.glues.next();
                    return g.getRefiners();
                }
                if (this.finish) {
                    return null;
                }
                this.finish = true;
                return Gluon.this.refiners.iterator();
            }

            public boolean hasNext() {
                do {
                    if (this.cur.hasNext()) {
                        return true;
                    }
                    this.cur = this.nextIterator();
                } while (this.cur != null);
                return false;
            }

            public Object next() {
                return this.cur.next();
            }

            public void remove() {
                throw new RuntimeException("fatal: not implemented");
            }
        };
    }

    public boolean hasAdvice() {
        if (this.hasAdviceCache != 0) {
            return this.hasAdviceCache != -1;
        }
        if (!this.advices.isEmpty()) {
            this.hasAdviceCache = 1;
            return true;
        }
        for (Gluon g : this.children) {
            if (!g.hasAdvice()) continue;
            this.hasAdviceCache = 1;
            return true;
        }
        this.hasAdviceCache = -1;
        return false;
    }

    public Gluon include(Gluon child) {
        this.children.add(child);
        this.hasAdviceCache = 0;
        this.helpers.putAll(child.helpers);
        return this;
    }

    public boolean isIncluded(String glueName) {
        if (glueName.equals(this.getName())) {
            return true;
        }
        for (Gluon c : this.children) {
            if (!c.isIncluded(glueName)) continue;
            return true;
        }
        return false;
    }

    public Advice addAdvice(int kind, Pointcut pc, String advice) throws WeaveException {
        Advice adv = new Advice(kind, advice);
        this.addAdvice(pc, adv);
        return adv;
    }

    void addAdvice(Pointcut pc, Advice adv) throws WeaveException {
        AliasList alias = new AliasList();
        PointcutNode pcn = Pointcut2.parse0(this, pc, alias);
        adv.setPointcut(pcn, alias.next);
        this.advices.add(adv);
        this.hasAdviceCache = 0;
    }

    private void addAdvice2(int kind, Pointcut pc, String advice) {
        try {
            this.addAdvice(kind, pc, advice);
        }
        catch (WeaveException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Gluon before(Pointcut pc, String advice) {
        this.addAdvice2(1, pc, advice);
        return this;
    }

    public Gluon addBefore(Pointcut pc, String advice) throws WeaveException {
        this.addAdvice(1, pc, advice);
        return this;
    }

    public Gluon after(Pointcut pc, String advice) {
        this.addAdvice2(2, pc, advice);
        return this;
    }

    public Gluon addAfter(Pointcut pc, String advice) throws WeaveException {
        this.addAdvice(2, pc, advice);
        return this;
    }

    public Gluon around(Pointcut pc, String advice) {
        this.addAdvice2(3, pc, advice);
        return this;
    }

    public Gluon addAround(Pointcut pc, String advice) throws WeaveException {
        this.addAdvice(3, pc, advice);
        return this;
    }

    public static Gluon create(String className) throws RuntimeException {
        try {
            return Gluon.make(className);
        }
        catch (WeaveException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Gluon make(String className) throws WeaveException {
        return Gluon.make(className, new ClassPool(true), null);
    }

    public static Gluon make(String className, ClassPool cp) throws WeaveException {
        return Gluon.make(className, cp, null);
    }

    public static Gluon make(String className, ClassPool cp, ClassLoader cloader) throws WeaveException {
        try {
            return maker.make(className, cp, cloader, null);
        }
        catch (NotFoundException e) {
            throw new WeaveException(e);
        }
    }

    public void registerInspector(Inspector i) {
        if (this.inspectors == null) {
            this.inspectors = new ArrayList();
        }
        this.inspectors.add(i);
    }

    public List getInspectors() {
        return this.inspectors;
    }

    public Hook.List match(MethodCall mcall) throws WeaveException {
        return this.match(new CallMatcher(mcall));
    }

    public Hook.List match(FieldAccess fa) throws WeaveException {
        return this.match(new FieldMatcher(fa));
    }

    public Hook.List match(NewExpr newexpr) throws WeaveException {
        return this.match(new NewMatcher(newexpr));
    }

    private Hook.List match(Matcher matcher) throws WeaveException {
        Hook.List list = new Hook.List();
        this.match(matcher, list);
        return list;
    }

    private void match(Matcher matcher, Hook.List list) throws WeaveException {
        for (Gluon g : this.children) {
            g.match(matcher, list);
        }
        for (Advice adv : this.advices) {
            adv.getPointcut().accept(matcher);
            if (!matcher.getResult()) continue;
            list.add(matcher.getResidue(), adv);
        }
    }

    public List findCflows() throws WeaveException {
        LinkedList list = new LinkedList();
        this.findCflows(list);
        return list;
    }

    private void findCflows(List list) throws WeaveException {
        CflowCollector collector = new CflowCollector(list);
        for (Gluon g : this.children) {
            g.findCflows(list);
        }
        for (Advice adv : this.advices) {
            adv.getPointcut().accept(collector);
        }
    }

    static class Pointcut2
    extends Pointcut {
        protected Pointcut2(Pointcut p) {
            super(p);
        }

        public static PointcutNode parse0(Gluon gluon, Pointcut pc, AliasList a) throws WeaveException {
            return Pointcut2.parse(gluon, pc, a);
        }
    }
}

