/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javassist.gluonj.Client;
import javassist.gluonj.Get;
import javassist.gluonj.If;
import javassist.gluonj.Overwrite;
import javassist.gluonj.Pointcut;
import javassist.gluonj.Set;
import javassist.gluonj.Super;
import javassist.gluonj.SuperOf;
import javassist.gluonj.WeaveException;
import javassist.gluonj.Within;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.ClassMap;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CodeConverter;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.CtConstructor;
import javassist.gluonj.embedded.CtField;
import javassist.gluonj.embedded.CtMethod;
import javassist.gluonj.embedded.CtNewMethod;
import javassist.gluonj.embedded.Modifier;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.embedded.bytecode.AnnotationsAttribute;
import javassist.gluonj.embedded.bytecode.AttributeInfo;
import javassist.gluonj.embedded.bytecode.CodeAttribute;
import javassist.gluonj.embedded.bytecode.CodeIterator;
import javassist.gluonj.embedded.bytecode.ConstPool;
import javassist.gluonj.embedded.bytecode.FieldInfo;
import javassist.gluonj.embedded.bytecode.annotation.Annotation;
import javassist.gluonj.embedded.convert.TransformCall;
import javassist.gluonj.embedded.convert.Transformer;
import javassist.gluonj.pc.RefinePc;
import javassist.gluonj.weave.Advice;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.NamePattern;
import javassist.gluonj.weave.RefineAdvice;
import javassist.gluonj.weave.RefineParam;
import javassist.gluonj.weave.Refiner;

public class RefineWeaver {
    private static int counter = 0;

    public CtClass getTarget(CtClass refiner) throws WeaveException {
        try {
            return this.getTarget0(refiner);
        }
        catch (NotFoundException nfe) {
            throw new WeaveException(nfe);
        }
    }

    protected CtClass getTarget0(CtClass refiner) throws WeaveException, NotFoundException {
        boolean isIntf = refiner.isInterface();
        if (isIntf) {
            CtClass[] interfaces = refiner.getInterfaces();
            if (interfaces.length > 0) {
                return interfaces[0];
            }
            throw new WeaveException(refiner.getName() + " must extend another interface");
        }
        CtClass target = refiner.getSuperclass();
        if (target.getName().equals("java.lang.Object")) {
            throw new WeaveException(refiner.getName() + " must not directly extend java.lang.Object");
        }
        return target;
    }

    public void prepare(String targetName, Refiner refiner, Gluon glue) throws WeaveException {
        ArrayList<Object> methodsWithClient = new ArrayList<Object>();
        HashMap<String, String> advices = new HashMap<String, String>();
        CtClass refinerClass = refiner.body;
        CtMethod[] newMethods = refinerClass.getDeclaredMethods();
        for (int i = 0; i < newMethods.length; ++i) {
            NamePattern memberName;
            boolean wildcard;
            int kind;
            CtMethod cm = newMethods[i];
            Object[] anno = cm.getAvailableAnnotations();
            Within wpc = null;
            If ifpc = null;
            Get getpc = null;
            Set setpc = null;
            String overwrite = null;
            boolean withClient = false;
            String fieldName = null;
            boolean notQualified = true;
            for (int j = 0; j < anno.length; ++j) {
                Object a = anno[j];
                if (a instanceof Within) {
                    wpc = (Within)a;
                    notQualified = false;
                    continue;
                }
                if (a instanceof If) {
                    ifpc = (If)a;
                    notQualified = false;
                    continue;
                }
                if (a instanceof Set) {
                    setpc = (Set)a;
                    fieldName = setpc.value();
                    notQualified = false;
                    continue;
                }
                if (a instanceof Get) {
                    getpc = (Get)a;
                    fieldName = getpc.value();
                    notQualified = false;
                    continue;
                }
                if (!(a instanceof Overwrite)) continue;
                overwrite = ((Overwrite)a).value();
            }
            if (this.hasClient(cm.getAvailableParameterAnnotations())) {
                withClient = true;
                notQualified = false;
            }
            if (notQualified) continue;
            String descriptor = cm.getSignature();
            if (setpc == null && getpc == null) {
                kind = 0;
                wildcard = overwrite != null;
                memberName = new NamePattern(wildcard ? overwrite : cm.getName());
            } else {
                if (setpc != null && getpc != null) {
                    throw new WeaveException("@Set and @Get are mutually exclusive: " + cm.getLongName());
                }
                if (setpc != null && !descriptor.endsWith(")V")) {
                    throw new WeaveException("The return type must be void: " + cm.getLongName());
                }
                if (getpc != null && !withClient && !descriptor.startsWith("()")) {
                    throw new WeaveException("The method must not take a parameter: " + cm.getLongName());
                }
                if (overwrite != null) {
                    throw new WeaveException("@Overwrite with @Set or @Get: " + cm.getLongName());
                }
                memberName = new NamePattern(fieldName);
                kind = setpc == null ? 1 : 2;
                wildcard = true;
            }
            String adviceName = RefineWeaver.makeAdviceName(cm.getName());
            advices.put(Refiner.getAdviceKey(cm), adviceName);
            RefinePc rpc = new RefinePc(adviceName, new NamePattern(targetName), memberName, descriptor, kind, withClient, cm);
            Pointcut pc = RefinePc.make(rpc);
            if (wpc != null) {
                pc = pc.and.within(wpc.value());
            }
            if (ifpc != null) {
                pc = pc.and.when(ifpc.value());
            }
            RefineAdvice a = new RefineAdvice(cm, setpc != null, adviceName, wildcard, withClient);
            if (withClient) {
                methodsWithClient.add(pc);
                methodsWithClient.add(a);
                continue;
            }
            glue.addAdvice(pc, a);
        }
        Iterator it = methodsWithClient.iterator();
        while (it.hasNext()) {
            Pointcut p = (Pointcut)it.next();
            Advice a = (Advice)it.next();
            glue.addAdvice(p, a);
        }
        if (advices.size() > 0) {
            refiner.setAdvices(advices);
        }
    }

    private static String makeAdviceName(String name) {
        return name + "_gj_" + counter++;
    }

    protected static String makeOrigName(String name) {
        return name + "__gj_" + counter++;
    }

    protected static boolean hasGluonJTag(String name) {
        int i = name.indexOf("_gj_");
        if (i < 0) {
            return false;
        }
        char c = name.charAt(i + 4);
        return '0' <= c && c <= '9';
    }

    public void weave(CtClass target, Refiner refiner, ClassMap allRefinerNames) throws WeaveException, CannotCompileException, NotFoundException {
        int first;
        CtClass refinerClass = refiner.body;
        if (refiner.getTargetName() != null && !refiner.privileged) {
            throw new WeaveException("@Refine(" + refiner.getTargetName() + ") needs @Privileged: " + refinerClass.getName());
        }
        boolean isIntf = refinerClass.isInterface();
        if (isIntf != target.isInterface()) {
            String s = isIntf ? "a class. " : "an interface.";
            throw new WeaveException(refinerClass.getName() + " must be " + s);
        }
        HashMap superOfFields = this.copyFields(target, refiner);
        CtClass[] interfaces = refinerClass.getInterfaces();
        for (int i = first = isIntf ? 1 : 0; i < interfaces.length; ++i) {
            if (target.subtypeOf(interfaces[i])) continue;
            target.addInterface(interfaces[i]);
        }
        if (!isIntf) {
            RefineWeaver.copyConstructors(target, refiner, allRefinerNames);
        }
        RefineWeaver.copyClassInitializer(target, refiner, allRefinerNames);
        this.copyMethods(target, refiner, isIntf, allRefinerNames, superOfFields);
        refiner.revert();
    }

    protected HashMap copyFields(CtClass target, Refiner refiner) throws WeaveException, CannotCompileException, NotFoundException {
        CtClass refinerClass = refiner.body;
        CtField[] newFields = refinerClass.getDeclaredFields();
        HashMap superOfFields = new HashMap();
        for (int i = 0; i < newFields.length; ++i) {
            CtField f = newFields[i];
            Object[] anno = f.getAvailableAnnotations();
            String superOfArg = this.isSuperOfAlias(anno);
            if (superOfArg != null) {
                RefineParam.putSuperOf(superOfFields, superOfArg, f);
                continue;
            }
            CtField origF = null;
            try {
                origF = target.getField(f.getName());
            }
            catch (NotFoundException e) {
                if (this.isSuperAlias(anno) != null) {
                    throw new WeaveException("non-overriding field with @Super: " + f);
                }
                CtField newF = new CtField(f, target);
                target.addField(newF);
                continue;
            }
            if (!refiner.privileged && !origF.visibleFrom(refinerClass)) {
                throw new WeaveException(refinerClass.getName() + " cannot access a field", origF);
            }
            if (!origF.getSignature().equals(f.getSignature())) {
                throw new WeaveException("incompatible field type", f);
            }
            if (Modifier.isFinal(origF.getModifiers())) {
                throw new WeaveException("cannot update a final field", origF);
            }
            FieldInfo info = f.getFieldInfo2();
            FieldInfo origInfo = origF.getFieldInfo2();
            AttributeInfo ai = info.getAttribute("ConstantValue");
            if (ai != null) {
                origInfo.addAttribute(ai);
            }
            RefineWeaver.appendAnnotations(true, info, origInfo);
            RefineWeaver.appendAnnotations(false, info, origInfo);
        }
        return superOfFields;
    }

    private static void appendAnnotations(boolean visible, FieldInfo src, FieldInfo dest) {
        String tag = visible ? "RuntimeInvisibleAnnotations" : "RuntimeVisibleAnnotations";
        AnnotationsAttribute srcAttr = (AnnotationsAttribute)src.getAttribute(tag);
        if (srcAttr == null) {
            return;
        }
        AnnotationsAttribute destAttr = (AnnotationsAttribute)dest.getAttribute(tag);
        if (destAttr == null) {
            dest.addAttribute(srcAttr);
            return;
        }
        Annotation[] anno = srcAttr.getAnnotations();
        for (int i = 0; i < anno.length; ++i) {
            destAttr.addAnnotation(anno[i]);
        }
    }

    protected static void copyConstructors(CtClass target, Refiner refiner, ClassMap allRefiners) throws WeaveException, CannotCompileException, NotFoundException {
        CtClass refinerClass = refiner.body;
        CtConstructor[] cons = refinerClass.getDeclaredConstructors();
        if (cons.length != 1) {
            throw new WeaveException("more than one constructors in " + refinerClass.getName());
        }
        CtConstructor cc = cons[0];
        if (cc.isEmpty()) {
            return;
        }
        if (!cc.getSignature().equals("()V")) {
            throw new WeaveException("constructor with parameters in " + refinerClass.getName());
        }
        String methodName = target.makeUniqueName("_init");
        CtMethod mth = cc.toMethod(methodName, target, allRefiners);
        mth.setModifiers(2);
        target.addMethod(mth);
        String flagName = target.makeUniqueName("_init_flag");
        CtField flag = new CtField(CtClass.booleanType, flagName, target);
        target.addField(flag);
        cons = target.getDeclaredConstructors();
        String expr = "if(!" + flagName + "){" + flagName + "=true;" + methodName + "();}";
        for (int i = 0; i < cons.length; ++i) {
            CtConstructor c = cons[i];
            c.insertAfter(expr);
        }
    }

    protected static void copyClassInitializer(CtClass target, Refiner refine, ClassMap allRefiners) throws WeaveException, CannotCompileException, NotFoundException {
        CtConstructor cons = refine.body.getClassInitializer();
        if (cons == null || cons.isEmpty()) {
            return;
        }
        CtConstructor dest = target.getClassInitializer();
        if (dest == null) {
            dest = new CtConstructor(cons, target, allRefiners);
            target.addConstructor(dest);
        } else {
            String methodName = target.makeUniqueName("_clinit");
            CtMethod mth = cons.toMethod(methodName, target, allRefiners);
            mth.setModifiers(10);
            target.addMethod(mth);
            dest.insertAfter(methodName + "();");
        }
    }

    protected void copyMethods(CtClass target, Refiner refiner, boolean isIntf, ClassMap allRefiners, HashMap superOfFields) throws WeaveException, NotFoundException, CannotCompileException {
        RefineParam refParam = new RefineParam(target, refiner, superOfFields);
        ArrayList superOrigPairs = this.findAtSuperMethods(refiner, target, refParam);
        this.copyMethodLoop(target, isIntf, refiner, refParam);
        if (superOrigPairs != null) {
            this.convSuperToOrig(refParam.refinerConv, superOrigPairs);
        }
        allRefiners.fix(target);
        for (CtMethod m : refParam.addedMethods) {
            m.instrument(refParam.refinerConv);
            CtMethod newM = CtNewMethod.copy(m, target, allRefiners);
            target.addMethod(newM);
        }
        this.beAbstractIfYes(target);
    }

    protected void beAbstractIfYes(CtClass clazz) {
        int mod = clazz.getModifiers();
        if (Modifier.isInterface(mod)) {
            return;
        }
        CtMethod[] m = clazz.getDeclaredMethods();
        int n = m.length;
        for (int i = 0; i < n; ++i) {
            if (!Modifier.isAbstract(m[i].getModifiers())) continue;
            clazz.setModifiers(clazz.getModifiers() | 0x400);
            return;
        }
        clazz.setModifiers(Modifier.clear(mod, 1024));
    }

    private ArrayList findAtSuperMethods(Refiner refiner, CtClass target, RefineParam param) throws WeaveException {
        ArrayList list = new ArrayList();
        this.findAtSuperMethods0(list, param, refiner, target, param.refineMethods, param.annotations);
        while (refiner.parent != null) {
            refiner = refiner.parent;
            this.findAtSuperMethods0(list, param, refiner, target, refiner.body.getDeclaredMethods(), null);
        }
        return list;
    }

    private void findAtSuperMethods0(ArrayList superOrigPairs, RefineParam param, Refiner refiner, CtClass target, CtMethod[] newMethods, Object[][] newMethodsAnno) throws WeaveException {
        boolean privileged = refiner.privileged;
        for (int j = 0; j < newMethods.length; ++j) {
            String origName;
            CtMethod m = newMethods[j];
            String name = m.getName();
            Object[] anno = m.getAvailableAnnotations();
            if (newMethodsAnno != null) {
                newMethodsAnno[j] = anno;
            }
            if ((origName = this.isSuperAlias(anno)) != null) {
                if (origName.equals("")) {
                    origName = name;
                }
                try {
                    CtMethod origM = target.getMethod(origName, m.getSignature());
                    if (origM.getDeclaringClass() == target) {
                        if (!privileged && !origM.visibleFrom(refiner.body)) {
                            this.throwBadSuper(name, refiner.body);
                        }
                    } else if (!origM.visibleFrom(target)) {
                        this.throwBadSuper(name, refiner.body);
                    }
                    superOrigPairs.add(m);
                    superOrigPairs.add(origM);
                    continue;
                }
                catch (NotFoundException e) {
                    String msg = "no such @Super method: " + name + " in " + refiner.body.getName();
                    throw new WeaveException(msg);
                }
            }
            String overriderName = this.isSuperOfAlias(anno);
            if (overriderName == null || param.putSuperOf(overriderName, m) == null) continue;
            throw new WeaveException("duplicated @SuperOf: " + m.getLongName());
        }
    }

    private void throwBadSuper(String name, CtClass refiner) throws WeaveException {
        String msg = "invisible @Super method: " + name + " in " + refiner.getName();
        throw new WeaveException(msg);
    }

    protected void copyMethodLoop(CtClass target, boolean isIntf, Refiner refiner, RefineParam param) throws WeaveException, CannotCompileException {
        int i;
        int num = param.refineMethods.length;
        boolean[] withClient = new boolean[num];
        for (i = 0; i < num; ++i) {
            withClient[i] = this.hasClient(param.refineMethods[i].getAvailableParameterAnnotations());
        }
        for (i = 0; i < num; ++i) {
            if (withClient[i]) continue;
            this.copyMethodLoop2(i, false, target, isIntf, refiner, param);
        }
        for (i = 0; i < num; ++i) {
            if (!withClient[i]) continue;
            this.copyMethodLoop2(i, true, target, isIntf, refiner, param);
        }
    }

    private void copyMethodLoop2(int index, boolean withClient, CtClass target, boolean isIntf, Refiner refiner, RefineParam param) throws WeaveException, CannotCompileException {
        CtMethod m = param.refineMethods[index];
        Object[] anno = param.annotations[index];
        for (int j = 0; j < anno.length; ++j) {
            Object a = anno[j];
            if (a instanceof Super || a instanceof SuperOf) {
                return;
            }
            if (a instanceof Overwrite) {
                this.copyOverwriteMethod(target, isIntf, refiner, param, m, ((Overwrite)a).value(), withClient);
                return;
            }
            if (a instanceof Set) {
                this.copySetGetMethod(target, isIntf, refiner, param, m, ((Set)a).value(), withClient);
                return;
            }
            if (!(a instanceof Get)) continue;
            this.copySetGetMethod(target, isIntf, refiner, param, m, ((Get)a).value(), withClient);
            return;
        }
        this.copySingleMethod(target, isIntf, refiner, param, m, withClient);
    }

    private String copySingleMethod(CtClass target, boolean isIntf, Refiner refiner, RefineParam param, CtMethod m, boolean withClient) throws CannotCompileException, WeaveException {
        if (param.getSuperOf(m) != null) {
            throw new WeaveException("@SuperOf is available only in @Overwrite methods: " + m.getLongName());
        }
        String adviceName = refiner.getAdviceName(m);
        CtClass refinerClass = refiner.body;
        if (adviceName != null) {
            CtMethod copy = CtNewMethod.copy(m, adviceName, refinerClass, null);
            param.addMethod(copy);
            this.addCombinedAdvices(param, m, target, refinerClass, adviceName, withClient);
            param.putOtherAdvice(m, m, adviceName, copy, withClient);
        } else {
            MethodDef found = (MethodDef)param.targetMethods.get(m);
            if (found == null) {
                param.addMethod(m);
            } else if (found.target.getDeclaringClass() != target) {
                if (Modifier.isFinal(found.target.getModifiers())) {
                    throw new WeaveException("cannot override a final method: " + found.target.getLongName());
                }
                param.addMethod(m);
            } else {
                this.overrideOrigMethod(target, isIntf, param, refinerClass, refiner.privileged, m, found);
            }
        }
        return adviceName;
    }

    private void addCombinedAdvices(RefineParam param, CtMethod src, CtClass target, CtClass refinerClass, String adviceName, boolean withClient) throws CannotCompileException, WeaveException {
        RefineParam.AdviceBody head;
        String sig = src.getSignature();
        RefineParam.AdviceBody list = head = param.getOtherAdvice(src.getName(), withClient ? RefineWeaver.removeClientParam(sig) : sig);
        RefineParam.AdviceBodyList newList = new RefineParam.AdviceBodyList();
        while (list != null) {
            this.checkMultipleClientAdvice(list, src);
            String name = list.name + "_" + adviceName;
            CtMethod copy = CtNewMethod.copy(src, name, refinerClass, null);
            CodeConverter2 conv = new CodeConverter2();
            conv.redirectProceed(target.getName(), src.getName(), list.method);
            copy.instrument(conv);
            copy.setModifiers(Modifier.setPublic(copy.getModifiers()));
            param.addMethod(copy);
            newList.append(new RefineParam.AdviceBody(src, name, copy, withClient));
            list = list.next;
        }
        newList.concat(head);
    }

    private void checkMultipleClientAdvice(RefineParam.AdviceBody ab, CtMethod advice) throws WeaveException {
        if (ab.withClient) {
            throw new WeaveException("sorry, not implemented; multiple @Client methods for the same join point: " + ab.srcMethod.getLongName() + " and " + advice.getLongName());
        }
    }

    private static String removeClientParam(String desc) {
        return "(" + desc.substring(desc.indexOf(59) + 1);
    }

    private void copyOverwriteMethod(CtClass target, boolean isIntf, Refiner refiner, RefineParam param, CtMethod m, String pattern, boolean withClient) throws WeaveException, CannotCompileException {
        String signature = m.getSignature();
        if (withClient) {
            signature = RefineWeaver.removeClientParam(signature);
        }
        NamePattern npat = new NamePattern(pattern);
        ClassPool cp = refiner.body.getClassPool();
        for (MethodDef mdef : param.targetMethods.values()) {
            CtMethod mt = mdef.target;
            if (!npat.matchMember(mdef.origName, cp) || !mt.getSignature().equals(signature)) continue;
            String adviceName = refiner.getAdviceName(m);
            String newMethodName = adviceName == null ? mt.getName() : mdef.origName + "_" + adviceName;
            CtMethod newM = CtNewMethod.copy(m, newMethodName, m.getDeclaringClass(), null);
            CtMethod superOf = param.getSuperOf(m, signature);
            if (superOf != null) {
                CodeConverter2 conv = new CodeConverter2();
                conv.redirectMethodCall(superOf, mt);
                newM.instrument(conv);
            }
            if (adviceName == null) {
                if (mt.getDeclaringClass() == target) {
                    this.overrideOrigMethod(target, isIntf, param, refiner.body, refiner.privileged, newM, mdef);
                    continue;
                }
                if (Modifier.isFinal(mt.getModifiers())) {
                    throw new WeaveException("cannot override a final method not directly declared in the target class: " + mt.getLongName());
                }
                param.addMethod(newM);
                continue;
            }
            param.addMethod(newM);
            this.addCombinedAdvices2(param, mdef, m, refiner.body, adviceName, superOf, withClient);
            param.putOtherAdvice(m, mdef.origName, mt.getSignature(), newMethodName, newM, withClient);
        }
    }

    private boolean hasClient(Object[][] paramAnno) {
        if (paramAnno.length < 1) {
            return false;
        }
        Object[] anno = paramAnno[0];
        for (int j = 0; j < anno.length; ++j) {
            if (!(anno[j] instanceof Client)) continue;
            return true;
        }
        return false;
    }

    private void addCombinedAdvices2(RefineParam param, MethodDef target, CtMethod src, CtClass refinerClass, String adviceName, CtMethod superOf, boolean withClient) throws CannotCompileException, WeaveException {
        RefineParam.AdviceBody head;
        RefineParam.AdviceBody list = head = param.getOtherAdvice(target.origName, target.target.getSignature());
        RefineParam.AdviceBodyList newList = new RefineParam.AdviceBodyList();
        while (list != null) {
            this.checkMultipleClientAdvice(list, src);
            String name = list.name + "_" + adviceName;
            CtMethod copy = CtNewMethod.copy(src, name, refinerClass, null);
            if (superOf != null) {
                CodeConverter conv = new CodeConverter();
                conv.redirectMethodCall(superOf, list.method);
                copy.instrument(conv);
            }
            copy.setModifiers(Modifier.setPublic(copy.getModifiers()));
            param.addMethod(copy);
            newList.append(new RefineParam.AdviceBody(src, name, copy, withClient));
            list = list.next;
        }
        newList.concat(head);
    }

    private void copySetGetMethod(CtClass target, boolean isIntf, Refiner refiner, RefineParam param, CtMethod m, String pattern, boolean withClient) throws WeaveException, CannotCompileException {
        NamePattern npat = new NamePattern(pattern);
        ClassPool cp = refiner.body.getClassPool();
        CtField[] fields = target.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            CtField targetField = fields[i];
            String fname = targetField.getName();
            if (!npat.matchMember(fname, cp)) continue;
            String adviceName = refiner.getAdviceName(m);
            if (adviceName == null) {
                throw new WeaveException("fatal error: " + m.getLongName());
            }
            String newMethodName = fname + "_" + adviceName;
            CtMethod newM = CtNewMethod.copy(m, newMethodName, m.getDeclaringClass(), null);
            newM.setModifiers(Modifier.setPublic(newM.getModifiers()));
            CtField superOf = param.getSuperOf(m.getName(), targetField);
            if (superOf != null) {
                CodeConverter2 conv = new CodeConverter2();
                conv.redirectFieldAccess(superOf, m.getDeclaringClass(), fname);
                newM.instrument(conv);
            }
            param.addMethod(newM);
            this.addCombinedAdvices3(param, targetField, m, adviceName, superOf, withClient);
            param.putOtherAdvice(m, targetField, newMethodName, newM, withClient);
        }
    }

    private void addCombinedAdvices3(RefineParam param, CtField target, CtMethod src, String adviceName, CtField superOf, boolean withClient) throws CannotCompileException, WeaveException {
        RefineParam.AdviceBody head;
        RefineParam.AdviceBody list = head = param.getOtherAdvice(target.getName(), target.getSignature());
        RefineParam.AdviceBodyList newList = new RefineParam.AdviceBodyList();
        while (list != null) {
            this.checkMultipleClientAdvice(list, src);
            String name = list.name + "_" + adviceName;
            CtMethod copy = CtNewMethod.copy(src, name, src.getDeclaringClass(), null);
            if (superOf != null) {
                CodeConverter2 conv = new CodeConverter2();
                conv.redirectFieldAccess(superOf, list.method);
                copy.instrument(conv);
            }
            copy.setModifiers(Modifier.setPublic(copy.getModifiers()));
            param.addMethod(copy);
            newList.append(new RefineParam.AdviceBody(src, name, copy, withClient));
            list = list.next;
        }
        newList.concat(head);
    }

    private void overrideOrigMethod(CtClass target, boolean isIntf, RefineParam param, CtClass refinerClass, boolean privileged, CtMethod m, MethodDef found) throws WeaveException, CannotCompileException {
        CtMethod mth = found.target;
        if (!privileged && !mth.visibleFrom(refinerClass)) {
            throw new WeaveException("cannot override an invisible method: " + m.getName() + " in " + refinerClass.getName());
        }
        if (!isIntf) {
            if (Modifier.isAbstract(mth.getModifiers())) {
                try {
                    target.removeMethod(mth);
                }
                catch (NotFoundException e) {}
            } else {
                this.renameOrigMethod(target, found, param.refinerConv);
            }
            param.addMethod(m);
        }
    }

    private String isSuperAlias(Object[] anno) {
        for (int i = 0; i < anno.length; ++i) {
            if (!(anno[i] instanceof Super)) continue;
            return ((Super)anno[i]).value();
        }
        return null;
    }

    private String isSuperOfAlias(Object[] anno) {
        for (int i = 0; i < anno.length; ++i) {
            if (!(anno[i] instanceof SuperOf)) continue;
            return ((SuperOf)anno[i]).value();
        }
        return null;
    }

    private void renameOrigMethod(CtClass orig, MethodDef origM, CodeConverter conv) throws CannotCompileException {
        CtMethod mth = origM.target;
        String origName = mth.getName();
        String methodName = RefineWeaver.makeOrigName(origName);
        try {
            orig.getMethod(methodName, mth.getSignature());
            methodName = orig.makeUniqueName(methodName);
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        mth.setName(methodName);
        int mod = mth.getModifiers();
        mth.setModifiers(Modifier.setPrivate(mod));
        if (origM.overrider == null) {
            conv.redirectMethodCall(origName, mth);
        } else {
            conv.redirectMethodCall(origM.overrider, mth);
        }
    }

    private void convSuperToOrig(CodeConverter conv, ArrayList superOrigPairs) throws CannotCompileException {
        int n = superOrigPairs.size();
        int i = 0;
        while (i < n) {
            CtMethod superM = (CtMethod)superOrigPairs.get(i++);
            CtMethod origM = (CtMethod)superOrigPairs.get(i++);
            conv.redirectMethodCall(superM, origM);
        }
    }

    public static class TransformProceedAccess
    extends Transformer {
        String className;
        String fieldName;
        String methodName;
        String typedesc;
        private ConstPool constPool;
        private int newIndex;

        public TransformProceedAccess(Transformer next, CtField orig, CtMethod subst) {
            super(next);
            this.className = orig.getDeclaringClass().getName();
            this.fieldName = orig.getName();
            this.methodName = subst.getName();
            this.typedesc = subst.getSignature();
        }

        public void initialize(ConstPool cp, CodeAttribute attr) {
            if (this.constPool != cp) {
                this.newIndex = 0;
            }
        }

        public int transform(CtClass clazz, int pos, CodeIterator iterator, ConstPool cp) {
            int c = iterator.byteAt(pos);
            if (c == 180 || c == 178 || c == 181 || c == 179) {
                int index = iterator.u16bitAt(pos + 1);
                int classIndex = cp.getFieldrefClass(index);
                if (cp.getFieldrefName(index).equals(this.fieldName) && cp.getClassInfo(classIndex).equals(this.className)) {
                    if (this.newIndex == 0) {
                        int nt = cp.addNameAndTypeInfo(this.methodName, this.typedesc);
                        this.newIndex = cp.addMethodrefInfo(classIndex, nt);
                        this.constPool = cp;
                    }
                    if (c == 178 || c == 179) {
                        iterator.writeByte(184, pos);
                    } else {
                        iterator.writeByte(182, pos);
                    }
                    iterator.write16bit(this.newIndex, pos + 1);
                }
            }
            return pos;
        }
    }

    public static class TransformProceedCall
    extends TransformCall {
        public TransformProceedCall(Transformer next, String origClassName, String origMethodName, CtMethod substMethod) {
            super(next, origMethodName, substMethod);
            this.classname = origClassName;
        }
    }

    public static class TransformSuperCall
    extends TransformCall {
        public TransformSuperCall(Transformer next, CtMethod origMethod, CtMethod substMethod) {
            super(next, origMethod, substMethod);
            this.newMethodIsPrivate = true;
        }
    }

    public static class CodeConverter2
    extends CodeConverter {
        public void redirectMethodCall(CtMethod oldMethod, CtMethod newMethod) throws CannotCompileException {
            this.transformers = new TransformSuperCall(this.transformers, oldMethod, newMethod);
        }

        public void redirectProceed(String origClassName, String origMethodName, CtMethod substMethod) {
            this.transformers = new TransformProceedCall(this.transformers, origClassName, origMethodName, substMethod);
        }

        public void redirectFieldAccess(CtField orig, CtMethod newMethod) {
            this.transformers = new TransformProceedAccess(this.transformers, orig, newMethod);
        }
    }

    public static class MethodDef {
        public CtMethod target;
        public String origName;
        public CtMethod overrider;

        public MethodDef(CtMethod m) {
            this.target = m;
            this.origName = this.target.getName();
            this.overrider = null;
        }
    }
}

