/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.WeaverCore;

public class RuntimeWeaver
extends WeaverCore {
    private ClassLoader classLoader;
    private boolean running;

    public RuntimeWeaver(Gluon g, Class mainClass) throws WeaveException {
        super(g);
        this.classLoader = mainClass.getClassLoader();
        this.running = false;
    }

    public void run() throws RuntimeException {
        this.running = true;
        Set set = this.refineTargets.entrySet();
        int size = set.size();
        String[] targetNames = new String[size];
        LinkedList[] refines = new LinkedList[size];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            targetNames[i] = (String)e.getKey();
            refines[i] = (LinkedList)e.getValue();
            ++i;
        }
        try {
            for (int j = 0; j < size; ++j) {
                this.transform(targetNames[j], refines[j], true);
            }
        }
        catch (WeaveException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void use(String className) throws RuntimeException {
        if (!this.running) {
            this.run();
        }
        try {
            this.transform(className);
        }
        catch (WeaveException err) {
            throw new RuntimeException(err.getMessage(), err);
        }
    }

    protected boolean transform(String className, LinkedList refines, boolean inspect) throws WeaveException {
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            return false;
        }
        try {
            CtClass target = this.pool.get(className);
            if (target.isFrozen()) {
                return false;
            }
            CtClass superClass = target.getSuperclass();
            if (superClass != null) {
                this.transform(superClass.getName(), inspect);
            }
            return super.transform(className, refines, inspect);
        }
        catch (NotFoundException nfe) {
            throw new WeaveException(nfe);
        }
    }

    protected void save(CtClass clazz, boolean modify) throws CannotCompileException {
        try {
            clazz.toClass(this.classLoader, null);
        }
        catch (CannotCompileException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof LinkageError) {
                throw (LinkageError)cause;
            }
            throw e;
        }
    }
}

