/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOHTTPConnection;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.xml._JavaMonitorCoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSThreadsafeMutableArray;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.MSiteConfig;
import er.extensions.foundation.ERXProperties;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class MHost
extends MObject {
    private static final Logger log = Logger.getLogger(MHost.class);
    private final int _receiveTimeout = ERXProperties.intForKeyWithDefault((String)"JavaMonitor.receiveTimeout", (int)10000);
    public static final String MAC_HOST_TYPE = "MACOSX";
    public static final String WINDOWS_HOST_TYPE = "WINDOWS";
    public static final String UNIX_HOST_TYPE = "UNIX";
    NSMutableArray _instanceArray;
    NSMutableArray _applicationArray = new NSMutableArray();
    private InetAddress _address = null;
    public String runningInstances = "?";
    public String operatingSystem = "?";
    public String processorType = "?";
    public boolean isAvailable = false;
    private static WORequest _syncRequest = null;
    private String errorResponse = null;

    public String name() {
        return (String)this.values.valueForKey("name");
    }

    public void setName(String value) {
        this.values.takeValueForKey((Object)value, "name");
        this._siteConfig.dataHasChanged();
    }

    public String osType() {
        return (String)this.values.valueForKey("type");
    }

    public void setOsType(String value) {
        this.values.takeValueForKey((Object)MObject.validatedHostType(value), "type");
        this._siteConfig.dataHasChanged();
    }

    public NSMutableArray instanceArray() {
        return this._instanceArray;
    }

    public NSArray applicationArray() {
        return this._applicationArray;
    }

    public MHost(MSiteConfig aConfig, String name, String type) {
        this(new NSDictionary(new Object[]{name, type}, new Object[]{"name", "type"}), aConfig);
    }

    public MHost(NSDictionary aValuesDict, MSiteConfig aConfig) {
        this.values = new NSMutableDictionary(aValuesDict);
        this._siteConfig = aConfig;
        this._instanceArray = new NSMutableArray();
        int tries = 0;
        while (tries++ < 5) {
            try {
                this._address = InetAddress.getByName(this.name());
                break;
            }
            catch (UnknownHostException anException) {
                log.error((Object)("Error getting address for Host: " + this.name()));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Interrupted");
                }
            }
        }
        this.errorResponse = new _JavaMonitorCoder().encodeRootObjectForKey((Object)new NSDictionary((Object)new NSArray((Object)("Failed to contact " + this.name() + "-" + WOApplication.application().lifebeatDestinationPort())), (Object)"errorResponse"), "instanceResponse");
    }

    public void _addInstancePrimitive(MInstance anInstance) {
        this._instanceArray.addObject((Object)anInstance);
        if (!this._applicationArray.containsObject((Object)anInstance._application)) {
            this._applicationArray.addObject((Object)anInstance._application);
        }
    }

    public void _removeInstancePrimitive(MInstance anInstance) {
        this._instanceArray.removeObject((Object)anInstance);
        boolean uniqueApplication = true;
        Enumeration e = this._instanceArray.objectEnumerator();
        while (e.hasMoreElements()) {
            MInstance anInst = (MInstance)e.nextElement();
            if (anInstance._application != anInst._application) continue;
            uniqueApplication = false;
            break;
        }
        if (uniqueApplication) {
            this._applicationArray.removeObject((Object)anInstance._application);
        }
    }

    public InetAddress address() {
        return this._address;
    }

    public String addressAsString() {
        if (this._address != null) {
            return this._address.getHostAddress();
        }
        return "Unknown";
    }

    public boolean equals(Object other) {
        return other instanceof MHost && ((MHost)other)._address.equals(this._address);
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public NSDictionary dictionaryForArchive() {
        return this.values;
    }

    public String toString() {
        return "MHost@" + this._address;
    }

    public Integer runningInstancesCount_W() {
        int runningInstances = 0;
        int numInstances = this._instanceArray.count();
        for (int i = 0; i < numInstances; ++i) {
            MInstance anInstance = (MInstance)this._instanceArray.objectAtIndex(i);
            if (!anInstance.isRunning_W()) continue;
            ++runningInstances;
        }
        return new Integer(runningInstances);
    }

    public boolean isPortInUse(Integer port) {
        return this.instanceWithPort(port) != null;
    }

    public Integer nextAvailablePort(Integer startingPort) {
        Integer retVal = null;
        do {
            if (this.isPortInUse(startingPort)) {
                startingPort = new Integer(startingPort + 1);
                continue;
            }
            retVal = startingPort;
        } while (retVal == null);
        return retVal;
    }

    public MInstance instanceWithPort(Integer port) {
        int instanceArrayCount = this._instanceArray.count();
        for (int i = 0; i < instanceArrayCount; ++i) {
            MInstance anInst = (MInstance)this._instanceArray.objectAtIndex(i);
            if (!anInst.port().equals(port)) continue;
            return anInst;
        }
        return null;
    }

    public void _setHostInfo(NSDictionary _hostStats) {
        Object aValue = null;
        aValue = _hostStats.valueForKey("runningInstances");
        if (aValue != null) {
            this.runningInstances = aValue.toString();
        }
        if ((aValue = _hostStats.valueForKey("operatingSystem")) != null) {
            this.operatingSystem = aValue.toString();
        }
        if ((aValue = _hostStats.valueForKey("processorType")) != null) {
            this.processorType = aValue.toString();
        }
    }

    public static WOResponse[] sendRequestToWotaskdArray(NSData content, NSArray wotaskdArray, boolean willChange) {
        MHost aHost = (MHost)wotaskdArray.objectAtIndex(0);
        if (aHost == null) {
            return null;
        }
        MSiteConfig aConfig = aHost.siteConfig();
        if (aConfig.hostErrorArray.count() > 0) {
            _syncRequest = null;
            final WORequest aSyncRequest = MHost.syncRequest(aConfig);
            final _NSThreadsafeMutableArray syncHosts = aConfig.hostErrorArray;
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
                NSLog.debug.appendln((Object)("Sending sync requests to: " + syncHosts.array()));
            }
            Thread[] workers = new Thread[syncHosts.count()];
            int i = 0;
            while (i < workers.length) {
                final int j = i++;
                Runnable work = new Runnable(){

                    public void run() {
                        MHost aHost = (MHost)syncHosts.objectAtIndex(j);
                        aHost.sendRequestToWotaskd(aSyncRequest, true, true);
                    }
                };
                workers[j] = new Thread(work);
                workers[j].start();
            }
            try {
                for (i = 0; i < workers.length; ++i) {
                    workers[i].join();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        final WORequest aRequest = new WORequest(MObject._POST, MObject.directActionString, MObject._HTTP1, aConfig.passwordDictionary(), content, null);
        final NSArray finalWotaskdArray = wotaskdArray;
        final boolean wc = willChange;
        Thread[] workers = new Thread[wotaskdArray.count()];
        final WOResponse[] responses = new WOResponse[workers.length];
        int i = 0;
        while (i < workers.length) {
            final int j = i++;
            Runnable work = new Runnable(){

                public void run() {
                    responses[j] = ((MHost)finalWotaskdArray.objectAtIndex(j)).sendRequestToWotaskd(aRequest, wc, false);
                }
            };
            workers[j] = new Thread(work);
            workers[j].start();
        }
        try {
            for (i = 0; i < workers.length; ++i) {
                workers[i].join();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        return responses;
    }

    private static WORequest syncRequest(MSiteConfig aConfig) {
        if (_syncRequest == null) {
            NSMutableDictionary data = new NSMutableDictionary((Object)aConfig.dictionaryForArchive(), (Object)"SiteConfig");
            NSMutableDictionary updateWotaskd = new NSMutableDictionary((Object)data, (Object)"sync");
            NSMutableDictionary monitorRequest = new NSMutableDictionary((Object)updateWotaskd, (Object)"updateWotaskd");
            NSData content = new NSData(new _JavaMonitorCoder().encodeRootObjectForKey((Object)monitorRequest, "monitorRequest"));
            _syncRequest = new WORequest(MObject._POST, MObject.directActionString, MObject._HTTP1, aConfig.passwordDictionary(), content, null);
        }
        return _syncRequest;
    }

    public WOResponse sendRequestToWotaskd(WORequest aRequest, boolean willChange, boolean isSync) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"!@#$!@#$ sendRequestToWotaskd creates a WOHTTPConnection");
        }
        WOResponse aResponse = null;
        try {
            WOHTTPConnection anHTTPConnection = new WOHTTPConnection(this.name(), WOApplication.application().lifebeatDestinationPort());
            anHTTPConnection.setReceiveTimeout(this._receiveTimeout);
            boolean requestSucceeded = anHTTPConnection.sendRequest(aRequest);
            this.isAvailable = true;
            if (requestSucceeded) {
                aResponse = anHTTPConnection.readResponse();
            } else {
                this.isAvailable = false;
            }
            if (aResponse == null) {
                this.isAvailable = false;
            }
        }
        catch (Throwable localException) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
                NSLog.err.appendln(localException);
            }
            this.isAvailable = false;
        }
        if (aResponse == null) {
            if (willChange) {
                this._siteConfig.hostErrorArray.addObjectIfAbsent((Object)this);
            }
            aResponse = new WOResponse();
            aResponse.setContent(this.errorResponse);
        } else if (isSync && this.isAvailable) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
                NSLog.debug.appendln((Object)("Cleared sync request for host " + this.name()));
            }
            this._siteConfig.hostErrorArray.removeObject((Object)this);
        }
        return aResponse;
    }
}

