/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOHTTPConnection;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOHostUtilities;
import com.webobjects.appserver.xml.WOXMLException;
import com.webobjects.appserver.xml._JavaMonitorCoder;
import com.webobjects.appserver.xml._JavaMonitorDecoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableArray;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.MonitorException;
import com.webobjects.monitor._private.ProtoLocalMonitor;
import er.extensions.foundation.ERXFileUtilities;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSiteConfig
extends MObject {
    private static final Logger log = Logger.getLogger(MSiteConfig.class);
    public _NSThreadsafeMutableDictionary globalErrorDictionary = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());
    public _NSThreadsafeMutableArray hostErrorArray = new _NSThreadsafeMutableArray(new NSMutableArray());
    NSMutableArray _hostArray = new NSMutableArray();
    NSMutableArray _instanceArray = new NSMutableArray();
    NSMutableArray _applicationArray = new NSMutableArray();
    MHost _localHost;
    protected boolean _hasChanges = true;
    InetAddress localHostAddress = WOApplication.application().hostAddress();
    String localHostName = WOApplication.application().host();
    private static Random _randomGenerator = new Random();
    private String _oldPassword = null;
    private boolean _oldPasswordSet = false;
    private NSMutableDictionary<String, NSMutableArray<String>> _passwordDictionary;
    private static String _configDirectoryPath = null;
    private static String _pathForSiteConfig = null;
    private static String _pathForAdaptorConfig = null;
    private static File _fileForSiteConfig = null;
    private static File _fileForAdaptorConfig = null;
    private String _lastConfig;
    public int _appIsDeadMultiplier;

    public String password() {
        return (String)this.values.valueForKey("password");
    }

    public void setPassword(String value) {
        this._setPassword(value);
        this._siteConfig.dataHasChanged();
    }

    public String woAdaptor() {
        return (String)this.values.valueForKey("woAdaptor");
    }

    public void setWoAdaptor(String value) {
        this.values.takeValueForKey((Object)value, "woAdaptor");
        this._siteConfig.dataHasChanged();
    }

    public String SMTPhost() {
        return (String)this.values.valueForKey("SMTPhost");
    }

    public void setSMTPhost(String value) {
        this.values.takeValueForKey((Object)value, "SMTPhost");
        this._siteConfig.dataHasChanged();
    }

    public String emailReturnAddr() {
        return (String)this.values.valueForKey("emailReturnAddr");
    }

    public void setEmailReturnAddr(String value) {
        this.values.takeValueForKey((Object)value, "emailReturnAddr");
        this._siteConfig.dataHasChanged();
    }

    public Boolean viewRefreshEnabled() {
        return (Boolean)this.values.valueForKey("viewRefreshEnabled");
    }

    public void setViewRefreshEnabled(Boolean value) {
        this.values.takeValueForKey((Object)value, "viewRefreshEnabled");
        this._siteConfig.dataHasChanged();
    }

    public Integer viewRefreshRate() {
        return (Integer)this.values.valueForKey("viewRefreshRate");
    }

    public void setViewRefreshRate(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "viewRefreshRate");
        this._siteConfig.dataHasChanged();
    }

    public Integer sequence() {
        return (Integer)this.values.valueForKey("sequence");
    }

    public void setSequence(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "sequence");
        this._siteConfig.dataHasChanged();
    }

    public Integer retries() {
        return (Integer)this.values.valueForKey("retries");
    }

    public void setRetries(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "retries");
        this._siteConfig.dataHasChanged();
    }

    public String scheduler() {
        return (String)this.values.valueForKey("scheduler");
    }

    public void setScheduler(String value) {
        this.values.takeValueForKey((Object)value, "scheduler");
        this._siteConfig.dataHasChanged();
    }

    public Integer dormant() {
        return (Integer)this.values.valueForKey("dormant");
    }

    public void setDormant(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "dormant");
        this._siteConfig.dataHasChanged();
    }

    public String redir() {
        return (String)this.values.valueForKey("redir");
    }

    public void setRedir(String value) {
        this.values.takeValueForKey((Object)value, "redir");
        this._siteConfig.dataHasChanged();
    }

    public Integer sendTimeout() {
        return (Integer)this.values.valueForKey("sendTimeout");
    }

    public void setSendTimeout(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "sendTimeout");
        this._siteConfig.dataHasChanged();
    }

    public Integer recvTimeout() {
        return (Integer)this.values.valueForKey("recvTimeout");
    }

    public void setRecvTimeout(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "recvTimeout");
        this._siteConfig.dataHasChanged();
    }

    public Integer cnctTimeout() {
        return (Integer)this.values.valueForKey("cnctTimeout");
    }

    public void setCnctTimeout(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "cnctTimeout");
        this._siteConfig.dataHasChanged();
    }

    public Integer sendBufSize() {
        return (Integer)this.values.valueForKey("sendBufSize");
    }

    public void setSendBufSize(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "sendBufSize");
        this._siteConfig.dataHasChanged();
    }

    public Integer recvBufSize() {
        return (Integer)this.values.valueForKey("recvBufSize");
    }

    public void setRecvBufSize(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "recvBufSize");
        this._siteConfig.dataHasChanged();
    }

    public Integer poolsize() {
        return (Integer)this.values.valueForKey("poolsize");
    }

    public void setPoolsize(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "poolsize");
        this._siteConfig.dataHasChanged();
    }

    public Integer urlVersion() {
        return (Integer)this.values.valueForKey("urlVersion");
    }

    public void setUrlVersion(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedUrlVersion(value), "urlVersion");
        this._siteConfig.dataHasChanged();
    }

    public NSMutableArray<MHost> hostArray() {
        return this._hostArray;
    }

    public NSMutableArray<MInstance> instanceArray() {
        return this._instanceArray;
    }

    public NSMutableArray<MApplication> applicationArray() {
        return this._applicationArray;
    }

    public MHost localHost() {
        return this._localHost;
    }

    public boolean hasChanges() {
        return this._hasChanges;
    }

    public void resetChanges() {
        this._hasChanges = false;
    }

    public void dataHasChanged() {
        this._hasChanges = true;
    }

    public void _addHost(MHost newHost) {
        if (WOHostUtilities.isLocalInetAddress((InetAddress)newHost.address(), (boolean)true)) {
            this._localHost = newHost;
        }
        this._hostArray.addObject((Object)newHost);
        this.dataHasChanged();
    }

    public void addHost_M(MHost newHost) {
        this.backup("addHost-" + newHost.name());
        this._addHost(newHost);
    }

    public void addHost_W(MHost newHost) {
        this._addHost(newHost);
    }

    public void _removeHost(MHost aHost) {
        this._hostArray.removeObject((Object)aHost);
        if (aHost == this._localHost) {
            this._localHost = null;
        }
        this.dataHasChanged();
    }

    public void removeHost_M(MHost aHost) {
        this.backup("removeHost-" + aHost.name());
        NSArray tempArray = new NSArray((NSArray)aHost._instanceArray);
        for (int i = 0; i < tempArray.count(); ++i) {
            this.removeInstance_M((MInstance)tempArray.objectAtIndex(i), false);
        }
        this._removeHost(aHost);
    }

    public void removeHost_W(MHost aHost) {
        NSArray tempArray = new NSArray((NSArray)aHost._instanceArray);
        for (int i = 0; i < tempArray.count(); ++i) {
            this.removeInstance_W((MInstance)tempArray.objectAtIndex(i));
        }
        this._removeHost(aHost);
    }

    public void _addApplication(MApplication newApplication) {
        this._applicationArray.addObject((Object)newApplication);
        this.dataHasChanged();
    }

    public void addApplication_M(MApplication newApplication) {
        this.backup("addApplication-" + newApplication.name());
        this._addApplication(newApplication);
    }

    public void addApplication_W(MApplication newApplication) {
        this._addApplication(newApplication);
    }

    public void _removeApplication(MApplication anApplication) {
        this._applicationArray.removeObject((Object)anApplication);
        this.dataHasChanged();
    }

    public void removeApplication_M(MApplication anApplication) {
        this.backup("removeApplication-" + anApplication.name());
        NSArray tempArray = new NSArray((NSArray)anApplication._instanceArray);
        for (int i = 0; i < tempArray.count(); ++i) {
            this.removeInstance_M((MInstance)tempArray.objectAtIndex(i), false);
        }
        this._removeApplication(anApplication);
    }

    public void removeApplication_W(MApplication anApplication) {
        NSArray tempArray = new NSArray((NSArray)anApplication._instanceArray);
        for (int i = 0; i < tempArray.count(); ++i) {
            this.removeInstance_W((MInstance)tempArray.objectAtIndex(i));
        }
        this._removeApplication(anApplication);
    }

    public void _addInstance(MInstance newInstance) {
        this._instanceArray.addObject((Object)newInstance);
        newInstance._host._addInstancePrimitive(newInstance);
        newInstance._application._addInstancePrimitive(newInstance);
        this.dataHasChanged();
    }

    public NSMutableArray<MInstance> addInstances_M(MHost selectedHost, MApplication myApplication, int numberToAdd) {
        this.backup("addInstances-" + myApplication.name() + "-" + selectedHost.name() + "-" + numberToAdd);
        NSMutableArray newInstanceArray = new NSMutableArray(numberToAdd);
        for (int i = 0; i < numberToAdd; ++i) {
            Integer aUniqueID = myApplication.nextID();
            MInstance newInstance = new MInstance(selectedHost, myApplication, aUniqueID, this);
            this.addInstance_M(newInstance);
            newInstanceArray.addObject((Object)newInstance);
        }
        return newInstanceArray;
    }

    public void addInstance_M(MInstance newInstance) {
        this._addInstance(newInstance);
    }

    public void addInstance_W(MInstance newInstance) {
        this._addInstance(newInstance);
    }

    public void _removeInstance(MInstance anInstance) {
        anInstance.cancelForceQuitTask();
        anInstance._host._removeInstancePrimitive(anInstance);
        anInstance._application._removeInstancePrimitive(anInstance);
        this._instanceArray.removeObject((Object)anInstance);
        this.dataHasChanged();
    }

    public void removeInstance_M(MInstance anInstance) {
        this.removeInstance_M(anInstance, true);
    }

    public void removeInstances_M(MApplication application, NSArray<MInstance> instances) {
        this.backup("removeInstances-" + application + "-" + instances.count());
        for (MInstance instance : instances) {
            this.removeInstance_M(instance, false);
        }
    }

    private void removeInstance_M(MInstance anInstance, boolean doBackup) {
        if (doBackup) {
            this.backup("removeInstance-" + anInstance.displayName());
        }
        this._removeInstance(anInstance);
    }

    public void removeInstance_W(MInstance anInstance) {
        if (anInstance._host == this._localHost && anInstance.isRunning_W()) {
            ProtoLocalMonitor plMonitor = (ProtoLocalMonitor)WOApplication.application().valueForKey("localMonitor");
            try {
                plMonitor.stopInstance(anInstance);
            }
            catch (MonitorException me) {
                log.error((Object)"Can't remove", (Throwable)me);
            }
        }
        this._removeInstance(anInstance);
    }

    public static long myrand() {
        return Math.abs(_randomGenerator.nextLong());
    }

    public String encryptStringWithKey(String to_be_encrypted, String aKey) {
        MessageDigest messageDigest;
        String encrypted_value = "";
        char[] xdigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException exc) {
            this.globalErrorDictionary.takeValueForKey((Object)"Security package does not contain appropriate algorithm", "Security package does not contain appropriate algorithm");
            log.error((Object)"Security package does not contain appropriate algorithm");
            return encrypted_value;
        }
        if (to_be_encrypted != null) {
            byte[] fudge_constant;
            try {
                fudge_constant = "X#@!".getBytes("UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                fudge_constant = "X#@!".getBytes();
            }
            byte[] fudgetoo_part = new byte[]{(byte)xdigit[(int)(MSiteConfig.myrand() % 16L)], (byte)xdigit[(int)(MSiteConfig.myrand() % 16L)], (byte)xdigit[(int)(MSiteConfig.myrand() % 16L)], (byte)xdigit[(int)(MSiteConfig.myrand() % 16L)]};
            int i = 0;
            if (aKey != null) {
                try {
                    fudgetoo_part = aKey.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    fudgetoo_part = aKey.getBytes();
                }
            }
            messageDigest.update(fudge_constant);
            try {
                messageDigest.update(to_be_encrypted.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException uee) {
                messageDigest.update(to_be_encrypted.getBytes());
            }
            messageDigest.update(fudgetoo_part);
            byte[] digest = messageDigest.digest();
            encrypted_value = new String(fudgetoo_part);
            for (i = 0; i < digest.length; ++i) {
                char[] temp = new char[2];
                int mashed = digest[i] < 0 ? 127 + -1 * digest[i] : digest[i];
                temp[0] = xdigit[mashed / 16];
                temp[1] = xdigit[mashed % 16];
                encrypted_value = encrypted_value + new String(temp);
            }
        }
        return encrypted_value;
    }

    public boolean isPasswordRequired() {
        return this.password() != null;
    }

    public void _setPassword(String value) {
        if (value != null) {
            this.values.takeValueForKey((Object)this.encryptStringWithKey(value, null), "password");
        } else {
            this.resetPassword();
        }
    }

    public void resetPassword() {
        this.values.takeValueForKey(null, "password");
    }

    public void _setOldPassword() {
        this._oldPassword = this.password();
        this._oldPasswordSet = true;
    }

    public void _resetOldPassword() {
        this._oldPassword = null;
        this._oldPasswordSet = false;
    }

    public boolean compareStringWithPassword(String aString) {
        String _encryptedPassword = this.password();
        if (aString == null && _encryptedPassword != null || aString != null && _encryptedPassword == null) {
            return false;
        }
        if (aString == null && _encryptedPassword == null) {
            return true;
        }
        if (aString.length() == 0 && _encryptedPassword == null || _encryptedPassword.length() == 0 && aString == null) {
            return true;
        }
        String fudgetoo_part = _encryptedPassword.substring(0, 4);
        String encrypted_string = this.encryptStringWithKey(aString, fudgetoo_part);
        return encrypted_string.equals(_encryptedPassword);
    }

    public boolean comparePasswordWithPassword(String aString) {
        String _encryptedPassword = this.password();
        if (_encryptedPassword == null || _encryptedPassword.length() == 0) {
            return true;
        }
        if (aString == null || aString.length() == 0) {
            return false;
        }
        return aString.equals(_encryptedPassword);
    }

    public NSDictionary<String, NSMutableArray<String>> passwordDictionary() {
        if (this._passwordDictionary == null) {
            this._passwordDictionary = new NSMutableDictionary();
            this._passwordDictionary.setObjectForKey((Object)new NSMutableArray((Object)""), (Object)"password");
        }
        String aPassword = this.password();
        if (this._oldPasswordSet) {
            if (this._oldPassword != null) {
                this._passwordDictionary.takeValueForKey((Object)new NSMutableArray((Object)this._oldPassword), "password");
                return this._passwordDictionary;
            }
            return NSDictionary.emptyDictionary();
        }
        if (aPassword != null) {
            this._passwordDictionary.takeValueForKey((Object)aPassword, "password");
            return this._passwordDictionary;
        }
        return NSDictionary.emptyDictionary();
    }

    public static MSiteConfig getSiteConfigFromHostAndPort(String configHostName, int aPort) throws MonitorException {
        NSArray errorResponse;
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"!@#$!@#$ getSiteConfigFromHostAndPort creates a WOHTTPConnection");
        }
        NSDictionary monitorRequest = new NSDictionary((Object)"SITE", (Object)"queryWotaskd");
        NSData content = new NSData(new _JavaMonitorCoder().encodeRootObjectForKey((Object)monitorRequest, "monitorRequest"));
        WORequest aRequest = new WORequest(MObject._POST, MObject.directActionString, MObject._HTTP1, NSDictionary.EmptyDictionary, content, null);
        WOResponse aResponse = null;
        try {
            WOHTTPConnection anHTTPConnection = new WOHTTPConnection(configHostName, aPort);
            anHTTPConnection.setReceiveTimeout(5000);
            if (anHTTPConnection.sendRequest(aRequest)) {
                aResponse = anHTTPConnection.readResponse();
            }
        }
        catch (Exception localException) {
            log.error((Object)("Failed to connect to Host: " + configHostName + " and Port: " + aPort));
            throw new MonitorException("Failed to connect to Host: " + configHostName + " and Port: " + aPort);
        }
        NSDictionary xmlDict = NSDictionary.EmptyDictionary;
        if (aResponse != null) {
            try {
                xmlDict = (NSDictionary)new _JavaMonitorDecoder().decodeRootObject(aResponse.content());
            }
            catch (WOXMLException wxe) {
                log.error((Object)("Got non-parsable data from Host: " + configHostName + " + and Port: " + aPort + ". Data received was: " + aResponse.contentString() + ". It is possible that the Wotaskd on the remote host is of the wrong version"));
                throw new MonitorException("Got non-parsable data from Host: " + configHostName + " + and Port: " + aPort + ". Data received was: " + aResponse.contentString() + ". It is possible that the Wotaskd on the remote host is of the wrong version");
            }
        }
        if ((errorResponse = (NSArray)xmlDict.valueForKey("errorResponse")) != null) {
            String errorString = "";
            for (int i = 0; i < errorResponse.count(); ++i) {
                errorString = errorString + (String)errorResponse.objectAtIndex(i) + "\n";
            }
            throw new MonitorException(errorString);
        }
        NSDictionary queryWotaskdResponse = (NSDictionary)xmlDict.valueForKey("queryWotaskdResponse");
        if (queryWotaskdResponse != null) {
            return new MSiteConfig((NSDictionary)queryWotaskdResponse.valueForKey("SiteConfig"));
        }
        return new MSiteConfig(null);
    }

    public MSiteConfig(NSDictionary xmlDict) {
        this._siteConfig = this;
        if (xmlDict == null) {
            this.values = new NSMutableDictionary();
            this.setViewRefreshEnabled(Boolean.TRUE);
            this.setViewRefreshRate(new Integer(60));
        } else {
            NSDictionary siteDict = (NSDictionary)xmlDict.valueForKey("site");
            this.values = siteDict == null ? new NSMutableDictionary(new NSArray(new Object[]{Boolean.TRUE, new Integer(60)}), new NSArray(new Object[]{"viewRefreshEnabled", "viewRefreshRate"})) : new NSMutableDictionary(siteDict);
            NSArray hostArray = (NSArray)xmlDict.valueForKey("hostArray");
            this._initHostsWithArray(hostArray);
            NSArray applicationArray = (NSArray)xmlDict.valueForKey("applicationArray");
            this._initApplicationsWithArray(applicationArray);
            NSArray instanceArray = (NSArray)xmlDict.valueForKey("instanceArray");
            this._initInstancesWithArray(instanceArray);
        }
        this._appIsDeadMultiplier = 2000;
        String WOAssumeAppIsDeadMultiplier = System.getProperties().getProperty("WOAssumeApplicationIsDeadMultiplier");
        if (WOAssumeAppIsDeadMultiplier != null) {
            try {
                Integer tempInt = new Integer(WOAssumeAppIsDeadMultiplier);
                this._appIsDeadMultiplier = tempInt * 1000;
            }
            catch (NumberFormatException e) {
                NSLog._conditionallyLogPrivateException((Throwable)e);
            }
        }
        this._lastConfig = this.generateSiteConfigXML();
    }

    public void _initHostsWithArray(NSArray anArray) {
        if (anArray == null) {
            return;
        }
        for (int i = 0; i < anArray.count(); ++i) {
            MHost aHost = new MHost((NSDictionary)anArray.objectAtIndex(i), this);
            this._addHost(aHost);
        }
    }

    public void _initApplicationsWithArray(NSArray anArray) {
        if (anArray == null) {
            return;
        }
        for (int i = 0; i < anArray.count(); ++i) {
            MApplication anApplication = new MApplication((NSDictionary)anArray.objectAtIndex(i), this);
            this._addApplication(anApplication);
        }
    }

    public void _initInstancesWithArray(NSArray anArray) {
        if (anArray == null) {
            return;
        }
        for (int i = 0; i < anArray.count(); ++i) {
            MInstance anInstance = new MInstance((NSDictionary)anArray.objectAtIndex(i), this);
            this._addInstance(anInstance);
        }
    }

    public static String configDirectoryPath() {
        File configDir;
        String _fS = File.separator;
        if (_configDirectoryPath != null) {
            return _configDirectoryPath;
        }
        _configDirectoryPath = System.getProperty("WODeploymentConfigurationDirectory");
        if (_configDirectoryPath != null) {
            NSLog.debug.appendln((Object)("WODeploymentConfigurationDirectory set to non-default: " + _configDirectoryPath));
        }
        if (_configDirectoryPath == null || _configDirectoryPath.length() == 0) {
            String localRoot = System.getProperty("WOLocalRootDirectory");
            if (localRoot != null && !localRoot.equals("")) {
                NSLog.debug.appendln((Object)("WOLocalRootDirectory set to non-default: " + localRoot));
            }
            if (localRoot == null) {
                if (System.getProperties().getProperty("os.name").toLowerCase().startsWith("win")) {
                    log.error((Object)"WOLocalRootDirectory was not set and the os.name returned something that started with 'win' or 'WIN' - guessing that path should be 'C:/Apple/Local'");
                    localRoot = "C:" + _fS + "Apple" + _fS + "Local";
                } else {
                    localRoot = "";
                }
            }
            _configDirectoryPath = NSPathUtilities.stringByAppendingPathComponent((String)localRoot, (String)(_fS + "Library" + _fS + "WebObjects" + _fS + "Configuration"));
        }
        if (!_configDirectoryPath.endsWith(_fS)) {
            _configDirectoryPath = _configDirectoryPath + _fS;
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("configDirectoryPath = " + _configDirectoryPath));
        }
        if (!(configDir = new File(_configDirectoryPath)).exists()) {
            if (!configDir.mkdirs()) {
                log.fatal((Object)("Configuration Directory " + _configDirectoryPath + " does not exist, and cannot be created."));
                System.exit(1);
            }
        } else {
            if (!configDir.isDirectory()) {
                log.fatal((Object)("Configuration Directory " + _configDirectoryPath + " is not actually a directory."));
                System.exit(1);
            }
            if (!configDir.canRead()) {
                log.fatal((Object)("Don't have permission to read from Configuration Directory " + _configDirectoryPath + " as this user, please change the permissions or restart " + WOApplication.application().name() + " as another user."));
                System.exit(1);
            }
            if (WOApplication.application().name().equals("wotaskd") && !configDir.canWrite()) {
                log.fatal((Object)("Don't have permission to write to Configuration Directory " + _configDirectoryPath + " as this user; please change the permissions."));
                System.exit(1);
            }
        }
        return _configDirectoryPath;
    }

    public static String pathForSiteConfig() {
        if (_pathForSiteConfig == null) {
            _pathForSiteConfig = MSiteConfig.configDirectoryPath().concat("SiteConfig.xml");
        }
        return _pathForSiteConfig;
    }

    public static String pathForAdaptorConfig() {
        if (_pathForAdaptorConfig == null) {
            _pathForAdaptorConfig = MSiteConfig.configDirectoryPath().concat("WOConfig.xml");
        }
        return _pathForAdaptorConfig;
    }

    public static File fileForSiteConfig() {
        if (_fileForSiteConfig == null) {
            _fileForSiteConfig = new File(MSiteConfig.pathForSiteConfig());
        }
        return _fileForSiteConfig;
    }

    public static File fileForAdaptorConfig() {
        if (_fileForAdaptorConfig == null) {
            _fileForAdaptorConfig = new File(MSiteConfig.pathForAdaptorConfig());
        }
        return _fileForAdaptorConfig;
    }

    public static MSiteConfig unarchiveSiteConfig(boolean isWotaskd) {
        MSiteConfig aConfig;
        block10: {
            aConfig = null;
            if (!MSiteConfig.fileForSiteConfig().exists()) {
                _NSStringUtilities.writeToFile((File)MSiteConfig.fileForSiteConfig(), (String)new _JavaMonitorCoder().encodeRootObjectForKey((Object)NSDictionary.EmptyDictionary, "SiteConfig"));
            }
            if (MSiteConfig.fileForSiteConfig().exists()) {
                if (MSiteConfig.fileForSiteConfig().canRead()) {
                    try {
                        NSDictionary siteDict = (NSDictionary)new _JavaMonitorDecoder().decodeRootObject(MSiteConfig.pathForSiteConfig());
                        aConfig = new MSiteConfig(siteDict);
                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
                            NSLog.debug.appendln((Object)("the SiteConfig is \n" + aConfig.generateSiteConfigXML()));
                        }
                    }
                    catch (Throwable ex) {
                        if (isWotaskd) {
                            log.error((Object)("Failed to parse " + MSiteConfig.pathForSiteConfig() + ". Backing up original SiteConfig and continuing as if empty."));
                            MSiteConfig.backupSiteConfig();
                            break block10;
                        }
                        log.error((Object)("Failed to parse " + MSiteConfig.pathForSiteConfig() + ". Continuing as if empty."));
                    }
                } else {
                    log.fatal((Object)("Cannot read from SiteConfig file " + MSiteConfig.pathForSiteConfig() + ". Possible Permissions Problem."));
                    System.exit(1);
                }
            } else {
                log.error((Object)("SiteConfig file " + MSiteConfig.pathForSiteConfig() + " doesn't exist. Continuing as if empty."));
            }
        }
        if (aConfig == null) {
            aConfig = new MSiteConfig(null);
        }
        return aConfig;
    }

    private static void backupSiteConfig() {
        try {
            File sc = MSiteConfig.fileForSiteConfig();
            if (sc.exists()) {
                NSTimestampFormatter formatter = new NSTimestampFormatter("%Y%m%d%H%M%S%F");
                File renamedFile = new File(MSiteConfig.pathForSiteConfig() + "." + formatter.format((Object)new NSTimestamp()));
                sc.renameTo(renamedFile);
            }
        }
        catch (NSForwardException ne) {
            log.error((Object)("Cannot backup file " + MSiteConfig.pathForSiteConfig() + ". Possible Permissions Problem."));
        }
    }

    public void archiveSiteConfig() {
        this.saveSiteConfig(MSiteConfig.fileForSiteConfig(), this.generateSiteConfigXML(), false);
    }

    public void saveSiteConfig(File sc, String value, boolean compress) {
        try {
            if (sc.exists() && !sc.canWrite()) {
                log.error((Object)("Don't have permission to write to file " + sc.getAbsolutePath() + " as this user, please change the permissions."));
                String pre = WOApplication.application().name() + " - " + this.localHostName;
                this.globalErrorDictionary.takeValueForKey((Object)(pre + " Don't have permission to write to file " + sc.getAbsolutePath() + " as this user, please change the permissions."), "archiveSiteConfig");
                return;
            }
            if (compress) {
                sc = new File(sc.getParentFile(), sc.getName() + ".gz");
                ERXFileUtilities.stringToGZippedFile((String)value, (File)sc);
            } else {
                _NSStringUtilities.writeToFile((File)sc, (String)value);
            }
            this.globalErrorDictionary.takeValueForKey(null, "archiveSiteConfig");
        }
        catch (IOException e) {
            String message = "Cannot write to file " + sc.getAbsolutePath() + ". IOException: " + e.getLocalizedMessage();
            log.error((Object)message);
            String pre = WOApplication.application().name() + " - " + this.localHostName;
            this.globalErrorDictionary.takeValueForKey((Object)(pre + message), "archiveSiteConfig");
        }
        catch (NSForwardException ne) {
            log.error((Object)("Cannot write to file " + sc.getAbsolutePath() + ". Possible Permissions Problem."));
            String pre = WOApplication.application().name() + " - " + this.localHostName;
            this.globalErrorDictionary.takeValueForKey((Object)(pre + " Cannot write to file " + sc.getAbsolutePath() + ". Possible Permissions Problem."), "archiveSiteConfig");
        }
    }

    public void archiveAdaptorConfig() {
        try {
            File ac = MSiteConfig.fileForAdaptorConfig();
            if (ac.exists() && !ac.canWrite()) {
                log.error((Object)("Don't have permission to write to file " + MSiteConfig.fileForAdaptorConfig() + " as this user, please change the permissions."));
                String pre = WOApplication.application().name() + " - " + this.localHostName;
                this.globalErrorDictionary.takeValueForKey((Object)(pre + " Don't have permission to write to file " + MSiteConfig.fileForAdaptorConfig() + "as this user, please change the permissions."), "archiveSiteConfig");
                return;
            }
            _NSStringUtilities.writeToFile((File)MSiteConfig.fileForAdaptorConfig(), (String)this.generateAdaptorConfigXML(false, false));
            this.globalErrorDictionary.takeValueForKey(null, "archiveAdaptorConfig");
        }
        catch (NSForwardException ne) {
            log.error((Object)("Cannot write to file " + MSiteConfig.pathForAdaptorConfig() + ". Possible Permissions Problem."));
            String pre = WOApplication.application().name() + " - " + this.localHostName;
            this.globalErrorDictionary.takeValueForKey((Object)(pre + " Cannot write to file " + MSiteConfig.pathForAdaptorConfig() + ". Possible Permissions Problem."), "archiveAdaptorConfig");
        }
    }

    public String generateHttpWebObjectsConfig() {
        StringBuilder result = new StringBuilder();
        result.append("ProxyRequests On\nProxyMaxForwards 10000\nProxyVia Full\n");
        Enumeration e = this.applicationArray().objectEnumerator();
        while (e.hasMoreElements()) {
            MApplication anApp = (MApplication)e.nextElement();
            anApp.extractAdaptorValuesFromSiteConfig();
            result.append("<Proxy balancer://" + anApp.name() + ".woa>\n");
            Enumeration e2 = anApp.instanceArray().objectEnumerator();
            while (e2.hasMoreElements()) {
                MInstance anInst = (MInstance)e2.nextElement();
                anInst.extractAdaptorValuesFromApplication();
                Integer id = (Integer)anInst.values.valueForKey("id");
                Integer port = (Integer)anInst.values.valueForKey("port");
                String host = (String)anInst.values.valueForKey("hostName");
                String route = anApp.name() + "_" + host + "_" + port + "_" + id;
                result.append("\tBalancerMember http://" + host + ":" + port + "/cgi-bin/WebObjects/" + anApp.name() + ".woa route=" + route + "\n");
            }
            result.append("</Proxy>\n");
            result.append("ProxyPass /cgi-bin/WebObjects/" + anApp.name() + ".woa balancer://" + anApp.name() + ".woa stickysession=woclusteragentid nofailover=On\n");
            result.append("\n");
        }
        result.append("\n");
        return result.toString();
    }

    public String generateAdaptorConfigXML(boolean onlyIncludeRunningInstances, boolean shouldIncludeUnregisteredInstances) {
        StringBuffer unknownSB;
        ProtoLocalMonitor plMonitor;
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"ASCII\"?>\n<adaptor>\n");
        Enumeration e = this.applicationArray().objectEnumerator();
        while (e.hasMoreElements()) {
            MApplication anApp = (MApplication)e.nextElement();
            if (onlyIncludeRunningInstances && !anApp.isRunning_W()) continue;
            anApp.extractAdaptorValuesFromSiteConfig();
            Integer retries = (Integer)anApp.adaptorValues.valueForKey("retries");
            String scheduler = (String)anApp.adaptorValues.valueForKey("scheduler");
            Integer dormant = (Integer)anApp.adaptorValues.valueForKey("dormant");
            String redir = (String)anApp.adaptorValues.valueForKey("redir");
            Integer poolsize = (Integer)anApp.adaptorValues.valueForKey("poolsize");
            Integer urlVersion = (Integer)anApp.adaptorValues.valueForKey("urlVersion");
            sb.append("  <application name=\"");
            sb.append(anApp.name());
            if (retries != null) {
                sb.append("\" retries=\"");
                sb.append(retries.toString());
            }
            if (scheduler != null) {
                sb.append("\" scheduler=\"");
                sb.append(scheduler);
            }
            if (dormant != null) {
                sb.append("\" dormant=\"");
                sb.append(dormant);
            }
            if (redir != null) {
                sb.append("\" redir=\"");
                sb.append(redir);
            }
            if (poolsize != null) {
                sb.append("\" poolsize=\"");
                sb.append(poolsize.toString());
            }
            if (urlVersion != null) {
                sb.append("\" urlVersion=\"");
                sb.append(urlVersion.toString());
            }
            sb.append("\">\n");
            Enumeration e2 = anApp.instanceArray().objectEnumerator();
            while (e2.hasMoreElements()) {
                MInstance anInst = (MInstance)e2.nextElement();
                if (onlyIncludeRunningInstances && !anInst.isRunning_W()) continue;
                anInst.extractAdaptorValuesFromApplication();
                Integer id = (Integer)anInst.values.valueForKey("id");
                Integer port = (Integer)anInst.values.valueForKey("port");
                String host = (String)anInst.values.valueForKey("hostName");
                Integer sendTimeout = (Integer)anInst.adaptorValues.valueForKey("sendTimeout");
                Integer recvTimeout = (Integer)anInst.adaptorValues.valueForKey("recvTimeout");
                Integer cnctTimeout = (Integer)anInst.adaptorValues.valueForKey("cnctTimeout");
                Integer sendBufSize = (Integer)anInst.adaptorValues.valueForKey("sendBufSize");
                Integer recvBufSize = (Integer)anInst.adaptorValues.valueForKey("recvBufSize");
                sb.append("    <instance");
                if (id != null) {
                    sb.append(" id=\"");
                    sb.append(id.toString());
                }
                if (port != null) {
                    sb.append("\" port=\"");
                    sb.append(port.toString());
                }
                if (host != null) {
                    sb.append("\" host=\"");
                    sb.append(host);
                }
                if (sendTimeout != null) {
                    sb.append("\" sendTimeout=\"");
                    sb.append(sendTimeout.toString());
                }
                if (recvTimeout != null) {
                    sb.append("\" recvTimeout=\"");
                    sb.append(recvTimeout.toString());
                }
                if (cnctTimeout != null) {
                    sb.append("\" cnctTimeout=\"");
                    sb.append(cnctTimeout.toString());
                }
                if (sendBufSize != null) {
                    sb.append("\" sendBufSize=\"");
                    sb.append(sendBufSize.toString());
                }
                if (recvBufSize != null) {
                    sb.append("\" recvBufSize=\"");
                    sb.append(recvBufSize.toString());
                }
                sb.append("\"/>\n");
            }
            sb.append("  </application>\n");
        }
        if (shouldIncludeUnregisteredInstances && (plMonitor = (ProtoLocalMonitor)WOApplication.application().valueForKey("localMonitor")) != null && (unknownSB = plMonitor.generateAdaptorConfigXML()).length() > 0) {
            sb.append(unknownSB);
        }
        sb.append("</adaptor>\n");
        return sb.toString();
    }

    public String generateSiteConfigXML() {
        return new _JavaMonitorCoder().encodeRootObjectForKey((Object)this.dictionaryForArchive(), "SiteConfig");
    }

    public void backup(String action) {
        if (Boolean.getBoolean("WODeploymentBackups")) {
            String currentSiteConfig = this.generateSiteConfigXML();
            if (!this._lastConfig.equals(this.generateSiteConfigXML())) {
                String date = new SimpleDateFormat("yyyy-MM-dd-hh_mm_ss").format(new Date());
                this.saveSiteConfig(new File(MSiteConfig.fileForSiteConfig().getParentFile(), "SiteConfigBackup.xml." + date + "." + action), this._lastConfig, true);
                this._lastConfig = currentSiteConfig;
            }
        }
    }

    public void forceBackup(String reason) {
        reason = reason != null ? "." + reason : "";
        String date = new SimpleDateFormat("yyyy-MM-dd-hh_mm_ss").format(new Date());
        this.saveSiteConfig(new File(MSiteConfig.fileForSiteConfig().getParentFile(), "SiteConfigBackup.xml." + date + reason), this.generateSiteConfigXML(), true);
    }

    public NSDictionary dictionaryForArchive() {
        int hostArrayCount = this._hostArray.count();
        int applicationArrayCount = this._applicationArray.count();
        int instanceArrayCount = this._instanceArray.count();
        NSMutableDictionary SiteConfig = new NSMutableDictionary(4);
        NSMutableDictionary Site = this.values;
        NSMutableArray HostArray = new NSMutableArray(hostArrayCount);
        for (int i = 0; i < hostArrayCount; ++i) {
            MObject anMobject = (MObject)this._hostArray.objectAtIndex(i);
            HostArray.addObject((Object)anMobject.values);
        }
        NSMutableArray ApplicationArray = new NSMutableArray(applicationArrayCount);
        for (int i = 0; i < applicationArrayCount; ++i) {
            MObject anMobject = (MObject)this._applicationArray.objectAtIndex(i);
            ApplicationArray.addObject((Object)anMobject.values);
        }
        NSMutableArray InstanceArray = new NSMutableArray(instanceArrayCount);
        for (int i = 0; i < instanceArrayCount; ++i) {
            MObject anMobject = (MObject)this._instanceArray.objectAtIndex(i);
            InstanceArray.addObject((Object)anMobject.values);
        }
        SiteConfig.takeValueForKey((Object)Site, "site");
        SiteConfig.takeValueForKey((Object)HostArray, "hostArray");
        SiteConfig.takeValueForKey((Object)ApplicationArray, "applicationArray");
        SiteConfig.takeValueForKey((Object)InstanceArray, "instanceArray");
        return SiteConfig;
    }

    public String toString() {
        return this.values.toString() + "\n" + "hasChanges = " + this._hasChanges + "\n" + "configDirectoryPath = " + _configDirectoryPath;
    }

    public long autoRecoverInterval() {
        int instanceArrayCount = this._instanceArray.count();
        int smallestInterval = 0;
        for (int i = 0; i < instanceArrayCount; ++i) {
            int interval;
            MInstance anInst = (MInstance)this._instanceArray.objectAtIndex(i);
            Integer Interval = anInst.lifebeatInterval();
            if (Interval == null || (interval = Interval.intValue()) >= smallestInterval) continue;
            smallestInterval = interval;
        }
        if (smallestInterval < 1) {
            return 30000L;
        }
        return smallestInterval * 1000;
    }

    public MApplication applicationWithName(String anAppName) {
        if (anAppName == null) {
            return null;
        }
        int applicationArrayCount = this._applicationArray.count();
        for (int i = 0; i < applicationArrayCount; ++i) {
            MApplication anApp = (MApplication)this._applicationArray.objectAtIndex(i);
            if (!anApp.name().equals(anAppName)) continue;
            return anApp;
        }
        return null;
    }

    public MHost hostWithName(String aHostName) {
        if (aHostName == null) {
            return null;
        }
        if (aHostName.equals("localhost")) {
            return this.localHost();
        }
        int hostArrayCount = this._hostArray.count();
        for (int i = 0; i < hostArrayCount; ++i) {
            MHost aHost = (MHost)this._hostArray.objectAtIndex(i);
            if (!aHost.name().equals(aHostName)) continue;
            return aHost;
        }
        return null;
    }

    public boolean localhostOrLoopbackHostExists() {
        String localhost = "localhost";
        String loopback = "127.0.0.1";
        int hostArrayCount = this._hostArray.count();
        for (int i = 0; i < hostArrayCount; ++i) {
            MHost aHost = (MHost)this._hostArray.objectAtIndex(i);
            if (!aHost.name().equals(localhost) && !aHost.name().equals(loopback)) continue;
            return true;
        }
        return false;
    }

    public MHost hostWithAddress(InetAddress anAddress) {
        if (anAddress == null) {
            return null;
        }
        if (this._localHost != null && anAddress.equals(this.localHostAddress)) {
            return this._localHost;
        }
        int hostArrayCount = this._hostArray.count();
        for (int i = 0; i < hostArrayCount; ++i) {
            MHost aHost = (MHost)this._hostArray.objectAtIndex(i);
            if (!anAddress.equals(aHost.address())) continue;
            return aHost;
        }
        return null;
    }

    public MInstance instanceWithName(String anInstanceName) {
        if (anInstanceName == null) {
            return null;
        }
        int instanceArrayCount = this._instanceArray.count();
        for (int i = 0; i < instanceArrayCount; ++i) {
            MInstance anInstance = (MInstance)this._instanceArray.objectAtIndex(i);
            if (!anInstance.displayName().equals(anInstanceName)) continue;
            return anInstance;
        }
        return null;
    }

    public MInstance instanceWithHostnameAndPort(String hostAndPort) {
        NSArray hostPortArray = NSArray.componentsSeparatedByString((String)hostAndPort, (String)"\n");
        return this.instanceWithHostnameAndPort((String)hostPortArray.objectAtIndex(0), new Integer((String)hostPortArray.objectAtIndex(2)));
    }

    public MInstance instanceWithHostnameAndPort(String hostName, String port) {
        try {
            Integer anIntPort = new Integer(port);
            return this.instanceWithHostnameAndPort(hostName, anIntPort);
        }
        catch (Exception e) {
            log.error((Object)("Exception getting instance: " + hostName + " + " + port), (Throwable)e);
            return null;
        }
    }

    public MInstance instanceWithHostnameAndPort(String hostName, Integer port) {
        MHost aHost = this.hostWithName(hostName);
        if (aHost == null) {
            return null;
        }
        return aHost.instanceWithPort(port);
    }

    public MInstance instanceWithHostAndPort(String name, InetAddress host, String port) {
        try {
            Integer anIntPort = new Integer(port);
            MHost aHost = this.hostWithAddress(host);
            if (aHost == null) {
                return null;
            }
            MInstance anInstance = aHost.instanceWithPort(anIntPort);
            if (anInstance != null && anInstance.applicationName().equals(name)) {
                return anInstance;
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception getting instance: " + host + " + " + port), (Throwable)e);
        }
        return null;
    }
}

