/*
 * Decompiled with CFR 0.152.
 */
package er.modern.movies.demo;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOSession;
import com.webobjects.directtoweb.D2W;
import com.webobjects.directtoweb.EditPageInterface;
import com.webobjects.directtoweb.ErrorPageInterface;
import com.webobjects.directtoweb.QueryPageInterface;
import er.modern.movies.demo.Session;

public class MoviesNavigationController {
    public static final String MOVIE = "Movie";
    public static final String STUDIO = "Studio";
    public static final String REVIEW = "Review";
    private Session _session;

    public MoviesNavigationController(Session s) {
        this._session = s;
    }

    public WOComponent homeAction() {
        return D2W.factory().defaultPage((WOSession)this.session());
    }

    public WOComponent adminAction() {
        return this.queryPageForEntityName("Talent");
    }

    public WOComponent queryMovieAction() {
        return this.queryPageForEntityName(MOVIE);
    }

    public WOComponent createMovieAction() {
        return this.newObjectForEntityName(MOVIE);
    }

    public WOComponent queryStudioAction() {
        return this.queryPageForEntityName(STUDIO);
    }

    public WOComponent createStudioAction() {
        return this.newObjectForEntityName(STUDIO);
    }

    public WOComponent queryTalentAction() {
        return this.queryPageForEntityName("Talent");
    }

    public WOComponent createTalentAction() {
        return this.newObjectForEntityName("Talent");
    }

    public WOComponent queryVotingAction() {
        return this.queryPageForEntityName("Voting");
    }

    public WOComponent createVotingAction() {
        return this.newObjectForEntityName("Voting");
    }

    public WOComponent queryReviewAction() {
        return this.queryPageForEntityName(REVIEW);
    }

    public WOComponent createReviewAction() {
        return this.newObjectForEntityName(REVIEW);
    }

    public WOComponent queryPageForEntityName(String entityName) {
        QueryPageInterface newQueryPage = D2W.factory().queryPageForEntityNamed(entityName, (WOSession)this.session());
        return (WOComponent)newQueryPage;
    }

    public WOComponent newObjectForEntityName(String entityName) {
        WOComponent nextPage = null;
        try {
            EditPageInterface epi = D2W.factory().editPageForNewObjectWithEntityNamed(entityName, (WOSession)this.session());
            epi.setNextPage(this.session().context().page());
            nextPage = (WOComponent)epi;
        }
        catch (IllegalArgumentException e) {
            ErrorPageInterface epf = D2W.factory().errorPage((WOSession)this.session());
            epf.setMessage(e.toString());
            epf.setNextPage(this.session().context().page());
            nextPage = (WOComponent)epf;
        }
        return nextPage;
    }

    public Session session() {
        return this._session;
    }

    public void setSession(Session s) {
        this._session = s;
    }
}

