/*
 * Decompiled with CFR 0.152.
 */
package er.memoryadaptor;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.memoryadaptor.EREntityStore;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERJoinEntityStore
extends EREntityStore
implements EREntityStore.JoinEntityStore {
    private NSDictionary<EOEntity, EREntityStore> _stores;
    private EOEntity _entity;

    public ERJoinEntityStore(NSDictionary<EOEntity, EREntityStore> stores, EOEntity entity) {
        this._stores = stores;
        this._entity = entity;
    }

    @Override
    public NSMutableArray<NSMutableDictionary<String, Object>> fetch(NSArray<EOAttribute> attributesToFetch, EOFetchSpecification fetchSpecification, boolean shouldLock, EOEntity entity) {
        EREntityStore store = this.joinedStore(attributesToFetch, fetchSpecification, entity);
        return store.fetch(attributesToFetch, fetchSpecification, shouldLock, entity);
    }

    private EREntityStore joinedStore(NSArray<EOAttribute> attributesToFetch, EOFetchSpecification fetchSpecification, EOEntity entity) {
        EREntityStore store = (EREntityStore)this._stores.objectForKey((Object)entity);
        for (EOAttribute attrib : attributesToFetch) {
            if (!attrib.isFlattened()) continue;
            EOAttribute _attrib = entity._attributeForPath(attrib.definition());
            EORelationship _rel = entity._relationshipForPath(attrib.relationshipPath());
            store = this.join(_rel, store, (EREntityStore)this._stores.objectForKey((Object)_attrib.entity()));
        }
        return store;
    }

    private EREntityStore join(EORelationship rel, EREntityStore store1, EREntityStore store2) {
        if (rel.joinSemantic() == 0) {
            return new InnerJoinEntityStore(rel, store1, store2);
        }
        throw new UnsupportedOperationException("ERMemoryAdaptor does not support outer joins");
    }

    @Override
    public Iterator<NSMutableDictionary<String, Object>> iterator() {
        return this.joinedStore((NSArray<EOAttribute>)this._entity.attributesToFetch(), null, this._entity).iterator();
    }

    @Override
    public void insertRow(NSDictionary<String, Object> row, EOEntity entity) {
        NSMutableDictionary newRow = new NSMutableDictionary();
        EOEntity target = entity;
        for (Map.Entry entry : row.entrySet()) {
            EOAttribute attrib = entity.anyAttributeNamed((String)entry.getKey());
            if (attrib.isFlattened()) {
                EOAttribute _attrib = entity._attributeForPath(attrib.definition());
                target = _attrib.entity();
                newRow.setObjectForKey(entry.getValue(), (Object)_attrib.name());
                continue;
            }
            newRow.setObjectForKey(entry.getValue(), (Object)attrib.name());
        }
        ((EREntityStore)this._stores.objectForKey((Object)target)).insertRow((NSDictionary<String, Object>)newRow, target);
    }

    @Override
    public int nextSequence() {
        return ((EREntityStore)this._stores.objectForKey((Object)this._entity)).nextSequence();
    }

    @Override
    protected void _insertRow(NSMutableDictionary<String, Object> row, EOEntity entity) {
        throw new UnsupportedOperationException("Inserting rows is not supported in " + this.getClass().getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InnerJoinEntityStore
    extends EREntityStore {
        NSMutableDictionary<EOAttribute, EOAttribute> attributeMap = new NSMutableDictionary();
        EREntityStore srcStore;
        EREntityStore destStore;
        EORelationship relationship;

        public InnerJoinEntityStore(EORelationship rel, EREntityStore store1, EREntityStore store2) {
            this.srcStore = store1;
            this.destStore = store2;
            this.relationship = rel;
            for (EOJoin join : rel.joins()) {
                this.attributeMap.setObjectForKey((Object)join.destinationAttribute(), (Object)join.sourceAttribute());
            }
        }

        @Override
        public Iterator<NSMutableDictionary<String, Object>> iterator() {
            return new InnerJoinIterator();
        }

        @Override
        protected void _insertRow(NSMutableDictionary<String, Object> row, EOEntity entity) {
            throw new UnsupportedOperationException("Inserting rows is not supported in " + this.getClass().getName());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InnerJoinIterator
        implements Iterator<NSMutableDictionary<String, Object>> {
            private Iterator<NSMutableDictionary<String, Object>> srcIterator;
            private Iterator<NSMutableDictionary<String, Object>> destIterator;
            private NSMutableDictionary<String, Object> src;
            private NSMutableDictionary<String, Object> dst;
            private Boolean _hasNext = null;

            public InnerJoinIterator() {
                this.srcIterator = InnerJoinEntityStore.this.srcStore.iterator();
                this.destIterator = InnerJoinEntityStore.this.destStore.iterator();
                if (this.srcIterator.hasNext()) {
                    this.src = this.srcIterator.next();
                }
            }

            @Override
            public boolean hasNext() {
                if (this._hasNext != null) {
                    return this._hasNext;
                }
                block0: while (this._hasNext == null) {
                    if (!this.destIterator.hasNext()) {
                        if (this.srcIterator.hasNext()) {
                            this.src = this.srcIterator.next();
                            this.destIterator = InnerJoinEntityStore.this.destStore.iterator();
                            continue;
                        }
                        this._hasNext = Boolean.FALSE;
                        break;
                    }
                    this.dst = this.destIterator.next();
                    if (this.src == null) {
                        this._hasNext = Boolean.FALSE;
                        break;
                    }
                    for (Map.Entry entry : InnerJoinEntityStore.this.attributeMap.entrySet()) {
                        Object dstValue;
                        String srcKey = ((EOAttribute)entry.getKey()).columnName();
                        String dstKey = ((EOAttribute)entry.getValue()).columnName();
                        Object srcValue = this.src.objectForKey((Object)srcKey);
                        if (srcValue != (dstValue = this.dst.objectForKey((Object)dstKey)) && (srcValue == null || !srcValue.equals(dstValue))) continue;
                        this._hasNext = Boolean.TRUE;
                        continue block0;
                    }
                }
                return this._hasNext;
            }

            @Override
            public NSMutableDictionary<String, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more rows are available");
                }
                this._hasNext = null;
                NSMutableDictionary row = new NSMutableDictionary(this.src);
                EOEntity entity = InnerJoinEntityStore.this.relationship.entity();
                for (EOAttribute attrib : entity.attributesToFetch()) {
                    EORelationship rel = entity._relationshipForPath(attrib.relationshipPath());
                    if (!attrib.isFlattened() || !InnerJoinEntityStore.this.relationship.equals(rel)) continue;
                    String dstKey = entity._attributeForPath(attrib.definition()).columnName();
                    Object value = this.dst.objectForKey((Object)dstKey);
                    row.setObjectForKey(value != null ? value : NSKeyValueCoding.NullValue, (Object)attrib.definition());
                }
                return row;
            }

            @Override
            public void remove() {
                this.srcIterator.remove();
            }
        }
    }
}

