/*
 * Decompiled with CFR 0.152.
 */
package er.changenotification;

import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSTimestamp;
import er.changenotification.ERCNNotificationCoordinator;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

class ERCNConnectionKeeper
implements ExceptionListener {
    public static final boolean VERBOSE_LOGGING = true;
    public static final boolean QUIET_LOGGING = false;
    private ERCNNotificationCoordinator _coordinator;
    private Timer _recoveryTimer;
    private Topic _topic;
    private TopicConnection _connection;
    private boolean _isConnected = false;

    ERCNConnectionKeeper(ERCNNotificationCoordinator coordinator) {
        this._coordinator = coordinator;
    }

    void openConnection(boolean verboseLogging) {
        if (this._isConnected) {
            this.stopConnection(false);
            this.closeConnection(false);
            this._isConnected = false;
        }
        Properties properties = this._coordinator.configuration().jmsProperties();
        TopicConnectionFactory connectionFactory = null;
        try {
            InitialContext context = new InitialContext(properties);
            connectionFactory = (TopicConnectionFactory)context.lookup("JmsTopicConnectionFactory");
            this._topic = (Topic)context.lookup(this._coordinator.configuration().topicName());
        }
        catch (CommunicationException ex) {
            if (verboseLogging) {
                NSLog.err.appendln((Object)("ERChangeNotification: Cannot connect to the JNDI server. Please check if the JNDI server is available: " + ex.getMessage()));
            }
            return;
        }
        catch (NameNotFoundException ex) {
            new RuntimeException("Cannot find the topic with name \"" + this._coordinator.configuration().topicName() + "\"." + "Please check if the JMS server is properly configured: " + ex.getMessage());
        }
        catch (NamingException ex) {
            if (verboseLogging) {
                NSLog.err.appendln((Object)("ERChangeNotification: An exception occurred while locating the topic with JNDI server: " + ex.getMessage()));
            }
            return;
        }
        String providerName = null;
        String providerVersion = null;
        try {
            this._connection = connectionFactory.createTopicConnection();
            ConnectionMetaData metaData = this._connection.getMetaData();
            providerName = metaData.getJMSProviderName();
            providerVersion = metaData.getProviderVersion();
            this._connection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException ex) {
            if (verboseLogging) {
                NSLog.err.appendln((Object)("ERChangeNotification: An exception occured while creating a JMS connection: " + ex.getMessage()));
            }
            return;
        }
        try {
            this._connection.start();
            this._coordinator.didConnect(this._connection);
        }
        catch (JMSException ex) {
            if (verboseLogging) {
                NSLog.err.appendln((Object)("ERChangeNotification: An exception occured while starting the JMS connection : " + ex.getMessage()));
                ex.printStackTrace();
            }
            return;
        }
        NSLog.out.appendln((Object)("ERChangeNotification: Connected to the JMS server: " + providerName + " " + providerVersion));
        this._isConnected = true;
    }

    void stopConnection(boolean verboseLogging) {
        block3: {
            if (this._connection == null) {
                return;
            }
            try {
                this._connection.stop();
            }
            catch (JMSException ex) {
                if (!verboseLogging) break block3;
                NSLog.err.appendln((Object)("ERChangeNotification: An exception occured while stopping the JMS connection: " + ex.getMessage()));
            }
        }
    }

    void closeConnection(boolean verboseLogging) {
        block3: {
            if (this._connection == null) {
                return;
            }
            try {
                this._connection.close();
            }
            catch (JMSException ex) {
                if (!verboseLogging) break block3;
                NSLog.err.appendln((Object)("ERChangeNotification: An exception occured while closing the JMS connection    : " + ex.getMessage()));
            }
        }
    }

    void initiateRecoveryTask() {
        NSLog.out.appendln((Object)("ERChangeNotification: : Trying to connect to the JMS Server... (Recovery interval: " + this._coordinator.configuration().connectionRecoveryInterval() + " seconds)"));
        if (this._recoveryTimer != null) {
            this._recoveryTimer.cancel();
        }
        this._recoveryTimer = new Timer(true);
        TimerTask recoveryTask = new TimerTask(){

            public void run() {
                ERCNConnectionKeeper.this.openConnection(false);
                if (ERCNConnectionKeeper.this.isConnected()) {
                    ERCNConnectionKeeper.this._recoveryTimer.cancel();
                }
            }
        };
        TimerTask warningMessageTask = new TimerTask(){
            private NSTimestamp _downTime = new NSTimestamp();
            private String _downTimeString = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format((Date)this._downTime);

            public void run() {
                if (!ERCNConnectionKeeper.this._isConnected) {
                    double elapsTime = (double)(new NSTimestamp().getTime() - this._downTime.getTime()) / 3600000.0;
                    String elapsTimeString = new DecimalFormat("#,##0.0").format(elapsTime);
                    NSLog.err.appendln((Object)("ERChangeNotification: JMS connection has been down for " + elapsTimeString + " hours. " + "(Since " + this._downTimeString + ")"));
                }
            }
        };
        long recoveryIntervalMils = this._coordinator.configuration().connectionRecoveryInterval() * 1000L;
        this._recoveryTimer.scheduleAtFixedRate(recoveryTask, recoveryIntervalMils, recoveryIntervalMils);
        long warningIntervalMils = this._coordinator.configuration().disconnectionWarningInterval() * 1000L;
        this._recoveryTimer.scheduleAtFixedRate(warningMessageTask, warningIntervalMils, warningIntervalMils);
    }

    public void onException(JMSException exception) {
        NSLog.err.appendln((Object)("ERChangeNotification: Connection Keeper has detected a problem with the current JMS connection: " + exception.getMessage()));
        this._isConnected = false;
        this.stopConnection(false);
        this._coordinator.didDisconnect(this._connection);
        this.closeConnection(false);
        this._topic = null;
        this._connection = null;
        this.initiateRecoveryTask();
    }

    Topic topic() {
        return this._topic;
    }

    TopicConnection connection() {
        return this._connection;
    }

    boolean isConnected() {
        return this._isConnected;
    }

    synchronized void terminate() {
    }
}

