/*
 * Decompiled with CFR 0.152.
 */
package er.changenotification;

import com.webobjects.appserver.WOApplication;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import er.changenotification.ERCNConfiguration;
import er.changenotification.ERCNNotificationCoordinator;
import java.io.Serializable;
import java.util.Enumeration;

public class ERCNSnapshot
implements Serializable {
    public static final String INSERTED = "inserted";
    public static final String UPDATED = "updated";
    public static final String DELETED = "deleted";
    private final String _senderHost;
    private final Number _senderPort;
    private final String _senderAppName;
    private final NSDictionary _shapshotsForInsertionGroupedByEntity;
    private final NSDictionary _shapshotsForUpdateGroupedByEntity;
    private final NSDictionary _globalIDsForDeletionGroupedByEntity;
    private transient String _toString;
    private transient int _entryCount = 0;

    public ERCNSnapshot(NSNotification notification) {
        WOApplication app = WOApplication.application();
        this._senderHost = app.host();
        this._senderPort = app.port();
        this._senderAppName = app.name();
        NSDictionary userInfo = notification.userInfo();
        ERCNConfiguration configuration = ERCNNotificationCoordinator.coordinator().configuration();
        this._shapshotsForInsertionGroupedByEntity = configuration.changeTypesToPublish().containsObject((Object)INSERTED) ? this.snapshotsGroupedByEntity((NSArray)userInfo.objectForKey((Object)INSERTED)) : NSDictionary.EmptyDictionary;
        this._shapshotsForUpdateGroupedByEntity = configuration.changeTypesToPublish().containsObject((Object)UPDATED) ? this.snapshotsGroupedByEntity((NSArray)userInfo.objectForKey((Object)UPDATED)) : NSDictionary.EmptyDictionary;
        this._globalIDsForDeletionGroupedByEntity = configuration.changeTypesToPublish().containsObject((Object)DELETED) ? this.globalIDsGroupedByEntity((NSArray)userInfo.objectForKey((Object)DELETED)) : NSDictionary.EmptyDictionary;
    }

    public NSDictionary shapshotsForInsertionGroupedByEntity() {
        return this._shapshotsForInsertionGroupedByEntity;
    }

    public NSDictionary shapshotsForUpdateGroupedByEntity() {
        return this._shapshotsForUpdateGroupedByEntity;
    }

    public NSDictionary globalIDsForDeletionGroupedByEntity() {
        return this._globalIDsForDeletionGroupedByEntity;
    }

    public boolean shouldPostChange() {
        return this._entryCount > 0;
    }

    public static boolean shouldApplyChangeFor(String operation) {
        ERCNConfiguration configuration = ERCNNotificationCoordinator.coordinator().configuration();
        return configuration.changeTypesToSubscrive().containsObject((Object)operation);
    }

    public static boolean shouldSynchronizeEntity(String entityName) {
        ERCNConfiguration configuration = ERCNNotificationCoordinator.coordinator().configuration();
        return !configuration.entitiesNotToSynchronize().containsObject((Object)entityName);
    }

    public String senderHost() {
        return this._senderHost;
    }

    public Number senderPort() {
        return this._senderPort;
    }

    public String senderAppName() {
        return this._senderAppName;
    }

    public NSDictionary snapshotsGroupedByEntity(NSArray objects) {
        if (objects == null) {
            return NSDictionary.EmptyDictionary;
        }
        NSMutableDictionary result = new NSMutableDictionary();
        EOEditingContext ec = new EOEditingContext();
        ec.lock();
        Enumeration e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            NSDictionary snapshot;
            EOKeyGlobalID globalID = (EOKeyGlobalID)e.nextElement();
            String entityName = globalID.entityName();
            if (!ERCNSnapshot.shouldSynchronizeEntity(entityName)) continue;
            EODatabaseContext dbContext = ERCNNotificationCoordinator.databaseContextForEntityNamed(entityName, ec);
            NSMutableArray snapshotsForEntity = (NSMutableArray)result.objectForKey((Object)entityName);
            if (snapshotsForEntity == null) {
                snapshotsForEntity = new NSMutableArray();
                result.setObjectForKey((Object)snapshotsForEntity, (Object)entityName);
            }
            if ((snapshot = dbContext.snapshotForGlobalID((EOGlobalID)globalID)) == null) continue;
            snapshotsForEntity.addObject((Object)snapshot);
            ++this._entryCount;
        }
        ec.unlock();
        return result.immutableClone();
    }

    public NSDictionary globalIDsGroupedByEntity(NSArray objects) {
        if (objects == null) {
            return NSDictionary.EmptyDictionary;
        }
        NSMutableDictionary result = new NSMutableDictionary();
        Enumeration e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            EOKeyGlobalID globalID = (EOKeyGlobalID)e.nextElement();
            String entityName = globalID.entityName();
            if (!ERCNSnapshot.shouldSynchronizeEntity(entityName)) continue;
            NSMutableArray globalIDsForEntity = (NSMutableArray)result.objectForKey((Object)entityName);
            if (globalIDsForEntity == null) {
                globalIDsForEntity = new NSMutableArray();
                result.setObjectForKey((Object)globalIDsForEntity, (Object)entityName);
            }
            globalIDsForEntity.addObject((Object)globalID);
            ++this._entryCount;
        }
        return result.immutableClone();
    }

    public String toString() {
        if (this._toString == null) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("<").append(this.getClass().getName()).append("\n");
            sbuf.append(" sender: ").append(this.senderHost()).append(":").append(this.senderPort()).append("/").append(this.senderAppName()).append("\n");
            sbuf.append(" insertion: ").append(this._summaryForChangeType(this._shapshotsForInsertionGroupedByEntity));
            sbuf.append(" update: ").append(this._summaryForChangeType(this._shapshotsForUpdateGroupedByEntity));
            sbuf.append(" deletion: ").append(this._summaryForChangeType(this._globalIDsForDeletionGroupedByEntity));
            sbuf.append(">");
            this._toString = sbuf.toString();
        }
        return this._toString;
    }

    private String _summaryForChangeType(NSDictionary objectsGroupedByEntity) {
        StringBuffer sbuf = new StringBuffer();
        if (objectsGroupedByEntity.allKeys().count() == 0) {
            sbuf.append("none \n");
        } else {
            sbuf.append("\n");
            Enumeration entityNames = objectsGroupedByEntity.keyEnumerator();
            while (entityNames.hasMoreElements()) {
                String entityName = (String)entityNames.nextElement();
                sbuf.append("    ").append(entityName).append(": ");
                NSArray objects = (NSArray)objectsGroupedByEntity.objectForKey((Object)entityName);
                sbuf.append(objects.count()).append(" objects \n");
            }
        }
        return sbuf.toString();
    }
}

