/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxComponent;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class AjaxAutoComplete
extends AjaxComponent {
    public String divName;
    public String fieldName;
    public String indicatorName;

    public AjaxAutoComplete(WOContext context) {
        super(context);
    }

    public void awake() {
        super.awake();
        this.divName = this.safeElementID() + "_div";
        this.fieldName = this.safeElementID() + "_field";
        this.indicatorName = this.safeElementID() + "_indicator";
    }

    public void sleep() {
        this.divName = null;
        this.fieldName = null;
        this.indicatorName = null;
        super.sleep();
    }

    public boolean isStateless() {
        return true;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public String indicator() {
        String indicator = (String)this.valueForBinding("indicator");
        if (indicator == null && this.valueForBinding("indicatorFilename") != null) {
            indicator = "'" + this.indicatorName + "'";
        }
        return indicator;
    }

    protected NSDictionary createAjaxOptions() {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("tokens", AjaxOption.STRING_ARRAY));
        ajaxOptionsArray.addObject((Object)new AjaxOption("frequency", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("minChars", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("indicator", this.indicator(), AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("updateElement", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("afterUpdateElement", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onShow", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("fullSearch", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("partialSearch", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("defaultValue", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("select", AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("autoSelect", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("choices", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("partialChars", AjaxOption.NUMBER));
        ajaxOptionsArray.addObject((Object)new AjaxOption("ignoreCase", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("activateOnFocus", AjaxOption.BOOLEAN));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, this);
        return options;
    }

    public void appendToResponse(WOResponse res, WOContext ctx) {
        boolean isDisabled;
        super.appendToResponse(res, ctx);
        boolean bl = isDisabled = this.hasBinding("disabled") && (Boolean)this.valueForBinding("disabled") != false;
        if (!isDisabled) {
            boolean isLocal;
            boolean bl2 = isLocal = this.hasBinding("isLocal") && (Boolean)this.valueForBinding("isLocal") != false;
            if (isLocal) {
                StringBuffer str = new StringBuffer();
                boolean isLocalSharedList = this.hasBinding("isLocalSharedList") && (Boolean)this.valueForBinding("isLocalSharedList") != false;
                String listJS = null;
                if (isLocalSharedList) {
                    String varName = (String)this.valueForBinding("localSharedVarName");
                    NSMutableDictionary userInfo = AjaxUtils.mutableUserInfo((WOMessage)res);
                    if (userInfo.objectForKey((Object)varName) == null) {
                        String ljs = this.listeJS();
                        AjaxUtils.addScriptCodeInHead(res, ctx, "var " + varName + " = " + ljs + ";");
                        userInfo.setObjectForKey((Object)ljs, (Object)varName);
                    }
                    listJS = varName;
                } else {
                    listJS = this.listeJS();
                }
                str.append("<script type=\"text/javascript\">\n// <![CDATA[\n");
                str.append("new Autocompleter.Local('");
                str.append(this.fieldName);
                str.append("','");
                str.append(this.divName);
                str.append("',");
                str.append(listJS);
                str.append(",");
                AjaxOptions.appendToBuffer(this.createAjaxOptions(), str, ctx);
                str.append(");\n// ]]>\n</script>\n");
                res.appendContentString(String.valueOf(str));
            } else {
                String actionUrl = AjaxUtils.ajaxComponentActionUrl(ctx);
                AjaxUtils.appendScriptHeader(res);
                res.appendContentString("new Ajax.Autocompleter('" + this.fieldName + "', '" + this.divName + "', '" + actionUrl + "', ");
                AjaxOptions.appendToResponse(this.createAjaxOptions(), res, ctx);
                res.appendContentString(");");
                AjaxUtils.appendScriptFooter(res);
            }
        }
    }

    String listeJS() {
        StringBuffer str = new StringBuffer();
        str.append("new Array(");
        NSArray list = (NSArray)this.valueForBinding("list");
        int max = list.count();
        String cnt = "";
        boolean hasItem = this.hasBinding("item");
        for (int i = 0; i < max; ++i) {
            Object ds = list.objectAtIndex(i);
            if (i > 0) {
                str.append(",");
            }
            str.append("\n\"");
            if (hasItem) {
                this.setValueForBinding(ds, "item");
            }
            Object displayValue = this.valueForBinding("displayString", this.valueForBinding("item", ds));
            str.append(displayValue.toString());
            str.append(cnt);
            str.append("\"");
        }
        str.append(")");
        return String.valueOf(str);
    }

    protected void addRequiredWebResources(WOResponse res) {
        boolean isDisabled;
        boolean bl = isDisabled = this.hasBinding("disabled") && (Boolean)this.valueForBinding("disabled") != false;
        if (!isDisabled) {
            this.addScriptResourceInHead(res, "prototype.js");
            this.addScriptResourceInHead(res, "effects.js");
            this.addScriptResourceInHead(res, "controls.js");
            this.addScriptResourceInHead(res, "wonder.js");
        }
    }

    public String stringValue() {
        String strValue = null;
        if (this.hasBinding("selection")) {
            Object selection = this.valueForBinding("selection");
            if (this.hasBinding("displayString")) {
                this.setValueForBinding(selection, "item");
                strValue = this.displayStringForValue(this.valueForBinding("value"));
            } else if (selection != null) {
                strValue = String.valueOf(selection);
            }
        } else if (this.hasBinding("value")) {
            strValue = (String)this.valueForBinding("value");
        }
        return strValue;
    }

    protected String displayStringForValue(Object value) {
        Object displayValue = this.valueForBinding("displayString", this.valueForBinding("item", value));
        String displayString = displayValue == null ? null : displayValue.toString();
        return displayString;
    }

    protected int maxItems() {
        int maxItems = ERXValueUtilities.intValueWithDefault((Object)this.valueForBinding("maxItems"), (int)50);
        return maxItems;
    }

    public void setStringValue(String strValue) {
        if (this.hasBinding("selection")) {
            Object selection = null;
            if (strValue != null) {
                NSArray values = (NSArray)this.valueForBinding("list");
                int maxItems = this.maxItems();
                int itemsCount = 0;
                Enumeration e = values.objectEnumerator();
                while (e.hasMoreElements() && itemsCount++ < maxItems) {
                    Object value = e.nextElement();
                    this.setValueForBinding(value, "item");
                    String displayString = this.displayStringForValue(value);
                    if (!ERXStringUtilities.stringEqualsString((String)displayString, (String)strValue)) continue;
                    selection = value;
                    break;
                }
            }
            this.setValueForBinding(selection, "selection");
        }
        this.setValueForBinding(strValue, "value");
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        super.takeValuesFromRequest(request, context);
    }

    protected void appendItemToResponse(Object value, WOElement child, boolean hasItem, WOResponse response, WOContext context) {
        response.appendContentString("<li>");
        if (hasItem && child != null) {
            this.setValueForBinding(value, "item");
            context._setCurrentComponent(this.parent());
            child.appendToResponse(response, context);
            context._setCurrentComponent((WOComponent)this);
        } else {
            if (hasItem) {
                this.setValueForBinding(value, "item");
            }
            response.appendContentString(this.displayStringForValue(value));
        }
        response.appendContentString("</li>");
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        String fieldValue = context.request().stringFormValueForKey(this.fieldName);
        this.setValueForBinding(fieldValue, "value");
        AjaxResponse response = AjaxUtils.createResponse(request, context);
        response.appendContentString("<ul>");
        int maxItems = this.maxItems();
        int itemsCount = 0;
        Object values = this.valueForBinding("list");
        WOElement child = this._childTemplate();
        boolean hasItem = this.hasBinding("item");
        if (values instanceof NSArray) {
            Enumeration valueEnum = ((NSArray)values).objectEnumerator();
            while (valueEnum.hasMoreElements() && itemsCount++ < maxItems) {
                this.appendItemToResponse(valueEnum.nextElement(), child, hasItem, (WOResponse)response, context);
            }
        } else if (values instanceof List) {
            Iterator iter = ((List)values).iterator();
            while (iter.hasNext() && itemsCount++ < maxItems) {
                this.appendItemToResponse(iter.next(), child, hasItem, (WOResponse)response, context);
            }
        }
        response.appendContentString("</ul>");
        return response;
    }

    public String zcontainerName() {
        return "ZContainer" + this.divName;
    }
}

