/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation.NSValidation;
import er.ajax.AjaxComponent;
import er.ajax.AjaxConstantOption;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.extensions.appserver.ERXResponseRewriter;
import java.text.Format;
import java.text.SimpleDateFormat;

public class AjaxDatePicker
extends AjaxComponent {
    private static String defaultImagesDir;
    private NSMutableDictionary<String, String> options;
    private Format formatter;
    private String format;

    public AjaxDatePicker(WOContext context) {
        super(context);
        if (defaultImagesDir == null) {
            defaultImagesDir = this.application().resourceManager().urlForResourceNamed("calendar_prev.png", "Ajax", null, this.context().request()).toString();
            int lastSeperator = defaultImagesDir.lastIndexOf("%2F");
            if (lastSeperator == -1) {
                lastSeperator = defaultImagesDir.lastIndexOf(47);
            }
            defaultImagesDir = defaultImagesDir.substring(0, lastSeperator);
            this.application().resourceManager().urlForResourceNamed("calendar_next.png", "Ajax", null, this.context().request()).toString();
        }
    }

    public boolean isStateless() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void awake() {
        super.awake();
        if (!this.hasBinding("formatter") && !this.hasBinding("format")) {
            this.format = "%m %d %Y";
            this.formatter = new NSTimestampFormatter(this.format);
        } else if (this.hasBinding("formatter")) {
            this.formatter = (Format)this.valueForBinding("formatter");
            if (this.formatter instanceof NSTimestampFormatter) {
                this.format = this.translateSimpleDateFormatSymbols(((NSTimestampFormatter)this.formatter).pattern());
            } else {
                if (!(this.formatter instanceof SimpleDateFormat)) throw new RuntimeException("Can't handle formatter of class " + this.formatter.getClass().getCanonicalName());
                this.format = ((SimpleDateFormat)this.formatter).toPattern();
            }
        } else {
            this.format = (String)this.valueForBinding("format");
            this.formatter = new NSTimestampFormatter(this.format);
        }
        this.format = this.translateSimpleDateFormatSymbols(this.format);
    }

    public void reset() {
        this.options = null;
        this.formatter = null;
        this.format = null;
        super.reset();
    }

    public void appendToResponse(WOResponse res, WOContext ctx) {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxConstantOption("format", "format", this.format(), AjaxOption.STRING));
        ajaxOptionsArray.addObject((Object)new AjaxOption("month_names", "monthNames", null, AjaxOption.ARRAY));
        ajaxOptionsArray.addObject((Object)new AjaxOption("day_names", "dayNames", null, AjaxOption.ARRAY));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onDateSelect", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("fireEvent", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("images_dir", "imagesDir", defaultImagesDir, AjaxOption.STRING));
        this.options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, this);
        super.appendToResponse(res, ctx);
    }

    public String onFocusScript() {
        return this.showCalendarScript();
    }

    public String onClickScript() {
        StringBuffer script = new StringBuffer(200);
        script.append("event.cancelBubble=true; ");
        script.append(this.showCalendarScript());
        return script.toString();
    }

    public String showCalendarScript() {
        StringBuffer script = new StringBuffer(200);
        script.append("AOD.loadCSS('");
        script.append(this.application().resourceManager().urlForResourceNamed(this.cssFileName(), this.cssFileFrameworkName(), null, this.context().request()).toString());
        script.append("'); ");
        script.append("this.select(); calendar_open(this, ");
        AjaxOptions.appendToBuffer((NSDictionary)this.options(), script, this.context());
        script.append(");");
        return script.toString();
    }

    public String translateSimpleDateFormatSymbols(String symbols) {
        if (symbols.indexOf(37) > -1) {
            return symbols;
        }
        StringBuilder sb = new StringBuilder(symbols);
        this.replace(sb, "dd", "%~");
        this.replace(sb, "d", "%d");
        this.replace(sb, "%~", "%d");
        this.replace(sb, "MMMM", "%B");
        this.replace(sb, "MMM", "%b");
        this.replace(sb, "MM", "%m");
        this.replace(sb, "M", "%m");
        this.replace(sb, "yyyy", "%Y");
        this.replace(sb, "yyy", "%~");
        this.replace(sb, "yy", "%~");
        this.replace(sb, "y", "%y");
        this.replace(sb, "%~", "%y");
        return sb.toString();
    }

    private void replace(StringBuilder builder, String original, String replacement) {
        int index = builder.indexOf(original);
        if (index > -1) {
            builder.replace(index, index + original.length(), replacement);
        }
    }

    public String format() {
        return this.format;
    }

    public Format formatter() {
        return this.formatter;
    }

    public NSMutableDictionary options() {
        return this.options;
    }

    protected void addRequiredWebResources(WOResponse response) {
        ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)this.context(), (String)"Ajax", (String)"prototype.js");
        ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)this.context(), (String)"Ajax", (String)"wonder.js");
        ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)this.context(), (String)"Ajax", (String)"calendar.js");
        ERXResponseRewriter.addScriptResourceInHead((WOResponse)response, (WOContext)this.context(), (String)"Ajax", (String)"date.js");
        ERXResponseRewriter.addStylesheetResourceInHead((WOResponse)response, (WOContext)this.context(), (String)this.cssFileFrameworkName(), (String)this.cssFileName());
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        return null;
    }

    public void validationFailedWithException(Throwable t, Object value, String keyPath) {
        if (keyPath != null && "<none>".equals(keyPath) && t instanceof NSValidation.ValidationException) {
            NSValidation.ValidationException e = (NSValidation.ValidationException)t;
            WOAssociation valueAssociation = (WOAssociation)this._keyAssociations.valueForKey("value");
            if (valueAssociation != null) {
                keyPath = valueAssociation.keyPath();
            }
            t = new NSValidation.ValidationException(e.getMessage(), e.object(), keyPath);
        }
        this.parent().validationFailedWithException(t, value, keyPath);
    }

    protected String cssFileName() {
        return (String)this.valueForBinding("calendarCSS", "calendar.css");
    }

    protected String cssFileFrameworkName() {
        return (String)this.valueForBinding("calendarCSSFramework", "Ajax");
    }
}

