/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxModalDialog;
import er.ajax.AjaxOptions;
import er.ajax.AjaxSubmitButton;
import er.ajax.AjaxUpdateContainer;
import er.ajax.AjaxUpdateLink;

public class AjaxDefaultSubmitButton
extends AjaxSubmitButton {
    public AjaxDefaultSubmitButton(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        StringBuilder sb;
        WOComponent component = context.component();
        String formName = (String)this.valueForBinding("formName", component);
        String formReference = "this.form";
        if (formName != null) {
            formReference = "document." + formName;
        }
        StringBuffer onClickBuffer = new StringBuffer();
        String onClickBefore = (String)this.valueForBinding("onClickBefore", component);
        if (onClickBefore != null) {
            onClickBuffer.append("if (");
            onClickBuffer.append(onClickBefore);
            onClickBuffer.append(") {");
        }
        String updateContainerID = AjaxUpdateContainer.updateContainerID(this, component);
        String beforeEffect = (String)this.valueForBinding("beforeEffect", component);
        if (beforeEffect != null) {
            onClickBuffer.append("new ");
            onClickBuffer.append(AjaxUpdateLink.fullEffectName(beforeEffect));
            onClickBuffer.append("('");
            String beforeEffectID = (String)this.valueForBinding("beforeEffectID", component);
            if (beforeEffectID == null && (beforeEffectID = AjaxUpdateContainer.currentUpdateContainerID()) == null) {
                beforeEffectID = updateContainerID;
            }
            onClickBuffer.append(beforeEffectID);
            onClickBuffer.append("', { ");
            String beforeEffectDuration = (String)this.valueForBinding("beforeEffectDuration", component);
            if (beforeEffectDuration != null) {
                onClickBuffer.append("duration: ");
                onClickBuffer.append(beforeEffectDuration);
                onClickBuffer.append(", ");
            }
            onClickBuffer.append("queue:'end', afterFinish: function() {");
        }
        if (updateContainerID != null) {
            onClickBuffer.append("ASB.update('" + updateContainerID + "',");
        } else {
            onClickBuffer.append("ASB.request(");
        }
        onClickBuffer.append(formReference);
        onClickBuffer.append(",null,");
        NSMutableDictionary options = this.createAjaxOptions(component);
        AjaxUpdateLink.addEffect(options, (String)this.valueForBinding("effect", component), updateContainerID, (String)this.valueForBinding("effectDuration", component));
        String afterEffectID = (String)this.valueForBinding("afterEffectID", component);
        if (afterEffectID == null && (afterEffectID = AjaxUpdateContainer.currentUpdateContainerID()) == null) {
            afterEffectID = updateContainerID;
        }
        AjaxUpdateLink.addEffect(options, (String)this.valueForBinding("afterEffect", component), afterEffectID, (String)this.valueForBinding("afterEffectDuration", component));
        AjaxOptions.appendToBuffer((NSDictionary)options, onClickBuffer, context);
        onClickBuffer.append(")");
        String onClick = (String)this.valueForBinding("onClick", component);
        if (onClick != null) {
            onClickBuffer.append(";");
            onClickBuffer.append(onClick);
        }
        if (beforeEffect != null) {
            onClickBuffer.append("}});");
        }
        if (onClickBefore != null) {
            onClickBuffer.append("}");
        }
        onClickBuffer.append("; return false;");
        response.appendContentString("<input ");
        this.appendTagAttributeToResponse(response, "tabindex", "");
        this.appendTagAttributeToResponse(response, "type", "image");
        this.appendTagAttributeToResponse(response, "src", WOApplication.application().resourceManager().urlForResourceNamed("clear1x1.gif", "Ajax", component.session().languages(), context.request()));
        String name = this.nameInContext(context, component);
        this.appendTagAttributeToResponse(response, "name", name);
        this.appendTagAttributeToResponse(response, "value", this.valueForBinding("value", component));
        this.appendTagAttributeToResponse(response, "accesskey", this.valueForBinding("accesskey", component));
        if (AjaxModalDialog.isInDialog(context)) {
            sb = new StringBuilder("MB_notFocusable ");
            Object cssClass = this.valueForBinding("class", component);
            if (cssClass != null) {
                sb.append(cssClass);
            }
            this.appendTagAttributeToResponse(response, "class", sb.toString());
        } else {
            this.appendTagAttributeToResponse(response, "class", this.valueForBinding("class", component));
        }
        sb = new StringBuilder("height:1px; width:1px; border: none; ");
        Object style = this.valueForBinding("style", component);
        if (style != null) {
            sb.append(style);
        }
        this.appendTagAttributeToResponse(response, "style", sb.toString());
        this.appendTagAttributeToResponse(response, "id", this.valueForBinding("id", component));
        this.appendTagAttributeToResponse(response, "onclick", onClickBuffer.toString());
        response.appendContentString(" />");
    }
}

