/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicGroup;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;
import er.ajax.IAjaxElement;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import org.apache.log4j.Logger;

public abstract class AjaxDynamicElement
extends WODynamicGroup
implements IAjaxElement {
    protected Logger log = Logger.getLogger(this.getClass());
    private WOElement _children;
    private NSDictionary _associations;

    public AjaxDynamicElement(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
        this._children = children;
        this._associations = associations;
    }

    public NSDictionary associations() {
        return this._associations;
    }

    public boolean hasBinding(String name) {
        return AjaxUtils.hasBinding(name, this.associations());
    }

    public WOAssociation bindingNamed(String name) {
        return (WOAssociation)this.associations().objectForKey((Object)name);
    }

    public Object valueForBinding(String name, Object defaultValue, WOComponent component) {
        return AjaxUtils.valueForBinding(name, defaultValue, this.associations(), component);
    }

    public Object valueForBinding(String name, WOComponent component) {
        return AjaxUtils.valueForBinding(name, this.associations(), component);
    }

    public String stringValueForBinding(String name, WOComponent component) {
        return AjaxUtils.stringValueForBinding(name, this.associations(), component);
    }

    public boolean booleanValueForBinding(String name, boolean defaultValue, WOComponent component) {
        return AjaxUtils.booleanValueForBinding(name, defaultValue, this.associations(), component);
    }

    public void setValueForBinding(Object value, String name, WOComponent component) {
        AjaxUtils.setValueForBinding(value, name, this.associations(), component);
    }

    protected void addScriptResourceInHead(WOContext context, WOResponse response, String framework, String fileName) {
        AjaxUtils.addScriptResourceInHead(context, response, framework, fileName);
    }

    protected void addScriptResourceInHead(WOContext context, WOResponse response, String fileName) {
        AjaxUtils.addScriptResourceInHead(context, response, fileName);
    }

    protected void addStylesheetResourceInHead(WOContext context, WOResponse response, String fileName) {
        AjaxUtils.addStylesheetResourceInHead(context, response, fileName);
    }

    protected void addStylesheetResourceInHead(WOContext context, WOResponse response, String framework, String fileName) {
        AjaxUtils.addStylesheetResourceInHead(context, response, framework, fileName);
    }

    public WOActionResults invokeAction(WORequest request, WOContext context) {
        Object result = null;
        if (this.shouldHandleRequest(request, context)) {
            WOComponent component = context.component();
            String elementID = context.elementID();
            AjaxResponse response = AjaxUtils.createResponse(request, context);
            NSMutableDictionary userInfo = AjaxUtils.mutableUserInfo((WOMessage)request);
            result = this.handleRequest(request, context);
            AjaxUtils.updateMutableUserInfoWithAjaxInfo(context);
            if (ERXAjaxApplication.shouldIgnoreResults((WORequest)request, (WOContext)context, (WOActionResults)result)) {
                this.log.warn((Object)"An Ajax request attempted to return the page, which is almost certainly an error.");
                result = null;
            }
            if (result == null && !ERXAjaxApplication.isAjaxReplacement((WORequest)request)) {
                result = AjaxUtils.createResponse(request, context);
            }
        } else if (this.hasChildrenElements()) {
            result = super.invokeAction(request, context);
        }
        return result;
    }

    protected String _containerID(WOContext context) {
        return null;
    }

    protected boolean shouldHandleRequest(WORequest request, WOContext context) {
        return AjaxUtils.shouldHandleRequest(request, context, this._containerID(context));
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        this.addRequiredWebResources(response, context);
    }

    public void appendTagAttributeToResponse(WOResponse response, String name, Object object) {
        if (object != null) {
            response._appendTagAttributeAndValue(name, object.toString(), true);
        }
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        this.takeChildrenValuesFromRequest(request, context);
    }

    protected abstract void addRequiredWebResources(WOResponse var1, WOContext var2);

    public abstract WOActionResults handleRequest(WORequest var1, WOContext var2);
}

