/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSData;
import er.ajax.AjaxFileUploadRequestHandler;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUploadProgress;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXWOContext;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.formatters.ERXUnitAwareDecimalFormat;
import er.extensions.foundation.ERXFileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class AjaxFileUpload
extends WOComponent {
    private static boolean _requestHandlerRegistered = false;
    private String _id;
    protected boolean _uploadStarted;
    protected AjaxUploadProgress _progress;
    protected boolean _triggerUploadStart;
    private String _requestHandlerKey = "upload";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AjaxFileUpload(WOContext context) {
        super(context);
        if (_requestHandlerRegistered) return;
        Class<AjaxFileUpload> clazz = AjaxFileUpload.class;
        synchronized (AjaxFileUpload.class) {
            if (_requestHandlerRegistered) return;
            if (WOApplication.application().requestHandlerForKey("upload") == null) {
                WOApplication.application().registerRequestHandler((WORequestHandler)new AjaxFileUploadRequestHandler(), "upload");
            }
            _requestHandlerRegistered = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setRequestHandlerKey(String requestHandlerKey) {
        this._requestHandlerKey = requestHandlerKey;
    }

    public String requestHandlerKey() {
        return this._requestHandlerKey;
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        super.appendToResponse(aResponse, aContext);
        AjaxUtils.addScriptResourceInHead(aContext, aResponse, "prototype.js");
        AjaxUtils.addScriptResourceInHead(aContext, aResponse, "effects.js");
        AjaxUtils.addScriptResourceInHead(aContext, aResponse, "wonder.js");
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public String uploadLabel() {
        String uploadLabel = (String)this.valueForBinding("uploadLabel");
        if (uploadLabel == null) {
            uploadLabel = "Upload";
        }
        return uploadLabel;
    }

    public boolean progressBarBeforeStart() {
        boolean progressBarBeforeStart = false;
        if (this.hasBinding("progressBarBeforeStart")) {
            progressBarBeforeStart = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"progressBarBeforeStart");
        }
        return progressBarBeforeStart;
    }

    public boolean progressBarAfterDone() {
        boolean progressBarAfterDone = false;
        if (this.hasBinding("progressBarAfterDone")) {
            progressBarAfterDone = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"progressBarAfterDone");
        }
        return progressBarAfterDone;
    }

    public void setUploadProgress(AjaxUploadProgress progress) {
        this._progress = progress;
        if (this.hasBinding("uploadProgress")) {
            this.setValueForBinding(progress, "uploadProgress");
        }
        if (progress == null && !this.hasBinding("uploadStarted")) {
            this._uploadStarted = false;
        }
    }

    public AjaxUploadProgress uploadProgress() {
        return this._progress;
    }

    public String id() {
        String id = this._id;
        if (id == null) {
            id = (String)this.valueForBinding("id");
            if (id == null) {
                id = ERXWOContext.safeIdentifierName((WOContext)this.context(), (boolean)true);
            }
            this._id = id;
        }
        return id;
    }

    public String uploadUrl() {
        String uploadUrl = this.context().urlWithRequestHandlerKey(this._requestHandlerKey, "", null);
        return uploadUrl;
    }

    public String bytesReadSize() {
        String bytesReadSize = null;
        AjaxUploadProgress progress = this.uploadProgress();
        if (progress != null) {
            ERXUnitAwareDecimalFormat formatter = new ERXUnitAwareDecimalFormat("byte");
            formatter.setMaximumFractionDigits(2);
            bytesReadSize = formatter.format(progress.value());
        }
        return bytesReadSize;
    }

    public String streamLengthSize() {
        String streamLengthSize = null;
        AjaxUploadProgress progress = this.uploadProgress();
        if (progress != null) {
            ERXUnitAwareDecimalFormat formatter = new ERXUnitAwareDecimalFormat("byte");
            formatter.setMaximumFractionDigits(2);
            streamLengthSize = formatter.format(progress.maximum());
        }
        return streamLengthSize;
    }

    public String uploadFrameName() {
        return this.id() + "UploadFrame";
    }

    public String startUploadName() {
        return this.id() + "StartUpload";
    }

    public String startUploadFunctionCall() {
        return "form.submit(true); " + this.startUploadName() + "();";
    }

    public boolean triggerStartUpload() {
        boolean triggerUploadStart = this._triggerUploadStart;
        if (triggerUploadStart) {
            this._triggerUploadStart = false;
        }
        return triggerUploadStart;
    }

    public String uploadFormID() {
        return this.id() + "Form";
    }

    public String progressBarID() {
        return this.id() + "ProgressBar";
    }

    public String startingText() {
        String startingText = (String)this.valueForBinding("startingText");
        if (startingText == null) {
            startingText = "Upload Starting ...";
        }
        return startingText;
    }

    public String cancelText() {
        String cancelText = (String)this.valueForBinding("cancelText");
        if (cancelText == null) {
            cancelText = "cancel";
        }
        return cancelText;
    }

    public String cancelingText() {
        String cancelingText = (String)this.valueForBinding("cancelingText");
        if (cancelingText == null) {
            cancelingText = "Canceling Upload ...";
        }
        return cancelingText;
    }

    public WOActionResults startUpload() {
        this._triggerUploadStart = true;
        if (this._progress != null) {
            this._progress.reset();
        }
        this._progress = null;
        if (this.hasBinding("uploadProgress")) {
            this.setValueForBinding(null, "uploadProgress");
        }
        this._uploadStarted = true;
        if (this.hasBinding("uploadStarted")) {
            this.setValueForBinding(Boolean.TRUE, "uploadStarted");
        }
        AjaxResponse response = AjaxUtils.createResponse(this.context().request(), this.context());
        AjaxUtils.appendScriptHeaderIfNecessary(this.context().request(), (WOResponse)response);
        response.appendContentString("document." + this.uploadFormID() + ".submit();");
        AjaxUtils.appendScriptFooterIfNecessary(this.context().request(), (WOResponse)response);
        return response;
    }

    public boolean isUploadStarted() {
        boolean uploadStarted;
        if (this.hasBinding("uploadStarted")) {
            uploadStarted = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"uploadStarted");
        } else {
            AjaxUploadProgress progress = this.uploadProgress();
            if (progress != null && progress.shouldReset()) {
                this._uploadStarted = false;
                this.setValueForBinding(Boolean.FALSE, "uploadStarted");
            }
            uploadStarted = this._uploadStarted;
        }
        return uploadStarted;
    }

    public void uploadFinished() {
        this.valueForBinding("finishedAction");
    }

    public WOActionResults uploadCanceled() {
        this.uploadFinished();
        WOActionResults results = (WOActionResults)this.valueForBinding("canceledAction");
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOActionResults uploadSucceeded() {
        AjaxUploadProgress progress = this.uploadProgress();
        try {
            OutputStream outputStream;
            String contentType;
            boolean deleteFile = true;
            if (this.hasBinding("filePath")) {
                this.setValueForBinding(progress.fileName(), "filePath");
            }
            if (this.hasBinding("data")) {
                NSData data = new NSData(progress.tempFile().toURL());
                this.setValueForBinding(data, "data");
            }
            if (this.hasBinding("mimeType") && (contentType = progress.contentType()) != null) {
                this.setValueForBinding(contentType, "mimeType");
            }
            if (this.hasBinding("inputStream")) {
                this.setValueForBinding(new FileInputStream(progress.tempFile()), "inputStream");
                deleteFile = false;
            }
            if (this.hasBinding("outputStream") && (outputStream = (OutputStream)this.valueForBinding("outputStream")) != null) {
                ERXFileUtilities.writeInputStreamToOutputStream((InputStream)new FileInputStream(progress.tempFile()), (boolean)true, (OutputStream)outputStream, (boolean)true);
            }
            String finalFilePath = progress.tempFile().getAbsolutePath();
            if (this.hasBinding("streamToFilePath")) {
                boolean renameFile;
                File streamToFile = new File((String)this.valueForBinding("streamToFilePath"));
                if (streamToFile.exists()) {
                    boolean overwrite = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"overwrite");
                    if (streamToFile.isDirectory()) {
                        File parentDir = streamToFile;
                        String fileName = ERXFileUtilities.fileNameFromBrowserSubmittedPath((String)progress.fileName());
                        streamToFile = ERXFileUtilities.reserveUniqueFile((File)new File(parentDir, fileName), (boolean)overwrite);
                        renameFile = true;
                    } else {
                        renameFile = overwrite;
                    }
                } else {
                    renameFile = true;
                }
                if (!renameFile || streamToFile.isDirectory()) {
                    boolean renamedFile = false;
                    progress.setFailure(new Exception("Could not rename file."));
                    WOActionResults wOActionResults = this.uploadFailed();
                    return wOActionResults;
                }
                ERXFileUtilities.renameTo((File)progress.tempFile(), (File)streamToFile);
                boolean renamedFile = true;
                if (renamedFile) {
                    finalFilePath = streamToFile.getAbsolutePath();
                }
                deleteFile = false;
            } else if (this.hasBinding("keepTempFile") && deleteFile) {
                boolean bl = deleteFile = !ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"keepTempFile");
            }
            if (deleteFile) {
                progress.dispose();
            } else if (this.hasBinding("finalFilePath")) {
                this.setValueForBinding(finalFilePath, "finalFilePath");
            }
        }
        catch (Throwable t) {
            progress.setFailure(t);
            WOActionResults wOActionResults = this.uploadFailed();
            return wOActionResults;
        }
        finally {
            this.uploadFinished();
        }
        WOActionResults results = (WOActionResults)this.valueForBinding("succeededAction");
        return results;
    }

    public WOActionResults uploadFailed() {
        this.uploadFinished();
        WOActionResults results = (WOActionResults)this.valueForBinding("failedAction");
        return results;
    }

    public String srcUrl() {
        return ERXWOContext._directActionURL((WOContext)this.context(), (String)"ERXDirectAction/empty", null, (boolean)ERXRequest.isRequestSecure((WORequest)this.context().request()));
    }
}

