/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxUtils;
import er.extensions.components._private.ERXWORepetition;
import er.extensions.eof.ERXSortOrdering;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.text.Format;
import java.text.ParseException;

public class AjaxGrid
extends WOComponent {
    private WODisplayGroup displayGroup;
    private NSMutableArray selectedObjects;
    private NSMutableDictionary columnsByKeypath;
    private NSMutableDictionary sortOrdersByKeypath;
    private NSMutableDictionary formattersByKeypath;
    private Boolean showRowSelector;
    private NSKeyValueCodingAdditions row;
    private NSDictionary currentColumn;
    private int rowIndex;
    public static final String TITLE = "title";
    public static final String KEY_PATH = "keyPath";
    public static final String SORT_PATH = "sortPath";
    public static final String SORT_DIRECTION = "direction";
    public static final String SORT_ASCENDING = "ascending";
    public static final String SORT_DESCENDING = "descending";
    public static final String SORT_ORDER = "sortOrder";
    public static final String COLUMNS = "columns";
    public static final String BATCH_SIZE = "batchSize";
    public static final String UPDATE_CONTAINER_ID = "updateContainerID";
    public static final String TABLE_ID = "tableID";
    public static final String ROW_IDENTIFIER = "rowIdentifier";
    public static final String CAN_REORDER = "canReorder";
    public static final String CAN_RESORT = "canResort";
    public static final String DRAG_HEADER_ONLY = "dragHeaderOnly";
    public static final String SOURCE_COLUMN_FORM_VALUE = "sourceColumn";
    public static final String DESTINATION_COLUMN_FORM_VALUE = "destinationColumn";
    public static final String FORMATTER_CLASS = "formatterClass";
    public static final String FORMAT_PATTERN = "formatPattern";
    public static final String EVEN_ROW_CSS_CLASS = "evenRowCSSClass";
    public static final String ODD_ROW_CSS_CLASS = "oddRowCSSClass";
    public static final String EVEN_ROW_CSS_STYLE = "evenRowCSSStyle";
    public static final String ODD_ROW_CSS_STYLE = "oddRowCSSStyle";
    public static final String SHOW_ROW_SELECTOR = "showRowSelector";
    public static final String SELECTED_ROW_CSS_CLASS = "selectedRowCSSClass";
    public static final String UNSELECTED_ROW_CSS_CLASS = "unselectedRowCSSClass";
    public static final String SELECTED_ROW_CSS_STYLE = "selectedRowCSSStyle";
    public static final String UNSELECTED_ROW_CSS_STYLE = "unselectedRowCSSStyle";
    public static final String CONFIGURATION_UPDATED = "configurationUpdated";
    public static final String COMPONENT_NAME = "component";
    public static final String UPDATE_FREQUENCY = "updateFrequency";
    public static final String DISPLAY_GROUP_BINDING = "displayGroup";
    public static final String CONFIGURATION_DATA_BINDING = "configurationData";
    public static final String SELECTED_OBJECTS_BINDING = "selectedObjects";
    public static final String WILL_UPDATE_BINDING = "willUpdate";
    public static final String AFTER_UPDATE_BINDING = "afterUpdate";
    public static final String MANDATORY_SORT_ORDER_FLAG = "isMandatorySortOrder";
    public static final String MANDATORY_SORT = "mandatorySort";
    public static final String CHECK_HASH_CODES = "er.extensions.ERXWORepetition.checkHashCodes";

    public AjaxGrid(WOContext context) {
        super(context);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        super.appendToResponse(response, context);
        AjaxUtils.addScriptResourceInHead(context, response, "AjaxGrid.js");
    }

    public void columnOrderUpdated() {
        int sourceIndex = Integer.parseInt((String)this.context().request().formValueForKey(SOURCE_COLUMN_FORM_VALUE)) - 1;
        int destinationIndex = Integer.parseInt((String)this.context().request().formValueForKey(DESTINATION_COLUMN_FORM_VALUE)) - 1;
        Object sourceColumn = this.columns().objectAtIndex(sourceIndex);
        this.columns().removeObjectAtIndex(sourceIndex);
        this.columns().insertObjectAtIndex(sourceColumn, destinationIndex);
    }

    public void sortOrderUpdated() {
        if (this.currentSortPath() == null || !this.canResort()) {
            return;
        }
        NSMutableDictionary sortOrder = this.currentColumnSortOrder();
        if (sortOrder == null) {
            NSMutableDictionary newSortOrder = new NSMutableDictionary(2);
            newSortOrder.setObjectForKey((Object)this.currentSortPath(), (Object)KEY_PATH);
            newSortOrder.setObjectForKey((Object)SORT_ASCENDING, (Object)SORT_DIRECTION);
            if (this.hasMandatorySort() && ((NSMutableDictionary)this.sortOrdersByKeypath().objectForKey((Object)this.manadatorySortKeyPath())).valueForKey(MANDATORY_SORT_ORDER_FLAG) != null) {
                this.sortOrders().insertObjectAtIndex((Object)newSortOrder, this.sortOrders().count() - 1);
            } else {
                this.sortOrders().addObject((Object)newSortOrder);
            }
            this.clearCachedConfiguration();
        } else if (sortOrder.valueForKey(MANDATORY_SORT_ORDER_FLAG) != null) {
            sortOrder.removeObjectForKey((Object)MANDATORY_SORT_ORDER_FLAG);
            sortOrder.setObjectForKey((Object)SORT_ASCENDING, (Object)SORT_DIRECTION);
        } else {
            String direction = (String)sortOrder.objectForKey((Object)SORT_DIRECTION);
            sortOrder.setObjectForKey((Object)(SORT_ASCENDING.equals(direction) ? SORT_DESCENDING : SORT_ASCENDING), (Object)SORT_DIRECTION);
        }
        this.updateDisplayGroupSort();
    }

    public void removeSorting() {
        if (this.canResort()) {
            this.configurationData().setObjectForKey((Object)(this.hasMandatorySort() ? new NSMutableArray((Object)this.manadatorySortDictionary()) : new NSMutableArray()), (Object)SORT_ORDER);
            this.clearCachedConfiguration();
            this.updateDisplayGroupSort();
        }
    }

    public String removeSortingID() {
        return this.tableID() + "_RemoveSorting";
    }

    public boolean hasMandatorySort() {
        return this.configurationData().objectForKey((Object)MANDATORY_SORT) != null;
    }

    public NSDictionary manadatorySortDictionary() {
        NSMutableDictionary manadatorySortDictionary = (NSMutableDictionary)this.configurationData().objectForKey((Object)MANDATORY_SORT);
        manadatorySortDictionary = manadatorySortDictionary.mutableClone();
        manadatorySortDictionary.setObjectForKey((Object)Boolean.TRUE, (Object)MANDATORY_SORT_ORDER_FLAG);
        return manadatorySortDictionary;
    }

    public String manadatorySortKeyPath() {
        NSMutableDictionary manadatorySortDictionary = (NSMutableDictionary)this.configurationData().objectForKey((Object)MANDATORY_SORT);
        return (String)manadatorySortDictionary.objectForKey((Object)KEY_PATH);
    }

    public void containerUpdated() {
        if (this.hasBinding(WILL_UPDATE_BINDING)) {
            this.valueForBinding(WILL_UPDATE_BINDING);
        }
        this.updateBatchSize();
    }

    public String initScript() {
        return this.canReorder() ? "<script type=\"text/javascript\">AjaxGrid.ajaxGrid_init('" + this.tableID() + "', " + this.dragHeaderOnly() + ");</script>" : null;
    }

    public String dragHeaderOnly() {
        String dragHeaderOnly = (String)this.configurationData().objectForKey((Object)DRAG_HEADER_ONLY);
        return dragHeaderOnly == null ? "false" : dragHeaderOnly;
    }

    public String afterUpdate() {
        String afterUpdate = this.hasBinding(AFTER_UPDATE_BINDING) ? (String)this.valueForBinding(AFTER_UPDATE_BINDING) : "";
        afterUpdate = afterUpdate + this.enableDragAndDrop();
        return afterUpdate.length() > 0 ? afterUpdate : null;
    }

    public String enableDragAndDrop() {
        return this.canReorder() ? "AjaxGrid.ajaxGrid_init('" + this.tableID() + "', " + this.dragHeaderOnly() + ");" : "";
    }

    public NSMutableDictionary configurationData() {
        NSMutableDictionary configurationData = (NSMutableDictionary)this.valueForBinding(CONFIGURATION_DATA_BINDING);
        if (configurationData.objectForKey((Object)CONFIGURATION_UPDATED) != null) {
            this.clearCachedConfiguration();
            configurationData.removeObjectForKey((Object)CONFIGURATION_UPDATED);
        }
        return configurationData;
    }

    protected void clearCachedConfiguration() {
        this.columnsByKeypath = null;
        this.sortOrdersByKeypath = null;
        this.formattersByKeypath = null;
        this.showRowSelector = null;
    }

    public boolean canReorder() {
        return this.configurationData().valueForKey(CAN_REORDER) != null ? Boolean.valueOf((String)this.configurationData().valueForKey(CAN_REORDER)) : true;
    }

    public boolean canResort() {
        return this.configurationData().valueForKey(CAN_RESORT) != null ? Boolean.valueOf((String)this.configurationData().valueForKey(CAN_RESORT)) : true;
    }

    public String tableID() {
        return (String)this.configurationData().valueForKey(TABLE_ID);
    }

    public String rowIdentifier() {
        return (String)this.configurationData().valueForKey(ROW_IDENTIFIER);
    }

    protected NSMutableArray columns() {
        return (NSMutableArray)this.configurationData().valueForKey(COLUMNS);
    }

    protected NSMutableArray sortOrders() {
        NSMutableArray sortOrders = (NSMutableArray)this.configurationData().valueForKey(SORT_ORDER);
        if (this.hasMandatorySort()) {
            boolean includesMandatorySort = false;
            for (int i = 0; i < sortOrders.count() && !includesMandatorySort; ++i) {
                if (!((NSKeyValueCoding)sortOrders.objectAtIndex(i)).valueForKey(KEY_PATH).equals(this.manadatorySortKeyPath())) continue;
                includesMandatorySort = true;
            }
            if (!includesMandatorySort) {
                sortOrders.addObject((Object)this.manadatorySortDictionary());
            }
        }
        return sortOrders;
    }

    protected int batchSize() {
        Object batchSizeObj = this.configurationData().objectForKey((Object)BATCH_SIZE);
        return ERXValueUtilities.intValue((Object)batchSizeObj);
    }

    public String rowClass() {
        boolean isEven = this.rowIndex() % 2 == 0;
        String userClass = (String)this.configurationData().valueForKey(isEven ? EVEN_ROW_CSS_CLASS : ODD_ROW_CSS_CLASS);
        String selectionClass = (String)this.configurationData().valueForKey(this.isRowSelected() ? SELECTED_ROW_CSS_CLASS : UNSELECTED_ROW_CSS_CLASS);
        if (userClass == null) {
            return selectionClass;
        }
        if (selectionClass == null) {
            return userClass;
        }
        return userClass + " " + selectionClass;
    }

    public String rowStyle() {
        boolean isEven = this.rowIndex() % 2 == 0;
        String userStyle = (String)this.configurationData().valueForKey(isEven ? EVEN_ROW_CSS_STYLE : ODD_ROW_CSS_STYLE);
        String selectionStyle = (String)this.configurationData().valueForKey(this.isRowSelected() ? SELECTED_ROW_CSS_STYLE : UNSELECTED_ROW_CSS_STYLE);
        if (userStyle == null) {
            return selectionStyle;
        }
        if (selectionStyle == null) {
            return userStyle;
        }
        return userStyle + " " + selectionStyle;
    }

    public String rowID() {
        if (this.rowIdentifier() != null) {
            return ERXStringUtilities.safeIdentifierName((String)this.row().valueForKeyPath(this.rowIdentifier()).toString());
        }
        return "row_" + String.valueOf(this.rowIndex());
    }

    public String rowIdentifierKey() {
        return this.rowIdentifier() != null ? this.rowIdentifier() : "hashCode";
    }

    public NSMutableDictionary columnsByKeypath() {
        if (this.columnsByKeypath == null) {
            NSMutableArray columns = this.columns();
            this.columnsByKeypath = new NSMutableDictionary(columns.count());
            for (int i = 0; i < columns.count(); ++i) {
                this.columnsByKeypath.setObjectForKey(columns.objectAtIndex(i), ((NSKeyValueCoding)columns.objectAtIndex(i)).valueForKey(KEY_PATH));
            }
        }
        return this.columnsByKeypath;
    }

    public NSMutableDictionary sortOrdersByKeypath() {
        if (this.sortOrdersByKeypath == null) {
            NSMutableArray sortOrders = this.sortOrders();
            this.sortOrdersByKeypath = new NSMutableDictionary(sortOrders.count());
            for (int i = 0; i < sortOrders.count(); ++i) {
                this.sortOrdersByKeypath.setObjectForKey(sortOrders.objectAtIndex(i), ((NSKeyValueCoding)sortOrders.objectAtIndex(i)).valueForKey(KEY_PATH));
            }
        }
        return this.sortOrdersByKeypath;
    }

    public NSMutableDictionary formattersByKeypath() {
        if (this.formattersByKeypath == null) {
            NSMutableArray columns = this.columns();
            this.formattersByKeypath = new NSMutableDictionary(columns.count());
            for (int i = 0; i < columns.count(); ++i) {
                NSDictionary column = (NSDictionary)columns.objectAtIndex(i);
                String className = (String)column.valueForKey(FORMATTER_CLASS);
                if (className == null) continue;
                try {
                    Format formatter = (Format)Class.forName(className).newInstance();
                    String pattern = (String)column.valueForKey(FORMAT_PATTERN);
                    if (pattern != null) {
                        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)formatter, (Object)pattern, (String)"pattern");
                    }
                    this.formattersByKeypath.setObjectForKey((Object)formatter, column.valueForKey(KEY_PATH));
                    continue;
                }
                catch (Exception e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            }
        }
        return this.formattersByKeypath;
    }

    public static void updateDisplayGroupSort(WODisplayGroup dg, NSArray sortConfig) {
        NSMutableArray sortOrders = new NSMutableArray(sortConfig.count());
        for (int i = 0; i < sortConfig.count(); ++i) {
            NSDictionary column = (NSDictionary)sortConfig.objectAtIndex(i);
            sortOrders.addObject((Object)new ERXSortOrdering((String)column.objectForKey((Object)KEY_PATH), SORT_ASCENDING.equals(column.objectForKey((Object)SORT_DIRECTION)) ? EOSortOrdering.CompareCaseInsensitiveAscending : EOSortOrdering.CompareCaseInsensitiveDescending));
        }
        if (!sortOrders.equals((Object)dg.sortOrderings())) {
            dg.setSortOrderings((NSArray)sortOrders);
            dg.updateDisplayedObjects();
        }
    }

    protected void updateDisplayGroupSort() {
        AjaxGrid.updateDisplayGroupSort(this.displayGroup(), (NSArray)this.sortOrders());
    }

    public static void updateBatchSize(WODisplayGroup dg, int batchSize) {
        if (dg.numberOfObjectsPerBatch() != batchSize) {
            dg.setNumberOfObjectsPerBatch(batchSize);
        }
    }

    protected void updateBatchSize() {
        AjaxGrid.updateBatchSize(this.displayGroup(), this.batchSize());
    }

    public WODisplayGroup displayGroup() {
        if (this.displayGroup == null) {
            this.displayGroup = (WODisplayGroup)this.valueForBinding(DISPLAY_GROUP_BINDING);
            this.updateDisplayGroupSort();
            this.updateBatchSize();
        }
        return this.displayGroup;
    }

    public String currentColumnID() {
        StringBuffer b = new StringBuffer(this.tableID());
        b.append("_SortBy_");
        b.append(ERXStringUtilities.safeIdentifierName((String)((String)this.currentColumn().objectForKey((Object)TITLE))));
        b.append(this.isCurrentColumnSortedAscending() ? "_Descending" : "_Ascending");
        return b.toString();
    }

    public boolean isCurrentColumnSorted() {
        return this.currentColumnSortOrder() != null && this.currentColumnSortOrder().objectForKey((Object)MANDATORY_SORT_ORDER_FLAG) == null;
    }

    public NSMutableDictionary currentColumnSortOrder() {
        return (NSMutableDictionary)this.sortOrdersByKeypath().objectForKey((Object)this.currentSortPath());
    }

    public boolean isCurrentColumnSortedAscending() {
        return this.isCurrentColumnSorted() ? SORT_ASCENDING.equals(this.currentColumnSortOrder().valueForKey(SORT_DIRECTION)) : false;
    }

    public int currentColumnSortIndex() {
        return this.isCurrentColumnSorted() ? this.sortOrders().indexOf((Object)this.currentColumnSortOrder()) + 1 : -1;
    }

    public Object columnValue() {
        if (this.currentKeyPath() == null || this.currentKeyPath().length() == 0) {
            return this.row();
        }
        Object rawValue = this.row().valueForKeyPath(this.currentKeyPath());
        Format formatter = this.columnFormatter();
        return formatter != null && rawValue != null ? formatter.format(rawValue) : rawValue;
    }

    public void setColumnValue(Object value) {
        if (this.currentKeyPath() == null || this.currentKeyPath().length() == 0) {
            return;
        }
        Format formatter = this.columnFormatter();
        if (formatter != null && value instanceof String) {
            try {
                value = formatter.parseObject((String)value);
            }
            catch (ParseException e) {
                throw new NSForwardException((Throwable)e);
            }
        }
        this.row().takeValueForKey(value, this.currentKeyPath());
    }

    public Format columnFormatter() {
        return (Format)this.formattersByKeypath().valueForKey(this.currentKeyPath());
    }

    public String currentKeyPath() {
        return (String)this.currentColumn().valueForKey(KEY_PATH);
    }

    public String currentSortPath() {
        return this.currentColumn().valueForKey(SORT_PATH) == null ? this.currentKeyPath() : (String)this.currentColumn().valueForKey(SORT_PATH);
    }

    public String columnComponentName() {
        String componentName = (String)this.currentColumn().valueForKey(COMPONENT_NAME);
        return componentName != null ? componentName : "WOString";
    }

    public boolean showRowSelector() {
        if (this.showRowSelector == null) {
            this.showRowSelector = Boolean.TRUE;
            if (this.configurationData().valueForKey(SHOW_ROW_SELECTOR) != null) {
                this.showRowSelector = Boolean.valueOf((String)this.configurationData().valueForKey(SHOW_ROW_SELECTOR));
            }
        }
        return this.showRowSelector;
    }

    public NSMutableArray selectedObjects() {
        if (this.selectedObjects == null) {
            this.selectedObjects = this.hasBinding(SELECTED_OBJECTS_BINDING) ? (NSMutableArray)this.valueForBinding(SELECTED_OBJECTS_BINDING) : new NSMutableArray();
        }
        return this.selectedObjects;
    }

    public void toggleRowSelection() {
        if (this.isRowSelected()) {
            this.selectedObjects().removeObject((Object)this.row);
        } else {
            this.selectedObjects().addObject((Object)this.row);
        }
    }

    public String toggleRowSelectionID() {
        return this.tableID() + "_ToggleRowSelection_" + this.rowID();
    }

    public boolean isRowSelected() {
        return this.selectedObjects().containsObject((Object)this.row);
    }

    public NSDictionary currentColumn() {
        return this.currentColumn;
    }

    public void setCurrentColumn(NSDictionary newColumn) {
        this.currentColumn = newColumn;
    }

    public NSKeyValueCodingAdditions row() {
        return this.row;
    }

    public void setRow(NSKeyValueCodingAdditions newRow) {
        this.row = newRow;
    }

    public int rowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int index) {
        this.rowIndex = index;
    }

    public AjaxGrid thisComponent() {
        return this;
    }

    public boolean checkHashCodes() {
        if (this.configurationData().objectForKey((Object)CHECK_HASH_CODES) == null) {
            this.configurationData().setObjectForKey((Object)Boolean.toString(ERXProperties.booleanForKeyWithDefault((String)CHECK_HASH_CODES, (boolean)ERXProperties.booleanForKey((String)(ERXWORepetition.class.getName() + ".checkHashCodes")))), (Object)CHECK_HASH_CODES);
        }
        return Boolean.parseBoolean((String)this.configurationData().objectForKey((Object)CHECK_HASH_CODES));
    }
}

