/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXWOContext;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.components._private.ERXWOForm;
import org.apache.log4j.Logger;

public class AjaxInPlace
extends WOComponent {
    public static final Logger log = Logger.getLogger(AjaxInPlace.class);
    private boolean _editing;
    private String _id;
    private boolean _changingToEdit;
    private boolean _changingToView;
    private boolean _alreadyInForm;

    public AjaxInPlace(WOContext context) {
        super(context);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public String elementName() {
        String elementName = (String)this.valueForBinding("elementName");
        if (elementName == null) {
            elementName = "div";
        }
        return elementName;
    }

    public String id() {
        if (this._id == null) {
            this._id = this.hasBinding("id") ? (String)this.valueForBinding("id") : ERXWOContext.safeIdentifierName((WOContext)this.context(), (boolean)false);
        }
        return this._id;
    }

    public WOActionResults invokeAction(WORequest aRequest, WOContext aContext) {
        this._alreadyInForm = this.context().isInForm();
        WOActionResults results = super.invokeAction(aRequest, aContext);
        this._id = null;
        return results;
    }

    public void takeValuesFromRequest(WORequest aRequest, WOContext aContext) {
        this._alreadyInForm = this.context().isInForm();
        super.takeValuesFromRequest(aRequest, aContext);
        this._id = null;
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        this._alreadyInForm = this.context().isInForm();
        super.appendToResponse(aResponse, aContext);
        this._id = null;
        this._changingToEdit = false;
        this._changingToView = false;
    }

    public String saveUpdateContainerID() {
        String saveUpdateContainerID = null;
        if (this.hasBinding("saveUpdateContainerID")) {
            saveUpdateContainerID = (String)this.valueForBinding("saveUpdateContainerID");
        }
        if (saveUpdateContainerID == null) {
            saveUpdateContainerID = this.id();
        }
        return saveUpdateContainerID;
    }

    public String cancelUpdateContainerID() {
        String cancelUpdateContainerID = null;
        if (this.hasBinding("cancelUpdateContainerID")) {
            cancelUpdateContainerID = (String)this.valueForBinding("cancelUpdateContainerID");
        }
        if (cancelUpdateContainerID == null) {
            cancelUpdateContainerID = this.id();
        }
        return cancelUpdateContainerID;
    }

    public String saveLabel() {
        String saveLabel = (String)this.valueForBinding("saveLabel");
        if (saveLabel == null) {
            saveLabel = "save";
        }
        return saveLabel;
    }

    public String formName() {
        String formName = null;
        if (this._alreadyInForm) {
            formName = ERXWOForm.formName((WOContext)this.context(), null);
            if (formName == null) {
                log.warn((Object)(this.id() + " is already inside of a form, but that form has no name, so AjaxInPlace can't work properly."));
                formName = "SetTheParentFormName";
            }
        } else {
            formName = this.id();
        }
        return formName;
    }

    public boolean button() {
        return AjaxUtils.booleanValueForBinding("button", true, (NSDictionary)this._keyAssociations, this.parent());
    }

    public boolean submitOnSave() {
        return AjaxUtils.booleanValueForBinding("submitOnSave", true, (NSDictionary)this._keyAssociations, this.parent());
    }

    public boolean linkOnSave() {
        return !this.submitOnSave();
    }

    public boolean disableForm() {
        return this._alreadyInForm || this.linkOnSave();
    }

    public String updateFunctionName() {
        return this.id() + "Update();";
    }

    public String editFunctionName() {
        return this.id() + "Edit";
    }

    public String editFunctionCall() {
        String editFunctionCall = null;
        if (!this.disabled()) {
            editFunctionCall = this.editFunctionName() + "()";
        }
        return editFunctionCall;
    }

    public String saveFunctionName() {
        return this.id() + "Save";
    }

    public String saveFunctionCall() {
        return this.saveFunctionName() + "()";
    }

    public String cancelFunctionName() {
        return this.id() + "Cancel";
    }

    public String cancelFunctionCall() {
        return this.cancelFunctionName() + "()";
    }

    public boolean manualControl() {
        boolean manualControl = false;
        if (this.hasBinding("manualControl")) {
            manualControl = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"manualControl");
        }
        return manualControl;
    }

    public boolean manualEditControl() {
        boolean manualEditControl = this.manualControl();
        if (!manualEditControl && this.hasBinding("manualEditControl")) {
            manualEditControl = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"manualEditControl");
        }
        if (this._alreadyInForm && this.editOnly()) {
            manualEditControl = true;
        }
        return manualEditControl;
    }

    public boolean manualViewControl() {
        boolean manualViewControl = this.manualControl();
        if (!manualViewControl && this.hasBinding("manualViewControl")) {
            manualViewControl = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"manualViewControl");
        }
        return manualViewControl;
    }

    public boolean disabled() {
        boolean disabled = false;
        if (this.hasBinding("disabled")) {
            disabled = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"disabled");
        }
        return disabled;
    }

    public boolean editOnly() {
        return ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"editOnly");
    }

    public boolean editing() {
        if (this.hasBinding("editing")) {
            this._editing = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"editing");
        }
        return !this.disabled() && (this._editing || this.editOnly());
    }

    public boolean canEdit() {
        return !this.hasBinding("canEdit") || ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"canEdit");
    }

    public boolean canSave() {
        return !this.hasBinding("canSave") || ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"canSave");
    }

    public boolean changingToEdit() {
        return this._changingToEdit;
    }

    public boolean changingToView() {
        return this._changingToView;
    }

    public void setEditing(boolean editing) {
        if (this.canSetValueForBinding("editing")) {
            this.setValueForBinding(editing, "editing");
            if (this.hasBinding("editing")) {
                editing = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"editing");
            }
        }
        if (this._editing != editing) {
            this._editing = editing;
            if (this._editing) {
                this._changingToEdit = true;
            } else {
                this._changingToView = true;
            }
        }
    }

    public String cleanupFunction() {
        return null;
    }

    public WOActionResults startEditing() {
        if (this.canEdit()) {
            this.setEditing(true);
            WOActionResults wOActionResults = (WOActionResults)this.valueForBinding("editAction");
        }
        return null;
    }

    public WOActionResults save() {
        WOActionResults results = null;
        boolean canSave = this.canSave();
        if (canSave) {
            if (this.hasBinding("saveAction")) {
                results = (WOActionResults)this.valueForBinding("saveAction");
                canSave = this.canSave();
            }
            if (canSave && !this.editOnly()) {
                this.setEditing(false);
            }
        }
        return results;
    }

    public WOActionResults cancel() {
        WOActionResults results = (WOActionResults)this.valueForBinding("cancelAction");
        if (!this.editOnly()) {
            this.setEditing(false);
        }
        return results;
    }
}

