/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxComponent;
import er.ajax.AjaxConstantOption;
import er.ajax.AjaxModalDialog;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxUtils;
import er.ajax.AjaxValue;
import er.extensions.appserver.ERXWOContext;

public class AjaxModalDialogOpener
extends AjaxComponent {
    public static void rejectOpen(WOContext context) {
        AjaxUtils.createResponse(context.request(), context).setStatus(409);
    }

    public AjaxModalDialogOpener(WOContext context) {
        super(context);
    }

    public boolean isStateless() {
        return true;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        if (!this.booleanValueForBinding("enabled", true)) {
            return;
        }
        String elementName = (String)this.valueForBinding("elementName", "a", context.component());
        response.appendContentString("<" + elementName + " ");
        if (elementName.equals("a")) {
            response.appendContentString("href=\"javascript:void(0)\"");
            this.appendTagAttributeToResponse(response, "title", this.valueForBinding("linkTitle", null));
        }
        this.appendTagAttributeToResponse(response, "id", this.id());
        this.appendTagAttributeToResponse(response, "class", this.valueForBinding("class", null));
        this.appendTagAttributeToResponse(response, "style", this.valueForBinding("style", null));
        response.appendContentString(" onclick=\"");
        response.appendContentString("new Ajax.Request('");
        response.appendContentString(AjaxUtils.ajaxComponentActionUrl(this.context()));
        response.appendContentString("', ");
        AjaxOptions.appendToResponse((NSDictionary)this.ajaxRequestOptions(), response, context);
        response.appendContentString("); ");
        response.appendContentString("return false;\" >");
        if (elementName.equals("a") && this.hasBinding("label")) {
            response.appendContentString((String)this.valueForBinding("label"));
        } else {
            super.appendToResponse(response, context);
        }
        response.appendContentString("</" + elementName + ">");
    }

    public String id() {
        return this.hasBinding("id") ? (String)this.valueForBinding("id") : ERXWOContext.safeIdentifierName((WOContext)this.context(), (boolean)false);
    }

    public String modalDialogId() {
        return (String)this.valueForBinding("dialogId");
    }

    protected void addRequiredWebResources(WOResponse res) {
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        if (this.booleanValueForBinding("enabled", true)) {
            this.valueForBinding("action");
        } else {
            AjaxModalDialogOpener.rejectOpen(context);
        }
        return null;
    }

    protected NSMutableDictionary ajaxRequestOptions() {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxConstantOption("asynchronous", Boolean.FALSE, AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxConstantOption("evalScripts", Boolean.FALSE, AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onFailure", AjaxOption.FUNCTION_1));
        StringBuilder sb = new StringBuilder(500);
        sb.append(AjaxModalDialog.openDialogFunctionName(this.modalDialogId()));
        sb.append("(");
        if (this.hasBinding("title")) {
            sb.append(AjaxValue.javaScriptEscaped(this.valueForBinding("title")));
        }
        sb.append(");");
        ajaxOptionsArray.addObject((Object)new AjaxConstantOption("onSuccess", sb.toString(), AjaxOption.FUNCTION_1));
        return AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, this);
    }
}

