/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import er.ajax.AjaxProgress;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXWOContext;
import er.extensions.components.ERXComponentUtilities;
import java.text.NumberFormat;

public class AjaxProgressBar
extends WOComponent {
    public static final String AJAX_PROGRESSES_KEY = "_ajaxProgresses";
    private String _id;
    private boolean _running;
    private AjaxProgress _progress;
    private boolean _completionEventsFired;
    private boolean _fireFinishedJavascriptEvents;
    private boolean _fireStartedJavascriptEvent;

    public AjaxProgressBar(WOContext context) {
        super(context);
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        super.appendToResponse(aResponse, aContext);
        AjaxUtils.addScriptResourceInHead(aContext, aResponse, "prototype.js");
        AjaxUtils.addScriptResourceInHead(aContext, aResponse, "effects.js");
        AjaxUtils.addScriptResourceInHead(aContext, aResponse, "wonder.js");
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public boolean fireStartedJavascriptEvent() {
        boolean fireStartedJavascriptEvent = this._fireStartedJavascriptEvent;
        if (fireStartedJavascriptEvent) {
            this._fireStartedJavascriptEvent = false;
        }
        return fireStartedJavascriptEvent;
    }

    public boolean fireFinishedJavascriptEvents() {
        boolean fireFinishedJavascriptEvents = this._fireFinishedJavascriptEvents;
        if (fireFinishedJavascriptEvents) {
            this._fireFinishedJavascriptEvents = false;
        }
        return fireFinishedJavascriptEvents;
    }

    public boolean progressBarVisible() {
        boolean visible = true;
        AjaxProgress progress = this.progress();
        if (!this.isStarted()) {
            if (this.hasBinding("visibleBeforeStart")) {
                visible = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"visibleBeforeStart");
            }
        } else if (this.done() && !this._fireFinishedJavascriptEvents && this.hasBinding("visibleAfterDone")) {
            visible = ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"visibleAfterDone");
        }
        return visible;
    }

    public String startingText() {
        String startingText = (String)this.valueForBinding("startingText");
        if (startingText == null) {
            startingText = "Starting ...";
        }
        return startingText;
    }

    public String cancelingText() {
        String cancelingText = (String)this.valueForBinding("cancelingText");
        if (cancelingText == null) {
            cancelingText = "Canceling ...";
        }
        return cancelingText;
    }

    public AjaxProgress progress() {
        if (this._progress != null && this._progress.shouldReset()) {
            this._progress = null;
            this.setValueForBinding(null, "progress");
        }
        if (this._progress == null) {
            this._progress = (AjaxProgress)this.valueForBinding("progress");
            if (this._progress != null && this._progress.shouldReset()) {
                this._progress = null;
                this.setValueForBinding(null, "progress");
            }
            if (this._progress == null) {
                this._progress = AjaxProgressBar.progress(this.session(), this.progressID());
                if (this._progress != null) {
                    if (this._progress.shouldReset()) {
                        AjaxProgressBar.unregisterProgress(this.session(), this._progress);
                        this._progress = null;
                    }
                    this.setValueForBinding(this._progress, "progress");
                }
            }
        }
        return this._progress;
    }

    public String progressID() {
        String progressID = (String)this.valueForBinding("progressID");
        if (progressID == null) {
            progressID = this.id();
        }
        return progressID;
    }

    public String id() {
        String id = this._id;
        if (id == null) {
            id = (String)this.valueForBinding("id");
            if (id == null) {
                id = ERXWOContext.safeIdentifierName((WOContext)this.context(), (boolean)true);
            }
            this._id = id;
        }
        return id;
    }

    public String finishedClass() {
        AjaxProgress progress;
        String percentage = this.percentage();
        String finishedClass = "0".equals(percentage) ? "percentageUnfinished" : ((progress = this.progress()) != null && progress.isDone() ? "percentageFinished done" : "percentageFinished");
        return finishedClass;
    }

    public Object displayValue() {
        Object displayValue = this.valueForBinding("displayValue");
        if (displayValue == null) {
            AjaxProgress progress = this.progress();
            displayValue = progress != null ? String.valueOf(progress.value()) : "";
        }
        return displayValue;
    }

    public Object displayMaximum() {
        Object displayMaximum = this.valueForBinding("displayMaximum");
        if (displayMaximum == null) {
            AjaxProgress progress = this.progress();
            displayMaximum = progress != null ? String.valueOf(progress.maximum()) : "";
        }
        return displayMaximum;
    }

    public String percentage() {
        double percentage;
        AjaxProgress progress = this.progress();
        String percentageStr = progress == null ? "0" : ((percentage = progress.percentage() * 100.0) < 5.0 ? "0" : NumberFormat.getIntegerInstance().format(percentage) + "%");
        return percentageStr;
    }

    public boolean isStarted() {
        boolean started = this.hasBinding("started") ? ERXComponentUtilities.booleanValueForBinding((WOComponent)this, (String)"started") : this.progress() != null || this._running;
        return started;
    }

    public String cancelText() {
        String cancelText = (String)this.valueForBinding("cancelText");
        if (cancelText == null) {
            cancelText = "cancel";
        }
        return cancelText;
    }

    public String progressOfText() {
        String progressOfText = (String)this.valueForBinding("progressOfText");
        if (progressOfText == null) {
            progressOfText = "of";
        }
        return progressOfText;
    }

    public String onChange() {
        return this.id() + "AjaxProgress.start()";
    }

    protected void _checkForCompletion() {
        AjaxProgress progress = this.progress();
        if (progress != null && progress.isDone() && !progress.completionEventsFired()) {
            if (progress.isCanceled()) {
                this.progressCanceled();
            } else if (progress.isFailed()) {
                this.progressFailed();
            } else if (progress.isSucceeded()) {
                this.progressSucceeded();
            }
            progress.setCompletionEventsFired(true);
            this._fireFinishedJavascriptEvents = true;
        }
    }

    public boolean done() {
        boolean done = false;
        AjaxProgress progress = this.progress();
        if (progress != null) {
            done = progress.isDone() && progress.completionEventsFired();
        }
        return done;
    }

    public String refreshTime() {
        Object refreshTime = this.valueForBinding("refreshTime");
        String refreshTimeStr = refreshTime == null ? "1000" : refreshTime.toString();
        return refreshTimeStr;
    }

    public WOActionResults refreshing() {
        if (!this._running) {
            this._fireStartedJavascriptEvent = true;
        }
        this._running = true;
        this._checkForCompletion();
        return null;
    }

    public WOActionResults cancel() {
        AjaxProgress progress = this.progress();
        if (progress != null) {
            progress.cancel();
        }
        return null;
    }

    protected void finished() {
        if (this._progress != null) {
            AjaxProgressBar.unregisterProgress(this.session(), this._progress);
        }
        this._running = false;
        this.valueForBinding("finishedAction");
    }

    protected void progressCanceled() {
        this.finished();
        this.valueForBinding("canceledAction");
    }

    protected void progressSucceeded() {
        AjaxProgress progress = this.progress();
        this.finished();
        this.valueForBinding("succeededAction");
    }

    protected void progressFailed() {
        this.finished();
        this.valueForBinding("failedAction");
    }

    public static void registerProgress(WOSession session, AjaxProgress progress) {
        AjaxProgress.registerProgress(session, progress);
    }

    public static void unregisterProgress(WOSession session, AjaxProgress progress) {
        AjaxProgress.unregisterProgress(session, progress);
    }

    public static AjaxProgress progress(WOSession session, String id) {
        return AjaxProgress.progress(session, id);
    }
}

