/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxComponent;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUtils;
import er.ajax.json.JSONBridge;
import er.extensions.appserver.ERXResponseRewriter;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.jabsorb.JSONRPCBridge;
import org.json.JSONObject;

public class AjaxProxy
extends AjaxComponent {
    private static final Logger log = Logger.getLogger(AjaxProxy.class);

    public AjaxProxy(WOContext context) {
        super(context);
    }

    public boolean isStateless() {
        return true;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    protected void addRequiredWebResources(WOResponse res) {
        this.addScriptResourceInHead(res, "jsonrpc.js");
        NSMutableDictionary userInfo = AjaxUtils.mutableUserInfo((WOMessage)this.context().response());
        String name = (String)this.valueForBinding("name");
        String key = "JSONRPC_" + name;
        Object oldValue = userInfo.objectForKey((Object)key);
        Object bridge = this.valueForBinding("JSONRPCBridge");
        if (bridge == null) {
            bridge = NSKeyValueCoding.NullValue;
        }
        if (oldValue == null) {
            userInfo.setObjectForKey(bridge, (Object)key);
            ERXResponseRewriter.addScriptCodeInHead((WOResponse)res, (WOContext)this.context(), (String)(name + " = new JSONRpcClient(\"" + AjaxUtils.ajaxComponentActionUrl(this.context()) + "\");"), (String)key);
        } else if (bridge != oldValue) {
            log.warn((Object)("JSONRPCProxy detected a conflict.  You defined the javascript variable '" + name + "'  multiple times, and linked to differents proxy objects: <" + bridge + "> and <" + oldValue + ">"));
        }
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        AjaxResponse response = AjaxUtils.createResponse(request, context);
        String inputString = request.contentString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("AjaxProxy.handleRequest: input = " + inputString));
        }
        JSONObject input = null;
        String output = null;
        try {
            input = new JSONObject(inputString);
            Object proxy = this.canGetValueForBinding("proxy") ? this.valueForBinding("proxy") : this.parent();
            String proxyName = (String)this.valueForBinding("proxyName");
            JSONRPCBridge bridge = null;
            if (this.canGetValueForBinding("AjaxBridge")) {
                bridge = (JSONRPCBridge)this.valueForBinding("AjaxBridge");
            } else {
                bridge = JSONBridge.createBridge();
                if (this.canSetValueForBinding("AjaxBridge")) {
                    this.setValueForBinding(bridge, "AjaxBridge");
                }
            }
            bridge.registerObject(proxyName, proxy);
            output = bridge.call(new Object[]{request, context, response, proxy}, input);
        }
        catch (NoSuchElementException e) {
            log.error((Object)"No method in request");
            output = "method not found (session may have timed out)";
        }
        catch (Exception e) {
            log.error((Object)"Exception", (Throwable)e);
            output = "method not found (session may have timed out)";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("AjaxProxy.handleRequest: output = " + output));
        }
        response.appendContentString(output.toString());
        return response;
    }
}

