/*
 * Decompiled with CFR 0.152.
 */
package er.ajax;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.ajax.AjaxDynamicElement;
import er.ajax.AjaxOption;
import er.ajax.AjaxOptions;
import er.ajax.AjaxResponse;
import er.ajax.AjaxUpdateContainer;
import er.ajax.AjaxUtils;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.foundation.ERXMutableURL;
import er.extensions.foundation.ERXStringUtilities;
import java.net.MalformedURLException;

public class AjaxUpdateLink
extends AjaxDynamicElement {
    public AjaxUpdateLink(String name, NSDictionary associations, WOElement children) {
        super(name, associations, children);
    }

    public String onClick(WOContext context, boolean generateFunctionWrapper) {
        WOComponent component = context.component();
        NSMutableDictionary options = this.createAjaxOptions(component);
        StringBuffer onClickBuffer = new StringBuffer();
        String onClick = (String)this.valueForBinding("onClick", component);
        String onClickBefore = (String)this.valueForBinding("onClickBefore", component);
        String updateContainerID = AjaxUpdateContainer.updateContainerID(this, component);
        String functionName = (String)this.valueForBinding("functionName", component);
        String function = (String)this.valueForBinding("function", component);
        String replaceID = (String)this.valueForBinding("replaceID", component);
        AjaxUpdateLink.addEffect(options, (String)this.valueForBinding("effect", component), updateContainerID, (String)this.valueForBinding("effectDuration", component));
        String afterEffectID = (String)this.valueForBinding("afterEffectID", component);
        if (afterEffectID == null && (afterEffectID = AjaxUpdateContainer.currentUpdateContainerID()) == null) {
            afterEffectID = updateContainerID;
        }
        AjaxUpdateLink.addEffect(options, (String)this.valueForBinding("afterEffect", component), afterEffectID, (String)this.valueForBinding("afterEffectDuration", component));
        String beforeEffect = (String)this.valueForBinding("beforeEffect", component);
        WOAssociation directActionNameAssociation = (WOAssociation)this.associations().valueForKey("directActionName");
        if (beforeEffect == null && updateContainerID != null && directActionNameAssociation == null && replaceID == null && function == null && onClick == null && onClickBefore == null) {
            NSDictionary nonDefaultOptions = AjaxUpdateContainer.removeDefaultOptions((NSDictionary)options);
            onClickBuffer.append("AUL.");
            if (generateFunctionWrapper) {
                onClickBuffer.append("updateFunc");
            } else {
                onClickBuffer.append("update");
            }
            onClickBuffer.append("('");
            onClickBuffer.append(updateContainerID);
            onClickBuffer.append("', ");
            AjaxOptions.appendToBuffer(nonDefaultOptions, onClickBuffer, context);
            onClickBuffer.append(", '");
            onClickBuffer.append(context.contextID());
            onClickBuffer.append('.');
            onClickBuffer.append(context.elementID());
            onClickBuffer.append("'");
            onClickBuffer.append(")");
            onClickBuffer.append(";");
        } else {
            if (generateFunctionWrapper) {
                onClickBuffer.append("function(additionalParams) {");
            }
            if (onClickBefore != null) {
                onClickBuffer.append("if (");
                onClickBuffer.append(onClickBefore);
                onClickBuffer.append(") {");
            }
            if (beforeEffect != null) {
                onClickBuffer.append("new ");
                onClickBuffer.append(AjaxUpdateLink.fullEffectName(beforeEffect));
                onClickBuffer.append("('");
                String beforeEffectID = (String)this.valueForBinding("beforeEffectID", component);
                if (beforeEffectID == null && (beforeEffectID = AjaxUpdateContainer.currentUpdateContainerID()) == null) {
                    beforeEffectID = updateContainerID;
                }
                onClickBuffer.append(beforeEffectID);
                onClickBuffer.append("', { ");
                String beforeEffectDuration = (String)this.valueForBinding("beforeEffectDuration", component);
                if (beforeEffectDuration != null) {
                    onClickBuffer.append("duration: ");
                    onClickBuffer.append(beforeEffectDuration);
                    onClickBuffer.append(", ");
                }
                onClickBuffer.append("queue:'end', afterFinish: function() {");
            }
            String actionUrl = null;
            actionUrl = directActionNameAssociation != null ? context._directActionURL((String)directActionNameAssociation.valueInComponent(component), (NSDictionary)ERXComponentUtilities.queryParametersInComponent((NSDictionary)this.associations(), (WOComponent)component), ERXRequest.isRequestSecure((WORequest)context.request())).replaceAll("&amp;", "&") : AjaxUtils.ajaxComponentActionUrl(context);
            if (replaceID != null) {
                try {
                    ERXMutableURL tempActionUrl = new ERXMutableURL(actionUrl);
                    tempActionUrl.addQueryParameter("_r", "true");
                    actionUrl = tempActionUrl.toExternalForm();
                }
                catch (MalformedURLException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            }
            actionUrl = "'" + actionUrl + "'";
            if (functionName != null) {
                actionUrl = actionUrl + ".addQueryParameters(additionalParams)";
            }
            if (function != null) {
                onClickBuffer.append("return " + function + "(" + actionUrl + ")");
            } else if (replaceID == null) {
                if (updateContainerID == null) {
                    onClickBuffer.append("new Ajax.Request(" + actionUrl + ", ");
                    AjaxOptions.appendToBuffer((NSDictionary)options, onClickBuffer, context);
                    onClickBuffer.append(")");
                } else {
                    onClickBuffer.append("new Ajax.Updater('" + updateContainerID + "', " + actionUrl + ", ");
                    AjaxOptions.appendToBuffer((NSDictionary)options, onClickBuffer, context);
                    onClickBuffer.append(")");
                }
            } else {
                onClickBuffer.append("new Ajax.Updater('" + replaceID + "', " + actionUrl + ", ");
                AjaxOptions.appendToBuffer((NSDictionary)options, onClickBuffer, context);
                onClickBuffer.append(")");
            }
            if (onClick != null) {
                onClickBuffer.append(";");
                onClickBuffer.append(onClick);
            }
            if (beforeEffect != null) {
                onClickBuffer.append("}});");
            }
            if (onClickBefore != null) {
                onClickBuffer.append("}");
            }
            if (generateFunctionWrapper) {
                onClickBuffer.append("}");
            }
        }
        return onClickBuffer.toString();
    }

    public static void addEffect(NSMutableDictionary options, String effect, String updateContainerID, String duration) {
        if (effect != null) {
            if (options.objectForKey((Object)"onSuccess") != null) {
                throw new WODynamicElementCreationException("You cannot specify both an effect and a custom onSuccess function.");
            }
            if (updateContainerID == null) {
                throw new WODynamicElementCreationException("You cannot specify an effect without an updateContainerID.");
            }
            StringBuffer effectBuffer = new StringBuffer();
            effectBuffer.append("function() { new " + AjaxUpdateLink.fullEffectName(effect) + "('" + updateContainerID + "', {  queue:'end'");
            if (duration != null) {
                effectBuffer.append(", duration: ");
                effectBuffer.append(duration);
            }
            effectBuffer.append("}) }");
            options.setObjectForKey((Object)effectBuffer.toString(), (Object)"onSuccess");
        }
    }

    public static String fullEffectName(String effectName) {
        String fullEffectName = effectName == null ? null : (effectName.indexOf(46) == -1 ? "Effect." + ERXStringUtilities.capitalize((String)effectName) : effectName);
        return fullEffectName;
    }

    protected NSMutableDictionary createAjaxOptions(WOComponent component) {
        NSMutableArray ajaxOptionsArray = new NSMutableArray();
        ajaxOptionsArray.addObject((Object)new AjaxOption("onLoading", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onComplete", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onSuccess", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onFailure", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("onException", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("evalScripts", AjaxOption.BOOLEAN));
        ajaxOptionsArray.addObject((Object)new AjaxOption("insertion", AjaxOption.SCRIPT));
        ajaxOptionsArray.addObject((Object)new AjaxOption("asynchronous", AjaxOption.BOOLEAN));
        NSMutableDictionary<String, String> options = AjaxOption.createAjaxOptionsDictionary((NSArray<AjaxOption>)ajaxOptionsArray, component, (NSDictionary<String, ? extends WOAssociation>)this.associations());
        options.setObjectForKey((Object)"'get'", (Object)"method");
        if (options.objectForKey((Object)"asynchronous") == null) {
            options.setObjectForKey((Object)"true", (Object)"asynchronous");
        }
        if (options.objectForKey((Object)"evalScripts") == null) {
            options.setObjectForKey((Object)"true", (Object)"evalScripts");
        }
        AjaxUpdateContainer.expandInsertionFromOptions(options, this, component);
        return options;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        WOComponent component = context.component();
        boolean disabled = this.booleanValueForBinding("disabled", false, component);
        Object stringValue = this.valueForBinding("string", component);
        String functionName = (String)this.valueForBinding("functionName", component);
        if (functionName == null) {
            boolean renderTags;
            boolean button = this.booleanValueForBinding("button", false, component);
            String elementName = button ? "input" : (String)this.valueForBinding("elementName", "a", component);
            boolean isATag = "a".equalsIgnoreCase(elementName);
            boolean bl = renderTags = !disabled || !isATag;
            if (renderTags) {
                response.appendContentString("<");
                response.appendContentString(elementName);
                response.appendContentString(" ");
                if (button) {
                    this.appendTagAttributeToResponse(response, "type", "button");
                }
                if (isATag) {
                    this.appendTagAttributeToResponse(response, "href", "javascript:void(0);");
                }
                this.appendTagAttributeToResponse(response, "onclick", this.onClick(context, false));
                this.appendTagAttributeToResponse(response, "title", this.valueForBinding("title", component));
                this.appendTagAttributeToResponse(response, "value", this.valueForBinding("value", component));
                this.appendTagAttributeToResponse(response, "class", this.valueForBinding("class", component));
                this.appendTagAttributeToResponse(response, "style", this.valueForBinding("style", component));
                this.appendTagAttributeToResponse(response, "id", this.valueForBinding("id", component));
                this.appendTagAttributeToResponse(response, "accesskey", this.valueForBinding("accesskey", component));
                if (button) {
                    if (stringValue != null) {
                        this.appendTagAttributeToResponse(response, "value", stringValue);
                    }
                    if (disabled) {
                        response.appendContentString(" disabled");
                    }
                }
                response.appendContentString(">");
            }
            if (stringValue != null && !button) {
                response.appendContentHTMLString(stringValue.toString());
            }
            this.appendChildrenToResponse(response, context);
            if (renderTags) {
                response.appendContentString("</");
                response.appendContentString(elementName);
                response.appendContentString(">");
            }
        } else {
            AjaxUtils.appendScriptHeader(response);
            response.appendContentString(functionName);
            response.appendContentString(" = ");
            response.appendContentString(this.onClick(context, true));
            AjaxUtils.appendScriptFooter(response);
        }
        super.appendToResponse(response, context);
    }

    protected void addRequiredWebResources(WOResponse res, WOContext context) {
        this.addScriptResourceInHead(context, res, "prototype.js");
        this.addScriptResourceInHead(context, res, "effects.js");
        this.addScriptResourceInHead(context, res, "wonder.js");
    }

    public WOActionResults handleRequest(WORequest request, WOContext context) {
        WOComponent component = context.component();
        String updateContainerID = AjaxUpdateContainer.updateContainerID(this, component);
        AjaxUpdateContainer.setUpdateContainerID(request, updateContainerID);
        Object results = (WOActionResults)this.valueForBinding("action", component);
        if (ERXAjaxApplication.isAjaxReplacement((WORequest)request)) {
            AjaxUtils.setPageReplacementCacheKey(context, (String)this.valueForBinding("replaceID", component));
        } else if (results == null || this.booleanValueForBinding("ignoreActionResponse", false, component)) {
            String script = (String)this.valueForBinding("onClickServer", component);
            if (script != null) {
                AjaxResponse response = AjaxUtils.createResponse(request, context);
                AjaxUtils.appendScriptHeaderIfNecessary(request, (WOResponse)response);
                response.appendContentString(script);
                AjaxUtils.appendScriptFooterIfNecessary(request, (WOResponse)response);
                results = response;
            }
        } else if (updateContainerID != null) {
            AjaxUtils.setPageReplacementCacheKey(context, updateContainerID);
        }
        return results;
    }
}

