/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.grouping.DRCriteria;
import er.grouping.DRMasterCriteria;
import er.grouping.DRRecord;
import er.grouping.DRRecordGroup;
import er.grouping.DRReportModel;
import java.util.Enumeration;

public class DRGroup {
    protected DRReportModel _reportModel;
    protected DRMasterCriteria _masterCriteria;
    protected NSArray _masterCriteriaDrillDownList;
    protected NSMutableDictionary _recordGroupDict;
    protected NSArray _ordering;
    protected NSArray _sortedArray;
    protected NSArray _sortedArrayBase;
    protected boolean _useGroupTotal;
    private String _keyDesc = null;

    public void resetDefaults() {
    }

    public NSMutableDictionary childrenFromGroupCriteriaList() {
        NSArray crits = this._masterCriteria.criteriaLookupDict().allValues();
        Enumeration anEnum = crits.objectEnumerator();
        NSMutableDictionary recGrpDict = new NSMutableDictionary();
        while (anEnum.hasMoreElements()) {
            DRCriteria crit = (DRCriteria)anEnum.nextElement();
            DRRecordGroup recGrp = DRRecordGroup.withCriteriaGroupParent(crit, this, null);
            recGrpDict.setObjectForKey((Object)recGrp, (Object)crit.keyDesc());
        }
        return recGrpDict;
    }

    public NSMutableDictionary groupBy(NSArray recs, DRMasterCriteria amc) {
        Enumeration anEnum = recs.objectEnumerator();
        NSMutableDictionary recGrpDict = amc.isPreset() ? this.childrenFromGroupCriteriaList() : new NSMutableDictionary();
        while (anEnum.hasMoreElements()) {
            DRRecord rec = (DRRecord)anEnum.nextElement();
            amc.groupRecordRecordGroupsDictGroupParent(rec, recGrpDict, this, null);
        }
        return recGrpDict;
    }

    public static NSArray drillDownListForMasterCriteriaList(DRMasterCriteria mc, NSArray mcList) {
        NSMutableArray arr = new NSMutableArray();
        int mcCount = mcList.count();
        int startIndex = mcList.indexOfObject((Object)mc);
        for (int i = 0; i < mcCount; ++i) {
            int atIndex = i + startIndex;
            if (atIndex == mcCount) {
                atIndex = 0;
                startIndex = -1;
            }
            DRMasterCriteria aMc = (DRMasterCriteria)mcList.objectAtIndex(atIndex);
            arr.addObject((Object)aMc);
        }
        return arr;
    }

    public static DRGroup withReportModelMasterCriteria(DRReportModel aMod, DRMasterCriteria amc) {
        DRGroup grp = new DRGroup(aMod, amc);
        return grp;
    }

    public DRGroup(DRReportModel aMod, DRMasterCriteria amc) {
        this._reportModel = aMod;
        this._masterCriteria = amc;
        this._useGroupTotal = this._masterCriteria.shouldTotal();
        this.resetDefaults();
        this._recordGroupDict = this.groupBy(this._reportModel.records(), this._masterCriteria);
        this._masterCriteriaDrillDownList = DRGroup.drillDownListForMasterCriteriaList(this._masterCriteria, this._reportModel.criteriaList());
        this._ordering = new NSArray((Object)new EOSortOrdering("score", EOSortOrdering.CompareAscending));
    }

    public NSArray recordGroupList() {
        return this._recordGroupDict.allValues();
    }

    public NSDictionary recordGroupDict() {
        return this._recordGroupDict;
    }

    public DRReportModel reportModel() {
        return this._reportModel;
    }

    public NSArray criteriaList() {
        return this._masterCriteria.criteriaLookupDict().allValues();
    }

    public DRMasterCriteria masterCriteria() {
        return this._masterCriteria;
    }

    public NSArray masterCriteriaDrillDownList() {
        return this._masterCriteriaDrillDownList;
    }

    public void groupSubRecordGroupsWithMasterCriteriaLookupDict(NSDictionary groupLookUpDict) {
        Enumeration anEnum = this.recordGroupList().objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRRecordGroup recGrp = (DRRecordGroup)anEnum.nextElement();
            NSMutableArray arr = new NSMutableArray(this.masterCriteriaDrillDownList());
            arr.removeObjectAtIndex(0);
            recGrp.groupSubRecordGroupGroupLookUpDict((NSArray)arr, groupLookUpDict);
        }
    }

    public NSArray sortedCriteriaList() {
        if (this._sortedArray == null) {
            this._sortedArrayBase = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)this.criteriaList(), (NSArray)this._ordering);
            NSMutableArray sortedArray2 = new NSMutableArray(this._sortedArrayBase);
            sortedArray2.addObject((Object)DRCriteria.asTotalWithMasterCriteria(this._masterCriteria));
            this._sortedArray = new NSArray((NSArray)sortedArray2);
        }
        if (this._useGroupTotal) {
            return this._sortedArray;
        }
        return this._sortedArrayBase;
    }

    public NSArray sortedCriteriaListBase() {
        this.sortedCriteriaList();
        return this._sortedArrayBase;
    }

    public boolean useGroupTotal() {
        return this._useGroupTotal;
    }

    public void setUseGroupTotal(boolean v) {
        this._useGroupTotal = v;
    }

    public String keyDesc() {
        if (this._keyDesc == null) {
            this._keyDesc = super.toString();
        }
        return this._keyDesc;
    }

    public String toString() {
        return "<DRGroup masterCriteria: " + this.masterCriteria() + "; >";
    }
}

