/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSTimestamp;
import org.apache.log4j.Logger;

public class DRValueConverter {
    protected static final Logger log = Logger.getLogger(DRValueConverter.class);
    private static DRValueConverter _converter = new DRValueConverter();

    public NSTimestamp timestampForValue(Object v) {
        if (v instanceof NSTimestamp) {
            return (NSTimestamp)v;
        }
        return null;
    }

    public double doubleForValue(Object v) {
        double scr = 0.0;
        if (v == null) {
            return 0.0;
        }
        if (v instanceof String) {
            try {
                scr = new Double((String)v);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Not a number: " + v));
                scr = 0.0;
            }
        } else if (v instanceof Number) {
            Number vv = (Number)v;
            scr = vv.doubleValue();
        } else if (v instanceof NSTimestamp) {
            NSTimestamp vv = (NSTimestamp)v;
            scr = (double)vv.getTime() / 1000.0;
        } else if (v == NSKeyValueCoding.NullValue) {
            scr = 0.0;
        } else {
            try {
                scr = new Double(v.toString());
            }
            catch (NumberFormatException ex) {
                log.error((Object)("Not a number: " + v));
                scr = 0.0;
            }
        }
        return scr;
    }

    public Number numberForValue(Object v) {
        double vv = this.doubleForValue(v);
        Double scr = new Double(vv);
        return scr;
    }

    public static DRValueConverter converter() {
        return _converter;
    }

    public static void setConverter(DRValueConverter value) {
        _converter = value;
    }
}

