/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.grouping.DRAttribute;
import er.grouping.DRRecord;
import er.grouping.DRValue;
import java.util.Enumeration;

public class DRValueGroup
extends DRValue {
    protected boolean _hasTotaled;
    protected double _total;
    protected NSMutableArray _flatValues;
    protected NSMutableArray _values;
    protected boolean _showTotal;

    public DRValueGroup() {
    }

    public static DRValue withRecordAttribute(DRRecord rec, DRAttribute att) {
        DRValueGroup aVal = new DRValueGroup(rec, att);
        return aVal;
    }

    public boolean showTotal() {
        return this._showTotal;
    }

    public DRValueGroup(DRRecord rec, DRAttribute att) {
        this._isGroup = true;
        this._hasTotaled = false;
        this._total = 0.0;
        if (att.showTotal()) {
            this._showTotal = true;
        }
        this._values = new NSMutableArray();
        this._flatValues = new NSMutableArray();
        this._record = rec;
        this._attribute = att;
        this.buildSubValues();
    }

    private void buildSubValues() {
        NSMutableArray attrs = this.attribute().attributes();
        Enumeration anEnum = attrs.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRValue val;
            DRAttribute att = (DRAttribute)anEnum.nextElement();
            if (att.isGroup()) {
                val = DRValueGroup.withRecordAttribute(this.record(), att);
                NSArray vals = val.flatValues();
                this._flatValues.addObjectsFromArray(vals);
            } else {
                val = DRValue.withRecordAttribute(this.record(), att);
                this._flatValues.addObject((Object)val);
            }
            double subtot = val.total();
            this._total += subtot;
            this._values.addObject((Object)val);
        }
        if (this.attribute().shouldTotal()) {
            this._flatValues.addObject((Object)DRValue.withTotalAttribute(this._total, this.attribute()));
        }
    }

    public NSArray flatValues() {
        return this._flatValues;
    }

    public boolean isGroup() {
        return this._isGroup;
    }

    public double total() {
        return this._total;
    }
}

