/*
 * Decompiled with CFR 0.152.
 */
package er.changenotification;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import er.changenotification.ERCNConfigurationV1;
import er.changenotification.ERCNConfigurationV2;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ERCNConfiguration {
    public static final String PROPERTY_PREFIX = "er.changenotification";
    public static final long DEFAULT_CONNECTION_RECOVERY_INTERVAL = 15L;
    public static final long DEFAULT_DISCONNECTION_WARNING_INTERVAL = 3600L;
    private NSArray _entitiesNotToSynchronize;
    private NSArray _changeTypesToPublish;
    private NSArray _changeTypesToSubscribe;
    private String _topicName;
    private boolean _isSubscriberDurable;
    private String _initialContextFactory;
    private String _providerURL;
    private long _connectionRecoveryInterval = 15L;
    private long _disconnectionWarningInterval = 3600L;

    public static ERCNConfiguration getInstance() {
        return ERCNConfiguration.getInstance(System.getProperties());
    }

    public static ERCNConfiguration getInstance(Properties props) {
        ERCNConfiguration configuration = null;
        String versionString = props.getProperty("er.changenotification.confVersion", "c1.0");
        Version configVersion = new Version(versionString);
        if (configVersion.majorVersion() == 1) {
            configuration = new ERCNConfigurationV1(props);
        } else if (configVersion.majorVersion() == 2) {
            configuration = new ERCNConfigurationV2(props);
        } else {
            throw new RuntimeException("ERChangeNotification: Invalid configuration version: " + versionString);
        }
        return configuration;
    }

    public NSArray entitiesNotToSynchronize() {
        return this._entitiesNotToSynchronize;
    }

    public NSArray changeTypesToPublish() {
        return this._changeTypesToPublish;
    }

    public NSArray changeTypesToSubscrive() {
        return this._changeTypesToSubscribe;
    }

    public String topicName() {
        return this._topicName;
    }

    public boolean isSubscriberDurable() {
        return this._isSubscriberDurable;
    }

    public String initialContextFactory() {
        return this._initialContextFactory;
    }

    public String providerURL() {
        return this._providerURL;
    }

    public long connectionRecoveryInterval() {
        return this._connectionRecoveryInterval;
    }

    public long disconnectionWarningInterval() {
        return this._disconnectionWarningInterval;
    }

    public Properties jmsProperties() {
        Properties properties = new Properties();
        properties.put("java.naming.provider.url", this._providerURL);
        properties.put("java.naming.factory.initial", this._initialContextFactory);
        return properties;
    }

    void setEntitiesNotToSynchronize(NSArray entities) {
        this._entitiesNotToSynchronize = entities != null ? entities : NSArray.EmptyArray;
    }

    void setChangeTypesToPublish(NSArray changeTypes) {
        this._changeTypesToPublish = changeTypes != null ? changeTypes : NSArray.EmptyArray;
    }

    void setChangeTypesToSubscribe(NSArray changeTypes) {
        this._changeTypesToSubscribe = changeTypes != null ? changeTypes : NSArray.EmptyArray;
    }

    void setTopicName(String topicName) {
        this._topicName = topicName;
    }

    void setIsSubscriberDurable(boolean isDurable) {
        this._isSubscriberDurable = isDurable;
    }

    void setInitialContextFactory(String initialContextFactory) {
        this._initialContextFactory = initialContextFactory;
    }

    void setProviderURL(String providerURL) {
        this._providerURL = providerURL;
    }

    void setConnectionRecoveryInterval(long interval) {
        this._connectionRecoveryInterval = interval;
    }

    void setConnectionRecoveryInterval(String intervalSting) {
        long interval = 15L;
        if (intervalSting != null) {
            try {
                interval = Long.parseLong(intervalSting);
            }
            catch (NumberFormatException ex) {
                NSLog.err.appendln((Object)"ERChangeNotification: Invalid number format for connection recovery interval.");
            }
            this.setConnectionRecoveryInterval(interval);
        }
    }

    void setDisconnectionWarningInterval(long interval) {
        this._disconnectionWarningInterval = interval;
    }

    void setDisconnectionWarningInterval(String intervalString) {
        long interval = 3600L;
        if (intervalString != null) {
            try {
                interval = Long.parseLong(intervalString);
            }
            catch (NumberFormatException ex) {
                NSLog.err.appendln((Object)"ERChangeNotification: Invalid number format for connection recovery interval.");
            }
            this.setDisconnectionWarningInterval(interval);
        }
    }

    public static class Version {
        private static final Pattern _versionPattern = Pattern.compile("^c([0-9]+)\\.([.0-9]*)$");
        private final int _majorVersion;
        private final String _minorVersionString;

        public Version(String configurationVasionString) {
            Matcher versionMatcher = _versionPattern.matcher(configurationVasionString);
            if (versionMatcher.find()) {
                this._majorVersion = Integer.parseInt(versionMatcher.group(1));
                this._minorVersionString = versionMatcher.group(2);
            } else {
                this._majorVersion = 1;
                this._minorVersionString = "0";
            }
        }

        public int majorVersion() {
            return this._majorVersion;
        }

        public String minorVersionString() {
            return this._minorVersionString;
        }

        public String toString() {
            return this._majorVersion + "." + this._minorVersionString;
        }
    }
}

