/*
 * Decompiled with CFR 0.152.
 */
package er.changenotification;

import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import er.changenotification.ERCNNotificationCoordinator;
import er.changenotification.ERCNSnapshot;
import er.changenotification.ERCNSubscriberDelegate;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

class ERCNSubscriber
implements MessageListener {
    private static ERCNSubscriberDelegate _delegate;
    private ERCNNotificationCoordinator _coordinator;
    private TopicSession _topicSession;
    private TopicSubscriber _topicSubscriber;

    ERCNSubscriber(ERCNNotificationCoordinator coordinator) {
        this._coordinator = coordinator;
    }

    static ERCNSubscriberDelegate delegate() {
        return _delegate;
    }

    static void setDelegate(ERCNSubscriberDelegate delegate) {
        _delegate = delegate;
    }

    void subscribe(TopicConnection connection) {
        try {
            this._topicSession = connection.createTopicSession(false, 2);
        }
        catch (JMSException ex) {
            NSLog.err.appendln((Object)("ERChangeNotification: Failed to create a JMS topic session: " + ex.getMessage()));
            return;
        }
        String selector = null;
        boolean noLocal = true;
        try {
            this._topicSubscriber = this._coordinator.configuration().isSubscriberDurable() ? this._topicSession.createDurableSubscriber(this._coordinator.topic(), this._coordinator.id(), selector, true) : this._topicSession.createSubscriber(this._coordinator.topic(), selector, true);
        }
        catch (Exception ex) {
            NSLog.err.appendln((Object)("ERChangeNotification: An exception occured: " + ex.getMessage()));
        }
        try {
            this._topicSubscriber.setMessageListener((MessageListener)this);
        }
        catch (JMSException ex) {
            NSLog.err.appendln((Object)("ERChangeNotification: An exception occured: " + ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            ERCNSnapshot snapshot = (ERCNSnapshot)((ObjectMessage)message).getObject();
            if (NSLog.debug.isEnabled()) {
                NSLog.debug.appendln((Object)("ERChangeNotification: Received a message with snapshot: " + snapshot));
            }
            if (ERCNSnapshot.shouldApplyChangeFor("inserted")) {
                this._processInsertions(snapshot);
            }
            if (ERCNSnapshot.shouldApplyChangeFor("deleted")) {
                this._processDeletions(snapshot);
            }
            if (ERCNSnapshot.shouldApplyChangeFor("updated")) {
                this._processUpdates(snapshot);
            }
            NSLog.debug.appendln((Object)"ERChangeNotification: Finished processing changes.");
        }
        catch (JMSException ex) {
            NSLog.err.appendln((Object)("ERChangeNotification: An exception occured: " + ex.getMessage()));
        }
        finally {
            try {
                message.acknowledge();
            }
            catch (JMSException ex) {
                NSLog.err.appendln((Object)("ERChangeNotification: An exception occured: " + ex.getMessage()));
            }
        }
    }

    void unsubscribe() {
        try {
            if (this._coordinator.configuration().isSubscriberDurable()) {
                this._topicSession.unsubscribe(this._coordinator.id());
            }
        }
        catch (JMSException ex) {
            NSLog.err.appendln((Object)("ERChangeNotification: An exception occured: " + ex.getMessage()));
        }
        this._topicSession = null;
    }

    private void _processInsertions(ERCNSnapshot ercnSnapshot) {
        if (_delegate != null) {
            _delegate.processInsertions(ercnSnapshot);
        }
    }

    private void _processDeletions(ERCNSnapshot ercnSnapshot) {
        if (_delegate != null) {
            _delegate.processDeletions(ercnSnapshot);
        }
    }

    private void _processUpdates(ERCNSnapshot ercnSnapshot) {
        boolean isProcessed;
        if (_delegate != null && (isProcessed = _delegate.processUpdates(ercnSnapshot))) {
            return;
        }
        NSArray entityNames = ercnSnapshot.shapshotsForUpdateGroupedByEntity().allKeys();
        EOEditingContext ec = new EOEditingContext();
        ec.lock();
        Enumeration entitiesEnumerator = entityNames.objectEnumerator();
        while (entitiesEnumerator.hasMoreElements()) {
            String entityName = (String)entitiesEnumerator.nextElement();
            if (!ERCNSnapshot.shouldSynchronizeEntity(entityName)) continue;
            EOEntity entity = EOModelGroup.defaultGroup().entityNamed(entityName);
            EODatabaseContext dbContext = ERCNNotificationCoordinator.databaseContextForEntityNamed(entityName, ec);
            EODatabase database = dbContext.database();
            NSArray snapshots = (NSArray)ercnSnapshot.shapshotsForUpdateGroupedByEntity().objectForKey((Object)entityName);
            Enumeration snapshotsEnumerator = snapshots.objectEnumerator();
            while (snapshotsEnumerator.hasMoreElements()) {
                NSDictionary snapshot = (NSDictionary)snapshotsEnumerator.nextElement();
                if (NSLog.debug.isEnabled()) {
                    NSLog.debug.appendln((Object)("ERChangeNotification: Snapshot: " + snapshot));
                }
                if (snapshot == null) continue;
                EOGlobalID globalID = entity.globalIDForRow(snapshot);
                dbContext.lock();
                database.forgetSnapshotForGlobalID(globalID);
                database.recordSnapshotForGlobalID(snapshot, globalID);
                dbContext.unlock();
            }
        }
        ec.unlock();
    }

    synchronized void terminate() {
        this.unsubscribe();
    }
}

