/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.components;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WODynamicGroup;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.attachment.model.ERAttachment;
import er.attachment.processors.ERAttachmentProcessor;
import er.extensions.components.ERXComponentUtilities;
import er.extensions.foundation.ERXMutableURL;
import java.net.MalformedURLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERAttachmentLink
extends WODynamicGroup {
    private WOAssociation _attachment;
    private WOAssociation _configurationName;
    private NSMutableDictionary<String, WOAssociation> _associations;
    private WOAssociation _download;

    public ERAttachmentLink(String name, NSDictionary<String, WOAssociation> associations, WOElement template) {
        super(name, associations, template);
        this._associations = associations.mutableClone();
        this._attachment = (WOAssociation)this._associations.removeObjectForKey((Object)"attachment");
        this._download = (WOAssociation)this._associations.removeObjectForKey((Object)"download");
        if (this._attachment == null) {
            throw new WODynamicElementCreationException("<ERAttachmentLink> The 'attachment' binding is required.");
        }
        this._configurationName = (WOAssociation)this._associations.removeObjectForKey((Object)"configurationName");
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        WOComponent component = context.component();
        ERAttachment attachment = (ERAttachment)((Object)this._attachment.valueInComponent(component));
        String attachmentUrl = "#";
        if (attachment != null) {
            attachmentUrl = ERAttachmentProcessor.processorForType(attachment).attachmentUrl(attachment, context.request(), context);
            if (!attachment.available().booleanValue()) {
                response.appendContentString("<span");
                ERXComponentUtilities.appendHtmlAttributes(this._associations, (WOResponse)response, (WOComponent)component);
                response.appendContentString(">");
                super.appendToResponse(response, context);
                response.appendContentString("</span>");
            } else {
                response.appendContentString("<a href = \"");
                if (this._download != null && this._download.booleanValueInComponent(component)) {
                    try {
                        ERXMutableURL attachmentMutableUrl = new ERXMutableURL(attachmentUrl);
                        attachmentMutableUrl.addQueryParameter("attachment", "true");
                        attachmentUrl = attachmentMutableUrl.toExternalForm();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("Failed to create attachment URL.", e);
                    }
                }
                response.appendContentString(attachmentUrl);
                response.appendContentString("\"");
                ERXComponentUtilities.appendHtmlAttributes(this._associations, (WOResponse)response, (WOComponent)component);
                response.appendContentString(">");
                super.appendToResponse(response, context);
                response.appendContentString("</a>");
            }
        }
    }
}

