/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.metadata;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.webobjects.foundation.NSLog;
import er.attachment.metadata.ERMetadataDirectorySet;
import er.attachment.metadata.ERMetadataEntry;
import er.attachment.metadata.ERMetadataParserException;
import er.attachment.metadata.ERMetadataUtils;
import er.attachment.metadata.ERParsedMetadataDirectory;
import er.attachment.metadata.IERMetadataParser;
import java.io.File;
import java.util.Iterator;

public class DrewMetadataParser
implements IERMetadataParser {
    public static final String UNKNOWN_TAG = "Unknown tag";

    public ERMetadataDirectorySet parseMetadata(File importFile) throws ERMetadataParserException {
        try {
            ERMetadataDirectorySet directorySet = new ERMetadataDirectorySet();
            Metadata metadata = JpegMetadataReader.readMetadata(importFile);
            Iterator directoryIter = metadata.getDirectoryIterator();
            while (directoryIter.hasNext()) {
                Directory directory = (Directory)directoryIter.next();
                ERParsedMetadataDirectory parsedMetadataDirectory = new ERParsedMetadataDirectory(directory.getName());
                DrewMetadataParser.fillInParsedMetadataDirectoryFromDrewMetadata(parsedMetadataDirectory, directory);
                directorySet.addMetadata(parsedMetadataDirectory);
            }
            return directorySet;
        }
        catch (JpegProcessingException e) {
            throw new ERMetadataParserException("Failed to parse metadata.", e);
        }
    }

    public static void fillInParsedMetadataDirectoryFromDrewMetadata(ERParsedMetadataDirectory parsedMetadataDirectory, Directory directory) {
        String directoryName = directory.getName();
        boolean isEXIF = "EXIF".equalsIgnoreCase(directoryName);
        Iterator tags = directory.getTagIterator();
        while (tags.hasNext()) {
            Tag tag = (Tag)tags.next();
            try {
                boolean isMakerNote;
                String tagName = tag.getTagName();
                String tagValue = tag.getDescription();
                int tagType = tag.getTagType();
                boolean bl = isMakerNote = tagType == 37500 && isEXIF;
                boolean isUnknown = tagName.startsWith(UNKNOWN_TAG);
                if (isUnknown || isMakerNote) continue;
                parsedMetadataDirectory.addMetadataEntry(new ERMetadataEntry(tagType, tagName, tagValue, ERMetadataUtils.classForTagName(directoryName, tagName)));
            }
            catch (MetadataException t) {
                NSLog.out.appendln((Throwable)t);
            }
        }
    }
}

