/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.metadata;

import er.attachment.metadata.ERParsedMetadataDirectory;
import er.attachment.metadata.ERUnparsedMetadataDirectory;
import er.attachment.metadata.IERMetadataDirectory;
import er.attachment.metadata.IERMetadataDirectoryParser;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERMetadataDirectorySet {
    private List<IERMetadataDirectory> _metadataDirectories = new LinkedList<IERMetadataDirectory>();
    private int _width = -1;
    private int _height = -1;
    private boolean _rotated;
    private String _caption = null;

    public boolean isEmpty() {
        return this._width == -1 && this._height == -1 && this._metadataDirectories.isEmpty();
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int getWidth() {
        return this._width;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public int getHeight() {
        return this._height;
    }

    public void setRotated(boolean rotated) {
        this._rotated = rotated;
    }

    public boolean isRotated() {
        return this._rotated;
    }

    public String getCaption() {
        return this._caption;
    }

    public void setCaption(String caption) {
        this._caption = caption;
    }

    public IERMetadataDirectory _getDirectoryNamed(String directoryName) {
        IERMetadataDirectory matchingMetadataDirectory = null;
        Iterator<IERMetadataDirectory> directoriesIter = this._metadataDirectories.iterator();
        while (matchingMetadataDirectory == null && directoriesIter.hasNext()) {
            IERMetadataDirectory metadataDirectory = directoriesIter.next();
            if (!directoryName.equals(metadataDirectory.getDirectoryName())) continue;
            matchingMetadataDirectory = metadataDirectory;
        }
        return matchingMetadataDirectory;
    }

    public ERParsedMetadataDirectory getDirectoryNamed(String directoryName) {
        return (ERParsedMetadataDirectory)this._getDirectoryNamed(directoryName);
    }

    public void addMetadata(IERMetadataDirectory metadata) {
        this._metadataDirectories.add(metadata);
    }

    public List<IERMetadataDirectory> getMetadataDirectories() {
        return this._metadataDirectories;
    }

    public void add(ERMetadataDirectorySet rawAssetMetadata) {
        if (rawAssetMetadata._width != -1) {
            this._width = rawAssetMetadata._width;
        }
        if (rawAssetMetadata._height != -1) {
            this._height = rawAssetMetadata._height;
        }
        this._metadataDirectories.addAll(rawAssetMetadata._metadataDirectories);
    }

    protected List<IERMetadataDirectory> removeUnparsedDirectories() {
        LinkedList<IERMetadataDirectory> unparsedMetadataDirectories = new LinkedList<IERMetadataDirectory>();
        Iterator<IERMetadataDirectory> metadataDirectoriesIter = this._metadataDirectories.iterator();
        while (metadataDirectoriesIter.hasNext()) {
            IERMetadataDirectory metadataDirectory = metadataDirectoriesIter.next();
            if (!(metadataDirectory instanceof ERUnparsedMetadataDirectory)) continue;
            unparsedMetadataDirectories.add(metadataDirectory);
            metadataDirectoriesIter.remove();
        }
        return unparsedMetadataDirectories;
    }

    protected void parseUnparsedDirectoriesWith(IERMetadataDirectoryParser metadataDirectoryParser) {
        for (IERMetadataDirectory metadataDirectory : new LinkedList<IERMetadataDirectory>(this.getMetadataDirectories())) {
            ERParsedMetadataDirectory parsedMetadataDirectory;
            if (metadataDirectory instanceof ERUnparsedMetadataDirectory) {
                ERUnparsedMetadataDirectory unparsedMetadataDirectory = (ERUnparsedMetadataDirectory)metadataDirectory;
                parsedMetadataDirectory = metadataDirectoryParser.parseMetadata(unparsedMetadataDirectory);
                if (parsedMetadataDirectory == null) continue;
                this.replaceUnparsedWithParsed(unparsedMetadataDirectory, parsedMetadataDirectory);
                continue;
            }
            parsedMetadataDirectory = (ERParsedMetadataDirectory)metadataDirectory;
        }
    }

    protected void replaceUnparsedWithParsed(ERUnparsedMetadataDirectory oldMetadata, ERParsedMetadataDirectory newMetadata) {
        this._metadataDirectories.remove(oldMetadata);
        if (newMetadata != null) {
            this._metadataDirectories.add(newMetadata);
        }
    }

    public String toString() {
        return "[MetadataDirectorySet: width = " + this._width + "; height = " + this._height + "; caption = " + this._caption + "; metadataDirectories = " + this._metadataDirectories + "]";
    }
}

