/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.processors;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSTimestamp;
import er.attachment.model.ERAttachmentData;
import er.attachment.model.ERDatabaseAttachment;
import er.attachment.processors.ERAttachmentProcessor;
import er.extensions.foundation.ERXProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERDatabaseAttachmentProcessor
extends ERAttachmentProcessor<ERDatabaseAttachment> {
    @Override
    public ERDatabaseAttachment _process(EOEditingContext editingContext, File uploadedFile, String recommendedFileName, String mimeType, String configurationName, String ownerID, boolean pendingDelete) throws IOException {
        String webPath = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".db.webPath"));
        if (webPath == null) {
            webPath = ERXProperties.stringForKeyWithDefault((String)"er.attachment.db.webPath", (String)"/${pk}${ext}");
        }
        if (webPath == null) {
            throw new IllegalArgumentException("There is no 'er.attachment." + configurationName + ".db.webPath' or 'er.attachment.db.webPath' property set.");
        }
        if (!webPath.startsWith("/")) {
            webPath = "/" + webPath;
        }
        boolean smallData = false;
        String smallDataStr = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".db.smallData"));
        if (smallDataStr == null) {
            smallDataStr = ERXProperties.stringForKey((String)"er.attachment.db.smallData");
        }
        if (smallDataStr != null) {
            smallData = Boolean.parseBoolean(smallDataStr);
        }
        ERDatabaseAttachment attachment = ERDatabaseAttachment.createERDatabaseAttachment(editingContext, Boolean.TRUE, new NSTimestamp(), mimeType, recommendedFileName, Boolean.TRUE, (int)uploadedFile.length(), webPath);
        if (this.delegate() != null) {
            this.delegate().attachmentCreated(this, attachment);
        }
        try {
            attachment.setWebPath(ERAttachmentProcessor._parsePathTemplate(attachment, webPath, recommendedFileName));
            NSData data = new NSData(uploadedFile.toURL());
            if (smallData) {
                attachment.setSmallData(data);
            } else {
                ERAttachmentData attachmentData = ERAttachmentData.createERAttachmentData(editingContext);
                attachmentData.setData(data);
                attachment.setAttachmentDataRelationship(attachmentData);
            }
            if (this.delegate() != null) {
                this.delegate().attachmentAvailable(this, attachment);
            }
        }
        catch (IOException e) {
            attachment.delete();
            throw e;
        }
        catch (RuntimeException e) {
            attachment.delete();
            throw e;
        }
        finally {
            if (pendingDelete) {
                uploadedFile.delete();
            }
        }
        return attachment;
    }

    @Override
    public InputStream attachmentInputStream(ERDatabaseAttachment attachment) throws FileNotFoundException {
        ERAttachmentData attachmentData;
        NSData data = attachment.smallData();
        if (data == null && (attachmentData = attachment.attachmentData()) != null) {
            data = attachmentData.data();
        }
        if (data == null) {
            throw new FileNotFoundException("There was no data available for this attachment.");
        }
        ByteArrayInputStream attachmentInputStream = data.stream();
        return attachmentInputStream;
    }

    @Override
    public String attachmentUrl(ERDatabaseAttachment attachment, WORequest request, WOContext context) {
        return this.proxiedUrl(attachment, context);
    }

    @Override
    public void deleteAttachment(ERDatabaseAttachment attachment) {
    }
}

