/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.processors;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSTimestamp;
import er.attachment.model.ERFileAttachment;
import er.attachment.processors.ERAttachmentProcessor;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERFileAttachmentProcessor
extends ERAttachmentProcessor<ERFileAttachment> {
    @Override
    public ERFileAttachment _process(EOEditingContext editingContext, File uploadedFile, String recommendedFileName, String mimeType, String configurationName, String ownerID, boolean pendingDelete) throws IOException {
        String webPath;
        String filesystemPath;
        boolean proxy = true;
        String proxyStr = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".file.proxy"));
        if (proxyStr == null) {
            proxyStr = ERXProperties.stringForKey((String)"er.attachment.file.proxy");
        }
        if (proxyStr != null) {
            proxy = Boolean.parseBoolean(proxyStr);
        }
        boolean overwrite = false;
        String overwriteStr = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".file.overwrite"));
        if (overwriteStr == null) {
            overwriteStr = ERXProperties.stringForKey((String)"er.attachment.file.overwrite");
        }
        if (overwriteStr != null) {
            overwrite = Boolean.parseBoolean(overwriteStr);
        }
        if ((filesystemPath = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".file.filesystemPath"))) == null) {
            filesystemPath = ERXProperties.stringForKey((String)"er.attachment.file.filesystemPath");
        }
        if (filesystemPath == null) {
            throw new IllegalArgumentException("There is no 'er.attachment." + configurationName + ".file.filesystemPath' or 'er.attachment.file.filesystemPath' property set.");
        }
        if (!filesystemPath.contains("${")) {
            filesystemPath = filesystemPath + "/attachments/${hash}/${pk}${ext}";
        }
        if ((webPath = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".file.webPath"))) == null) {
            webPath = ERXProperties.stringForKey((String)"er.attachment.file.webPath");
        }
        if (webPath == null) {
            if (!proxy) {
                throw new IllegalArgumentException("There is no 'er.attachment." + configurationName + ".file.webPath' or 'er.attachment.file.webPath' property set.");
            }
            webPath = "/${pk}${ext}";
        } else if (!webPath.startsWith("/")) {
            webPath = "/" + webPath;
        }
        ERFileAttachment attachment = ERFileAttachment.createERFileAttachment(editingContext, Boolean.TRUE, new NSTimestamp(), mimeType, recommendedFileName, proxy, (int)uploadedFile.length(), webPath);
        if (this.delegate() != null) {
            this.delegate().attachmentCreated(this, attachment);
        }
        try {
            webPath = ERAttachmentProcessor._parsePathTemplate(attachment, webPath, recommendedFileName);
            filesystemPath = ERAttachmentProcessor._parsePathTemplate(attachment, filesystemPath, recommendedFileName);
            File desiredFilesystemPath = new File(filesystemPath);
            File actualFilesystemPath = ERXFileUtilities.reserveUniqueFile((File)desiredFilesystemPath, (boolean)overwrite);
            ERXFileUtilities.copyFileToFile((File)uploadedFile, (File)actualFilesystemPath, (boolean)pendingDelete, (boolean)true);
            String desiredFileName = desiredFilesystemPath.getName();
            String actualFileName = actualFilesystemPath.getName();
            webPath = webPath.replaceAll(desiredFileName + "$", actualFileName);
            attachment.setWebPath(webPath);
            attachment.setFilesystemPath(actualFilesystemPath.getAbsolutePath());
            if (this.delegate() != null) {
                this.delegate().attachmentAvailable(this, attachment);
            }
        }
        catch (IOException e) {
            attachment.delete();
            throw e;
        }
        catch (RuntimeException e) {
            attachment.delete();
            throw e;
        }
        return attachment;
    }

    @Override
    public InputStream attachmentInputStream(ERFileAttachment attachment) throws IOException {
        return new FileInputStream(new File(attachment.filesystemPath()));
    }

    @Override
    public String attachmentUrl(ERFileAttachment attachment, WORequest request, WOContext context) {
        String attachmentUrl = attachment.proxied() == false ? attachment.webPath() : this.proxiedUrl(attachment, context);
        return attachmentUrl;
    }

    @Override
    public void deleteAttachment(ERFileAttachment attachment) throws IOException {
        String filesystemPath = attachment.filesystemPath();
        File attachmentFile = new File(filesystemPath);
        if (attachmentFile.exists() && !attachmentFile.delete()) {
            throw new IOException("Failed to delete the attachment '" + attachmentFile + "'.");
        }
    }
}

