/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFaultHandler;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol._EOPrivateMemento;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMultiReaderLock;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSUndoManager;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Enumeration;

public class EOSharedEditingContext
extends EOEditingContext {
    static final long serialVersionUID = 6468385361066892450L;
    private static final String SerializationGIDArrayFieldKey = "initedGIDs";
    private static final String SerializationObjectsByEntityFieldKey = "objectsByEntity";
    private static final String SerializationObjectsByEntityFetchSpecFieldKey = "objectsByEntityFS";
    private static final Class _NSMutableDictionaryClass = new NSMutableDictionary().getClass();
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOSharedEditingContext");
    private static boolean _hasInitializedDefaultEditingContext = false;
    private static EOSharedEditingContext _defaultSharedEditingContext = null;
    public static final String DefaultSharedEditingContextWasInitializedNotification = "EODefaultSharedEditingContextWasInitializedNotification";
    public static final String SharedEditingContextInitializedObjectsNotification = "EOSharedEditingContextInitializedObjectsNotification";
    private transient NSMultiReaderLock _sharedLock;
    private NSMutableArray _initializedGlobalIDs;
    private NSMutableDictionary _objectsByEntity;
    private NSMutableDictionary _objectsByEntityFetchSpecification;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("initedGIDs", new NSMutableArray().getClass()), new ObjectStreamField("objectsByEntity", _NSMutableDictionaryClass), new ObjectStreamField("objectsByEntityFS", _NSMutableDictionaryClass)};

    public static synchronized EOSharedEditingContext defaultSharedEditingContext() {
        if (_defaultSharedEditingContext == null) {
            _defaultSharedEditingContext = new EOSharedEditingContext();
            if (!_hasInitializedDefaultEditingContext) {
                _hasInitializedDefaultEditingContext = true;
                NSNotificationCenter.defaultCenter().postNotification(DefaultSharedEditingContextWasInitializedNotification, null);
            }
        }
        return _defaultSharedEditingContext;
    }

    public static synchronized EOSharedEditingContext _defaultSharedEditingContext() {
        return _defaultSharedEditingContext;
    }

    public static synchronized void setDefaultSharedEditingContext(EOSharedEditingContext context) {
        if (context != null && !(context instanceof EOSharedEditingContext)) {
            throw new IllegalArgumentException("EOSharedEditingContext: setDefaultSharedEditingContext: attempt to set default shared editing context to a non-shared context.");
        }
        _defaultSharedEditingContext = context;
    }

    public EOSharedEditingContext(EOObjectStore parent) {
        super(parent);
        if (!(parent instanceof EOObjectStoreCoordinator)) {
            throw new IllegalArgumentException("The parent EOObjectStore for an EOSharedEditingContext must be an EOObjectStoreCoordinator");
        }
    }

    public EOSharedEditingContext() {
    }

    protected void _initWithParentObjectStore(EOObjectStore parent) {
        super._initWithParentObjectStore(parent);
        if (this._sharedLock == null) {
            this._sharedLock = new NSMultiReaderLock();
        }
        this._retainsAllRegisteredObjects = true;
        super.setSharedEditingContext(null);
        NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
        notificationCenter.removeObserver((Object)this, "NSUndoManagerCheckpointNotification", null);
        notificationCenter.removeObserver((Object)this, SharedEditingContextInitializedObjectsNotification, null);
        notificationCenter.removeObserver((Object)this, "EOGlobalIDChangedNotification", null);
        this._undoManager = null;
        this._lock = null;
        this._initializedGlobalIDs = new NSMutableArray(256);
        this._objectsByEntity = new NSMutableDictionary(16);
        this._objectsByEntityFetchSpecification = new NSMutableDictionary(64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSDictionary objectsByEntityName() {
        this.lockForReading();
        try {
            NSDictionary nSDictionary = this._objectsByEntity.immutableClone();
            return nSDictionary;
        }
        finally {
            this.unlockForReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSDictionary objectsByEntityNameAndFetchSpecificationName() {
        this.lockForReading();
        try {
            NSDictionary nSDictionary = this._objectsByEntityFetchSpecification.immutableClone();
            return nSDictionary;
        }
        finally {
            this.unlockForReading();
        }
    }

    public void reset() {
    }

    public void dispose() {
        super.dispose();
    }

    public EOSharedEditingContext sharedEditingContext() {
        return null;
    }

    public void setSharedEditingContext(EOSharedEditingContext sharedEditingContext) {
        if (sharedEditingContext != null) {
            throw new IllegalArgumentException("EOSharedEditingContext: setSharedEditingContext: attempt to set a shared editing context on a shared editing context.");
        }
    }

    public void setUndoManager(NSUndoManager undoManager) {
        if (undoManager != null) {
            throw new IllegalArgumentException("EOSharedEditingContext: setUndoManager: attempt to set undo manager on a shared editing context.");
        }
    }

    public EOGlobalID globalIDForObject(EOEnterpriseObject object) {
        _EOPrivateMemento m;
        if (object != null && (m = (_EOPrivateMemento)object.opaqueState()).__editingContext() == this) {
            return m.__globalID();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOEnterpriseObject objectForGlobalID(EOGlobalID gid) {
        EOEnterpriseObject obj;
        this.lockForReading();
        try {
            obj = super.objectForGlobalID(gid);
        }
        finally {
            this.unlockForReading();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOEnterpriseObject faultForGlobalID(EOGlobalID gid, EOEditingContext editingContext) {
        EOEnterpriseObject obj;
        this.lockForReading();
        try {
            obj = super.faultForGlobalID(gid, editingContext);
        }
        finally {
            this.unlockForReading();
        }
        return obj;
    }

    private void _registerObjectsOfEntityName(NSArray objects, String entityName, String fetchSpecificationName) {
        NSMutableArray allObjectsOfEntity = (NSMutableArray)this._objectsByEntity.objectForKey((Object)entityName);
        if (allObjectsOfEntity != null) {
            NSMutableSet uniquedObjects = new NSMutableSet(allObjectsOfEntity.count() + objects.count());
            uniquedObjects.addObjectsFromArray((NSArray)allObjectsOfEntity);
            uniquedObjects.addObjectsFromArray(objects);
            this._objectsByEntity.setObjectForKey((Object)uniquedObjects.allObjects().mutableClone(), (Object)entityName);
        } else {
            this._objectsByEntity.setObjectForKey((Object)new NSMutableArray(objects), (Object)entityName);
        }
        if (fetchSpecificationName != null) {
            NSMutableDictionary fetchSpecificationNames = (NSMutableDictionary)this._objectsByEntityFetchSpecification.objectForKey((Object)entityName);
            if (fetchSpecificationNames != null) {
                fetchSpecificationNames = fetchSpecificationNames.mutableClone();
                fetchSpecificationNames.setObjectForKey((Object)objects, (Object)fetchSpecificationName);
                this._objectsByEntityFetchSpecification.setObjectForKey((Object)fetchSpecificationNames, (Object)entityName);
            } else {
                this._objectsByEntityFetchSpecification.setObjectForKey((Object)new NSMutableDictionary((Object)objects, (Object)fetchSpecificationName), (Object)entityName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray objectsWithFetchSpecification(EOFetchSpecification fetchSpecification, EOEditingContext editingContext) {
        NSArray objects;
        this.lock();
        try {
            objects = super.objectsWithFetchSpecification(fetchSpecification, editingContext);
            this._registerObjectsOfEntityName(objects, fetchSpecification.entityName(), null);
        }
        finally {
            this.unlock();
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindObjectsWithFetchSpecification(EOFetchSpecification fetchSpecification, String fetchSpecificationName) {
        if (fetchSpecificationName == null) {
            throw new IllegalArgumentException("Fetch specification name cannot be null");
        }
        this.lock();
        try {
            NSArray objects = super.objectsWithFetchSpecification(fetchSpecification, this);
            this._registerObjectsOfEntityName(objects, fetchSpecification.entityName(), fetchSpecificationName);
        }
        finally {
            this.unlock();
        }
    }

    public void _processGlobalIDChanges(NSDictionary userInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeObject(EOEnterpriseObject object, EOGlobalID gid, EOEditingContext editingContext) {
        this.lock();
        try {
            super.initializeObject(object, gid, editingContext);
            if (editingContext == this) {
                this._initializedGlobalIDs.addObject((Object)gid);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void _resetAllChanges() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _processObjectStoreChanges(NSDictionary info) {
        NSDictionary chgs = this._objectBasedChangeInfoForGIDInfo(info);
        if (chgs.count() == 0) {
            return;
        }
        this.lock();
        try {
            EOEnterpriseObject obj;
            int i;
            int count;
            NSArray objs = (NSArray)chgs.objectForKey((Object)"updated");
            if (objs != null && (count = objs.count()) > 0) {
                for (i = 0; i < count; ++i) {
                    obj = (EOEnterpriseObject)objs.objectAtIndex(i);
                    this.refaultObject(obj, this.globalIDForObject(obj), this);
                }
            }
            if ((objs = (NSArray)chgs.objectForKey((Object)"invalidated")) != null && (count = objs.count()) > 0) {
                for (i = 0; i < count; ++i) {
                    obj = (EOEnterpriseObject)objs.objectAtIndex(i);
                    this.refaultObject(obj, this.globalIDForObject(obj), this);
                }
            }
            if ((objs = (NSArray)chgs.objectForKey((Object)"deleted")) != null && (count = objs.count()) > 0) {
                for (i = 0; i < count; ++i) {
                    int count2;
                    NSArray values;
                    obj = (EOEnterpriseObject)objs.objectAtIndex(i);
                    String entityName = obj.entityName();
                    NSMutableArray array = (NSMutableArray)this._objectsByEntity.objectForKey((Object)entityName);
                    NSDictionary dict = (NSDictionary)this._objectsByEntityFetchSpecification.objectForKey((Object)entityName);
                    if (array != null) {
                        array.removeObject((Object)obj);
                    }
                    if (dict == null || (values = dict.allValues()) == null || (count2 = values.count()) <= 0) continue;
                    for (int j = 0; j < count2; ++j) {
                        ((NSMutableArray)values.objectAtIndex(j)).removeObject((Object)obj);
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetObject(EOEnterpriseObject object) {
        this.lock();
        try {
            super.forgetObject(object);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _completeRefaultingOfGID(EOGlobalID gid, EOEnterpriseObject object) {
        _EOPrivateMemento memento;
        EOEnterpriseObject rec = this._eoForGID(gid);
        _EOPrivateMemento _EOPrivateMemento2 = memento = rec != null ? (_EOPrivateMemento)rec.opaqueState() : null;
        if (memento != null) {
            memento.__setInitialized(false);
        }
        this.lockObjectStore();
        try {
            this._objectStore.editingContextDidForgetObjectWithGlobalID(this, gid);
        }
        finally {
            this.unlockObjectStore();
        }
        this._clearOriginalSnapshotForObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refaultObject(EOEnterpriseObject object, EOGlobalID gid, EOEditingContext editingContext) {
        if (!EOFaultHandler.isFault(object)) {
            this.lockObjectStore();
            try {
                this._objectStore.refaultObject(object, gid, editingContext);
            }
            finally {
                this.unlockObjectStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refaultAllObjects() {
        this.lockObjectStore();
        try {
            NSArray objs = this.registeredObjects();
            Enumeration items = objs.objectEnumerator();
            while (items.hasMoreElements()) {
                EOEnterpriseObject obj = (EOEnterpriseObject)items.nextElement();
                this._objectStore.refaultObject(obj, this.globalIDForObject(obj), this);
            }
        }
        finally {
            this.unlockObjectStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObjectsWithGlobalIDs(NSArray gids) {
        this.lock();
        try {
            super.invalidateObjectsWithGlobalIDs(gids);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllObjects() {
        this.lock();
        try {
            super.invalidateAllObjects();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _processRecentChanges() {
        boolean result;
        if (this._initializedGlobalIDs == null) {
            return super._processRecentChanges();
        }
        if (this._initializedGlobalIDs.count() > 0) {
            NSNotificationCenter.defaultCenter().postNotification(SharedEditingContextInitializedObjectsNotification, (Object)this, new NSDictionary((Object)this._initializedGlobalIDs, (Object)"initialized"));
            this._initializedGlobalIDs = new NSMutableArray(256);
        }
        this.lock();
        try {
            result = super._processRecentChanges();
        }
        finally {
            this.unlock();
        }
        return result;
    }

    public NSArray updatedObjects() {
        return NSArray.EmptyArray;
    }

    public NSArray insertedObjects() {
        return NSArray.EmptyArray;
    }

    public NSArray deletedObjects() {
        return NSArray.EmptyArray;
    }

    public boolean hasChanges() {
        return false;
    }

    public void validateChangesForSave() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray registeredObjects() {
        NSArray objs;
        this.lockForReading();
        try {
            objs = super.registeredObjects();
        }
        finally {
            this.unlockForReading();
        }
        return objs;
    }

    public void objectWillChange(Object object) {
        throw new IllegalArgumentException("Attempt to change object " + object + " in a shared editing context");
    }

    protected void _insertObjectWithGlobalID(EOEnterpriseObject object, EOGlobalID gid) {
        throw new IllegalArgumentException("Attempt to insert object " + object + " with global ID " + gid + " into a shared editing context");
    }

    public void insertObjectWithGlobalID(EOEnterpriseObject object, EOGlobalID gid) {
        throw new IllegalArgumentException("Attempt to insert object " + object + " with global ID " + gid + " into a shared editing context");
    }

    public void insertObject(EOEnterpriseObject object) {
        throw new IllegalArgumentException("Attempt to insert object " + object + " into a shared editing context");
    }

    public void deleteObject(EOEnterpriseObject object) {
        throw new IllegalArgumentException("Attempt to delete object " + object + " from a shared editing context");
    }

    public void saveChanges() {
        throw new IllegalArgumentException("Attempt to save changes in a shared editing context");
    }

    public void lockObjectStore() {
        this.lock();
        this._objectStore.lock();
    }

    public void unlockObjectStore() {
        this._objectStore.unlock();
        this.unlock();
    }

    public void lock() {
        if (this._sharedLock == null) {
            super.lock();
        } else {
            this._sharedLock.suspendReaderLocks();
            this._sharedLock.lockForWriting();
            ++this._lockCount;
            if (this._lockCount == 1) {
                this._processNotificationQueue();
            }
        }
    }

    public boolean tryLock() {
        if (!this._sharedLock.tryLockForWriting()) {
            return false;
        }
        this.lock();
        this._sharedLock.unlockForWriting();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        if (this._sharedLock == null) {
            super.unlock();
        } else {
            try {
                if (this._lockCount == 1) {
                    this.processRecentChanges();
                    this._processNotificationQueue();
                }
            }
            finally {
                --this._lockCount;
                this._sharedLock.retrieveReaderLocks();
                this._sharedLock.unlockForWriting();
            }
        }
    }

    public void lockForReading() {
        this._sharedLock.lockForReading();
    }

    public boolean tryLockForReading() {
        if (!this._sharedLock.tryLockForReading()) {
            return false;
        }
        this.lockForReading();
        this._sharedLock.unlockForReading();
        return true;
    }

    public void unlockForReading() {
        this._sharedLock.unlockForReading();
    }

    public void suspendReaderLocks() {
        this._sharedLock.suspendReaderLocks();
    }

    public void retrieveReaderLocks() {
        this._sharedLock.retrieveReaderLocks();
    }

    public void _EOAssertSafeMultiThreadedAccess(String info) {
        if (!_doAssertLock) {
            return;
        }
        if (!_doAssertLockInitialized) {
            EOSharedEditingContext._checkAssertLock();
            if (!_doAssertLock) {
                return;
            }
        }
        if (this._lockCount == 0) {
            NSLog.debug.appendln((Object)("EOSharedEditingContext: WRITE access with no lock: " + info + "!"));
            if (NSLog.allowedDebugLevel() >= 2) {
                NSLog.debug.appendln((Throwable)new Exception("This is not a real exception, just a stack trace of the location of the missing lock:"));
            }
            return;
        }
        if (!this._sharedLock.tryLockForWriting()) {
            NSLog.debug.appendln((Object)("EOSharedEditingContext: WRITE access when another thread holds a WRITE lock: " + info + "!"));
            if (NSLog.allowedDebugLevel() >= 2) {
                NSLog.debug.appendln((Throwable)new Exception("This is not a real exception, just a stack trace of the location of the missing lock:"));
            }
            return;
        }
        this._sharedLock.unlockForWriting();
    }

    public void _EOAssertSafeMultiThreadedReadAccess(String info) {
        if (!_doAssertLock) {
            return;
        }
        if (!_doAssertLockInitialized) {
            EOSharedEditingContext._checkAssertLock();
            if (!_doAssertLock) {
                return;
            }
        }
        if (this._lockCount > 0) {
            if (!this._sharedLock.tryLockForWriting()) {
                NSLog.debug.appendln((Object)("EOSharedEditingContext: READ access when another thread holds a WRITE lock: " + info + "!"));
                if (NSLog.allowedDebugLevel() >= 2) {
                    NSLog.debug.appendln((Throwable)new Exception("This is not a real exception, just a stack trace of the location of the missing lock:"));
                }
                return;
            }
            this._sharedLock.unlockForWriting();
            return;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.lock();
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationGIDArrayFieldKey, this._initializedGlobalIDs);
        fields.put(SerializationObjectsByEntityFieldKey, this._objectsByEntity);
        fields.put(SerializationObjectsByEntityFetchSpecFieldKey, this._objectsByEntityFetchSpecification);
        s.writeFields();
        this.unlock();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        this._sharedLock = new NSMultiReaderLock();
        this._initWithParentObjectStore(EOSharedEditingContext.defaultParentObjectStore());
        this._initializedGlobalIDs = (NSMutableArray)fields.get(SerializationGIDArrayFieldKey, null);
        this._objectsByEntity = (NSMutableDictionary)fields.get(SerializationObjectsByEntityFieldKey, null);
        this._objectsByEntityFetchSpecification = (NSMutableDictionary)fields.get(SerializationObjectsByEntityFetchSpecFieldKey, null);
    }
}

