/*
 * Decompiled with CFR 0.152.
 */
package er.rest.example.client;

import com.webobjects.eocontrol.EOClassDescription;
import er.extensions.eof.ERXKeyFilter;
import er.extensions.foundation.ERXMutableURL;
import er.rest.ERXRestClassDescriptionFactory;
import er.rest.ERXRestRequestNode;
import er.rest.IERXRestDelegate;
import er.rest.format.ERXRestFormat;
import er.rest.format.ERXStringBufferRestResponse;
import er.rest.format.ERXStringRestRequest;
import er.rest.format.IERXRestRequest;
import er.rest.format.IERXRestResponse;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRestClient {
    private String _baseURL;
    private IERXRestDelegate _delegate;
    private boolean _classDescriptionRequired;
    private HttpClient _httpClient = null;

    public ERXRestClient(String baseURL, IERXRestDelegate delegate, boolean classDescriptionRequired) {
        this._baseURL = baseURL;
        this._delegate = delegate;
        this.setClassDescriptionRequired(classDescriptionRequired);
    }

    public ERXRestClient(String baseURL, IERXRestDelegate delegate) {
        this(baseURL, delegate, true);
    }

    public void setBaseURL(String baseURL) {
        this._baseURL = baseURL;
    }

    public String baseURL() {
        return this._baseURL;
    }

    public void setDelegate(IERXRestDelegate delegate) {
        this._delegate = delegate;
    }

    public IERXRestDelegate delegate() {
        return this._delegate;
    }

    public void setClassDescriptionRequired(boolean classDescriptionRequired) {
        this._classDescriptionRequired = classDescriptionRequired;
    }

    public boolean isClassDescriptionRequired() {
        return this._classDescriptionRequired;
    }

    protected ERXRestRequestNode requestNodeWithMethod(HttpMethodBase method) throws IOException {
        ERXRestFormat format = ERXRestFormat.formatNamed((String)method.getResponseHeader("Content-Type").getValue());
        return this.requestNodeWithMethod(method, format);
    }

    protected ERXRestRequestNode requestNodeWithMethod(HttpMethodBase method, ERXRestFormat format) throws IOException {
        ERXRestRequestNode responseNode = format.parser().parseRestRequest((IERXRestRequest)new ERXStringRestRequest(method.getResponseBodyAsString()), format.delegate());
        return responseNode;
    }

    protected Object _objectWithRequestNode(ERXRestRequestNode node, String entityName) {
        EOClassDescription classDescription = ERXRestClassDescriptionFactory.classDescriptionForEntityName((String)entityName);
        Object obj = entityName != null && classDescription == null && !this._classDescriptionRequired ? node : node.objectWithFilter(entityName, ERXKeyFilter.filterWithAllRecursive(), this._delegate);
        return obj;
    }

    public <T> T objectWithRequestNode(ERXRestRequestNode node) {
        return (T)this._objectWithRequestNode(node, null);
    }

    public <T> T objectWithRequestNode(ERXRestRequestNode node, String entityName) {
        return (T)this._objectWithRequestNode(node, entityName);
    }

    protected String path(String entityName, String id, String action, ERXRestFormat format) {
        StringBuffer sb = new StringBuffer();
        sb.append(entityName);
        if (id != null) {
            sb.append("/");
            sb.append(id);
        }
        if (action != null) {
            sb.append("/");
            sb.append(action);
        }
        if (format != null) {
            sb.append(".");
            sb.append(format.name());
        }
        return sb.toString();
    }

    public <T> T object(String entityName, String id, String action, ERXRestFormat format) throws HttpException, IOException {
        return this.objectWithPath(this.path(entityName, id, action, format));
    }

    public HttpClient httpClient() {
        if (this._httpClient == null) {
            this._httpClient = new HttpClient();
        }
        return this._httpClient;
    }

    public <T> T objectWithPath(String path, String entityName) throws HttpException, IOException {
        HttpClient client = this.httpClient();
        GetMethod fetchObjectMethod = new GetMethod(new ERXMutableURL(this._baseURL).appendPath(path).toExternalForm());
        client.executeMethod((HttpMethod)fetchObjectMethod);
        ERXRestRequestNode node = this.requestNodeWithMethod((HttpMethodBase)fetchObjectMethod);
        return (T)this._objectWithRequestNode(node, entityName);
    }

    public <T> T objectWithPath(String path) throws HttpException, IOException {
        HttpClient client = this.httpClient();
        GetMethod fetchObjectMethod = new GetMethod(new ERXMutableURL(this._baseURL).appendPath(path).toExternalForm());
        client.executeMethod((HttpMethod)fetchObjectMethod);
        ERXRestRequestNode node = this.requestNodeWithMethod((HttpMethodBase)fetchObjectMethod);
        String type = node.type();
        return (T)this._objectWithRequestNode(node, type);
    }

    public ERXRestRequestNode update(Object obj, ERXKeyFilter filter, String entityName, String id, String action, ERXRestFormat format) throws HttpException, IOException {
        return this.updateObjectWithPath(obj, filter, this.path(entityName, id, action, format), format);
    }

    public ERXRestRequestNode updateObjectWithPath(Object obj, ERXKeyFilter filter, String path, ERXRestFormat format) throws HttpException, IOException {
        ERXRestRequestNode node = ERXRestRequestNode.requestNodeWithObjectAndFilter((Object)obj, (ERXKeyFilter)filter, (IERXRestDelegate)this._delegate);
        ERXStringBufferRestResponse response = new ERXStringBufferRestResponse();
        format.writer().appendToResponse(node, (IERXRestResponse)response, format.delegate());
        HttpClient client = this.httpClient();
        PutMethod updateObjectMethod = new PutMethod(new ERXMutableURL(this._baseURL).appendPath(path).toExternalForm());
        updateObjectMethod.setRequestEntity((RequestEntity)new StringRequestEntity(response.toString()));
        client.executeMethod((HttpMethod)updateObjectMethod);
        return this.requestNodeWithMethod((HttpMethodBase)updateObjectMethod);
    }

    public ERXRestRequestNode create(Object obj, ERXKeyFilter filter, String entityName, String id, String action, ERXRestFormat format) throws HttpException, IOException {
        return this.createObjectWithPath(obj, filter, this.path(entityName, id, action, format), format);
    }

    public ERXRestRequestNode createObjectWithPath(Object obj, ERXKeyFilter filter, String path, ERXRestFormat format) throws HttpException, IOException {
        ERXRestRequestNode node = ERXRestRequestNode.requestNodeWithObjectAndFilter((Object)obj, (ERXKeyFilter)filter, (IERXRestDelegate)this._delegate);
        ERXStringBufferRestResponse response = new ERXStringBufferRestResponse();
        format.writer().appendToResponse(node, (IERXRestResponse)response, format.delegate());
        HttpClient client = this.httpClient();
        PostMethod updateObjectMethod = new PostMethod(new ERXMutableURL(this._baseURL).appendPath(path).toExternalForm());
        updateObjectMethod.setRequestEntity((RequestEntity)new StringRequestEntity(response.toString()));
        client.executeMethod((HttpMethod)updateObjectMethod);
        return this.requestNodeWithMethod((HttpMethodBase)updateObjectMethod, format);
    }

    public ERXRestRequestNode delete(Object obj, String entityName, String id, String action, ERXRestFormat format) throws HttpException, IOException {
        return this.deleteObjectWithPath(obj, this.path(entityName, id, action, format), format);
    }

    public ERXRestRequestNode deleteObjectWithPath(Object obj, String path, ERXRestFormat format) throws HttpException, IOException {
        ERXRestRequestNode node = ERXRestRequestNode.requestNodeWithObjectAndFilter((Object)obj, (ERXKeyFilter)ERXKeyFilter.filterWithNone(), (IERXRestDelegate)this._delegate);
        HttpClient client = this.httpClient();
        DeleteMethod deleteObjectMethod = new DeleteMethod(new ERXMutableURL(this._baseURL).appendPath(path).toExternalForm());
        client.executeMethod((HttpMethod)deleteObjectMethod);
        return this.requestNodeWithMethod((HttpMethodBase)deleteObjectMethod);
    }
}

