/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.expr;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtPrimitiveType;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.Javac;
import org.zeroturnaround.bundled.javassist.compiler.JvstCodeGen;
import org.zeroturnaround.bundled.javassist.compiler.JvstTypeChecker;
import org.zeroturnaround.bundled.javassist.compiler.ProceedHandler;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTList;
import org.zeroturnaround.bundled.javassist.expr.Expr;

public class NewArray
extends Expr {
    int opcode;

    protected NewArray(int pos, CodeIterator i, CtClass declaring, MethodInfo m, int op) {
        super(pos, i, declaring, m);
        this.opcode = op;
    }

    public CtBehavior where() {
        return super.where();
    }

    public int getLineNumber() {
        return super.getLineNumber();
    }

    public String getFileName() {
        return super.getFileName();
    }

    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    public CtClass getComponentType() throws NotFoundException {
        if (this.opcode == 188) {
            int atype = this.iterator.byteAt(this.currentPos + 1);
            return this.getPrimitiveType(atype);
        }
        if (this.opcode == 189 || this.opcode == 197) {
            int index = this.iterator.u16bitAt(this.currentPos + 1);
            String desc = this.getConstPool().getClassInfo(index);
            int dim = Descriptor.arrayDimension(desc);
            desc = Descriptor.toArrayComponent(desc, dim);
            return Descriptor.toCtClass(desc, this.thisClass.getClassPool());
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    CtClass getPrimitiveType(int atype) {
        switch (atype) {
            case 4: {
                return CtClass.booleanType;
            }
            case 5: {
                return CtClass.charType;
            }
            case 6: {
                return CtClass.floatType;
            }
            case 7: {
                return CtClass.doubleType;
            }
            case 8: {
                return CtClass.byteType;
            }
            case 9: {
                return CtClass.shortType;
            }
            case 10: {
                return CtClass.intType;
            }
            case 11: {
                return CtClass.longType;
            }
        }
        throw new RuntimeException("bad atype: " + atype);
    }

    public int getDimension() {
        if (this.opcode == 188) {
            return 1;
        }
        if (this.opcode == 189 || this.opcode == 197) {
            int index = this.iterator.u16bitAt(this.currentPos + 1);
            String desc = this.getConstPool().getClassInfo(index);
            return Descriptor.arrayDimension(desc) + (this.opcode == 189 ? 1 : 0);
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    public int getCreatedDimensions() {
        if (this.opcode == 197) {
            return this.iterator.byteAt(this.currentPos + 3);
        }
        return 1;
    }

    public void replace(String statement) throws CannotCompileException {
        try {
            this.replace2(statement);
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException("broken method");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void replace2(String statement) throws CompileError, NotFoundException, BadBytecode, CannotCompileException {
        void retType;
        void jc;
        int codeLength;
        int desc;
        String dim;
        Object index;
        this.thisClass.getClassFile();
        ConstPool constPool = this.getConstPool();
        int pos = this.currentPos;
        int n = 0;
        boolean bl = true;
        if (this.opcode == 188) {
            n = this.iterator.byteAt(this.currentPos + 1);
            index = (CtPrimitiveType)this.getPrimitiveType(n);
            dim = "[" + ((CtPrimitiveType)index).getDescriptor();
            desc = 2;
        } else if (this.opcode == 189) {
            n = this.iterator.u16bitAt(pos + 1);
            dim = constPool.getClassInfo(n);
            dim = dim.startsWith("[") ? "[" + dim : "[L" + dim + ";";
            desc = 3;
        } else if (this.opcode == 197) {
            n = this.iterator.u16bitAt(this.currentPos + 1);
            dim = constPool.getClassInfo(n);
            codeLength = this.iterator.byteAt(this.currentPos + 3);
            desc = 4;
        } else {
            throw new RuntimeException("bad opcode: " + this.opcode);
        }
        CtClass cpt = Descriptor.toCtClass(dim, this.thisClass.getClassPool());
        index = new Javac(this.thisClass);
        CodeAttribute ca = this.iterator.get();
        CtClass[] params = new CtClass[codeLength];
        for (int i = 0; i < codeLength; ++i) {
            params[i] = CtClass.intType;
        }
        int paramVar = ca.getMaxLocals();
        ((Javac)index).recordParams("java.lang.Object", params, true, paramVar, this.withinStatic());
        NewArray.checkResultValue((CtClass)jc, statement);
        int retVar = ((Javac)index).recordReturnType((CtClass)jc, true);
        ((Javac)index).recordProceed(new ProceedForArray((CtClass)jc, this.opcode, (int)retType, codeLength));
        Bytecode bytecode = ((Javac)index).getBytecode();
        NewArray.storeStack(params, true, paramVar, bytecode);
        ((Javac)index).recordLocalVariables(ca, pos);
        bytecode.addOpcode(1);
        bytecode.addAstore(retVar);
        ((Javac)index).compileStmnt(statement);
        bytecode.addAload(retVar);
        this.replace0(pos, bytecode, desc);
    }

    static class ProceedForArray
    implements ProceedHandler {
        CtClass arrayType;
        int opcode;
        int index;
        int dimension;

        ProceedForArray(CtClass type, int op, int i, int dim) {
            this.arrayType = type;
            this.opcode = op;
            this.index = i;
            this.dimension = dim;
        }

        public void doit(JvstCodeGen gen, Bytecode bytecode, ASTList args) throws CompileError {
            int num = gen.getMethodArgsLength(args);
            if (num != this.dimension) {
                throw new CompileError("$proceed() with a wrong number of parameters");
            }
            gen.atMethodArgs(args, new int[num], new int[num], new String[num]);
            bytecode.addOpcode(this.opcode);
            if (this.opcode == 189) {
                bytecode.addIndex(this.index);
            } else if (this.opcode == 188) {
                bytecode.add(this.index);
            } else {
                bytecode.addIndex(this.index);
                bytecode.add(this.dimension);
                bytecode.growStack(1 - this.dimension);
            }
            gen.setType(this.arrayType);
        }

        public void setReturnType(JvstTypeChecker c, ASTList args) throws CompileError {
            c.setType(this.arrayType);
        }
    }
}

