/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOEvent;
import com.webobjects.eocontrol.EOEvent;
import com.webobjects.eocontrol.EOEventCenter;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.woextensions.WOEventPage;
import com.webobjects.woextensions._EventComparator;
import java.util.Enumeration;

public class WOEventDisplayPage
extends WOEventPage {
    public EOEvent currentEvent;
    public NSArray selectionPath;
    public int _displayMode = 1;
    public NSArray events;
    public NSMutableDictionary cache;
    public NSMutableArray webEvents;
    public NSMutableArray eofEvents;
    public WOEventDisplayPage _self = this;
    protected _EventComparator _eventAscendingComparator;

    public WOEventDisplayPage(WOContext aContext) {
        super(aContext);
        this.selectionPath = new NSMutableArray();
        this.cache = new NSMutableDictionary();
        this._eventAscendingComparator = new _EventComparator(EOSortOrdering.CompareDescending, this);
    }

    public int displayMode() {
        return this._displayMode;
    }

    public void setDisplayMode(Object ick) {
        if (ick == null) {
            this._displayMode = 0;
        } else if (ick instanceof Number) {
            this._displayMode = ((Number)ick).intValue();
        } else {
            try {
                this._displayMode = Integer.parseInt(ick.toString());
            }
            catch (NumberFormatException e) {
                this._displayMode = 0;
            }
        }
    }

    public int displayLevelForEvent(EOEvent e) {
        int index = this.selectionPath.indexOfObject((Object)e);
        if (index != -1) {
            return index;
        }
        NSArray children = this.rootEventList();
        if (children.containsObject((Object)e)) {
            return 0;
        }
        int count = this.selectionPath.count();
        int n = count;
        for (int i = 0; i < n && null != (children = (NSArray)this.cache.objectForKey(this.selectionPath.objectAtIndex(i))); ++i) {
            if (!children.containsObject((Object)e)) continue;
            return i + 1;
        }
        return -1;
    }

    public NSArray filterEvents(NSArray evs, int level) {
        NSArray filtered;
        if (evs == null) {
            return NSArray.EmptyArray;
        }
        try {
            if (this._displayMode != 4 || level != 0) {
                try {
                    filtered = evs.sortedArrayUsingComparator((NSComparator)this._eventAscendingComparator);
                }
                catch (IllegalStateException ex) {
                    filtered = evs;
                }
            } else {
                int count = evs.count();
                NSMutableArray mutableFiltered = new NSMutableArray(count);
                int n = count;
                for (int i = 0; i < n; ++i) {
                    if (this.childrenForEvent((EOEvent)evs.objectAtIndex(i)).count() == 0) continue;
                    mutableFiltered.addObject(evs.objectAtIndex(i));
                }
                mutableFiltered.sortUsingComparator((NSComparator)this._eventAscendingComparator);
                filtered = mutableFiltered;
            }
        }
        catch (NSComparator.ComparisonException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        return filtered;
    }

    public int groupTagForDisplayLevel(int level) {
        switch (this._displayMode) {
            case 0: {
                return -1;
            }
            case 1: {
                return -1;
            }
            case 2: {
                switch (level) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 1;
                    }
                }
                return -1;
            }
            case 3: {
                if (level == 0) {
                    return 2;
                }
                return -1;
            }
            case 4: {
                if (level == 0) {
                    return 2;
                }
                return -1;
            }
        }
        return -1;
    }

    public int aggregateTagForDisplayLevel(int level) {
        switch (this._displayMode) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                if (level <= 1) {
                    return -1;
                }
                return 0;
            }
            case 3: {
                if (level == 0) {
                    return -1;
                }
                return 0;
            }
            case 4: {
                if (level == 0) {
                    return -1;
                }
                return 3;
            }
        }
        return -1;
    }

    public NSArray rootEventList() {
        if (null == this.events) {
            switch (this._displayMode) {
                case 0: 
                case 1: {
                    this.events = EOEventCenter.rootEventsForAllCenters();
                    break;
                }
                default: {
                    this.events = EOEventCenter.allEventsForAllCenters();
                }
            }
            this.events = EOEvent.groupEvents((NSArray)this.events, (int)this.groupTagForDisplayLevel(0));
            this.events = EOEvent.aggregateEvents((NSArray)this.events, (int)this.aggregateTagForDisplayLevel(0));
            this.events = this.filterEvents(this.events, 0);
        }
        return this.events;
    }

    public EOEvent object() {
        return this.currentEvent;
    }

    public NSArray childrenForEvent(EOEvent event) {
        int tag;
        NSArray anArray = (NSArray)this.cache.objectForKey((Object)event);
        if (null != anArray) {
            if (anArray.count() == 0) {
                return null;
            }
            return anArray;
        }
        anArray = event.subevents();
        if (anArray == null || anArray.count() == 0) {
            this.cache.setObjectForKey((Object)NSArray.EmptyArray, (Object)event);
            return null;
        }
        int level = this.displayLevelForEvent(event) + 1;
        if (level == -1) {
            level = this.selectionPath.count() + 1;
        }
        if ((tag = this.groupTagForDisplayLevel(level)) >= 0) {
            anArray = EOEvent.groupEvents((NSArray)anArray, (int)tag);
        }
        if ((tag = this.aggregateTagForDisplayLevel(level)) >= 0) {
            anArray = EOEvent.aggregateEvents((NSArray)anArray, (int)tag);
        }
        anArray = this.filterEvents(anArray, level);
        this.cache.setObjectForKey((Object)anArray, (Object)event);
        return anArray;
    }

    public NSArray currentEventChildren() {
        NSArray result = this.childrenForEvent(this.currentEvent);
        return result != null ? result : NSArray.EmptyArray;
    }

    public boolean isDirectory() {
        return this.currentEventChildren().count() > 0;
    }

    public WOComponent resetLoggingClicked() {
        EOEventCenter.resetLoggingForAllCenters();
        return this.refreshLoggingClicked();
    }

    public WOComponent refreshLoggingClicked() {
        this.cache.removeAllObjects();
        this.selectionPath = new NSMutableArray();
        this.events = null;
        this.webEvents = null;
        this.eofEvents = null;
        return null;
    }

    public String displayComponentName() {
        if (this.currentEvent == null) {
            return "";
        }
        return this.currentEvent.displayComponentName();
    }

    public int eventCount() {
        return EOEventCenter.allEventsForAllCenters().count();
    }

    public long topmostDurationValue() {
        NSArray roots = this.rootEventList();
        if (roots == null || roots.count() == 0) {
            return 0L;
        }
        return this.durationOfEvent((EOEvent)roots.objectAtIndex(0));
    }

    public long durationOfEvent(EOEvent e) {
        long sum;
        int n;
        if (this._displayMode != 4) {
            long sum2 = e.duration();
            return sum2;
        }
        NSArray kids = this.childrenForEvent(e);
        if (kids == null) {
            kids = NSArray.EmptyArray;
        }
        if ((n = kids.count()) != 0) {
            sum = 0L;
            for (int i = 0; i < n; ++i) {
                sum += ((EOEvent)kids.objectAtIndex(i)).duration();
            }
        } else {
            sum = e.duration();
        }
        return sum;
    }

    public void _cacheWebEofEvents() {
        if (this.webEvents != null) {
            return;
        }
        NSArray allCenters = EOEventCenter.allEventsForAllCenters();
        int halfCount = allCenters.count() / 2;
        this.webEvents = new NSMutableArray(halfCount);
        this.eofEvents = new NSMutableArray(halfCount);
        Enumeration anEnumerator = allCenters.objectEnumerator();
        while (anEnumerator.hasMoreElements()) {
            EOEvent e = (EOEvent)anEnumerator.nextElement();
            if (e instanceof WOEvent) {
                this.webEvents.addObject((Object)e);
                continue;
            }
            this.eofEvents.addObject((Object)e);
        }
    }

    public int webEventDuration() {
        this._cacheWebEofEvents();
        int n = this.webEvents != null ? this.webEvents.count() : 0;
        int time = 0;
        for (int i = 0; i < n; ++i) {
            EOEvent e = (EOEvent)this.webEvents.objectAtIndex(i);
            if (!(e instanceof WOEvent)) continue;
            time += (int)e.durationWithoutSubevents();
        }
        return time;
    }

    public int eofEventDuration() {
        this._cacheWebEofEvents();
        int n = this.eofEvents != null ? this.eofEvents.count() : 0;
        int time = 0;
        for (int i = 0; i < n; ++i) {
            EOEvent e = (EOEvent)this.eofEvents.objectAtIndex(i);
            if (e instanceof WOEvent) continue;
            time += (int)e.durationWithoutSubevents();
        }
        return time;
    }

    public int webEventCount() {
        this._cacheWebEofEvents();
        return this.webEvents != null ? this.webEvents.count() : 0;
    }

    public int eofEventCount() {
        this._cacheWebEofEvents();
        return this.eofEvents != null ? this.eofEvents.count() : 0;
    }

    public boolean isEmpty() {
        return this.eventCount() == 0;
    }
}

