/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.woextensions._WOJExtensionsUtil;

public class WOSimpleArrayDisplay
extends WOComponent {
    public NSArray list;
    public int numberToDisplay = -1;
    public String itemDisplayKey;
    public String listAction;
    public String listActionString;
    public Object currentItem;
    protected int _realSize;
    protected NSArray _subList;

    public WOSimpleArrayDisplay(WOContext aContext) {
        super(aContext);
    }

    public boolean isStateless() {
        return true;
    }

    public void reset() {
        this._invalidateCaches();
    }

    public NSArray list() {
        NSArray nSArray = this.list = this.list != null ? this.list : (NSArray)_WOJExtensionsUtil.valueForBindingOrNull("list", this);
        if (this.list == null) {
            throw new IllegalStateException("<" + ((Object)((Object)this)).getClass().getName() + " list binding required. list value is null or missing>");
        }
        return this.list;
    }

    public String itemDisplayKey() {
        if (null == this.itemDisplayKey && this.hasBinding("itemDisplayKey")) {
            this.itemDisplayKey = (String)_WOJExtensionsUtil.valueForBindingOrNull("itemDisplayKey", this);
        }
        return this.itemDisplayKey;
    }

    public String listAction() {
        if (null == this.listAction) {
            this.listAction = (String)_WOJExtensionsUtil.valueForBindingOrNull("listAction", this);
        }
        return this.listAction;
    }

    public String listActionString() {
        if (null == this.listActionString) {
            this.listActionString = (String)_WOJExtensionsUtil.valueForBindingOrNull("listActionString", this);
        }
        return this.listActionString;
    }

    public int numberToDisplay() {
        if (this.numberToDisplay == -1) {
            Object numStr = this.valueForBinding("numberToDisplay");
            if (numStr != null) {
                try {
                    this.numberToDisplay = Integer.parseInt(numStr.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("WOSimpleArrayDisplay - problem parsing int from numberToDisplay binding " + e);
                }
            } else {
                this.numberToDisplay = 5;
            }
            if (this.numberToDisplay <= 0) {
                throw new RuntimeException("<" + ((Object)((Object)this)).getClass().getName() + " numberToDisplay can not be <=0 !");
            }
        }
        return this.numberToDisplay;
    }

    public int realSize() {
        return this._realSize;
    }

    public NSArray subList() {
        if (null == this._subList) {
            this._realSize = this.list().count();
            if (this._realSize > this.numberToDisplay()) {
                int count = this.numberToDisplay();
                NSMutableArray aSubList = new NSMutableArray(count);
                for (int anIndex = 0; anIndex < count; ++anIndex) {
                    aSubList.addObject(this.list().objectAtIndex(anIndex));
                }
                this._subList = aSubList;
            } else {
                this._subList = this.list();
            }
        }
        return this._subList;
    }

    public String displayStringForItem() {
        String displayStringForItem = null;
        displayStringForItem = this.itemDisplayKey() != null ? (String)NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)this.currentItem, (String)this.itemDisplayKey()) : (String)NSKeyValueCoding.Utility.valueForKey((Object)this.currentItem, (String)"userPresentableDescription");
        return displayStringForItem;
    }

    public boolean isDisplayingSubset() {
        return this.realSize() > this.numberToDisplay();
    }

    public WOActionResults listActionClicked() {
        return this.performParentAction(this.listAction());
    }

    public boolean hasItems() {
        return this.list().count() != 0;
    }

    protected void _invalidateCaches() {
        this._subList = null;
        this.list = null;
        this.itemDisplayKey = null;
        this.listAction = null;
        this.listActionString = null;
        this.numberToDisplay = -1;
    }
}

