/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.woextensions;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSArray;
import com.webobjects.woextensions._WOJExtensionsUtil;

public class WOTable
extends WOComponent {
    protected NSArray _list;
    protected int _maxColumns;
    public int currentRow;
    public int currentCol;
    protected int _rowCount;
    protected int _colCount;

    public WOTable(WOContext aContext) {
        super(aContext);
        this._resetInternalCaches();
    }

    public boolean isStateless() {
        return true;
    }

    public NSArray list() {
        if (this._list == null) {
            this._list = (NSArray)_WOJExtensionsUtil.valueForBindingOrNull("list", this);
            if (this._list == null) {
                this._list = NSArray.EmptyArray;
            }
        }
        return this._list;
    }

    public int maxColumns() {
        if (this._maxColumns == -1) {
            Object maxStr = this.valueForBinding("maxColumns");
            if (maxStr != null) {
                try {
                    this._maxColumns = Integer.parseInt(maxStr.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("WOTable - problem parsing int from maxColumns binding " + e);
                }
            }
            if (this._maxColumns <= 0) {
                this._maxColumns = 1;
            }
        }
        return this._maxColumns;
    }

    public int rowCount() {
        if (this._rowCount == -1) {
            NSArray aList = this.list();
            int aMaxColCount = this.maxColumns();
            int aListCount = aList.count();
            int aRemainder = 0;
            if (aMaxColCount != 0) {
                this._rowCount = aListCount / aMaxColCount;
                aRemainder = aListCount % aMaxColCount;
            }
            if (aRemainder != 0) {
                ++this._rowCount;
            }
        }
        return this._rowCount;
    }

    public int colCount() {
        if (this._colCount == -1) {
            int aMaxColumns = this.maxColumns();
            NSArray aList = this.list();
            if (this.currentRow < this.rowCount() - 1) {
                this._colCount = aMaxColumns;
            } else {
                if (aMaxColumns != 0) {
                    this._colCount = aList.count() % aMaxColumns;
                }
                if (this._colCount == 0) {
                    this._colCount = aMaxColumns;
                }
            }
        }
        return this._colCount;
    }

    public void setCurrentRow(Number newValue) {
        if (newValue != null) {
            this.currentRow = newValue.intValue();
            this._colCount = -1;
            this.currentCol = -1;
        }
    }

    public void pushItem() {
        NSArray aList = this.list();
        int index = this.currentCol + this.maxColumns() * this.currentRow;
        Object item = index < aList.count() ? aList.objectAtIndex(index) : null;
        this.setValueForBinding(item, "item");
        if (this.canSetValueForBinding("row")) {
            this.setValueForBinding(new Integer(this.currentRow), "row");
        }
        if (this.canSetValueForBinding("col")) {
            this.setValueForBinding(new Integer(this.currentCol), "col");
        }
        if (this.canSetValueForBinding("index")) {
            this.setValueForBinding(new Integer(index), "index");
        }
    }

    public void setCurrentCol(Number newValue) {
        this.currentCol = newValue.intValue();
        this.pushItem();
    }

    protected void _resetInternalCaches() {
        this._list = null;
        this._rowCount = -1;
        this._colCount = -1;
        this.currentCol = -1;
        this.currentRow = -1;
        this._maxColumns = -1;
    }

    public void takeValuesFromRequest(WORequest aRequest, WOContext aContext) {
        this._resetInternalCaches();
        super.takeValuesFromRequest(aRequest, aContext);
    }

    public void reset() {
        this._resetInternalCaches();
    }
}

