/*
 * Decompiled with CFR 0.152.
 */
package er.profiling;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import er.profiling.PFProfilerRequestHandler;
import er.profiling.PFStatsNode;
import er.profiling.delegates.PFHeatMap;
import er.profiling.delegates.PFMarkup;
import er.profiling.delegates.PFSummary;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PFProfiler {
    private static ThreadLocal<PFStatsNode> _currentStats = new ThreadLocal();
    private static Map<String, PFStatsNode> _stats = new LRUMap<String, PFStatsNode>(30);
    private static List<Delegate> _delegates = new LinkedList<Delegate>();
    private static long _statsID = 0L;

    public static synchronized long nextStatsID() {
        return _statsID++;
    }

    public static void setCurrentStats(PFStatsNode stats) {
        _currentStats.set(stats);
    }

    public static PFStatsNode currentStats() {
        return _currentStats.get();
    }

    public static void startRequest(WORequest request) {
        _currentStats.set(new PFStatsNode("request", null, request, null));
        _currentStats.get().start();
        for (Delegate delegate : _delegates) {
            delegate.requestStarted(request);
        }
    }

    public static void endRequest(WORequest request) {
        for (Delegate delegate : _delegates) {
            delegate.requestEnded(request);
        }
    }

    public static void pushStats(String name, String type, Object target, Object context) {
        PFStatsNode currentStats = _currentStats.get();
        if (currentStats != null) {
            currentStats.push(name, type, target, context);
        }
    }

    public static PFStatsNode popStats() {
        PFStatsNode currentStats = _currentStats.get();
        if (currentStats != null) {
            currentStats.pop();
        }
        return currentStats;
    }

    public static void incrementCounter(String counterName) {
        PFStatsNode currentStats = _currentStats.get();
        if (currentStats != null) {
            currentStats.incrementCounter(counterName);
        }
    }

    public static void willAppendToResponse(WOElement element, WOResponse response, WOContext context) {
        for (Delegate delegate : _delegates) {
            delegate.willAppendToResponse(element, response, context);
        }
    }

    public static void didAppendToResponse(WOElement element, WOResponse response, WOContext context) {
        PFStatsNode stats = _currentStats.get();
        if (stats != null) {
            stats.end();
        }
        for (Delegate delegate : _delegates) {
            delegate.didAppendToResponse(element, response, context);
        }
        if (stats != null && stats.parentStats().isRoot()) {
            for (Delegate delegate : _delegates) {
                delegate.responseEnded(response, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStatsWithID(PFStatsNode stats, String id) {
        Map<String, PFStatsNode> map = _stats;
        synchronized (map) {
            _stats.put(id, stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PFStatsNode statsWithID(String id) {
        Map<String, PFStatsNode> map = _stats;
        synchronized (map) {
            return _stats.get(id);
        }
    }

    public static void registerRequestHandler() {
        WOApplication.application().registerRequestHandler((WORequestHandler)new PFProfilerRequestHandler(), "profiler");
    }

    static {
        _delegates.add(new PFSummary());
        _delegates.add(new PFMarkup());
        _delegates.add(new PFHeatMap());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LRUMap<U, V>
    extends LinkedHashMap<U, V> {
        private int _maxSize;

        public LRUMap(int maxSize) {
            super(16, 0.75f, true);
            this._maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<U, V> eldest) {
            return this.size() > this._maxSize;
        }
    }

    public static interface Delegate {
        public void requestStarted(WORequest var1);

        public void requestEnded(WORequest var1);

        public void responseEnded(WOResponse var1, WOContext var2);

        public void willAppendToResponse(WOElement var1, WOResponse var2, WOContext var3);

        public void didAppendToResponse(WOElement var1, WOResponse var2, WOContext var3);
    }
}

