/*
 * Decompiled with CFR 0.152.
 */
package er.profiling.delegates;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import er.profiling.PFProfiler;
import er.profiling.PFStatsNode;
import er.profiling.delegates.PFHeatMap;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class PFMarkup
implements PFProfiler.Delegate {
    private static Pattern _tagPattern = Pattern.compile("<[a-zA-Z]+[ />]?", 8);
    private static final String _marker = "~~PROFILER_MARKER~~";
    private boolean _markupEnabled;
    private ThreadLocal<List<MarkerStats>> _markerList = new ThreadLocal();
    private Field _contentField;

    public void requestStarted(WORequest request) {
        this._markupEnabled = PFHeatMap.isHeatEnabled();
        this._markerList.set(new LinkedList());
        try {
            this._contentField = WOMessage.class.getDeclaredField("_content");
            this._contentField.setAccessible(true);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to load the _content field of WOMessage.", t);
        }
    }

    public void requestEnded(WORequest request) {
    }

    public void responseEnded(WOResponse response, WOContext context) {
    }

    protected static void append(Object content, String str) {
        if (content instanceof StringBuffer) {
            ((StringBuffer)content).append(str);
        } else if (content instanceof StringBuilder) {
            ((StringBuilder)content).append(str);
        } else {
            throw new IllegalArgumentException("Don't know how to append to '" + content + "'.");
        }
    }

    protected static void insert(Object content, int index, String str) {
        if (content instanceof StringBuffer) {
            ((StringBuffer)content).insert(index, str);
        } else if (content instanceof StringBuilder) {
            ((StringBuilder)content).insert(index, str);
        } else {
            throw new IllegalArgumentException("Don't know how to insert into '" + content + "'.");
        }
    }

    protected static void replace(Object content, int start, int end, String str) {
        if (content instanceof StringBuffer) {
            ((StringBuffer)content).replace(start, end, str);
        } else if (content instanceof StringBuilder) {
            ((StringBuilder)content).replace(start, end, str);
        } else {
            throw new IllegalArgumentException("Don't know how to replace strings in '" + content + "'.");
        }
    }

    protected static int indexOf(Object content, String str, int fromIndex) {
        if (content instanceof StringBuffer) {
            return ((StringBuffer)content).indexOf(str, fromIndex);
        }
        if (content instanceof StringBuilder) {
            return ((StringBuilder)content).indexOf(str, fromIndex);
        }
        throw new IllegalArgumentException("Don't know how to insert into '" + content + "'.");
    }

    protected static boolean regionMatches(CharSequence str, int toffset, String other, int ooffset, int len) {
        int to = toffset;
        int po = ooffset;
        int count = str.length();
        int otherCount = other.length();
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)count - (long)len || (long)ooffset > (long)otherCount - (long)len) {
            return false;
        }
        while (len-- > 0) {
            if (str.charAt(to++) == other.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    public void willAppendToResponse(WOElement element, WOResponse response, WOContext context) {
        if (this._markupEnabled) {
            try {
                MarkerStats ms = new MarkerStats();
                ms._stats = PFProfiler.currentStats();
                Object content = this._contentField.get(response);
                if (content != null) {
                    ms._index = ((CharSequence)content).length();
                    PFMarkup.append(content, _marker);
                }
                this._markerList.get().add(ms);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to get the length of the response.", t);
            }
        }
    }

    public void didAppendToResponse(WOElement element, WOResponse response, WOContext context) {
        if (this._markupEnabled) {
            try {
                CharSequence contentStr = (CharSequence)this._contentField.get(response);
                if (contentStr != null) {
                    List<MarkerStats> markerList = this._markerList.get();
                    MarkerStats markerStats = markerList.remove(markerList.size() - 1);
                    int startIndex = markerStats._index;
                    int markerIndex = PFMarkup.indexOf(contentStr, _marker, startIndex);
                    if (markerIndex != -1) {
                        PFMarkup.replace(contentStr, markerIndex, markerIndex + _marker.length(), "");
                        startIndex = markerIndex;
                        int tagIndex = -1;
                        int endIndex = contentStr.length();
                        for (int i = startIndex; i < endIndex; ++i) {
                            char ch = contentStr.charAt(i);
                            if (ch != '<' || i >= endIndex - 1 || contentStr.charAt(i + 1) == '/') continue;
                            tagIndex = i;
                            break;
                        }
                        if (tagIndex != -1) {
                            int attributeOffset = -1;
                            boolean spacesFound = false;
                            for (int i = tagIndex; i < endIndex; ++i) {
                                char ch = contentStr.charAt(i);
                                if (ch == ' ') {
                                    spacesFound = true;
                                    continue;
                                }
                                if (ch == '>' || ch == '/') {
                                    if (attributeOffset <= tagIndex + 1) break;
                                    attributeOffset = i;
                                    break;
                                }
                                if (!spacesFound) continue;
                                attributeOffset = i;
                                break;
                            }
                            if (attributeOffset != -1) {
                                String profilerID = markerStats._stats.cssID();
                                String profilerIDAttributeName = "class";
                                if (PFMarkup.regionMatches(contentStr, attributeOffset, profilerIDAttributeName, 0, profilerIDAttributeName.length())) {
                                    int openQuoteIndex = PFMarkup.indexOf(contentStr, "\"", attributeOffset);
                                    if (openQuoteIndex != -1) {
                                        PFMarkup.insert(contentStr, openQuoteIndex + 1, profilerID + " ");
                                    }
                                } else {
                                    PFMarkup.insert(contentStr, attributeOffset, " " + profilerIDAttributeName + "=\"" + profilerID + "\" ");
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to replace markers in the response.", t);
            }
        }
    }

    protected static class MarkerStats {
        public PFStatsNode _stats;
        public int _index;

        protected MarkerStats() {
        }
    }
}

