/*
 * Decompiled with CFR 0.152.
 */
package er.jgroups;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXDatabase;
import er.extensions.eof.ERXObjectStoreCoordinatorSynchronizer;
import er.extensions.foundation.ERXProperties;
import er.extensions.remoteSynchronizer.ERXRemoteSynchronizer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public class ERJGroupsSynchronizer
extends ERXRemoteSynchronizer {
    private String _groupName;
    private JChannel _channel;

    public ERJGroupsSynchronizer(ERXObjectStoreCoordinatorSynchronizer.IChangeListener listener) throws ChannelException {
        super(listener);
        String jgroupsPropertiesFile = ERXProperties.stringForKey((String)"er.extensions.jgroupsSynchronizer.properties");
        String jgroupsPropertiesFramework = null;
        if (jgroupsPropertiesFile == null) {
            jgroupsPropertiesFile = "jgroups-default.xml";
            jgroupsPropertiesFramework = "ERJGroupsSynchronizer";
        }
        this._groupName = ERXProperties.stringForKeyWithDefault((String)"er.extensions.jgroupsSynchronizer.groupName", (String)WOApplication.application().name());
        String localBindAddressStr = ERXProperties.stringForKey((String)"er.extensions.jgroupsSynchronizer.localBindAddress");
        if (localBindAddressStr == null) {
            System.setProperty("bind.address", WOApplication.application().hostAddress().getHostAddress());
        } else {
            System.setProperty("bind.address", localBindAddressStr);
        }
        URL propertiesUrl = WOApplication.application().resourceManager().pathURLForResourceNamed(jgroupsPropertiesFile, jgroupsPropertiesFramework, null);
        this._channel = new JChannel(propertiesUrl);
        this._channel.setOpt(3, (Object)Boolean.FALSE);
        if (ERXProperties.booleanForKeyWithDefault((String)"er.extensions.jgroupsSynchronizer.autoReconnect", (boolean)true)) {
            this._channel.setOpt(5, (Object)Boolean.TRUE);
        }
        this._registerForCleanup();
    }

    public void join() throws ChannelException {
        this._channel.connect(this._groupName);
    }

    public void leave() {
        this._channel.disconnect();
    }

    public void listen() {
        this._channel.setReceiver((Receiver)new ExtendedReceiverAdapter(){

            public void receive(Message message) {
                try {
                    byte[] buffer = message.getBuffer();
                    ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                    DataInputStream dis = new DataInputStream(bais);
                    int transactionCount = dis.readInt();
                    ERXObjectStoreCoordinatorSynchronizer.RemoteChange remoteChange = new ERXObjectStoreCoordinatorSynchronizer.RemoteChange("AnotherInstance", -1, transactionCount);
                    for (int transactionNum = 0; transactionNum < transactionCount; ++transactionNum) {
                        ERJGroupsSynchronizer.this._readCacheChange(remoteChange, dis);
                    }
                    ERJGroupsSynchronizer.this.addChange(remoteChange);
                    if (ERXRemoteSynchronizer.log.isInfoEnabled()) {
                        ERXRemoteSynchronizer.log.info((Object)("Received " + transactionCount + " changes from " + message.getSrc()));
                    }
                    if (ERXRemoteSynchronizer.log.isDebugEnabled()) {
                        ERXRemoteSynchronizer.log.info((Object)("  Changes = " + remoteChange.remoteCacheChanges()));
                    }
                }
                catch (IOException e) {
                    ERXRemoteSynchronizer.log.error((Object)"Failed to apply remote changes.  This is bad.", (Throwable)e);
                }
            }

            public void viewAccepted(View view) {
            }
        });
    }

    protected void _writeCacheChanges(int transactionID, NSArray cacheChanges) throws ChannelNotConnectedException, ChannelClosedException, IOException {
        if (!this._channel.isConnected()) {
            if (ERXRemoteSynchronizer.log.isInfoEnabled()) {
                ERXRemoteSynchronizer.log.info((Object)("Channel not connected: Not Sending " + cacheChanges.count() + " changes."));
            }
            if (ERXRemoteSynchronizer.log.isDebugEnabled()) {
                ERXRemoteSynchronizer.log.info((Object)("Channel not connected: Changes = " + cacheChanges));
            }
            return;
        }
        if (cacheChanges.count() == 0) {
            if (ERXRemoteSynchronizer.log.isInfoEnabled()) {
                ERXRemoteSynchronizer.log.info((Object)"No changes to send!");
            }
            return;
        }
        ERXRemoteSynchronizer.RefByteArrayOutputStream baos = new ERXRemoteSynchronizer.RefByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream((OutputStream)baos);
        dos.writeInt(cacheChanges.count());
        Enumeration cacheChangesEnum = cacheChanges.objectEnumerator();
        while (cacheChangesEnum.hasMoreElements()) {
            ERXDatabase.CacheChange cacheChange = (ERXDatabase.CacheChange)cacheChangesEnum.nextElement();
            this._writeCacheChange(dos, cacheChange);
        }
        dos.flush();
        dos.close();
        if (ERXRemoteSynchronizer.log.isInfoEnabled()) {
            ERXRemoteSynchronizer.log.info((Object)("Sending " + cacheChanges.count() + " changes."));
        }
        if (ERXRemoteSynchronizer.log.isDebugEnabled()) {
            ERXRemoteSynchronizer.log.info((Object)("  Changes = " + cacheChanges));
        }
        Message message = new Message(null, null, baos.buffer(), 0, baos.size());
        this._channel.send(message);
    }

    private void _registerForCleanup() {
        String notificationName = ERXProperties.stringForKey((String)"er.extensions.jgroupsSynchronizer.applicationWillTerminateNotificationName");
        if (notificationName != null && notificationName.length() > 0) {
            NSSelector applicationLaunchedNotification = new NSSelector("_applicationWillTerminateNotification", new Class[]{NSNotification.class});
            NSNotificationCenter.defaultCenter().addObserver((Object)this, applicationLaunchedNotification, notificationName, null);
        }
        if (ERXProperties.booleanForKeyWithDefault((String)"er.extensions.jgroupsSynchronizer.useShutdownHook", (boolean)true)) {
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new JGroupsCleanupTask(this._channel), "ERJGroupsCleanupThread"));
        }
    }

    private static void cleanUpJChannel(JChannel channel) {
        try {
            if (channel == null || !channel.isOpen()) {
                return;
            }
            if (channel.isConnected()) {
                channel.disconnect();
            }
            channel.close();
        }
        catch (Throwable e) {
            ERXRemoteSynchronizer.log.error((Object)("Error closing JChannel: " + channel), e);
        }
    }

    public void _applicationWillTerminateNotification(NSNotification notification) {
        try {
            ERJGroupsSynchronizer.cleanUpJChannel(this._channel);
        }
        catch (Throwable e) {
            ERXRemoteSynchronizer.log.error((Object)"Error cleaning up ERJgroupsSynchronizer JChannel", e);
        }
    }

    private static class JGroupsCleanupTask
    implements Runnable {
        private final JChannel channel;

        public JGroupsCleanupTask(JChannel channel) {
            this.channel = channel;
        }

        public void run() {
            ERJGroupsSynchronizer.cleanUpJChannel(this.channel);
        }
    }
}

