/*
 * Decompiled with CFR 0.152.
 */
package er.pdf.builder;

import com.lowagie.text.DocumentException;
import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.foundation.ERXProperties;
import er.pdf.builder.ERPDFReplacedElementFactory;
import er.pdf.builder.PDFBuilder;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.resource.FSEntityResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlyingSaucerImpl
implements PDFBuilder {
    private static final DocumentBuilderFactory _builderFactory = DocumentBuilderFactory.newInstance();
    private ITextRenderer renderer = new ITextRenderer();
    private Document doc;
    private ErrorHandler errorHandler = new ErrorHandler(){

        public void error(SAXParseException e) throws SAXException {
            FlyingSaucerImpl.this.exception = e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            FlyingSaucerImpl.this.exception = e;
        }

        public void warning(SAXParseException e) throws SAXException {
            FlyingSaucerImpl.this.exception = e;
        }
    };
    private SAXParseException exception;

    public FlyingSaucerImpl() {
        ERPDFReplacedElementFactory ref = new ERPDFReplacedElementFactory(this.renderer.getOutputDevice());
        this.renderer.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)ref);
    }

    @Override
    public void createDocument(OutputStream os) {
        try {
            this.renderer.createPDF(os);
        }
        catch (DocumentException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    @Override
    public void setSource(String document, String encoding, String urlPrefix, NSDictionary<String, Object> configuration) throws UnsupportedEncodingException {
        DocumentBuilder builder;
        try {
            this.exception = null;
            builder = _builderFactory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)FSEntityResolver.instance());
            builder.setErrorHandler(this.errorHandler);
        }
        catch (ParserConfigurationException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(document.getBytes(encoding));
        ITextFontResolver resolver = this.renderer.getFontResolver();
        for (String font : this.fontsFromConfiguration(configuration)) {
            try {
                resolver.addFont(font, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.doc = builder.parse(is);
            if (this.exception != null) {
                throw this.exception;
            }
            this.renderer.setDocument(this.doc, urlPrefix);
            this.renderer.layout();
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    private NSArray<String> fontsFromConfiguration(NSDictionary<String, Object> configuration) {
        if (configuration == null) {
            return NSArray.emptyArray();
        }
        NSArray fonts = (NSArray)configuration.objectForKey((Object)"fonts");
        NSMutableArray result = new NSMutableArray();
        String framework = (String)configuration.objectForKey((Object)"framework");
        if (fonts != null) {
            for (String font : fonts) {
                URL path = WOApplication.application().resourceManager().pathURLForResourceNamed(font, framework, null);
                if (path == null) continue;
                result.addObject((Object)path.getFile());
            }
        }
        return result;
    }

    static {
        _builderFactory.setValidating(ERXProperties.booleanForKeyWithDefault((String)"er.pdf.validation", (boolean)false));
        _builderFactory.setNamespaceAware(true);
        _builderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
    }
}

