/*
 * Decompiled with CFR 0.152.
 */
package er.pdf.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ERPDF2PS
extends ERXStatelessComponent {
    public static final String PDF_TO_PS_KEY = "er.pdf.pdftops";
    private String pdftops = ERXProperties.stringForKeyWithDefault((String)"er.pdf.pdftops", (String)"/usr/local/bin/pdftops");

    public ERPDF2PS(WOContext context) {
        super(context);
    }

    public boolean duplex() {
        return this.booleanValueForBinding("duplex", false);
    }

    public boolean enabled() {
        return this.booleanValueForBinding("enabled", true);
    }

    public void appendToResponse(WOResponse response, WOContext aContext) {
        super.appendToResponse(response, aContext);
        if (this.enabled()) {
            File tempFile = null;
            File psFile = null;
            try {
                NSData content = response.content();
                tempFile = File.createTempFile("pdftops", "pdf");
                tempFile.deleteOnExit();
                psFile = File.createTempFile("pdftops", "ps");
                psFile.deleteOnExit();
                NSMutableArray array = new NSMutableArray((Object)this.pdftops, (Object[])new String[]{"-expand", tempFile.getPath(), psFile.getPath()});
                if (this.duplex()) {
                    array.add(1, (Object)"-duplex");
                }
                content.writeToStream((OutputStream)new FileOutputStream(tempFile));
                Process process = Runtime.getRuntime().exec((String[])array.toArray((Object[])new String[array.size()]));
                process.waitFor();
                NSData data = new NSData((InputStream)new FileInputStream(psFile), 4096);
                String header = response.headerForKey((Object)"content-disposition");
                response.setHeader(header.replace(".pdf", ".ps"), "content-disposition");
                response.setHeader("application/postscript", "Content-Type");
                response.setHeader(String.valueOf(data.length()), "Content-Length");
                response.setContent(data);
            }
            catch (FileNotFoundException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (InterruptedException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            finally {
                if (tempFile != null) {
                    try {
                        tempFile.delete();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
                if (psFile != null) {
                    try {
                        psFile.delete();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

