/*
 * Decompiled with CFR 0.152.
 */
package er.captcha;

import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaStore;
import com.octo.captcha.service.captchastore.FastHashMapCaptchaStore;
import com.octo.captcha.service.image.DefaultManageableImageCaptchaService;
import com.octo.captcha.service.image.ImageCaptchaService;
import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSData;
import er.captcha.ERCaptchaEngine;
import er.extensions.foundation.ERXProperties;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class ERCaptcha
extends WOComponent {
    private static final Logger log = Logger.getLogger(ERCaptcha.class);
    private static ImageCaptchaService _captchaService;
    private NSData _captcha;
    private String _response;

    public static ImageCaptchaService captchaService() {
        try {
            if (_captchaService == null) {
                String captchaEngineClass = ERXProperties.stringForKeyWithDefault((String)"er.captcha.captchaEngineClass", (String)ERCaptchaEngine.class.getName());
                CaptchaEngine captchaEngine = (CaptchaEngine)Class.forName(captchaEngineClass).newInstance();
                _captchaService = new DefaultManageableImageCaptchaService((CaptchaStore)new FastHashMapCaptchaStore(), captchaEngine, 180, 100000, 75000);
            }
            return _captchaService;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialize captcha engine.", t);
        }
    }

    public ERCaptcha(WOContext context) {
        super(context);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void setCaptcha(NSData captcha) {
        this._captcha = captcha;
    }

    public NSData captcha() {
        return this._captcha;
    }

    public String mimeType() {
        return "image/jpeg";
    }

    public void setResponse(String response) {
        this._response = response;
    }

    public String response() {
        return this._response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeValuesFromRequest(WORequest request, WOContext context) {
        super.takeValuesFromRequest(request, context);
        if (context._wasFormSubmitted()) {
            Boolean validated = Boolean.FALSE;
            try {
                validated = ERCaptcha.captchaService().validateResponseForID(context.elementID(), (Object)this._response);
            }
            catch (CaptchaServiceException e) {
                log.error((Object)"Captcha service failed.", (Throwable)e);
            }
            finally {
                this._captcha = null;
            }
            this.setValueForBinding(validated, "validated");
        }
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        if (this._captcha == null) {
            Object captchaChallengeAsJpeg = null;
            ByteArrayOutputStream captchaOutputStream = new ByteArrayOutputStream();
            try {
                BufferedImage challenge = ERCaptcha.captchaService().getImageChallengeForID(context.elementID());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)challenge, "jpg", baos);
                this._captcha = new NSData(baos.toByteArray());
            }
            catch (Throwable e) {
                log.error((Object)"Failed to create JPEG for Captcha.", e);
            }
        }
        super.appendToResponse(response, context);
    }

    public WOActionResults resetCaptcha() {
        this._captcha = null;
        return null;
    }
}

