/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSLocking;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSUtilities;
import java.lang.ref.WeakReference;

public class NSRecursiveLock
implements NSLocking {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSRecursiveLock");
    protected WeakReference _owner;
    protected long _recursionCount;
    protected short _waitingThreads;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Thread caller = Thread.currentThread();
        NSRecursiveLock nSRecursiveLock = this;
        synchronized (nSRecursiveLock) {
            Thread owner;
            Thread thread = owner = this._owner != null ? (Thread)this._owner.get() : null;
            if (caller != owner) {
                this._waitingThreads = (short)(this._waitingThreads + 1);
                while (this._owner != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        NSLog._conditionallyLogPrivateException(ex);
                        this.notify();
                    }
                }
                this._waitingThreads = (short)(this._waitingThreads - 1);
                this._owner = new WeakReference<Thread>(caller);
            }
            ++this._recursionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        Thread caller = Thread.currentThread();
        NSRecursiveLock nSRecursiveLock = this;
        synchronized (nSRecursiveLock) {
            Thread owner;
            Thread thread = owner = this._owner != null ? (Thread)this._owner.get() : null;
            if (caller == owner || owner == null) {
                ++this._recursionCount;
                this._owner = new WeakReference<Thread>(caller);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _verifyLock() {
        Thread caller = Thread.currentThread();
        NSRecursiveLock nSRecursiveLock = this;
        synchronized (nSRecursiveLock) {
            Thread owner = this._owner != null ? (Thread)this._owner.get() : null;
            return caller == owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLock(long msecs) {
        Thread caller = Thread.currentThread();
        NSRecursiveLock nSRecursiveLock = this;
        synchronized (nSRecursiveLock) {
            Thread owner;
            Thread thread = owner = this._owner != null ? (Thread)this._owner.get() : null;
            if (caller == owner || owner == null) {
                this._owner = new WeakReference<Thread>(caller);
                ++this._recursionCount;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            this._waitingThreads = (short)(this._waitingThreads + 1);
            try {
                do {
                    this.wait(waitTime);
                    if (this._owner != null) continue;
                    this._owner = new WeakReference<Thread>(caller);
                    ++this._recursionCount;
                    boolean bl = true;
                    return bl;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException ex) {
                NSLog._conditionallyLogPrivateException(ex);
                this.notify();
                boolean bl = false;
                return bl;
            }
            finally {
                this._waitingThreads = (short)(this._waitingThreads - 1);
            }
        }
    }

    public boolean tryLock(NSTimestamp timestamp) {
        return this.tryLock(timestamp.getTime() - System.currentTimeMillis());
    }

    public boolean lockBeforeDate(NSTimestamp timestamp) {
        return this.tryLock(timestamp);
    }

    public synchronized void unlock() {
        Thread owner;
        Thread thread = owner = this._owner != null ? (Thread)this._owner.get() : null;
        if (owner != null && Thread.currentThread() != owner) {
            throw new IllegalStateException("Illegal Lock usage: unlocking thread not owner.");
        }
        if (owner == null || this._recursionCount == 0L) {
            throw new IllegalStateException("Illegal Lock usage: unlock() called without a lock().");
        }
        if (--this._recursionCount == 0L) {
            this._owner = null;
            if (this._waitingThreads > 0) {
                this.notify();
            }
        }
    }

    public synchronized void unlock(long n) {
        Thread owner;
        if (n < 0L) {
            throw new IllegalStateException("Illegal Lock usage: unlock(n) called with n<0!");
        }
        Thread thread = owner = this._owner != null ? (Thread)this._owner.get() : null;
        if (owner != null && Thread.currentThread() != owner) {
            throw new IllegalStateException("Illegal Lock usage: unlocking thread not owner.");
        }
        this._recursionCount -= n;
        if (this._recursionCount <= 0L) {
            this._owner = null;
            if (this._waitingThreads > 0) {
                this.notify();
            }
            if (this._recursionCount < 0L) {
                this._recursionCount = 0L;
                throw new IllegalStateException("Illegal Lock usage: unlock() called without a lock().");
            }
        }
    }

    public synchronized long recursionCount() {
        Thread owner;
        Thread thread = owner = this._owner != null ? (Thread)this._owner.get() : null;
        if (this._recursionCount == 0L || Thread.currentThread() != owner) {
            return 0L;
        }
        return this._recursionCount;
    }

    public String toString() {
        Thread owner = this._owner != null ? (Thread)this._owner.get() : null;
        return "<" + this.getClass().getName() + "> owner: " + owner + " recursion count:" + this._recursionCount;
    }
}

