/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.xml;

import com.webobjects.foundation.xml.NSXMLObjectStreamConstants;
import com.webobjects.foundation.xml._NSArrayTxr;
import com.webobjects.foundation.xml._NSClassTxr;
import com.webobjects.foundation.xml._NSDataTxr;
import com.webobjects.foundation.xml._NSFieldTxr;
import com.webobjects.foundation.xml._NSObjectTxr;
import com.webobjects.foundation.xml._NSProxyTxr;
import com.webobjects.foundation.xml._NSStringTxr;
import com.webobjects.foundation.xml._NSTagTransformer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

final class _NSTransformHandler
implements ContentHandler,
LexicalHandler,
NSXMLObjectStreamConstants {
    private OutputStream _transformedData = new ByteArrayOutputStream();
    private _NSTagTransformer _curTagTxr;
    private static HashMap tag2Handler;
    private StringBuffer _curChars;
    BlockDataOutputStream _bdos = new BlockDataOutputStream(this._transformedData);

    public void write(byte[] b) throws IOException {
        this._transformedData.write(b);
    }

    public void write(byte v) throws IOException {
        this._transformedData.write(v);
    }

    public static void write(byte v, OutputStream os) throws IOException {
        os.write(v);
    }

    public void write(short v) throws IOException {
        _NSTransformHandler.write(v, this._transformedData);
    }

    public static void write(short v, OutputStream os) throws IOException {
        os.write((byte)(v >>> 8));
        os.write((byte)v);
    }

    public void write(char v) throws IOException {
        _NSTransformHandler.write(v, this._transformedData);
    }

    public static void write(char v, OutputStream os) throws IOException {
        os.write((byte)(v >>> 8));
        os.write((byte)v);
    }

    public void write(int v) throws IOException {
        _NSTransformHandler.write(v, this._transformedData);
    }

    public static void write(int v, OutputStream os) throws IOException {
        os.write((byte)(v >>> 24));
        os.write((byte)(v >>> 16));
        os.write((byte)(v >>> 8));
        os.write((byte)v);
    }

    public void write(long v) throws IOException {
        _NSTransformHandler.write(v, this._transformedData);
    }

    public static void write(long v, OutputStream os) throws IOException {
        os.write((byte)(v >>> 56));
        os.write((byte)(v >>> 48));
        os.write((byte)(v >>> 40));
        os.write((byte)(v >>> 32));
        os.write((byte)(v >>> 24));
        os.write((byte)(v >>> 16));
        os.write((byte)(v >>> 8));
        os.write((byte)v);
    }

    public void write(float v) throws IOException {
        _NSTransformHandler.write(v, this._transformedData);
    }

    public static void write(float v, OutputStream os) throws IOException {
        int i = Float.floatToIntBits(v);
        os.write((byte)(i >>> 24));
        os.write((byte)(i >>> 16));
        os.write((byte)(i >>> 8));
        os.write((byte)i);
    }

    public void write(double v) throws IOException {
        _NSTransformHandler.write(v, this._transformedData);
    }

    public static void write(double v, OutputStream os) throws IOException {
        long l = Double.doubleToLongBits(v);
        os.write((byte)(l >>> 56));
        os.write((byte)(l >>> 48));
        os.write((byte)(l >>> 40));
        os.write((byte)(l >>> 32));
        os.write((byte)(l >>> 24));
        os.write((byte)(l >>> 16));
        os.write((byte)(l >>> 8));
        os.write((byte)l);
    }

    public void write(String s) throws IOException {
        _NSTransformHandler.write(s, this._transformedData);
    }

    public static void write(String s, OutputStream os) throws IOException {
        byte[] b = s.getBytes("UTF-8");
        if (b.length <= 65535) {
            _NSTransformHandler.write((short)b.length, os);
        } else {
            _NSTransformHandler.write((long)b.length, os);
        }
        os.write(b);
    }

    public void writeReference(String referenceStr) throws IOException {
        _NSTransformHandler.writeReference(referenceStr, this._transformedData);
    }

    public static void writeReference(String referenceStr, OutputStream os) throws IOException {
        _NSTransformHandler.write((byte)113, os);
        try {
            int ref = Integer.parseInt(referenceStr);
            _NSTransformHandler.write(0x7E0000 + ref, os);
        }
        catch (NumberFormatException e) {
            throw new StreamCorruptedException(e.getMessage());
        }
    }

    public _NSTransformHandler() throws IOException {
        this._bdos.setBlockDataMode(true);
        tag2Handler = new HashMap();
        tag2Handler.put("content", new _NSDataTxr(this));
        _NSClassTxr classTxr = new _NSClassTxr(this);
        tag2Handler.put("class", classTxr);
        tag2Handler.put("super", classTxr);
        tag2Handler.put("field", new _NSFieldTxr(this, classTxr));
        _NSProxyTxr proxyTxr = new _NSProxyTxr(this);
        tag2Handler.put("proxy", proxyTxr);
        tag2Handler.put("interface", new _NSProxyTxr._NSInterfaceTxr(this, proxyTxr));
        tag2Handler.put("object", new _NSObjectTxr(this));
        tag2Handler.put("array", new _NSArrayTxr(this));
        _NSStringTxr stringTxr = new _NSStringTxr(this);
        tag2Handler.put("string", stringTxr);
        tag2Handler.put("finalException", new _NSExceptionTxr(this));
        tag2Handler.put("boolean", new _NSBoolTxr(this));
        tag2Handler.put("byte", new _NSByteTxr(this));
        tag2Handler.put("short", new _NSShortTxr(this));
        tag2Handler.put("ch", new _NSCharTxr(this, stringTxr));
        tag2Handler.put("int", new _NSIntTxr(this));
        tag2Handler.put("long", new _NSLongTxr(this));
        tag2Handler.put("float", new _NSFloatTxr(this));
        tag2Handler.put("double", new _NSDoubleTxr(this));
    }

    public OutputStream transformedData() {
        return this._transformedData;
    }

    public String previousPartOfString() {
        return this._curChars.toString();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this._curChars = new StringBuffer();
    }

    public void endDocument() throws SAXException {
        try {
            this._transformedData.flush();
            this._transformedData.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        try {
            this._curTagTxr = (_NSTagTransformer)tag2Handler.get(rawName);
            if (this._curTagTxr != null) {
                this._curTagTxr.handleStart(rawName, atts);
                this._curChars = new StringBuffer();
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        try {
            _NSTagTransformer tagHandler = (_NSTagTransformer)tag2Handler.get(rawName);
            if (tagHandler != null) {
                tagHandler.handleEnd(rawName, this._curChars.toString());
                this._curChars = new StringBuffer();
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this._curChars.append(ch, start, length);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    static final class _NSExceptionTxr
    extends _NSTagTransformer {
        public _NSExceptionTxr(_NSTransformHandler handler) {
            super(handler);
        }

        public void handleStart(String tag, Attributes attributes) throws IOException {
            this.handler._bdos.setBlockDataMode(false);
            this.handler.write((byte)123);
            this.handler.write((byte)115);
        }

        public void handleEnd(String tag, String data) throws IOException {
            this.handler._bdos.setBlockDataMode(true);
        }
    }

    static final class _NSDoubleTxr
    extends _NSPrimitiveTxr {
        public _NSDoubleTxr(_NSTransformHandler handler) {
            super(handler);
        }

        public void handleEnd(String tag, String data) throws IOException {
            try {
                double v = Double.parseDouble(data);
                if (this.objectValue) {
                    this.handler.write(v);
                } else {
                    this.handler._bdos.writeDouble(v);
                }
            }
            catch (NumberFormatException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
            this.writeEndDataBlock();
        }
    }

    static final class _NSFloatTxr
    extends _NSPrimitiveTxr {
        public _NSFloatTxr(_NSTransformHandler handler) {
            super(handler);
        }

        public void handleEnd(String tag, String data) throws IOException {
            try {
                float v = Float.parseFloat(data);
                if (this.objectValue) {
                    this.handler.write(v);
                } else {
                    this.handler._bdos.writeFloat(v);
                }
            }
            catch (NumberFormatException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
            this.writeEndDataBlock();
        }
    }

    static final class _NSLongTxr
    extends _NSPrimitiveTxr {
        public _NSLongTxr(_NSTransformHandler handler) {
            super(handler);
        }

        public void handleEnd(String tag, String data) throws IOException {
            try {
                long v = Long.parseLong(data);
                if (this.objectValue) {
                    this.handler.write(v);
                } else {
                    this.handler._bdos.writeLong(v);
                }
            }
            catch (NumberFormatException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
            this.writeEndDataBlock();
        }
    }

    static final class _NSIntTxr
    extends _NSPrimitiveTxr {
        public _NSIntTxr(_NSTransformHandler handler) {
            super(handler);
        }

        public void handleEnd(String tag, String data) throws IOException {
            try {
                int v = Integer.parseInt(data);
                if (this.objectValue) {
                    this.handler.write(v);
                } else {
                    this.handler._bdos.writeInt(v);
                }
            }
            catch (NumberFormatException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
            this.writeEndDataBlock();
        }
    }

    static final class _NSCharTxr
    extends _NSPrimitiveTxr {
        private _NSStringTxr _stringTxr;

        public _NSCharTxr(_NSTransformHandler handler, _NSStringTxr stringTxr) {
            super(handler);
            this._stringTxr = stringTxr;
        }

        public void handleStart(String tag, Attributes attributes) throws IOException {
            super.handleStart(tag, attributes);
            if (this._stringTxr.partOfString()) {
                this._stringTxr.append(this.handler.previousPartOfString());
            }
        }

        public void handleEnd(String tag, String data) throws IOException {
            char ch = data.charAt(0);
            if (data.length() > 1) {
                try {
                    ch = (char)Integer.parseInt(data.substring(2), 16);
                }
                catch (NumberFormatException e) {
                    throw new StreamCorruptedException(e.getMessage());
                }
            }
            if (this.objectValue) {
                this.handler.write(ch);
            } else if (this._stringTxr.partOfString()) {
                this._stringTxr.append(ch);
            } else {
                this.handler._bdos.writeChar(ch);
            }
            this.writeEndDataBlock();
        }
    }

    static final class _NSShortTxr
    extends _NSPrimitiveTxr {
        public _NSShortTxr(_NSTransformHandler handler) {
            super(handler);
        }

        public void handleEnd(String tag, String data) throws IOException {
            try {
                short v = Short.parseShort(data);
                if (this.objectValue) {
                    this.handler.write(v);
                } else {
                    this.handler._bdos.writeShort(v);
                }
            }
            catch (NumberFormatException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
            this.writeEndDataBlock();
        }
    }

    static final class _NSByteTxr
    extends _NSPrimitiveTxr {
        public _NSByteTxr(_NSTransformHandler handler) {
            super(handler);
        }

        public void handleEnd(String tag, String data) throws IOException {
            try {
                byte v = Byte.parseByte(data);
                if (this.objectValue) {
                    this.handler.write(v);
                } else {
                    this.handler._bdos.writeByte(v);
                }
            }
            catch (NumberFormatException e) {
                throw new StreamCorruptedException(e.getMessage());
            }
            this.writeEndDataBlock();
        }
    }

    static final class _NSBoolTxr
    extends _NSPrimitiveTxr {
        public _NSBoolTxr(_NSTransformHandler handler) {
            super(handler);
        }

        public void handleEnd(String tag, String data) throws IOException {
            byte v = 0;
            if ("true".equals(data)) {
                v = 1;
            }
            if (this.objectValue) {
                this.handler.write(v);
            } else {
                this.handler._bdos.writeByte(v);
            }
            this.writeEndDataBlock();
        }
    }

    static abstract class _NSPrimitiveTxr
    extends _NSTagTransformer {
        protected boolean objectValue;

        protected _NSPrimitiveTxr(_NSTransformHandler handler) {
            super(handler);
        }

        public void handleStart(String tag, Attributes attributes) throws IOException {
            boolean bl = this.objectValue = attributes.getValue("field") != null;
            if (this.objectValue) {
                if (this.handler._bdos.getBlockDataMode()) {
                    this.handler._bdos.setBlockDataMode(false);
                }
            } else {
                this.handler._bdos.setBlockDataMode(true);
            }
            this.getNumEndDataBlock(attributes);
        }
    }

    static final class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private byte[] buf = new byte[1024];
        private byte[] hbuf = new byte[5];
        private char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private OutputStream out;
        private DataOutputStream dout;

        BlockDataOutputStream(OutputStream out) {
            this.out = out;
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean mode) throws IOException {
            if (this.blkmode == mode) {
                return this.blkmode;
            }
            this.drain();
            this.blkmode = mode;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        public void write(int b) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)b;
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length, false);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.write(b, off, len, false);
        }

        public void flush() throws IOException {
            this.drain();
            this.out.flush();
        }

        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        void write(byte[] b, int off, int len, boolean copy) throws IOException {
            if (!copy && !this.blkmode) {
                this.drain();
                this.out.write(b, off, len);
                return;
            }
            while (len > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                if (len >= 1024 && !copy && this.pos == 0) {
                    this.writeBlockHeader(1024);
                    this.out.write(b, off, 1024);
                    off += 1024;
                    len -= 1024;
                    continue;
                }
                int wlen = Math.min(len, 1024 - this.pos);
                System.arraycopy(b, off, this.buf, this.pos, wlen);
                this.pos += wlen;
                off += wlen;
                len -= wlen;
            }
        }

        void drain() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int len) throws IOException {
            if (len <= 255) {
                this.hbuf[0] = 119;
                this.hbuf[1] = (byte)len;
                this.out.write(this.hbuf, 0, 2);
            } else {
                this.hbuf[0] = 122;
                this.hbuf[1] = (byte)(len >>> 24);
                this.hbuf[2] = (byte)(len >>> 16);
                this.hbuf[3] = (byte)(len >>> 8);
                this.hbuf[4] = (byte)(len >>> 0);
                this.out.write(this.hbuf, 0, 5);
            }
        }

        public void writeBoolean(boolean v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)(v ? 1 : 0);
        }

        public void writeByte(int v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)v;
        }

        public void writeShort(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                this.buf[this.pos++] = (byte)(v >>> 8);
                this.buf[this.pos++] = (byte)(v >>> 0);
            } else {
                this.dout.writeShort(v);
            }
        }

        public void writeChar(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                this.buf[this.pos++] = (byte)(v >>> 8);
                this.buf[this.pos++] = (byte)(v >>> 0);
            } else {
                this.dout.writeChar(v);
            }
        }

        public void writeInt(int v) throws IOException {
            if (this.pos + 4 <= 1024) {
                this.buf[this.pos++] = (byte)(v >>> 24);
                this.buf[this.pos++] = (byte)(v >>> 16);
                this.buf[this.pos++] = (byte)(v >>> 8);
                this.buf[this.pos++] = (byte)(v >>> 0);
            } else {
                this.dout.writeInt(v);
            }
        }

        public void writeFloat(float v) throws IOException {
            if (this.pos + 4 <= 1024) {
                int i = Float.floatToIntBits(v);
                this.buf[this.pos++] = (byte)(i >>> 24);
                this.buf[this.pos++] = (byte)(i >>> 16);
                this.buf[this.pos++] = (byte)(i >>> 8);
                this.buf[this.pos++] = (byte)(i >>> 0);
            } else {
                this.dout.writeFloat(v);
            }
        }

        public void writeLong(long v) throws IOException {
            if (this.pos + 8 <= 1024) {
                this.buf[this.pos++] = (byte)(v >>> 56);
                this.buf[this.pos++] = (byte)(v >>> 48);
                this.buf[this.pos++] = (byte)(v >>> 40);
                this.buf[this.pos++] = (byte)(v >>> 32);
                this.buf[this.pos++] = (byte)(v >>> 24);
                this.buf[this.pos++] = (byte)(v >>> 16);
                this.buf[this.pos++] = (byte)(v >>> 8);
                this.buf[this.pos++] = (byte)(v >>> 0);
            } else {
                this.dout.writeLong(v);
            }
        }

        public void writeDouble(double v) throws IOException {
            if (this.pos + 8 <= 1024) {
                long l = Double.doubleToLongBits(v);
                this.buf[this.pos++] = (byte)(l >>> 56);
                this.buf[this.pos++] = (byte)(l >>> 48);
                this.buf[this.pos++] = (byte)(l >>> 40);
                this.buf[this.pos++] = (byte)(l >>> 32);
                this.buf[this.pos++] = (byte)(l >>> 24);
                this.buf[this.pos++] = (byte)(l >>> 16);
                this.buf[this.pos++] = (byte)(l >>> 8);
                this.buf[this.pos++] = (byte)(l >>> 0);
            } else {
                this.dout.writeDouble(v);
            }
        }

        public void writeBytes(String s) throws IOException {
        }

        public void writeChars(String s) throws IOException {
        }

        public void writeUTF(String s) throws IOException {
        }
    }
}

