/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSDelayedCallbackCenter;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;

public class NSUndoManager
implements NSDisposable {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSUndoManager");
    private _NSUndoStack _undoStack = new _NSUndoStack();
    private _NSUndoStack _redoStack = new _NSUndoStack();
    private int _disabled = 0;
    private boolean _undoing = false;
    private boolean _redoing = false;
    private boolean _registeredForCallback;
    private boolean _postingCheckpointNotification;
    private boolean _groupsByEvent = true;
    public static final int UndoCloseGroupingRunLoopOrdering = 350000;
    public static final String CheckpointNotification = "NSUndoManagerCheckpointNotification";
    public static final String WillUndoChangeNotification = "NSUndoManagerWillUndoChangeNotification";
    public static final String WillRedoChangeNotification = "NSUndoManagerWillRedoChangeNotification";
    public static final String DidUndoChangeNotification = "NSUndoManagerDidUndoChangeNotification";
    public static final String DidRedoChangeNotification = "NSUndoManagerDidRedoChangeNotification";
    public static final String DidOpenUndoGroupNotification = "NSUndoManagerDidOpenUndoGroupNotification";
    public static final String WillCloseUndoGroupNotification = "NSUndoManagerWillCloseUndoGroupNotification";
    private static final NSSelector _endOfEventSelector = new NSSelector("_processEndOfEventNotification", _NSUtilities._ObjectClassArray);
    private static final boolean DebugUndo = false;

    private void _prepareEventGrouping() {
        _NSUndoStack stack;
        _NSUndoStack _NSUndoStack2 = stack = this._undoing ? this._redoStack : this._undoStack;
        if (!this._registeredForCallback && this._groupsByEvent && stack.nestingLevel() == 0) {
            this._registeredForCallback = true;
            this.beginUndoGrouping();
            NSDelayedCallbackCenter.defaultCenter().performSelector(_endOfEventSelector, this, null, 350000);
        }
    }

    public void _processEndOfEventNotification(Object arg) {
        if (this._groupsByEvent && this._registeredForCallback) {
            this._registeredForCallback = false;
            this.endUndoGrouping();
        }
    }

    private void _postCheckpointNotification() {
        if (!this._postingCheckpointNotification) {
            this._postingCheckpointNotification = true;
            NSNotificationCenter.defaultCenter().postNotification(CheckpointNotification, this);
            this._postingCheckpointNotification = false;
        }
    }

    private void _registerUndoObject(_NSUndoObject undo) {
        _NSUndoStack stack;
        if (this._disabled > 0) {
            return;
        }
        if (!this._undoing && !this._redoing) {
            this._redoStack.removeAllObjects();
        }
        this._prepareEventGrouping();
        _NSUndoStack _NSUndoStack2 = stack = this._undoing ? this._redoStack : this._undoStack;
        if (stack.nestingLevel() == 0) {
            throw new IllegalStateException("_registerUndoObject: undo manager is in invalid state, must begin a group before registering undo");
        }
        stack.push(undo);
    }

    private void _setGroupIdentifier(Object identifier) {
        if (identifier != null && this._disabled == 0) {
            _NSUndoStack stack;
            this._prepareEventGrouping();
            _NSUndoStack _NSUndoStack2 = stack = this._undoing ? this._redoStack : this._undoStack;
            if (stack.nestingLevel() == 0) {
                throw new IllegalStateException("_setGroupIdentifier: undo manager is in invalid state, must begin a group before registering undo");
            }
            stack.setGroupIdentifier(identifier);
        }
    }

    public _NSUndoStack _undoStack() {
        return this._undoStack;
    }

    public void dispose() {
        this.removeAllActions();
        NSDelayedCallbackCenter.defaultCenter()._cancelAllActionsWithTarget(this);
    }

    public void beginUndoGrouping() {
        _NSUndoStack stack;
        if (this._disabled > 0) {
            return;
        }
        if (!this._undoing && !this._redoing) {
            this._prepareEventGrouping();
        }
        _NSUndoStack _NSUndoStack2 = stack = this._undoing ? this._redoStack : this._undoStack;
        if (!this._groupsByEvent || stack.nestingLevel() != 0) {
            this._postCheckpointNotification();
        }
        stack.markBegin();
        if (!this._undoing && !this._redoing) {
            NSNotificationCenter.defaultCenter().postNotification(DidOpenUndoGroupNotification, this);
        }
    }

    public int groupingLevel() {
        _NSUndoStack stack = this._undoing ? this._redoStack : this._undoStack;
        return stack.nestingLevel();
    }

    public void endUndoGrouping() {
        if (this._disabled > 0) {
            return;
        }
        _NSUndoStack stack = this._undoing ? this._redoStack : this._undoStack;
        this._postCheckpointNotification();
        if (stack.nestingLevel() == 0) {
            throw new IllegalStateException("endUndoGrouping: undo manager is in invalid state, endUndoGrouping called with no matching begin");
        }
        if (!this._undoing && !this._redoing) {
            NSNotificationCenter.defaultCenter().postNotification(WillCloseUndoGroupNotification, this);
        }
        stack.markEnd();
    }

    public void disableUndoRegistration() {
        ++this._disabled;
    }

    public void enableUndoRegistration() {
        if (this._disabled == 0) {
            throw new IllegalStateException("enableUndoRegistration: undo manager is in invalid state, enableUndoRegistration may only be invoked with matching call to disableUndoRegistration");
        }
        --this._disabled;
    }

    public boolean isUndoRegistrationEnabled() {
        return this._disabled == 0;
    }

    public boolean groupsByEvent() {
        return this._groupsByEvent;
    }

    public void setGroupsByEvent(boolean groupsByEvent) {
        this._groupsByEvent = groupsByEvent;
    }

    public void setLevelsOfUndo(int levels) {
        this._undoStack.setMax(levels);
    }

    public int levelsOfUndo() {
        return this._undoStack.max();
    }

    public void undo() {
        this._postCheckpointNotification();
        if (this._registeredForCallback && this._undoStack.nestingLevel() == 1) {
            this.endUndoGrouping();
            this._registeredForCallback = false;
            NSDelayedCallbackCenter.defaultCenter().cancelPerformSelector(_endOfEventSelector, this, null);
        }
        if (this._undoStack.nestingLevel() != 0) {
            throw new IllegalStateException("undo: undo manager is in invalid state, undo was called with too many nested undo groups");
        }
        this.undoNestedGroup();
    }

    public void undoNestedGroup() {
        this._postCheckpointNotification();
        this._undoing = true;
        _NSUndoObject top = this._undoStack.topUndoObject();
        if (top == null) {
            this._undoing = false;
            return;
        }
        if (!top.isEndMark()) {
            this._undoing = false;
            throw new IllegalStateException("undoNestedGroup: undo manager is in invalid state, call endUndoGrouping before calling this method");
        }
        NSNotificationCenter.defaultCenter().postNotification(WillUndoChangeNotification, this);
        this.beginUndoGrouping();
        if (this._disabled == 0) {
            this._redoStack.setGroupIdentifier(this._undoStack.groupIdentifier());
        }
        this._undoStack.popAndInvoke();
        this.endUndoGrouping();
        NSNotificationCenter.defaultCenter().postNotification(DidUndoChangeNotification, this);
        this._undoing = false;
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        this._redoing = true;
        _NSUndoObject top = this._redoStack.topUndoObject();
        if (top == null) {
            this._redoing = false;
            return;
        }
        if (!top.isEndMark()) {
            this._redoing = false;
            throw new IllegalStateException("redo: undo manager is in invalid state, do not invoke this method while undoing");
        }
        NSNotificationCenter.defaultCenter().postNotification(WillRedoChangeNotification, this);
        this.beginUndoGrouping();
        if (this._disabled == 0) {
            this._undoStack.setGroupIdentifier(this._redoStack.groupIdentifier());
        }
        this._redoStack.popAndInvoke();
        this._postCheckpointNotification();
        this.endUndoGrouping();
        NSNotificationCenter.defaultCenter().postNotification(DidRedoChangeNotification, this);
        this._redoing = false;
    }

    public boolean canUndo() {
        return this._undoStack.count() > 0;
    }

    public boolean canRedo() {
        this._postCheckpointNotification();
        return this._redoStack.count() > 0;
    }

    public boolean isUndoing() {
        return this._undoing;
    }

    public boolean isRedoing() {
        return this._redoing;
    }

    public void removeAllActions() {
        this._undoStack.removeAllObjects();
        this._redoStack.removeAllObjects();
        this._undoing = false;
        this._redoing = false;
        this._disabled = 0;
        if (this._registeredForCallback) {
            this._registeredForCallback = false;
            NSDelayedCallbackCenter.defaultCenter().cancelPerformSelector(_endOfEventSelector, this, null);
        }
    }

    public void removeAllActionsWithTarget(Object target) {
        this._undoStack.removeAllObjectsWithTarget(target);
        this._redoStack.removeAllObjectsWithTarget(target);
    }

    public void registerUndoWithTarget(Object target, NSSelector selector, Object object) {
        _NSUndoLightInvocation undoObject = new _NSUndoLightInvocation(target, selector, object);
        this._registerUndoObject(undoObject);
    }

    public void registerUndoWithTargetAndArguments(Object target, NSSelector selector, Object[] objects) {
        _NSUndoLightInvocation undoObject = new _NSUndoLightInvocation(target, selector, objects);
        this._registerUndoObject(undoObject);
    }

    public static class _NSUndoStack {
        private int _max = 0;
        private int _count = 0;
        private int _nestingLevel;
        _NSUndoObject _head = null;

        public void _removeBottom() {
            _NSUndoObject obj = this._head.previous;
            int nestingLevelCount = 0;
            if (!obj.isBeginMark()) {
                throw new IllegalStateException("error while removing bottom of undo stack");
            }
            do {
                if (obj.isBeginMark()) {
                    ++nestingLevelCount;
                } else if (obj.isEndMark()) {
                    --nestingLevelCount;
                }
                obj = obj.previous;
            } while (nestingLevelCount > 0);
            this._head.previous = obj;
            this._head.previous.next = null;
            --this._count;
        }

        public int max() {
            return this._max;
        }

        public int count() {
            return this._count;
        }

        public void setMax(int m) {
            this._max = m;
            while (this._max > 0 && this._count > this._max) {
                this._removeBottom();
            }
        }

        public void push(_NSUndoObject undo) {
            undo.next = this._head;
            _NSUndoObject _NSUndoObject2 = undo.previous = this._head != null ? this._head.previous : undo;
            if (this._head != null) {
                this._head.previous = undo;
            }
            this._head = undo;
            if (undo.isEndMark()) {
                if (this._nestingLevel == 0) {
                    throw new IllegalStateException("pushing more ends than begins onto stack");
                }
                --this._nestingLevel;
                if (this._nestingLevel == 0 && this._max > 0 && this._count > this._max) {
                    this._removeBottom();
                }
            } else if (undo.isBeginMark()) {
                if (this._nestingLevel == 0) {
                    ++this._count;
                }
                ++this._nestingLevel;
            }
        }

        public _NSUndoObject popUndoObject() {
            _NSUndoObject top = this._head;
            if (this._head == null) {
                return null;
            }
            this._head = this._head.next;
            if (this._head != null) {
                this._head.previous = top.previous;
            }
            if (top.isBeginMark()) {
                if (this._nestingLevel == 0) {
                    throw new IllegalStateException("popping more begins than ends from stack");
                }
                --this._nestingLevel;
                if (this._nestingLevel == 0) {
                    --this._count;
                }
            } else if (top.isEndMark()) {
                ++this._nestingLevel;
            }
            return top;
        }

        public _NSUndoBeginMark _beginMark() {
            _NSUndoBeginMark beginMark = null;
            int nestingLevel = this._nestingLevel;
            _NSUndoObject current = this._head;
            while (current != null) {
                if (current.isEndMark()) {
                    ++nestingLevel;
                }
                if (current.isBeginMark() && nestingLevel != 0 && --nestingLevel == 0) {
                    beginMark = (_NSUndoBeginMark)current;
                    break;
                }
                current = current.next;
            }
            return beginMark;
        }

        public void setGroupIdentifier(Object identifier) {
            _NSUndoBeginMark beginMark = this._beginMark();
            if (beginMark == null) {
                throw new IllegalStateException("setGroupIdentifier: undo manager is in invalid state, calling setGroupIdentifier with no begin group mark");
            }
            beginMark.setGroupIdentifier(identifier);
        }

        public Object groupIdentifier() {
            _NSUndoBeginMark beginMark = this._beginMark();
            return beginMark != null ? beginMark.groupIdentifier() : null;
        }

        public _NSUndoObject topUndoObject() {
            return this._head;
        }

        public void markBegin() {
            this.push(new _NSUndoBeginMark());
        }

        public void markEnd() {
            this.push(new _NSUndoEndMark());
        }

        public boolean popAndInvoke() {
            boolean didUndo = false;
            int nestingLevelCount = 0;
            if (this._head != null && !this._head.isEndMark()) {
                throw new IllegalStateException("popAndInvoke: undo manager is in invalid state, call endUndoGrouping on undo manager before calling this method");
            }
            do {
                if (this._head.isBeginMark()) {
                    --nestingLevelCount;
                    this.popUndoObject();
                    continue;
                }
                if (this._head.isEndMark()) {
                    ++nestingLevelCount;
                    this.popUndoObject();
                    continue;
                }
                this.popUndoObject().invoke();
                didUndo = true;
            } while (this._head != null && nestingLevelCount >= 1);
            return didUndo;
        }

        public int nestingLevel() {
            return this._nestingLevel;
        }

        public void removeAllObjects() {
            this._head = null;
            this._count = 0;
            this._nestingLevel = 0;
        }

        public void removeAllObjectsWithTarget(Object target) {
            int nestingLevel = 0;
            boolean foundEndMark = false;
            _NSUndoObject current = this._head;
            _NSUndoObject prev = null;
            while (current != null) {
                if (current.isEndMark()) {
                    ++nestingLevel;
                    foundEndMark = true;
                }
                if (current.isBeginMark() && foundEndMark && --nestingLevel == 0) {
                    foundEndMark = false;
                }
                if (current.target() == target) {
                    _NSUndoObject next = current.next;
                    this.removeObject(current);
                    if ((next == null || next.isBeginMark()) && (prev == null || prev.isEndMark())) {
                        _NSUndoObject temp;
                        if (prev != null) {
                            temp = prev.previous;
                            this.removeObject(prev);
                            prev = temp;
                        }
                        if (next != null) {
                            temp = next.next;
                            this.removeObject(next);
                            next = temp;
                            if (foundEndMark) {
                                --nestingLevel;
                            }
                        }
                        if (nestingLevel == 0) {
                            --this._count;
                            foundEndMark = false;
                        }
                    }
                    current = next;
                    continue;
                }
                prev = current;
                current = current.next;
            }
        }

        public void removeObject(_NSUndoObject undo) {
            if (undo.next != null) {
                undo.next.previous = undo.previous;
                if (undo.previous.next != null) {
                    undo.previous.next = undo.next;
                }
            } else {
                undo.previous.next = null;
                this._head.previous = undo.previous;
            }
            if (undo == this._head) {
                this._head = undo.next;
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("Stack:");
            int i = 0;
            _NSUndoObject current = this._head;
            while (current != null) {
                buffer.append(i++ + ": " + current.toString() + "\n");
                current = current.next;
            }
            return new String(buffer);
        }
    }

    private static class _NSUndoLightInvocation
    extends _NSUndoObject {
        private NSSelector _selector;
        private Object[] _args;

        public _NSUndoLightInvocation(Object target, NSSelector selector, Object arg) {
            Object[] objectArray;
            if (arg != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = arg;
            } else {
                objectArray = null;
            }
            this(target, selector, objectArray);
        }

        public _NSUndoLightInvocation(Object target, NSSelector selector, Object[] args) {
            super(target);
            if (selector == null) {
                throw new IllegalArgumentException("Selector must not be null");
            }
            this._selector = selector;
            this._args = args;
        }

        public void invoke() {
            NSSelector._safeInvokeSelector(this._selector, this.target(), this._args);
        }

        Object _argument() {
            return this._args != null ? this._args[0] : null;
        }

        Object[] _arguments() {
            return this._args;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("target: ");
            buffer.append(this._target.getClass().getName());
            buffer.append(" 0x");
            buffer.append(Integer.toHexString(System.identityHashCode(this._target)));
            buffer.append(" -- selector:");
            buffer.append(this._selector.toString());
            buffer.append(" -- arg:");
            if (this._args != null) {
                int iCount = this._args.length;
                for (int i = 0; i < iCount; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    if (this._args[i] != null) {
                        buffer.append(this._args[i].getClass().toString());
                        buffer.append(" 0x");
                        buffer.append(Integer.toHexString(System.identityHashCode(this._args[i])));
                        continue;
                    }
                    buffer.append("null");
                }
            } else {
                buffer.append("none");
            }
            return new String(buffer);
        }
    }

    private static class _NSUndoEndMark
    extends _NSUndoObject {
        private _NSUndoEndMark() {
        }

        public boolean isEndMark() {
            return true;
        }

        public String toString() {
            return "endUndoGrouping";
        }
    }

    private static class _NSUndoBeginMark
    extends _NSUndoObject {
        private Object _groupIdentifier;

        private _NSUndoBeginMark() {
        }

        public void setGroupIdentifier(Object identifier) {
            this._groupIdentifier = identifier;
        }

        public Object groupIdentifier() {
            return this._groupIdentifier;
        }

        public boolean isBeginMark() {
            return true;
        }

        public String toString() {
            return "beginUndoGrouping";
        }
    }

    private static class _NSUndoObject {
        _NSUndoObject next;
        _NSUndoObject previous;
        protected Object _target;

        public _NSUndoObject() {
            this(null);
        }

        public _NSUndoObject(Object target) {
            this._target = target;
        }

        public boolean isBeginMark() {
            return false;
        }

        public boolean isEndMark() {
            return false;
        }

        public void invoke() {
            throw new IllegalStateException("invoke is subclass responsibility");
        }

        public Object target() {
            return this._target;
        }
    }
}

