/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSchemaGeneration;
import com.webobjects.eoaccess.EOSchemaSynchronization;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.foundation._NSDictionaryUtilities;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;

public class EOSynchronizationFactory
implements EOSchemaGeneration,
EOSchemaSynchronization {
    private boolean _commentsEnabled = false;
    private Delegate _delegate = null;
    protected EOAdaptor _adaptor;
    private static final NSSelector _selColumnName = new NSSelector("columnName", new Class[0]);
    private static final NSSelector _selCompare = new NSSelector("compare", new Class[]{String.class});
    private static final NSDictionary _sqlReplacementsDictionary = new NSDictionary(new NSArray(new Object[]{"create", "table"}), new NSArray(new Object[]{"CREATE", "TABLE"}));

    public EOSynchronizationFactory(EOAdaptor adaptor) {
        this._adaptor = adaptor;
    }

    private EOSynchronizationFactory() {
    }

    public EOAdaptor adaptor() {
        return this._adaptor;
    }

    private static NSDictionary _dictionaryForKey(NSDictionary source, String key) {
        if (source == null) {
            return NSDictionary.EmptyDictionary;
        }
        NSDictionary dict = (NSDictionary)source.objectForKey((Object)key);
        if (dict == null) {
            return NSDictionary.EmptyDictionary;
        }
        return dict;
    }

    private static NSArray _arrayForKey(NSDictionary source, String key) {
        if (source == null) {
            return NSArray.EmptyArray;
        }
        NSArray array = (NSArray)source.objectForKey((Object)key);
        if (array == null) {
            return NSArray.EmptyArray;
        }
        return array;
    }

    public NSArray foreignKeyConstraintStatementsForRelationship(EORelationship relationship) {
        EOModel destModel;
        EOEntity entity = relationship.entity();
        EOEntity destEntity = relationship.destinationEntity();
        NSMutableArray sourceKeys = new NSMutableArray();
        NSMutableArray destinationKeys = new NSMutableArray();
        NSArray destinationAttrs = destEntity.primaryKeyAttributes();
        NSArray joins = relationship.joins();
        int destCount = destinationAttrs.count();
        EOModel entModel = entity.model();
        if (entModel != (destModel = destEntity.model()) && !entModel.connectionDictionary().equals((Object)destModel.connectionDictionary())) {
            return NSArray.EmptyArray;
        }
        if (relationship.isToMany()) {
            return NSArray.EmptyArray;
        }
        EORelationship inverse = relationship.inverseRelationship();
        if (inverse != null && !inverse.isToMany()) {
            return NSArray.EmptyArray;
        }
        int c = destCount;
        for (int i = 0; i < c; ++i) {
            EOAttribute attr = (EOAttribute)destinationAttrs.objectAtIndex(i);
            destinationKeys.addObject((Object)attr.columnName());
            int j = joins.count();
            while (j-- != 0) {
                EOJoin join = (EOJoin)joins.objectAtIndex(j);
                if (join.destinationAttribute() != attr) continue;
                sourceKeys.addObject((Object)join.sourceAttribute().columnName());
            }
        }
        if (sourceKeys.count() != joins.count()) {
            return NSArray.EmptyArray;
        }
        EOSQLExpression expression = this._expressionForEntity(entity);
        expression.prepareConstraintStatementForRelationship(relationship, (NSArray)sourceKeys, (NSArray)destinationKeys);
        return new NSArray((Object)expression);
    }

    public NSArray createTableStatementsForEntityGroup(NSArray entityGroup) {
        int iCount;
        EOSQLExpression sqlExpr = null;
        EOEntity entity = null;
        NSMutableArray columnNames = new NSMutableArray();
        int n = iCount = entityGroup == null ? 0 : entityGroup.count();
        if (iCount == 0) {
            return NSArray.EmptyArray;
        }
        sqlExpr = this._expressionForEntity((EOEntity)entityGroup.objectAtIndex(0));
        for (int i = 0; i < iCount; ++i) {
            entity = (EOEntity)entityGroup.objectAtIndex(i);
            NSArray atts = entity.attributes();
            int jCount = atts == null ? 0 : atts.count();
            for (int j = 0; j < jCount; ++j) {
                EOAttribute att = (EOAttribute)atts.objectAtIndex(j);
                String columnName = att.columnName();
                if (att.isDerived() || att.isFlattened() || columnName == null || columnName.length() <= 0 || columnNames.indexOfObject((Object)columnName) != -1) continue;
                sqlExpr.addCreateClauseForAttribute(att);
                columnNames.addObject((Object)columnName);
            }
        }
        sqlExpr.setStatement(_NSStringUtilities.concat((String)"CREATE TABLE ", (String)entity.externalName(), (String)"(", (String)sqlExpr.listString(), (String)")"));
        return new NSArray((Object)sqlExpr);
    }

    public NSArray dropTableStatementsForEntityGroup(NSArray entityGroup) {
        if (entityGroup == null) {
            return NSArray.EmptyArray;
        }
        EOSQLExpression sqlExpr = this._expressionForString(_NSStringUtilities.concat((String)"DROP TABLE ", (String)((EOEntity)entityGroup.objectAtIndex(0)).externalName(), (String)" CASCADE"));
        return new NSArray((Object)sqlExpr);
    }

    public NSArray primaryKeyConstraintStatementsForEntityGroup(NSArray entityGroup) {
        int i;
        if (entityGroup == null) {
            return NSArray.EmptyArray;
        }
        EOEntity entity = (EOEntity)entityGroup.objectAtIndex(0);
        NSArray pkAttrs = entity.primaryKeyAttributes();
        int n = i = pkAttrs != null ? pkAttrs.count() : 0;
        if (i == 0) {
            return NSArray.EmptyArray;
        }
        while (i-- != 0) {
            String columnName = ((EOAttribute)pkAttrs.objectAtIndex(i)).columnName();
            if (columnName != null && columnName.length() != 0) continue;
            return NSArray.EmptyArray;
        }
        NSMutableArray columnNames = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)pkAttrs, (NSSelector)_selColumnName);
        EOSQLExpression sqlExpr = this._expressionForString(_NSStringUtilities.concat((String)"ALTER TABLE ", (String)entity.externalName(), (String)" ADD PRIMARY KEY (", (String)columnNames.componentsJoinedByString(", "), (String)")"));
        return new NSArray((Object)sqlExpr);
    }

    public NSArray primaryKeySupportStatementsForEntityGroup(NSArray entityGroup) {
        return null;
    }

    public NSArray dropPrimaryKeySupportStatementsForEntityGroup(NSArray entityGroup) {
        return null;
    }

    public NSArray createTableStatementsForEntityGroups(NSArray entityGroups) {
        int count = entityGroups.count();
        NSMutableArray result = new NSMutableArray();
        for (int i = 0; i < count; ++i) {
            NSArray entityGroup = (NSArray)entityGroups.objectAtIndex(i);
            result.addObjectsFromArray(this.createTableStatementsForEntityGroup(entityGroup));
        }
        return result;
    }

    public NSArray dropTableStatementsForEntityGroups(NSArray entityGroups) {
        int count = entityGroups.count();
        NSMutableArray result = new NSMutableArray();
        for (int i = 0; i < count; ++i) {
            NSArray entityGroup = (NSArray)entityGroups.objectAtIndex(i);
            result.addObjectsFromArray(this.dropTableStatementsForEntityGroup(entityGroup));
        }
        return result;
    }

    public NSArray primaryKeyConstraintStatementsForEntityGroups(NSArray entityGroups) {
        int count = entityGroups.count();
        NSMutableArray result = new NSMutableArray();
        for (int i = 0; i < count; ++i) {
            NSArray entityGroup = (NSArray)entityGroups.objectAtIndex(i);
            result.addObjectsFromArray(this.primaryKeyConstraintStatementsForEntityGroup(entityGroup));
        }
        return result;
    }

    public NSArray primaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
        int count = entityGroups == null ? 0 : entityGroups.count();
        NSMutableArray result = new NSMutableArray();
        boolean isNotSupported = false;
        for (int i = 0; i < count; ++i) {
            NSArray entityGroup = (NSArray)entityGroups.objectAtIndex(i);
            NSArray stmts = this.primaryKeySupportStatementsForEntityGroup(entityGroup);
            if (stmts == null) {
                isNotSupported = true;
                continue;
            }
            result.addObjectsFromArray(stmts);
        }
        if (isNotSupported) {
            result.addObject((Object)this._expressionForString("/* The 'Create Primary Key Support' option is unavailable. */"));
        }
        return result;
    }

    public NSArray dropPrimaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
        int count = entityGroups == null ? 0 : entityGroups.count();
        NSMutableArray result = new NSMutableArray();
        boolean isNotSupported = false;
        for (int i = 0; i < count; ++i) {
            NSArray entityGroup = (NSArray)entityGroups.objectAtIndex(i);
            NSArray stmts = this.dropPrimaryKeySupportStatementsForEntityGroup(entityGroup);
            if (stmts == null) {
                isNotSupported = true;
                continue;
            }
            result.addObjectsFromArray(stmts);
        }
        if (isNotSupported) {
            result.addObject((Object)this._expressionForString("/* The 'Drop Primary Key Support' option is unavailable. */"));
        }
        return result;
    }

    public void appendExpressionToScript(EOSQLExpression expression, StringBuffer script) {
        if (expression != null) {
            script.append(expression.statement() + ";\n\n");
        }
    }

    public String schemaCreationScriptForEntities(NSArray allEntities, NSDictionary options) {
        StringBuffer result = new StringBuffer();
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        NSArray statements = this.schemaCreationStatementsForEntities(allEntities, options);
        int count = statements.count();
        for (int i = 0; i < count; ++i) {
            this.appendExpressionToScript((EOSQLExpression)statements.objectAtIndex(i), result);
        }
        return new String(result);
    }

    public NSArray tableEntityGroupsForEntities(NSArray entities) {
        if (entities == null) {
            return NSArray.EmptyArray;
        }
        NSMutableArray externalNames = new NSMutableArray();
        NSMutableArray result = new NSMutableArray();
        int iCount = entities.count();
        for (int i = 0; i < iCount; ++i) {
            EOEntity entity = (EOEntity)entities.objectAtIndex(i);
            String extName = entity.externalName();
            if (extName == null || !entity.hasRealAttributes()) continue;
            int index = externalNames.indexOfObject((Object)extName);
            if (index == -1) {
                externalNames.addObject((Object)extName);
                index = externalNames.count() - 1;
                result.addObject((Object)new NSMutableArray());
            }
            NSMutableArray item = (NSMutableArray)result.objectAtIndex(index);
            item.addObject((Object)entity);
        }
        return result;
    }

    public NSArray primaryKeyEntityGroupsForEntities(NSArray entities) {
        if (entities == null) {
            return NSArray.EmptyArray;
        }
        NSMutableArray parents = new NSMutableArray();
        NSMutableArray result = new NSMutableArray();
        int iCount = entities.count();
        for (int i = 0; i < iCount; ++i) {
            int index;
            EOEntity parent1;
            EOEntity entity = (EOEntity)entities.objectAtIndex(i);
            String extName = entity.externalName();
            if (extName == null || !entity.hasSimplePrimaryKey()) continue;
            EOEntity parent = entity.parentEntity();
            while (parent != null && (parent1 = parent.parentEntity()) != null) {
                parent = parent1;
            }
            if (parent == null) {
                parent = entity;
            }
            if ((index = parents.indexOfObject((Object)parent)) == -1) {
                parents.addObject((Object)parent);
                index = parents.count() - 1;
                result.addObject((Object)new NSMutableArray());
            }
            NSMutableArray item = (NSMutableArray)result.objectAtIndex(index);
            item.addObject((Object)entity);
        }
        return result;
    }

    public NSArray schemaCreationStatementsForEntities(NSArray allEntities, NSDictionary options) {
        NSArray entityGroups;
        NSMutableArray result = new NSMutableArray();
        if (allEntities == null || allEntities.count() == 0) {
            return result;
        }
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        NSDictionary connectionDictionary = ((EOEntity)allEntities.lastObject()).model().connectionDictionary();
        boolean createDatabase = _NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"createDatabase", (boolean)false);
        boolean dropDatabase = _NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"dropDatabase", (boolean)false);
        if (createDatabase || dropDatabase) {
            boolean adminCommentsNeeded = false;
            NSArray dropDatabaseStatements = null;
            NSArray createDatabaseStatements = null;
            if (dropDatabase) {
                dropDatabaseStatements = this.dropDatabaseStatementsForConnectionDictionary(connectionDictionary, null);
                if (dropDatabaseStatements == null) {
                    dropDatabaseStatements = new NSArray((Object)this._expressionForString("/* The 'Drop Database' option is unavailable. */"));
                } else {
                    adminCommentsNeeded = true;
                }
            }
            if (createDatabase) {
                createDatabaseStatements = this.createDatabaseStatementsForConnectionDictionary(connectionDictionary, null);
                if (createDatabaseStatements == null) {
                    createDatabaseStatements = new NSArray((Object)this._expressionForString("/* The 'Create Database' option is unavailable. */"));
                } else {
                    adminCommentsNeeded = true;
                }
            }
            if (adminCommentsNeeded) {
                result.addObject((Object)this._expressionForString("/* connect as an administrator */"));
            }
            if (dropDatabaseStatements != null) {
                result.addObjectsFromArray(dropDatabaseStatements);
            }
            if (createDatabaseStatements != null) {
                result.addObjectsFromArray(createDatabaseStatements);
            }
            if (adminCommentsNeeded) {
                result.addObject((Object)this._expressionForString("/* connect as the user from the connection dictionary */"));
            }
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"dropPrimaryKeySupport", (boolean)true)) {
            entityGroups = this.primaryKeyEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.dropPrimaryKeySupportStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"dropTables", (boolean)true)) {
            entityGroups = this.tableEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.dropTableStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"createTables", (boolean)true)) {
            entityGroups = this.tableEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.createTableStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"createPrimaryKeySupport", (boolean)true)) {
            entityGroups = this.primaryKeyEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.primaryKeySupportStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"primaryKeyConstraints", (boolean)true)) {
            entityGroups = this.tableEntityGroupsForEntities(allEntities);
            result.addObjectsFromArray(this.primaryKeyConstraintStatementsForEntityGroups(entityGroups));
        }
        if (_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"foreignKeyConstraints", (boolean)false)) {
            entityGroups = this.tableEntityGroupsForEntities(allEntities);
            int iCount = entityGroups.count();
            for (int i = 0; i < iCount; ++i) {
                result.addObjectsFromArray(this._foreignKeyConstraintStatementsForEntityGroup((NSArray)entityGroups.objectAtIndex(i)));
            }
        }
        return result;
    }

    public NSArray _foreignKeyConstraintStatementsForEntityGroup(NSArray entityGroup) {
        if (entityGroup == null) {
            return NSArray.EmptyArray;
        }
        NSMutableArray result = new NSMutableArray();
        NSMutableSet constraints = new NSMutableSet();
        int jCount = entityGroup.count();
        for (int j = 0; j < jCount; ++j) {
            NSArray relationships;
            EOEntity entity = (EOEntity)entityGroup.objectAtIndex(j);
            if (entity.externalName() == null || (relationships = entity.relationships()) == null) continue;
            int x = relationships.count();
            while (x-- != 0) {
                String destinationColumns;
                String sourceColumns;
                EORelationship rel = (EORelationship)relationships.objectAtIndex(x);
                EOEntity destinationEntity = rel.destinationEntity();
                if (rel.isFlattened() || destinationEntity.externalName() == null || entity.model() != destinationEntity.model() || destinationEntity.subEntities() != null && destinationEntity.subEntities().count() != 0) continue;
                try {
                    sourceColumns = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)rel.sourceAttributes(), (NSSelector)_selColumnName).sortedArrayUsingComparator(NSComparator.AscendingStringComparator).componentsJoinedByString(",");
                    destinationColumns = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)rel.destinationAttributes(), (NSSelector)_selColumnName).sortedArrayUsingComparator(NSComparator.AscendingStringComparator).componentsJoinedByString(",");
                }
                catch (NSComparator.ComparisonException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                String constraint = _NSStringUtilities.concat((String)entity.externalName(), (String)"(", (String)sourceColumns, (String)")", (String)destinationEntity.externalName(), (String)"(", (String)destinationColumns, (String)")");
                if (constraints.containsObject((Object)constraint)) continue;
                NSArray statements = this.foreignKeyConstraintStatementsForRelationship(rel);
                if (statements != null) {
                    result.addObjectsFromArray(statements);
                }
                constraints.addObject((Object)constraint);
            }
        }
        return result;
    }

    public NSArray createDatabaseStatementsForConnectionDictionary(NSDictionary connectionDictionary, NSDictionary administrativeConnectionDictionary) {
        return null;
    }

    public NSArray dropDatabaseStatementsForConnectionDictionary(NSDictionary connectionDictionary, NSDictionary administrativeConnectionDictionary) {
        return null;
    }

    public EOSQLExpression _expressionForString(String string) {
        return this.adaptor().expressionFactory().expressionForString(string);
    }

    public EOSQLExpression _expressionForEntity(EOEntity entity) {
        return this.adaptor().expressionFactory().expressionForEntity(entity);
    }

    public boolean _allowsNullForColumnNamed(String columnName, String tableName) {
        if (this._delegate != null) {
            return this._delegate.allowsNullForColumnNamed(columnName, tableName);
        }
        throw new IllegalStateException("Invocation of _allowsNullForColumnNamed:inSchemaTableNamed: with no schema synchronization delegate");
    }

    public String _alterPhraseCoercingColumnsWithNames(NSArray columnNames, NSDictionary updates, NSArray entityGroup, NSDictionary options) {
        return null;
    }

    public String _alterPhraseDeletingColumnsWithNames(NSArray columnNames, NSArray entityGroup, NSDictionary options) {
        return null;
    }

    public String _alterPhraseInsertingColumnsWithNames(NSArray columnNames, NSArray entityGroup, NSDictionary options) {
        StringBuffer result = new StringBuffer();
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        for (int c = 0; c < columnNames.count(); ++c) {
            String clause = this._columnCreationClauseForAttribute(this._firstAttributeInEntityGroupWithColumnName(entityGroup, (String)columnNames.objectAtIndex(c)));
            String prefix = this._alterPhraseInsertionClausePrefixAtIndex(c);
            if (c == 0) {
                if (prefix != null) {
                    result.append(prefix);
                    result.append(" ");
                    result.append(clause);
                    continue;
                }
                result.append(clause);
                continue;
            }
            result.append(this._alterPhraseJoinString());
            if (prefix != null) {
                result.append(prefix);
                result.append(" ");
                result.append(clause);
                continue;
            }
            result.append(clause);
        }
        return result.toString();
    }

    public String _alterPhraseInsertionClausePrefixAtIndex(int clauseIndex) {
        return null;
    }

    public String _alterPhraseJoinString() {
        return ", ";
    }

    public boolean _arePurelyForeignKeyConstraintRelatedChanges(NSDictionary changes) {
        NSArray keys;
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        return (keys = changes.allKeys()).count() == 1 && ((String)keys.objectAtIndex(0)).equals("relationships");
    }

    public NSArray _columnAttributesInEntityGroup(NSArray entityGroup) {
        NSMutableArray result = new NSMutableArray();
        for (int e = 0; e < entityGroup.count(); ++e) {
            NSArray attributes = ((EOEntity)entityGroup.objectAtIndex(e)).attributes();
            for (int a = 0; a < attributes.count(); ++a) {
                EOAttribute attribute = (EOAttribute)attributes.objectAtIndex(a);
                if (attribute.columnName() == null) continue;
                result.addObject((Object)attribute);
            }
        }
        return result.count() != 0 ? result : null;
    }

    public EOSchemaSynchronization.ColumnTypes _columnTypeNamedWithPrecisionScaleAndWidth(String name, int precision, int scale, int width) {
        return new _EOExternalType(name, precision, scale, width);
    }

    public Object _directCoercionsForEntityGroupInTable(NSArray entityGroup, String tableName, NSDictionary changes, NSDictionary options) {
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        NSArray coercedColumnNames = this._namesOfColumnsCoercedInChangeDictionaryForEntityGroup(changes, entityGroup);
        NSMutableArray statements = null;
        if (coercedColumnNames.count() > 0) {
            NSDictionary updated = EOSynchronizationFactory._dictionaryForKey(changes, "updated");
            String alterPhrase = this._alterPhraseCoercingColumnsWithNames(coercedColumnNames, updated, entityGroup, options);
            if (alterPhrase != null) {
                return alterPhrase;
            }
            statements = new NSMutableArray();
            for (int c = 0; c < coercedColumnNames.count(); ++c) {
                String columnName = (String)coercedColumnNames.objectAtIndex(c);
                EOAttribute attribute = this._firstAttributeInEntityGroupWithColumnName(entityGroup, columnName);
                NSDictionary columnChanges = EOSynchronizationFactory._dictionaryForKey(updated, columnName);
                EOSchemaSynchronization.ColumnTypes oldType = this._columnTypeForChangeDictionaryAndAttribute(columnChanges, attribute);
                EOSchemaSynchronization.ColumnTypes newType = this._columnTypeForAttribute(attribute);
                statements.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToConvertColumnType(columnName, tableName, oldType, newType, options), "statementsToConvertColumnNamed:" + columnName + " inTableNamed:" + tableName + " fromType:" + ((_EOExternalType)oldType).toString() + " toType:" + ((_EOExternalType)newType).toString()));
            }
        }
        return statements;
    }

    public NSArray _entityGroupsInModelReferringToTableNamed(EOModel model, String tableName) {
        int r;
        NSMutableArray result = new NSMutableArray();
        NSMutableSet referringTableNameSet = new NSMutableSet();
        NSArray entities = model.entities();
        for (int e = 0; e < entities.count(); ++e) {
            EOEntity entity = (EOEntity)entities.objectAtIndex(e);
            NSArray relationships = entity.relationships();
            if (relationships == null) continue;
            for (r = 0; r < relationships.count(); ++r) {
                EORelationship relationship = (EORelationship)relationships.objectAtIndex(r);
                if (!relationship.destinationEntity().externalName().equals(tableName) || referringTableNameSet.containsObject((Object)entity.externalName())) continue;
                referringTableNameSet.addObject((Object)entity.externalName());
            }
        }
        NSArray referringTableNames = referringTableNameSet.allObjects();
        for (r = 0; r < referringTableNames.count(); ++r) {
            result.addObject((Object)this._entityGroupInModelForTableNamed(model, (String)referringTableNames.objectAtIndex(r)));
        }
        return result;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean isColumnTypeEquivalentToColumnType(EOSchemaSynchronization.ColumnTypes candidate, EOSchemaSynchronization.ColumnTypes columnType, NSDictionary options) {
        return candidate.name().equals(columnType.name()) && candidate.precision() == columnType.precision() && candidate.scale() == columnType.scale() && candidate.width() == columnType.width();
    }

    public boolean _isPoorlyFormedColumnType(EOSchemaSynchronization.ColumnTypes columnType) {
        NSDictionary parameterizedTypes = this._parameterizedTypes();
        if (parameterizedTypes == null) {
            return false;
        }
        String name = columnType.getClass().getName();
        return EOSynchronizationFactory._arrayForKey(parameterizedTypes, "precision").containsObject((Object)name) && columnType.precision() != 0 || EOSynchronizationFactory._arrayForKey(parameterizedTypes, "scale").containsObject((Object)name) && columnType.scale() != 0 || EOSynchronizationFactory._arrayForKey(parameterizedTypes, "width").containsObject((Object)name) && columnType.width() != 0;
    }

    public NSArray logicalErrorsInChangeDictionaryForModelOptions(NSDictionary changes, EOModel model, NSDictionary options) {
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        NSMutableArray result = new NSMutableArray();
        NSDictionary allUpdates = EOSynchronizationFactory._dictionaryForKey(changes, "updated");
        NSArray tableNames = allUpdates.allKeys();
        for (int t = 0; t < tableNames.count(); ++t) {
            String tableName = (String)tableNames.objectAtIndex(t);
            NSArray entityGroup = this._entityGroupInModelForTableNamed(model, tableName);
            NSDictionary tableUpdates = EOSynchronizationFactory._dictionaryForKey(allUpdates, tableName);
            String newTableName = (String)tableUpdates.objectForKey((Object)"externalName");
            if (newTableName != null) {
                tableName = newTableName;
            }
            NSDictionary allColumnUpdates = EOSynchronizationFactory._dictionaryForKey(tableUpdates, "updated");
            NSArray columnNames = allColumnUpdates.allKeys();
            for (int c = 0; c < columnNames.count(); ++c) {
                String columnName = (String)columnNames.objectAtIndex(c);
                NSDictionary columnUpdates = EOSynchronizationFactory._dictionaryForKey(allColumnUpdates, columnName);
                Number allowsNull = (Number)columnUpdates.objectForKey((Object)"allowsNull");
                if (columnUpdates.objectForKey((Object)"externalType") == null || allowsNull == null || allowsNull.intValue() <= 0) continue;
                EOAttribute attribute = this._firstAttributeInEntityGroupWithColumnName(entityGroup, columnName);
                String newColumnName = (String)columnUpdates.objectForKey((Object)"columnName");
                if (newColumnName != null) {
                    columnName = newColumnName;
                }
                if (!this._schemaSynchronizationAdaptor().isValidQualifierType(attribute.externalType(), model) || this._nullCountForColumnNamedInTableNamedBeneathModel(columnName, tableName, model) <= 0) continue;
                result.addObject((Object)("" + tableName + "." + columnName + " no longer ALLOWS _NULL but contains it"));
            }
        }
        return result.count() > 0 ? result : null;
    }

    public NSArray _namesOfColumnsCoercedInChangeDictionaryForEntityGroup(NSDictionary changes, NSArray entityGroup) {
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        NSDictionary updated = EOSynchronizationFactory._dictionaryForKey(changes, "updated");
        NSMutableArray result = new NSMutableArray();
        NSArray columnNames = updated.allKeys();
        for (int c = 0; c < columnNames.count(); ++c) {
            String columnName = (String)columnNames.objectAtIndex(c);
            EOAttribute attribute = this._firstAttributeInEntityGroupWithColumnName(entityGroup, columnName);
            NSDictionary columnChanges = EOSynchronizationFactory._dictionaryForKey(updated, columnName);
            if (columnChanges.objectForKey((Object)"precision") == null && columnChanges.objectForKey((Object)"scale") == null && columnChanges.objectForKey((Object)"width") == null && columnChanges.objectForKey((Object)"externalType") == null) continue;
            result.addObject((Object)columnName);
        }
        return result;
    }

    public NSDictionary _parameterizedTypes() {
        return null;
    }

    public String phraseCastingColumnNamed(String columnName, EOSchemaSynchronization.ColumnTypes type, EOSchemaSynchronization.ColumnTypes castType, NSDictionary options) {
        return columnName;
    }

    public String _prettyDictionary(NSDictionary dictionary) {
        return NSArray.componentsSeparatedByString((String)dictionary.toString(), (String)"; }").componentsJoinedByString(";}");
    }

    public NSArray _schemaCreationStatementsForEntityGroup(NSArray entityGroup, NSDictionary options) {
        NSMutableDictionary EOSchemaGenerationOptions = this._EOSchemaGenerationOptions(new NSDictionary((Object)"YES", (Object)"createTables"));
        NSMutableArray result = new NSMutableArray();
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        EOSchemaGenerationOptions.setObjectForKey((Object)(_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"SchemaSynchronizationPrimaryKeyConstraintsKey", (boolean)true) ? "YES" : "NO"), (Object)"SchemaSynchronizationPrimaryKeyConstraintsKey");
        EOSchemaGenerationOptions.setObjectForKey((Object)(_NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"SchemaSynchronizationPrimaryKeySupportKey", (boolean)true) ? "YES" : "NO"), (Object)"SchemaSynchronizationPrimaryKeySupportKey");
        NSArray statements = this.schemaCreationStatementsForEntities(entityGroup, (NSDictionary)EOSchemaGenerationOptions);
        for (int s = 0; s < statements.count(); ++s) {
            result.addObject((Object)this._expressionForString(_NSStringUtilities.stringWithReplacements((String)((EOSQLExpression)statements.objectAtIndex(s)).statement(), (NSDictionary)this._sqlReplacements())));
        }
        return result;
    }

    public boolean _schemaSynchronizationCommentsEnabled() {
        return this._commentsEnabled;
    }

    public void setSchemaSynchronizationDelegate(Delegate delegate) {
        this._delegate = delegate;
    }

    public Delegate schemaSynchronizationDelegate() {
        return this._delegate;
    }

    public void _setSchemaSynchronizationCommentsEnabled(boolean commentsEnabled) {
        this._commentsEnabled = commentsEnabled;
    }

    public int _intForExpressionStringAdaptorChannel(String expressionString, EOAdaptorChannel adaptorChannel) {
        adaptorChannel.openChannel();
        adaptorChannel.evaluateExpression(this._expressionForString(expressionString));
        adaptorChannel.setAttributesToFetch(adaptorChannel.describeResults());
        NSMutableDictionary row = adaptorChannel.fetchRow();
        adaptorChannel.closeChannel();
        NSArray rowKeys = row.allKeys();
        if (row == null || (rowKeys = row.allKeys()).count() != 1) {
            throw new IllegalStateException("_intForExpressionString:adaptorChannel: received results which do not contain exactly one column");
        }
        return ((Number)row.objectForKey(rowKeys.lastObject())).intValue();
    }

    public boolean _isSignificantExceptionAtIndexOfSynchronizationStatements(Exception exception, int index, NSArray statements) {
        return true;
    }

    public boolean _isTableNamed(String tableName) {
        if (this._delegate != null) {
            return this._delegate.isSchemaTableNamed(tableName);
        }
        throw new IllegalStateException("invocation of _isTableNamed: with no schema synchronization delegate");
    }

    public int _nullCountForColumnNamedInTableNamedBeneathModel(String columnName, String tableName, EOModel model) {
        return this._intForExpressionStringAdaptorChannel("select count(*) from " + tableName + " where " + columnName + " is NULL", this._schemaSynchronizationAdaptorChannelForModel(model));
    }

    public NSArray _primaryKeyEntityGroupsForEntityGroups(NSArray entityGroups) {
        NSMutableArray entities = new NSMutableArray();
        for (int g = 0; g < entityGroups.count(); ++g) {
            NSArray entityGroup = (NSArray)entityGroups.objectAtIndex(g);
            for (int e = 0; e < entityGroup.count(); ++e) {
                entities.addObject(entityGroup.objectAtIndex(e));
            }
        }
        return this.primaryKeyEntityGroupsForEntities((NSArray)entities);
    }

    public EOAdaptor _schemaSynchronizationAdaptor() {
        if (this._delegate != null) {
            return this._delegate.schemaSynchronizationAdaptor();
        }
        throw new IllegalStateException("invocation of _schemaSynchronizationAdaptor: with no schema synchronization delegate");
    }

    public NSArray _statementsCommentedWithString(NSArray statements, String comment) {
        if (statements == null) {
            statements = NSArray.EmptyArray;
        }
        if (this._commentsEnabled) {
            NSMutableArray result = new NSMutableArray();
            result.addObject((Object)new _EOSQLComment(comment));
            result.addObjectsFromArray(statements);
            result.addObject((Object)new _EOSQLComment(""));
            return result;
        }
        return statements;
    }

    boolean arrayHasValue(NSArray objects, String string) {
        if (objects == null) {
            return false;
        }
        for (int i = 0; i < objects.count(); ++i) {
            if (!((String)objects.objectAtIndex(i)).equals(string)) continue;
            return true;
        }
        return false;
    }

    public NSArray statementsToCopyTableNamed(String tableName, NSArray entityGroup, NSDictionary changes, NSDictionary options) {
        EOAttribute attribute;
        int a;
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        StringBuffer string = new StringBuffer();
        NSArray attributes = this._columnAttributesInEntityGroup(entityGroup);
        NSArray inserted = EOSynchronizationFactory._arrayForKey(changes, "inserted");
        int attributeCount = attributes.count();
        NSDictionary columnChanges = null;
        String sourceName = null;
        String destinationName = ((EOEntity)entityGroup.lastObject()).externalName();
        string.append("insert into " + destinationName + " (");
        for (a = 0; a < attributeCount; ++a) {
            attribute = (EOAttribute)attributes.objectAtIndex(a);
            if (this.arrayHasValue(inserted, attribute.columnName())) continue;
            string.append(attribute.columnName() + (a == attributeCount - 1 ? ")" : ", "));
        }
        if (string.toString().endsWith(", ")) {
            string = new StringBuffer(string.toString().substring(0, string.length() - 2) + ")");
        }
        string.append(" select ");
        for (a = 0; a < attributeCount; ++a) {
            EOSchemaSynchronization.ColumnTypes newType;
            EOSchemaSynchronization.ColumnTypes oldType;
            attribute = (EOAttribute)attributes.objectAtIndex(a);
            NSDictionary updateDict = (NSDictionary)changes.objectForKey((Object)"updated");
            if (this.arrayHasValue(inserted, attribute.columnName())) continue;
            columnChanges = updateDict != null ? (NSDictionary)updateDict.objectForKey((Object)attribute.columnName()) : null;
            if (columnChanges != null) {
                sourceName = (String)columnChanges.objectForKey((Object)"columnName");
            }
            if (sourceName == null) {
                sourceName = attribute.columnName();
            }
            String phrase = this.isColumnTypeEquivalentToColumnType(oldType = this._columnTypeForChangeDictionaryAndAttribute(columnChanges, attribute), newType = this._columnTypeForAttribute(attribute), options) ? sourceName : this.phraseCastingColumnNamed(sourceName, oldType, newType, options);
            sourceName = null;
            string.append(phrase + "" + (a == attributeCount - 1 ? "" : ", "));
        }
        if (string.toString().endsWith(", ")) {
            string = new StringBuffer(string.toString().substring(0, string.length() - 2));
        }
        string.append(" from " + tableName);
        return new NSArray((Object)this._expressionForString(string.toString()));
    }

    public NSArray _statementsToCreateTableForEntityGroupOptions(NSArray entityGroup, NSDictionary options) {
        NSMutableDictionary EOSchemaGenerationOptions = this._EOSchemaGenerationOptions(new NSDictionary((Object)"YES", (Object)"createTables"));
        String statement = ((EOSQLExpression)this.schemaCreationStatementsForEntities(entityGroup, (NSDictionary)EOSchemaGenerationOptions).lastObject()).statement();
        return new NSArray((Object)this._expressionForString(_NSStringUtilities.stringWithReplacements((String)statement, (NSDictionary)this._sqlReplacements())));
    }

    public NSArray _statementsToDeleteTableNamedOptions(String tableName, NSDictionary options) {
        return new NSArray((Object)this._expressionForString("DROP TABLE " + tableName + " CASCADE"));
    }

    public NSArray statementsToConvertColumnType(String columnName, String tableName, EOSchemaSynchronization.ColumnTypes type, EOSchemaSynchronization.ColumnTypes newType, NSDictionary options) {
        return null;
    }

    public NSArray statementsToDeleteColumnNamed(String columnName, String tableName, NSDictionary options) {
        return null;
    }

    public NSArray _statementsToDirectlyUpdateObjectStoreForEntityGroup(NSArray entityGroup, NSDictionary changes, NSDictionary options) {
        String alterPhrase;
        EOAttribute attribute;
        String columnName;
        int c;
        NSArray columnNames;
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        NSMutableArray result = new NSMutableArray();
        NSMutableArray allColumnNames = new NSMutableArray();
        NSMutableArray alterPhrases = new NSMutableArray();
        String tableName = ((EOEntity)entityGroup.lastObject()).externalName();
        NSDictionary updated = EOSynchronizationFactory._dictionaryForKey(changes, "updated");
        String oldName = (String)changes.objectForKey((Object)"externalName");
        if (oldName != null) {
            result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToRenameTableNamed(oldName, tableName, options), "statementsToRenameTableNamed:" + oldName + " newName:" + tableName));
        }
        if (updated != null) {
            columnNames = updated.allKeys();
            allColumnNames.addObjectsFromArray(columnNames);
            for (c = 0; c < columnNames.count(); ++c) {
                columnName = (String)columnNames.objectAtIndex(c);
                attribute = this._firstAttributeInEntityGroupWithColumnName(entityGroup, columnName);
                NSDictionary columnChanges = EOSynchronizationFactory._dictionaryForKey(updated, columnName);
                oldName = (String)columnChanges.objectForKey((Object)"columnName");
                if (oldName != null) {
                    result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToRenameColumnNamed(oldName, tableName, columnName, options), "statementsToRenameColumnNamed(" + oldName + ", " + tableName + ", " + columnName + ")"));
                }
                if (columnChanges.objectForKey((Object)"allowsNull") == null) continue;
                result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToModifyColumnNullRule(columnName, tableName, attribute.allowsNull(), options), "statementsToModifyColumnNullRule(" + columnName + ", " + tableName + ", " + (attribute.allowsNull() ? Boolean.TRUE : Boolean.FALSE) + ")"));
            }
        }
        int alterIndex = result.count();
        Object coercions = this._directCoercionsForEntityGroupInTable(entityGroup, tableName, changes, options);
        if (coercions != null) {
            if (coercions instanceof String) {
                alterPhrases.addObject(coercions);
            } else {
                result.addObjectsFromArray((NSArray)coercions);
            }
        }
        if ((columnNames = (NSArray)changes.objectForKey((Object)"deleted")) != null) {
            allColumnNames.addObjectsFromArray(columnNames);
            alterPhrase = this._alterPhraseDeletingColumnsWithNames(columnNames, entityGroup, options);
            if (alterPhrase != null) {
                alterPhrases.addObject((Object)alterPhrase);
            } else {
                for (c = 0; c < columnNames.count(); ++c) {
                    columnName = (String)columnNames.objectAtIndex(c);
                    result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToDeleteColumnNamed(columnName, tableName, options), "statementsToDeleteColumnNamed:" + columnName + " inTableNamed:" + tableName));
                }
            }
        }
        if ((columnNames = (NSArray)changes.objectForKey((Object)"inserted")) != null) {
            allColumnNames.addObjectsFromArray(columnNames);
            alterPhrase = this._alterPhraseInsertingColumnsWithNames(columnNames, entityGroup, options);
            if (alterPhrase != null) {
                alterPhrases.addObject((Object)alterPhrase);
            } else {
                for (c = 0; c < columnNames.count(); ++c) {
                    attribute = (EOAttribute)columnNames.objectAtIndex(c);
                    result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToInsertColumnForAttribute((EOAttribute)columnNames.objectAtIndex(c), options), "statementsToInsertColumnForAttribute:" + attribute.entity().name() + "." + attribute.name()));
                }
            }
        }
        if (alterPhrases.count() > 0) {
            if (this._commentsEnabled) {
                result.insertObjectAtIndex((Object)new _EOSQLComment("alterations to " + allColumnNames.componentsJoinedByString(", ")), alterIndex);
            }
            int index = 0;
            if (this._commentsEnabled) {
                index = 1;
            }
            result.insertObjectAtIndex((Object)this._expressionForString("alter table " + tableName + " " + alterPhrases.componentsJoinedByString(this._alterPhraseJoinString())), alterIndex + index);
            if (this._commentsEnabled) {
                result.insertObjectAtIndex((Object)new _EOSQLComment(""), alterIndex + 2);
            }
        }
        return result.count() > 0 ? result : null;
    }

    public NSArray statementsToDropForeignKeyConstraintsOnEntityGroups(NSArray entityGroups, NSDictionary changes, NSDictionary options) {
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        NSMutableArray result = new NSMutableArray();
        for (int g = 0; g < entityGroups.count(); ++g) {
            NSArray entityGroup = (NSArray)entityGroups.objectAtIndex(g);
            NSDictionary tableUpdates = EOSynchronizationFactory._dictionaryForKey(changes, ((EOEntity)entityGroup.lastObject()).externalName());
            String tableName = this._nameInObjectStoreForEntityGroupWithChangeDictionary(entityGroup, changes);
            NSDictionary relationshipDict = EOSynchronizationFactory._dictionaryForKey(tableUpdates, "relationships");
            for (int e = 0; e < entityGroup.count(); ++e) {
                EOEntity entity = (EOEntity)entityGroup.objectAtIndex(e);
                NSArray relationships = entity.relationships();
                if (relationships == null) continue;
                for (int r = 0; r < relationships.count(); ++r) {
                    EORelationship inv;
                    EORelationship relationship = (EORelationship)relationships.objectAtIndex(r);
                    String oldName = (String)EOSynchronizationFactory._dictionaryForKey(relationshipDict, entity.name() + "." + relationship.name()).objectForKey((Object)"name");
                    if (entity.model() != relationship.destinationEntity().model() || relationship.isToMany() || (inv = relationship.inverseRelationship()) == null || !inv.isToMany()) continue;
                    result.addObject((Object)this._expressionForString("alter table " + tableName + " drop constraint " + tableName + "_" + (oldName != null ? oldName : relationship.name()) + "_FK cascade"));
                }
            }
        }
        return result;
    }

    public NSArray _statementsToDropPrimaryKeyConstraintsOnTableNamed(String tableName) {
        return new NSArray((Object)this._expressionForString("alter table " + tableName + " drop primary key cascade"));
    }

    public NSArray statementsToDropPrimaryKeyConstraintsOnEntityGroups(NSArray entityGroups, NSDictionary changes, NSDictionary options) {
        NSMutableArray result = new NSMutableArray();
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        for (int e = 0; e < entityGroups.count(); ++e) {
            NSArray entityGroup = (NSArray)entityGroups.objectAtIndex(e);
            String tableName = this._nameInObjectStoreForEntityGroupWithChangeDictionary(entityGroup, EOSynchronizationFactory._dictionaryForKey(changes, ((EOEntity)entityGroup.lastObject()).externalName()));
            result.addObjectsFromArray(this._statementsToDropPrimaryKeyConstraintsOnTableNamed(tableName));
        }
        return result;
    }

    public NSArray statementsToDropPrimaryKeySupportForEntityGroups(NSArray entityGroups, NSDictionary changes, NSDictionary options) {
        NSArray result = this.dropPrimaryKeySupportStatementsForEntityGroups(this._primaryKeyEntityGroupsForEntityGroups(entityGroups));
        return result;
    }

    public NSArray statementsToImplementForeignKeyConstraintsOnEntityGroups(NSArray entityGroups, NSDictionary changes, NSDictionary options) {
        NSMutableArray result = new NSMutableArray();
        for (int e = 0; e < entityGroups.count(); ++e) {
            NSArray statements = this._foreignKeyConstraintStatementsForEntityGroup((NSArray)entityGroups.objectAtIndex(e));
            if (statements.count() <= 0) continue;
            result.addObjectsFromArray(statements);
        }
        return result;
    }

    public NSArray statementsToImplementPrimaryKeyConstraintsOnEntityGroups(NSArray entityGroups, NSDictionary changes, NSDictionary options) {
        return this.primaryKeyConstraintStatementsForEntityGroups(entityGroups);
    }

    public NSArray statementsToImplementPrimaryKeySupportForEntityGroups(NSArray entityGroups, NSDictionary changes, NSDictionary options) {
        return this.primaryKeySupportStatementsForEntityGroups(this._primaryKeyEntityGroupsForEntityGroups(entityGroups));
    }

    public NSArray _statementsToIndirectlyUpdateObjectStoreForEntityGroupWithChangeDictionaryOptions(NSArray entityGroup, NSDictionary changes, NSDictionary options) {
        NSArray statements;
        String sourceTableName;
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        NSMutableArray result = new NSMutableArray();
        String oldTableName = (String)changes.objectForKey((Object)"externalName");
        String tableName = ((EOEntity)entityGroup.lastObject()).externalName();
        if (oldTableName != null) {
            sourceTableName = oldTableName;
        } else {
            int lastDot = tableName.lastIndexOf(46);
            if (lastDot == -1) {
                sourceTableName = "EO_OLD_" + tableName;
            } else {
                int start = lastDot + 1;
                sourceTableName = tableName.substring(0, start) + "EO_OLD_" + tableName.substring(start);
            }
            if (this._isTableNamed(sourceTableName)) {
                result.addObjectsFromArray(this._statementsCommentedWithString(this._statementsToDeleteTableNamedOptions(sourceTableName, options), "deletion of " + sourceTableName));
            }
            result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToRenameTableNamed(tableName, sourceTableName, options), "statementsToRenameTableNamed" + tableName + ", " + sourceTableName + ")"));
        }
        result.addObjectsFromArray(this._statementsCommentedWithString(this._statementsToCreateTableForEntityGroupOptions(entityGroup, options), "statementsToCreateTableForEntityGroup(" + tableName + ")"));
        if (this._rowCountForTableNamedBeneathModel(oldTableName != null ? oldTableName : tableName, ((EOEntity)entityGroup.lastObject()).model()) > 0) {
            statements = this._statementsCommentedWithString(this.statementsToCopyTableNamed(sourceTableName, entityGroup, changes, options), "statementsToCopyTableNamed" + sourceTableName + ", " + tableName + ")");
            if (this._delegate != null) {
                this._delegate.schemaSynchronizationStatementsWillCopyTableNamed(statements, sourceTableName);
            }
            result.addObjectsFromArray(statements);
        }
        statements = this._statementsCommentedWithString(this._statementsToDeleteTableNamedOptions(sourceTableName, options), "deletion of " + sourceTableName);
        if (this._delegate != null) {
            this._delegate.schemaSynchronizationStatementsWillDeleteTableNamed(statements, sourceTableName);
        }
        result.addObjectsFromArray(statements);
        return result;
    }

    public NSArray statementsToInsertColumnForAttribute(EOAttribute attribute, NSDictionary options) {
        String clause = this._columnCreationClauseForAttribute(attribute);
        return new NSArray((Object)this._expressionForString("alter table " + attribute.entity().externalName() + " add (" + clause + ")"));
    }

    public NSArray statementsToModifyColumnNullRule(String columnName, String tableName, boolean allowsNull, NSDictionary options) {
        return null;
    }

    public NSArray statementsToRenameColumnNamed(String columnName, String tableName, String newName, NSDictionary options) {
        return null;
    }

    public NSArray statementsToRenameTableNamed(String tableName, String newName, NSDictionary options) {
        return new NSArray((Object)this._expressionForString("rename " + tableName + " to " + newName));
    }

    public NSArray _statementsToUpdateObjectStoreForEntityGroup(NSArray entityGroup, NSDictionary changes, NSDictionary options) {
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        if (this._isTableCopyingRequiredByColumnChangesToEntityGroup(changes, entityGroup)) {
            return this._statementsToIndirectlyUpdateObjectStoreForEntityGroupWithChangeDictionaryOptions(entityGroup, changes, options);
        }
        return this._statementsToDirectlyUpdateObjectStoreForEntityGroup(entityGroup, changes, options);
    }

    public NSArray statementsToUpdateObjectStoreForEntityGroups(NSArray entityGroups, NSDictionary changes, NSDictionary options) {
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        NSMutableArray result = new NSMutableArray();
        boolean shouldManagePrimaryKeyConstraints = _NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"SchemaSynchronizationPrimaryKeyConstraintsKey", (boolean)true);
        boolean shouldManagePrimaryKeySupport = _NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"SchemaSynchronizationPrimaryKeySupportKey", (boolean)true);
        String tableNames = changes.allKeys().componentsJoinedByString(" ");
        if (shouldManagePrimaryKeySupport) {
            result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToDropPrimaryKeySupportForEntityGroups(entityGroups, changes, options), "statementsToDropPrimaryKeySupportForEntityGroups(" + tableNames + ")"));
        }
        if (shouldManagePrimaryKeyConstraints) {
            result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToDropPrimaryKeyConstraintsOnEntityGroups(entityGroups, changes, options), "statementsToDropPrimaryKeyConstraintsOnEntityGroups(" + tableNames + ")"));
        }
        for (int e = 0; e < entityGroups.count(); ++e) {
            NSArray entityGroup = (NSArray)entityGroups.objectAtIndex(e);
            String tableName = ((EOEntity)entityGroup.lastObject()).externalName();
            result.addObjectsFromArray(this._statementsToUpdateObjectStoreForEntityGroup(entityGroup, (NSDictionary)changes.objectForKey((Object)tableName), options));
        }
        if (shouldManagePrimaryKeySupport) {
            result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToImplementPrimaryKeySupportForEntityGroups(entityGroups, changes, options), "statementsToImplementPrimaryKeySupportForEntityGroups:(" + tableNames + ")"));
        }
        if (shouldManagePrimaryKeyConstraints) {
            result.addObjectsFromArray(this._statementsCommentedWithString(this.statementsToImplementPrimaryKeyConstraintsOnEntityGroups(entityGroups, changes, options), "statementsToImplementPrimaryKeyConstraintsOnEntityGroups:(" + tableNames + ")"));
        }
        return result;
    }

    public NSArray statementsToUpdateObjectStoreForModel(EOModel model, NSDictionary changes, NSDictionary options) {
        NSArray entityGroup;
        String tableName;
        int t;
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        NSMutableArray result = new NSMutableArray();
        NSDictionary updatedTables = EOSynchronizationFactory._dictionaryForKey(changes, "updated");
        NSMutableSet foreignKeyConstraintEntityGroups = new NSMutableSet();
        boolean shouldManageForeignKeyConstraints = _NSDictionaryUtilities.boolValueForKeyDefault((NSDictionary)options, (String)"SchemaSynchronizationForeignKeyConstraintsKey", (boolean)true);
        NSMutableArray entityGroups = new NSMutableArray();
        NSArray tableNames = (NSArray)changes.objectForKey((Object)"deleted");
        if (tableNames == null) {
            tableNames = NSArray.EmptyArray;
        } else {
            try {
                tableNames = tableNames.sortedArrayUsingSelector(_selCompare);
            }
            catch (NSComparator.ComparisonException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
        for (t = 0; t < tableNames.count(); ++t) {
            tableName = (String)tableNames.objectAtIndex(t);
            result.addObjectsFromArray(this._statementsCommentedWithString(this._statementsToDeleteTableNamedOptions(tableName, options), "deletion of " + tableName));
        }
        tableNames = (NSArray)changes.objectForKey((Object)"inserted");
        if (tableNames == null) {
            tableNames = NSArray.EmptyArray;
        } else {
            try {
                tableNames = tableNames.sortedArrayUsingSelector(_selCompare);
            }
            catch (NSComparator.ComparisonException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
        for (t = 0; t < tableNames.count(); ++t) {
            tableName = (String)tableNames.objectAtIndex(t);
            entityGroup = this._entityGroupInModelForTableNamed(model, tableName);
            result.addObjectsFromArray(this._statementsCommentedWithString(this._schemaCreationStatementsForEntityGroup(entityGroup, options), "creation of " + tableName));
            foreignKeyConstraintEntityGroups.addObject((Object)entityGroup);
        }
        if (updatedTables == null) {
            tableNames = NSArray.EmptyArray;
        } else {
            try {
                tableNames = updatedTables.allKeys().sortedArrayUsingSelector(_selCompare);
            }
            catch (NSComparator.ComparisonException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
        for (t = 0; t < tableNames.count(); ++t) {
            tableName = (String)tableNames.objectAtIndex(t);
            NSDictionary tableChanges = EOSynchronizationFactory._dictionaryForKey(updatedTables, tableName);
            entityGroup = this._entityGroupInModelForTableNamed(model, tableName);
            foreignKeyConstraintEntityGroups.addObject((Object)entityGroup);
            NSArray refs = this._entityGroupsInModelReferringToTableNamed(model, tableName);
            if (refs != null) {
                foreignKeyConstraintEntityGroups.addObjectsFromArray(refs);
            }
            if (this._arePurelyForeignKeyConstraintRelatedChanges(tableChanges)) continue;
            entityGroups.addObject((Object)entityGroup);
        }
        NSArray subresult = entityGroups.count() > 0 ? this.statementsToUpdateObjectStoreForEntityGroups((NSArray)entityGroups, updatedTables, options) : NSArray.EmptyArray;
        NSArray fkEntityGroups = foreignKeyConstraintEntityGroups.allObjects();
        if (fkEntityGroups.count() > 0 && shouldManageForeignKeyConstraints) {
            result.addObjectsFromArray(this.statementsToDropForeignKeyConstraintsOnEntityGroups(fkEntityGroups, updatedTables, options));
        }
        result.addObjectsFromArray(subresult);
        if (fkEntityGroups.count() > 0 && shouldManageForeignKeyConstraints) {
            result.addObjectsFromArray(this.statementsToImplementForeignKeyConstraintsOnEntityGroups(fkEntityGroups, updatedTables, options));
        }
        return result;
    }

    public NSMutableDictionary _EOSchemaGenerationOptions(NSDictionary options) {
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        NSMutableDictionary result = new NSMutableDictionary();
        result.setObjectForKey((Object)"NO", (Object)"createTables");
        result.setObjectForKey((Object)"NO", (Object)"dropTables");
        result.setObjectForKey((Object)"NO", (Object)"createPrimaryKeySupport");
        result.setObjectForKey((Object)"NO", (Object)"dropPrimaryKeySupport");
        result.setObjectForKey((Object)"NO", (Object)"primaryKeyConstraints");
        NSArray keys = options.allKeys();
        for (int i = 0; i < keys.count(); ++i) {
            String key = (String)keys.objectAtIndex(i);
            result.setObjectForKey(options.valueForKey(key), (Object)key);
        }
        return result;
    }

    public EOAdaptorChannel _schemaSynchronizationAdaptorChannelForModel(EOModel model) {
        if (this._delegate != null) {
            return this._delegate.schemaSynchronizationAdaptorChannelForModel(model);
        }
        throw new IllegalStateException("invocation of _EOSchemaSynchronizationAdaptorChannelForModel: with no schema synchronization delegate");
    }

    public NSDictionary _sqlReplacements() {
        return _sqlReplacementsDictionary;
    }

    public boolean supportsDirectColumnCoercion() {
        return false;
    }

    public boolean supportsDirectColumnDeletion() {
        return false;
    }

    public boolean supportsDirectColumnInsertion() {
        return false;
    }

    public boolean supportsDirectColumnRenaming() {
        return false;
    }

    public boolean supportsDirectColumnNullRuleModification() {
        return false;
    }

    public boolean supportsSchemaSynchronization() {
        return false;
    }

    public NSMutableDictionary _tableNameMapInChangeDictionary(NSDictionary changeDictionary) {
        if (changeDictionary == null) {
            changeDictionary = NSDictionary.EmptyDictionary;
        }
        NSMutableDictionary result = new NSMutableDictionary();
        NSDictionary updatedTables = EOSynchronizationFactory._dictionaryForKey(changeDictionary, "updated");
        NSArray updatedTableKeys = updatedTables.allKeys();
        for (int t = 0; t < updatedTableKeys.count(); ++t) {
            String tableName = (String)updatedTableKeys.objectAtIndex(t);
            String oldName = (String)((NSDictionary)updatedTables.objectForKey((Object)tableName)).objectForKey((Object)"externalName");
            if (oldName == null) continue;
            result.setObjectForKey((Object)oldName, (Object)tableName);
        }
        return result;
    }

    public String _temporaryNameForTableName(String tableName) {
        return "EO_TMP_" + tableName;
    }

    public boolean _canConvertColumnOfTypeToTypeOptions(EOSchemaSynchronization.ColumnTypes type, EOSchemaSynchronization.ColumnTypes newType, NSDictionary options) {
        if (options == null) {
            options = NSDictionary.EmptyDictionary;
        }
        return this.supportsDirectColumnCoercion() && this.statementsToConvertColumnType("COLUMN", "TABLE", type, newType, options) != null || this.phraseCastingColumnNamed("COLUMN", type, newType, options) != null;
    }

    public String _columnCreationClauseForAttribute(EOAttribute attribute) {
        EOSQLExpression expression = this._expressionForEntity(attribute.entity());
        expression.addCreateClauseForAttribute(attribute);
        String listString = expression.listString();
        if (listString.substring(listString.length() - 1).equals(" ")) {
            listString = listString.substring(0, listString.length() - 1);
        }
        return listString;
    }

    public EOSchemaSynchronization.ColumnTypes _columnTypeForAttribute(EOAttribute attribute) {
        return this._columnTypeNamedWithPrecisionScaleAndWidth(attribute.externalType(), attribute.precision(), attribute.scale(), attribute.width());
    }

    public EOSchemaSynchronization.ColumnTypes _columnTypeForChangeDictionaryAndAttribute(NSDictionary changes, EOAttribute attribute) {
        Object object;
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        String externalType = (object = changes.objectForKey((Object)"externalType")) != null ? (String)object : attribute.externalType();
        object = changes.objectForKey((Object)"precision");
        int precision = object != null ? ((Number)object).intValue() : attribute.precision();
        object = changes.objectForKey((Object)"scale");
        int scale = object != null ? ((Number)object).intValue() : attribute.scale();
        object = changes.objectForKey((Object)"width");
        int width = object != null ? ((Number)object).intValue() : attribute.width();
        return this._columnTypeNamedWithPrecisionScaleAndWidth(externalType, precision, scale, width);
    }

    public NSArray _entityGroupInModelForTableNamed(EOModel model, String tableName) {
        NSMutableArray result = new NSMutableArray();
        NSArray entities = model.entities();
        for (int e = 0; e < entities.count(); ++e) {
            EOEntity entity = (EOEntity)entities.objectAtIndex(e);
            if (!entity.externalName().equals(tableName)) continue;
            result.addObject((Object)entity);
        }
        return result;
    }

    public EOAttribute _firstAttributeInEntityGroupWithColumnName(NSArray entityGroup, String columnName) {
        for (int e = 0; e < entityGroup.count(); ++e) {
            NSArray attributes = ((EOEntity)entityGroup.objectAtIndex(e)).attributes();
            for (int a = 0; a < attributes.count(); ++a) {
                EOAttribute attribute = (EOAttribute)attributes.objectAtIndex(a);
                if (!attribute.columnName().equals(columnName)) continue;
                return attribute;
            }
        }
        return null;
    }

    public boolean _isTableCopyingRequiredByColumnChangesToEntityGroup(NSDictionary changes, NSArray entityGroup) {
        int c;
        NSArray columnNames;
        String tableName;
        if (changes == null) {
            changes = NSDictionary.EmptyDictionary;
        }
        if ((tableName = (String)changes.objectForKey((Object)"externalName")) == null) {
            tableName = ((EOEntity)entityGroup.lastObject()).externalName();
        }
        if ((columnNames = (NSArray)changes.objectForKey((Object)"inserted")) != null) {
            if (!this.supportsDirectColumnInsertion()) {
                return true;
            }
            for (c = 0; c < columnNames.count(); ++c) {
                if (this._allowsNullForColumnNamed((String)columnNames.objectAtIndex(c), tableName)) continue;
                return true;
            }
        }
        if (changes.objectForKey((Object)"deleted") != null && !this.supportsDirectColumnDeletion()) {
            return true;
        }
        NSDictionary columnChanges = EOSynchronizationFactory._dictionaryForKey(changes, "updated");
        columnNames = columnChanges.allKeys();
        for (c = 0; c < columnNames.count(); ++c) {
            String columnName = (String)columnNames.objectAtIndex(c);
            NSDictionary propertyChanges = EOSynchronizationFactory._dictionaryForKey(columnChanges, columnName);
            if (propertyChanges.objectForKey((Object)"allowsNull") != null && !this.supportsDirectColumnNullRuleModification()) {
                return true;
            }
            if (propertyChanges.objectForKey((Object)"columnName") != null && !this.supportsDirectColumnRenaming()) {
                return true;
            }
            if (propertyChanges.objectForKey((Object)"precision") == null && propertyChanges.objectForKey((Object)"scale") == null && propertyChanges.objectForKey((Object)"width") == null && propertyChanges.objectForKey((Object)"externalType") == null || this.supportsDirectColumnCoercion()) continue;
            return true;
        }
        return false;
    }

    public String _nameInObjectStoreForEntityGroupWithChangeDictionary(NSArray entityGroup, NSDictionary changes) {
        String result;
        if (entityGroup == null) {
            return null;
        }
        if (changes != null && (result = (String)changes.objectForKey((Object)"externalName")) != null) {
            return result;
        }
        return ((EOEntity)entityGroup.lastObject()).externalName();
    }

    public int _rowCountForTableNamedBeneathModel(String tableName, EOModel model) {
        return this._intForExpressionStringAdaptorChannel("select count(*) from " + tableName, this._schemaSynchronizationAdaptorChannelForModel(model));
    }

    public NSDictionary objectStoreChangesFromAttributeToAttribute(EOAttribute schemaAttribute, EOAttribute modelAttribute) {
        NSMutableDictionary result = new NSMutableDictionary();
        if (!modelAttribute.externalType().equals(schemaAttribute.externalType())) {
            result.setObjectForKey((Object)schemaAttribute.externalType(), (Object)"externalType");
        }
        if (modelAttribute.allowsNull() != schemaAttribute.allowsNull()) {
            result.setObjectForKey((Object)(schemaAttribute.allowsNull() ? Boolean.TRUE : Boolean.FALSE), (Object)"allowsNull");
        }
        if (modelAttribute.precision() != schemaAttribute.precision()) {
            result.setObjectForKey((Object)_NSUtilities.IntegerForInt((int)schemaAttribute.precision()), (Object)"precision");
        }
        if (modelAttribute.scale() != schemaAttribute.scale()) {
            result.setObjectForKey((Object)_NSUtilities.IntegerForInt((int)schemaAttribute.scale()), (Object)"scale");
        }
        if (modelAttribute.width() != schemaAttribute.width()) {
            result.setObjectForKey((Object)_NSUtilities.IntegerForInt((int)schemaAttribute.width()), (Object)"width");
        }
        return result;
    }

    public static interface Delegate {
        public boolean allowsNullForColumnNamed(String var1, String var2);

        public boolean isSchemaTableNamed(String var1);

        public EOAdaptor schemaSynchronizationAdaptor();

        public EOAdaptorChannel schemaSynchronizationAdaptorChannelForModel(EOModel var1);

        public void schemaSynchronizationStatementsWillCopyTableNamed(NSArray var1, String var2);

        public void schemaSynchronizationStatementsWillDeleteTableNamed(NSArray var1, String var2);
    }

    class _EOExternalType
    implements EOSchemaSynchronization.ColumnTypes {
        protected String _name;
        protected int _precision;
        protected int _scale;
        protected int _width;

        public String toString() {
            return this._precision != 0 || this._scale != 0 || this._width != 0 ? this._name + "(" + this._precision + "." + this._scale + "." + this._width + ")" : this._name;
        }

        public _EOExternalType(String name, int precision, int scale, int width) {
            this._name = name;
            this._precision = precision;
            this._scale = scale;
            this._width = width;
        }

        public String name() {
            return this._name;
        }

        public int precision() {
            return this._precision;
        }

        public int scale() {
            return this._scale;
        }

        public int width() {
            return this._width;
        }
    }

    static class _EOSQLComment
    extends EOSQLExpression {
        protected String _comment;

        public _EOSQLComment(String comment) {
            super(null);
            this._comment = comment != null ? (comment.length() > 0 ? "/* " + comment + " */" : "") : "";
        }

        public String toString() {
            return this._comment;
        }

        public String statement() {
            return this._comment;
        }

        public NSMutableDictionary bindVariableDictionaryForAttribute(EOAttribute attribute, Object value) {
            return null;
        }
    }
}

